(* ::Package:: *)

BeginPackage["convexHullSemigroups3D`"]



Authors="J. I. Garc\[IAcute]a-Garc\[IAcute]a and A. Vigneron-Tenorio,\nDpto. Matem\[AAcute]ticas, 
Universidad de C\[AAcute]diz
ignacio.garcia@uca.es, alberto.vigneron@uca.es\n";

Commands="This package contains the commands: 
....
Try command::usage for more help";

(*leeHB::usage="leeHB ";*)

configuration::usage=
"Sets the variables rutaHastaLRS, dirFicheros and  dirNormaliz.\n\[IndentingNewLine]Example: configuration[\"C:\\tmp\\lrs\\lrs.exe\",\"C:\\tmp\\\",\"C:\\tmp\\Normaliz2.12\"];\[IndentingNewLine]";
showConfiguration::usage=
"Shows the variables rutaHastaLRS, dirFicheros and  dirNormaliz.\n\[IndentingNewLine]Example: showConfiguration[];\[IndentingNewLine]";

(*
getRaysOfConvex::usage=
"\n
Example: 
getRaysOfConvex[pts_]
";*)

facesOfConvexLRS::usage=
"Computes the list of defining inequalities of the polyhedron with 
vertices the list of points of verticesOfThePolyhedron.\n
Example:
facesOfConvexLRS[verticesOfThePolyhedron]
";
belongToCHSgr::usage=
"Check if the point P belong to the polyhedron with vertices verticesOfPolyhedron and definiing 
inequalities listOfInequalities.\n
Example:
belongToCHSgr[listOfInequalities,verticesOfPolyhedron,P]
";
generatorsOfConvexHSgr::usage=
"Returns a set of generators of the convex semigroup generated with the polyhedron with vertices verticesOfPolyhedron. 
It uses the program normaliz.exe.\n
Example:
generatorsOfConvexHSgr[verticesOfPolyhedron]
";
raysOfConeOfCHSgr::usage=
"Returns the set of rays of the cone generated by the polyhedron with vertices verticesOfPolyhedron. 
It uses the program normaliz.exe.\n
Example:
raysOfConeOfCHSgr[verticesOfPolyhedron]
";
msgCHSgr::usage=
"Computes a minimal set of generators of the convex semigroup defined by the polyhedron 
with vertices verticesOfPolyhedron and geenrators generatorsOfSemigroup.\n
Example:
msgCHSgr[verticesOfPolyhedron,generatorsOfSemigroup]
";


msgSgr::usage=
"Computes the minimal system of generators of an affine semigroup from one 
of its system of generators systemOfGeneratorsOfAffineSemigroup.\n
Example:
msgSgr[systemOfGeneratorsOfAffineSemigroup]
";


convexHullIntersection::usage=
"Intersects the polyhedron defined by pts1 and pts2\n
Example:
convexHullIntersection[pts1,pts2]
";


showAxesAndPoints::usage=
"Show the axes.\n
Example:
showAxesAndPoints[listOfGraphics]
";

paintCHSemigroup::usage=
"Shows the convex hull semigroup with vertices verticesOfPolyhedron.\n
Example:
paintCHSemigroup[verticesOfPolyhedron,numberOfIterations,False][[1]] // showAxesAndPoints
";

chSemigroup::usage=
"chSemigroup[v_,n_,t1,t2,t3]";
verticesOfCone::usage=
"verticesOfCone[v_]";


boundCohenMacaulay::usage=
"Returns some datas that are needed by the function isCohenMacaulay to check if the convex hull semigroups defined by 
the polyhedron with vertices verticesOf Polyhedron is Conhen-Macaulay\n
Example:
Cota[verticesOfPolyhedron]
";

isCohenMacaulay::usage=
"Checks if the semigroup defined by verticesOfPolyhedron is Cohen-Macaulay.
bound is the list of data that returns the function boundCohenMacaulay for the same semigroup.\n
Example:
isCohenMacaulay[verticesOfPolyhedron,bound]
";

isBuchsbaum::usage=
"isBuchbaum[verticesOfPolyhedron]";


eqOfPlane::usage="...";
distanciaMinimalAlOrigen::usage="distanciaMinimalAlOrigen[puntos_]:=Min[Norm/@ puntos];";
perteneceAlConvexo::usage="perteneceAlConvexo[lineq_,P_]:=And @@ evaluaListaInecuaciones[lineq,P];"

x1;x2;x3;

Print[Authors<>"\n"<>Commands];


Begin["Private`"]


rutaHastaLRS="";dirFicheros="";dirNormaliz="";

configuration[c1_,c2_,c3_]:=Module[{},
	rutaHastaLRS=c1;dirFicheros=c2;dirNormaliz=c3;
];

showConfiguration[]:=Module[{},Print[rutaHastaLRS,"\n",dirFicheros,"\n",dirNormaliz]];

configuracion1[]:=Module[{},
rutaHastaLRS="C:\\tmp\\lrs\\lrs.exe";dirFicheros="C:\\tmp\\";dirNormaliz="C:\\tmp\\Normaliz2.12";
];

configuracion2[]:=Module[{},
rutaHastaLRS="C:\\Users\\alb\\Desktop\\Math\\lrs\\lrs.exe";dirFicheros="C:\\Users\\alb\\Desktop\\Dropbox\\convex_hull_semigroups\\calculos\\paquete\\";dirNormaliz="C:\\Users\\alb\\Desktop\\Math\\Normaliz2.12";
];





leeHB[opcion_]:=Module[
(*"Hilbert basis elements:" "extreme rays:"*)
	{cad,lineas={},lin,caux,st,i},
	(* --- cad=ReadString[NotebookDirectory[]<>"/"<>"aux1.out"];*)
	cad=ReadString[dirFicheros<>"aux1.out"];
	st=StringToStream[cad];
	If[opcion==1,caux=Find[st,"Hilbert basis elements:"];];
	If[opcion==2,
		caux=Find[st,"*********************************************"];
		caux=Find[st,"extreme rays:"];
	];
	If[opcion==3,caux=Find[st,"support hyperplanes:"];];
	(*Print[caux];*)
	caux=ReadLine[st];
	(*Print[caux];*)
	caux=ReadLine[st];
	While[Characters[caux]!={},
		(*Print[caux,caux\[Equal]" \n",Characters[caux]];*)
		AppendTo[lineas,caux];
		caux=ReadLine[st];
	];
	Return[Flatten[ImportString[#,"Table"]& /@lineas,1]];
];



eqOfPlane[{A_,B_,C_}]:=Module[
	{v=C-A,w=B-A,ddm,ddM,dd},
	dd=Det[{{x1,x2,x3}-A,v,w}];
	(* El origen est\[AAcute] en el semiplano positivo *)
	If[(dd/.{x1->0,x2->0,x3->0})<0,dd=-dd;];
	Return[{dd,v\[Cross]w}]
];



evaluaIneqDePlano[ineq_,pto_]:=ineq/.{x1->pto[[1]],x2->pto[[2]],x3->pto[[3]]};

evaluaListaInecuaciones[lineq_,pto_]:=evaluaIneqDePlano[#,pto]&  /@lineq;

perteneceAlConvexo[lineq_,P_]:=And @@ evaluaListaInecuaciones[lineq,P];

feqAux[aa_ >= 0]:=aa;

toStringRat[x_]:=Module[
{num,den,xx,a,b},
xx=Rationalize[x];
a=Numerator[xx];
b=Denominator[xx];
If[b==1,Return[ToString[a]],Return[ToString[a]<>"/"<>ToString[b]]];
];



pintaAuxLrsHS[leq_]:=Module[{cadena,aa,bb,cc,dd,ii,f},
	(*leq=facesOfConvex[puntos];*)
	cadena="H-representation\nbegin\n";
	cadena=cadena<>ToString[Length[leq]]<>" 4 rational\n";
	For[ii=1,ii<=Length[leq],ii++,
		aa=(leq[[ii]]/.{x1->0,x2->0,x3->0});
		bb=((leq[[ii]]/.{x1->1,x2->0,x3->0})-aa);
		cc=((leq[[ii]]/.{x1->0,x2->1,x3->0})-aa);
		dd=((leq[[ii]]/.{x1->0,x2->0,x3->1})-aa);
		cadena=cadena<>toStringRat[aa]<>" "<>toStringRat[bb]<>" "<>toStringRat[cc]<>" "<>toStringRat[dd];
		cadena=cadena<>"\n";
	];
	cadena=cadena<>"end\n";
	(*Print[cadena];*)
	(*f=OpenWrite[NotebookDirectory[]<>"/"<>"auxLrsHS.ine"];*)
	f=OpenWrite[dirFicheros<>"auxLrsHS.ine"];
	WriteString[f,cadena];
	Close[f];
];

pintaAuxLrsV[pts_]:=Module[
	{cadena,aa,bb,cc,dd,ii,f,ptsAux},
	ptsAux=pts//Rationalize;
	cadena="V-representation\nbegin\n";
	cadena=cadena<>ToString[Length[pts]]<>" 4 rational\n";
	For[ii=1,ii<=Length[pts],ii++,
		cadena=cadena<>"1 "<>toStringRat[ptsAux[[ii]][[1]]]<>" "
			<>toStringRat[ptsAux[[ii]][[2]]]
			<>" "<>toStringRat[ptsAux[[ii]][[3]]]<>"\n";
	];
	cadena=cadena<>"end\n";
	(*Print[cadena];*)
	(*f=OpenWrite[NotebookDirectory[]<>"/"<>"auxLrsVertices.ext"];*)
	f=OpenWrite[dirFicheros<>"auxLrsVertices.ext"];
	WriteString[f,cadena];
	Close[f];
];

fauxSol[a_->b_]:=b
fauxSol[x->7]

quitaLine[Line[x_]]:=x;
quitaPoint[Point[x_]]:=x;

showAxesAndPoints[lista_]:=Show[lista,AxesLabel->{"x","y","z"},AxesOrigin->{0,0,0},PlotRange->All,Axes->True];

GetMinimalSetOfPoints[pts_]:=MeshCoordinates[ConvexHullMesh[pts]];

puntoYKPoligono[vRayo_,{vCercaOrigen_,vLejosOrigen_}]:=Module[
{k=0,A=vRayo,C=vCercaOrigen,B=vLejosOrigen,sol,P,t=False},
While[t==False,
k++;
(*Print[k A+\[Lambda] (k B-k A)==(k+1)A+\[Mu] ((k+1) C-(k+1) A)];*)
sol=Solve[k A+\[Lambda] (k B-k A)==(k+1)A+\[Mu] ((k+1) C-(k+1) A),{\[Lambda],\[Mu]}];
(*Print[sol];*)
t=fauxSol[sol[[1,1]]]<=1 \[And] fauxSol[sol[[1,1]]]>= 0 \[And] fauxSol[sol[[1,2]]]<=1 \[And] fauxSol[sol[[1,2]]]>= 0;
(*Print[And@@ t];*)
];
P=k A+\[Lambda] (k B-k A)/. sol[[1,1]];
(*Print[P];*)
Return[{P,k}];
];

puntosAdyacentesPoligono[puntosPoligono_,vrayo_]:=Module[
{laux,posMax,posMin,ppol=puntosPoligono,pos},
pos=Position[ppol,vrayo][[1,1]];
(*Print[pos];*)
ppol=Delete[ppol,pos];
(*Print[ppol,"\n",puntosPoligono,"\n",vrayo];*)
(*Print[((#-vrayo) & /@ ppol)//N];*)
laux=((#-vrayo).vrayo)/Norm[#-vrayo] & /@ ppol;
(*Print["laux=",laux//N];*)
posMax=Position[laux,Max[laux]][[1,1]];
posMin=Position[laux,Min[laux]][[1,1]];
(*Print[posMin,posMax];*)
Return[{ppol[[posMin]],ppol[[posMax]]}];
];

getVerticesLRS[leq_]:=Module[
	{lAux,cc,ss,listaT,laux,leqAux},
	listaT={};
	leqAux=feqAux /@ leq;
	(*Print["leqAux:",leqAux];*)
	pintaAuxLrsHS[leqAux];
	(*Print[rutaHastaLRS<>" "<>dirFicheros<>"auxLrsHS.ine > "<>dirFicheros<>"salidaLrs1.txt"];*)
	Run[rutaHastaLRS<>" "<>dirFicheros<>"auxLrsHS.ine > "<>dirFicheros<>"salidaLrs1.txt"];
	(*Print[dirFicheros<>"salidaLrs1.txt"];*)
	cc=ReadString[dirFicheros<>"salidaLrs1.txt"];
	ss=StringToStream[cc];
	(*Print[cc];*)
	cc=Find[ss,"*****"];
	cc=ReadLine[ss];
	While[cc!="end",
		(*Print[cc];*)
		laux=Flatten[ImportString[cc,"Table"]//ToExpression,1];
		If[laux!={},
			AppendTo[listaT,Delete[ laux,1 ]] 
		];
		cc=ReadLine[ss];
	];
	Return[listaT];
];

verticesOfPoligon[carasDelConvexo_,{vrayo_,w_}]:=Module[
{paux,deq1,deq2},
paux=eqOfPlane[{{0,0,0},vrayo,w}];
deq1=paux[[1]]>=0;
deq2=-paux[[1]]>= 0;
(*Print[deq1," ",deq2];*)
Return[getVerticesLRS[carasDelConvexo~Join~{deq1,deq2}]];
];

verticesAdyacentes[v_,convexo_]:=Module[
	{lados,i,adyacentes={}},
	lados=quitaLine/@ MeshPrimitives[convexo,1];
	For[i=1,i<=Length[lados],i++,
		If[v==lados[[i,1]],
			AppendTo[adyacentes,lados[[i,2]]];
			,
			If[v==lados[[i,2]],
				AppendTo[adyacentes,lados[[i,1]]];
			];
		];
	];
	Return[adyacentes];
];

kSegmento[lVertices_]:=Module[
{llong,maximo,minimo,k=1},
llong=Norm /@ lVertices;
maximo=Max[llong];
minimo=Min[llong];
While[k maximo < (k+1) minimo,k++];
Return[k];
];

distintoAtodos[l_,x_]:=And @@ Table[x!=l[[ii]],{ii,Length[l]}];

ni[v_]:=(LCM@@(Denominator/@v))v



paintCHSemigroup[v1_,n_,SemP_]:=Module[
{\[ScriptCapitalR],Rb,MR,PMR,PSMR,Gaux,T1L,LineasT1,T1,RT1,RbT1,MRT1,PMRT1,PSMRT1,j,i,k,
AllHighlightMesh={},SemigPoints={{0,0,0}},SemigInRays,vectorsinrays2,vectorsinrays,vectorsinrays3,vConCero},
(*v1_= v\[EAcute]rtices que forman el poliedro, n_= n\.ba de poliedros a dibujar, SemP_= True/False 
dibuja puntos del semigrupo, si False s\[OAcute]lo dibuja el origen*)
vConCero={{0.,0.,0.}}~Join~v1;
T1=ConvexHullMesh[vConCero];
(*Print[vConCero];
Print[MeshPrimitives[T1,2]];
Print[MeshPrimitives[T1,1]];
Print[MeshPrimitives[T1,0]];*)
LineasT1=MeshPrimitives[T1,1];
(*Print[LineasT1];*)
T1L=Select[Level[LineasT1,{2}],MemberQ[#,{0.,0.,0.}]&];

vectorsinrays=Select[Flatten[T1L,1],# !={0.,0.,0.}&];

SemigInRays=Select[
	DeleteDuplicates[Flatten[Table[i*Union[Flatten[T1L,1]],{i,1,n}],1]],
	FractionalPart[#[[1]]]==0&&FractionalPart[#[[2]]]==0&&FractionalPart[#[[3]]]==0&
];

T1=ConvexHullMesh[Join @@ {{{0,0,0}},n*v1}];
LineasT1=MeshPrimitives[T1,1];
T1L=Select[Level[LineasT1,{2}],MemberQ[#,{0.,0.,0.}]&];
Gaux=Graphics3D[{Red,Line /@ T1L }];
RT1=ConvexHullMesh[Union[{{0,0,0}},n*v1]];
RbT1=RegionBounds[RT1];
MRT1=Table[Table[j,{j,RbT1[[i,1]],RbT1[[i,2]]}],{i,1,3}];
PMRT1=Flatten[Outer[List,MRT1[[1]],MRT1[[2]],MRT1[[3]]],2];
PSMRT1=Select[PMRT1,#\[Element]RT1&]; (*PSMRT1, PUNTOS DEL CONO *)
For[k=1,k<=n,k++,
	\[ScriptCapitalR]=ConvexHullMesh[k*v1];
	If[SemP,
		Rb=RegionBounds[\[ScriptCapitalR]];
		MR=Table[Table[j,{j,Rb[[i,1]],Rb[[i,2]]}],{i,1,3}];
		PMR=Flatten[Outer[List,MR[[1]],MR[[2]],MR[[3]]],2];
		PSMR=Select[PMR,#\[Element]\[ScriptCapitalR]&];
		SemigPoints=Union[SemigPoints,PSMR]
	]; 
	(*SemigPoint, PUNTOS DEL SEMIGRUPO EN CADA POLIEDRO PARA DIBUJAR, si "SemP_= False" s\[OAcute]lo dibuja el origen *)
	PSMRT1=Select[PSMRT1,#\[NotElement]\[ScriptCapitalR]&];
	PSMRT1=Select[PSMRT1,#!={0,0,0}&];
	AllHighlightMesh=Join[AllHighlightMesh,{HighlightMesh[\[ScriptCapitalR],Style[2,Opacity[.5],RGBColor[RandomReal[{0,1},3]]]]}];
]; (*AllHighlightMesh=, POLIEDRO PARA DIBUJAR *)
Return[{{
	AllHighlightMesh,
	ListPointPlot3D[PSMRT1,PlotStyle->{PointSize[Medium],Black}],
	ListPointPlot3D[SemigPoints,PlotStyle->{PointSize[Medium],Blue}],
	ListPointPlot3D[SemigInRays,PlotStyle->{PointSize[0.0065],Red}],
	Gaux
	},
	PSMRT1}
];
];



(*
getRaysOfConvex[pts_]:=Module[
	{T1,LineasT1,T1L,ptsAux=pts,f1,f2},
	f1[Line[Par_]]:=Par;
	f2[{A_,B_}]:=If[A=={0,0,0},
		Return[B],
		If[B=={0,0,0},
			Return[A],
			Return[{}]
		]
	];
	T1=ConvexHullMesh[AppendTo[ptsAux,{0,0,0}]];
	LineasT1= f1 /@ MeshPrimitives[T1,1];
	(*Print[LineasT1];*)
	LineasT1= f2 /@ LineasT1;
	(*Print[LineasT1];*)
	T1L=Select[LineasT1,#!={} &];
	Return[T1L];
];
*)


semiplano2Eq[aaa_>=0]:=aaa;


distanciaDesdePlanoAlOrigen[ineqPlano_]:=Module[{n,ti,eq,vn={0,0,0}},
	eq=semiplano2Eq[ineqPlano];
	ti=eq/.{x1->0,x2->0,x3->0};
	vn={(eq/.{x1->1,x2->0,x3->0})-ti,(eq/.{x1->0,x2->1,x3->0})-ti,(eq/.{x1->0,x2->0,x3->1})-ti};
	Return[Abs[ti/Norm[vn]]];
];


distanciaMinimalAlOrigen[convexo_]:=Norm[RegionNearest[convexo,{0,0,0}]];


belongToCHSgr[lineq_,puntosR_,P_]:=Module[
	{k=1,d,Paux=P,convexo},
	convexo=ConvexHullMesh[puntosR];
	d=Norm[RegionNearest[convexo,{0,0,0}]];
	If[P=={0,0,0},Return[{True,1}]];
	(*Print[Paux," Norma Paux=",Norm[Paux]];*)
	While[Norm[Paux]>=d,
		(*Print["k=",k," Paux=",Paux];*)
		If[perteneceAlConvexo[lineq,Paux],Return[{True,k}]];
		k++;
		Paux=P/k;
	];
	Return[{False,-1}];
];



pintaAux[lptos_,cadAux_]:=Module[
{i,cad="",n=Length[lptos],mcdD,l=lptos},
Print["entrada en pintaAux"];
If [cadAux=="3",
	cad=ToString[n]<>"\n"<>"3\n",
	cad=ToString[n]<>"\n"<>"4\n"
];
Print["lptos de pintaAux=",Flatten[lptos]];
mcdD=LCM @@ (Denominator /@ Flatten[lptos]);
l=l*mcdD;
Print["l=",l];
For[i=1,i<=Length[l],i++,
	cad=cad<>ToString[l[[i]][[1]] //InputForm]<>" "<>
	ToString[l[[i]][[2]] //InputForm]<>" "<> ToString[l[[i]][[3]] //InputForm];
	If[cadAux=="3",
		cad=cad<>"\n",
		cad=cad<>" "<>ToString[mcdD]<>"\n"
	];
	];
cad=cad<>"integral_closure\n";
(*Print[cad];*)
(* --- f=OpenWrite[NotebookDirectory[]<>"/"<>"aux1.in"];*)
Print["Escribiendo: ",dirFicheros<>"aux1.in"];
f=OpenWrite[dirFicheros<>"aux1.in"];
WriteString[f,cad];
Close[f];
];




generatorsOfConvexHSgr[pts_]:=Module[
	{lAux},
	pintaAux[pts,"4"];
	(*Print[dirNormaliz <> "\\normaliz.exe -c -e "<>NotebookDirectory[]<>"aux1"];*)
	(*Run[dirNormaliz <> "\\normaliz.exe -c -e "<>NotebookDirectory[]<>"aux1"];*)
	Print[dirNormaliz <> "\\normaliz.exe -c -e "<>dirFicheros<>"aux1"];
	Run[dirNormaliz <> "\\normaliz.exe -c -e "<>dirFicheros<>"aux1"];
	lAux=leeHB[1];
	lAux={#[[1]],#[[2]],#[[3]]}& /@ lAux;
	Return[lAux];
];



raysOfConeOfCHSgr[pts_]:=Module[
{lAux},
pintaAux[pts,"3"];
Print[dirNormaliz <> "\\normaliz.exe -c -e "<>NotebookDirectory[]<>"aux1"];
Run[dirNormaliz <> "\\normaliz.exe -c -e "<>dirFicheros<>"aux1"];
lAux=leeHB[2];Return[lAux];
];



msgSgr[lgenerators_]:=Module[
	{n=Length[lgenerators],smg={},i,xAux,gAux,sols,j,lgenOrdenado,k},

	lgenOrdenado=Sort[lgenerators];

	For[i=1,i<=n,i++,
		xAux=lgenOrdenado[[i]];
		(*Print["xAux=",xAux," buenos=",buenos];
		Print["Ecuaciones: ",xAux\[Equal] \!\(
\*SubsuperscriptBox[\(\[Sum]\), \(j = 1\), \(Length[buenos]\)]\(
\*SubscriptBox[\(x\), \(buenos[\([j]\)]\)]\ lgenerators[\([buenos[\([j]\)]]\)]\)\) && And @@(#\[GreaterEqual]0 & /@ (Subscript[x, #] & /@ buenos)),"\nVariables=",Subscript[x, #]& /@ buenos];*)
		sols=Solve[xAux== \!\(
\*SubsuperscriptBox[\(\[Sum]\), \(j = 1\), \(Length[smg]\)]\(
\*SubscriptBox[\(x\), \(j\)]\ smg[\([j]\)]\)\) && And @@(#>=0 & /@ (Subscript[x, #] & /@ Table[k,{k,1,Length[smg]}])),
		Subscript[x, #]& /@ Table[k,{k,1,Length[smg]}],Integers];
		(*Print[sols, " ", buenos];*)
		If[sols=={},AppendTo[smg,xAux];Print["New element ",xAux," added"]];
		(*Print["buenos (en i=",i,")=",buenos];
		Print[];*)

	];
	Return[smg];
];



msgCHSgr[vertices_,gen_]:=Module[
{ineq,i,j,k,msg={},n=Length[gen],laux,xx,genOrdenado,seguir},
(*Print["vertices=",vertices];*)
genOrdenado=Sort[gen];
(*Print["generadores=",genOrdenado];*)
ineq=facesOfConvexLRS[vertices];
(*Print[ineq, " n=",n];Print["gen=",genOrdenado];*)
For[i=1,i<=n,i++,
(*Print["i=",i," ",gen[[i]]];*)
seguir=True;
For[k=1,(k<=i-1) \[And] seguir,k++,
xx=genOrdenado[[i]]-genOrdenado[[k]];
(*Print["k=",k," xx=",xx];*)
If[ belongToCHSgr[ineq,vertices,xx][[1]], seguir=False;];
];
(*Print["k=",k];*)
If[(k==i)\[And]seguir,AppendTo[msg,genOrdenado[[i]]];];
];
Return[msg];
];



facesOfConvexLRS[pts_]:=Module[
	{lAux,cc,ss,listaT,laux},
	listaT={};
	pintaAuxLrsV[pts];
	(*Print["Comanda ejecutado:"];
	Print[rutaHastaLRS<>" "<>dirFicheros<>"auxLrsVertices.ext > "<>dirFicheros<>"salidaLrs2.txt"];*)
	Run[rutaHastaLRS<>" "<>dirFicheros<>"auxLrsVertices.ext > "<>dirFicheros<>"salidaLrs2.txt"];
	(*Print["\nSalida de "<>dirFicheros<>"salidaLrs2.txt"<>":"];*)
	cc=ReadString[dirFicheros<>"salidaLrs2.txt"];
	ss=StringToStream[cc];
	(*Print[cc];*)
	cc=Find[ss,"*****"];
	cc=ReadLine[ss];
	While[cc!="end",
		(*Print[cc];*)
		laux=Flatten[ImportString[cc,"Table"] //ToExpression,1];
		If[laux!={},
			AppendTo[listaT, laux[[1]]+x1 laux[[2]]+x2 laux[[3]]+ x3 laux[[4]]>=0 ] 
		];
		cc=ReadLine[ss];
	];

	(*Print["Comprobando inecuaciones sobre los v\[EAcute]rtices:"];*)
	(*Print[comprobarIneq[listaT,#] & /@ pts];*)

	Return[listaT];
];



convexHullIntersection[pts1_,pts2_]:=Module[
{ineq1,ineq2,ineq,pts},
ineq1=facesOfConvexLRS[pts1];
ineq2=facesOfConvexLRS[pts2];
ineq=ineq1~Join~ineq2;
pts=getVerticesLRS[ineq];
Return[pts];
];



verticesOfCone[v_]:=Module[
{laux={},rr,i,j,sols},
rr=raysOfConeOfCHSgr[v];
For[i=1,i<=Length[rr],i++,AppendTo[laux,{}]];
(*Print["rr=",rr];*)
For[i=1,i<=Length[v],i++,
	For[j=1,j<=Length[rr],j++,
		sols=Solve[ {rr[[j]]==\[Lambda] v[[i]]} ,{\[Lambda]}];
		(*Print["sols=",sols];*)
		If[sols!={},AppendTo[laux[[j]],v[[i]]]];
	];
];
Return[laux];
];



classifyVertices[v_,{v1_,v2_,v3_}]:=Module[
{ineq,vDel={},vTra={},i,ss,vi},
ineq=eqOfPlane[{v1,v2,v3}];
For[i=1,i<=Length[v],i++,
vi=v[[i]];
ss=ineq[[1]]/.{x1->vi[[1]],x2->vi[[2]],x3->vi[[3]]};
(*Print["vi=",vi," ss=",ss];*)
If[ss<0,AppendTo[vDel,vi]];
If[ss>0,AppendTo[vTra,vi]];
];
Return[{vTra,vDel}];
];



boundCohenMacaulay[vv_]:=Module[
{Convexo,carasDeVV,vTriangulo,vAdyacentes={},p={},lpuntosPoligono={},lpuntosAux={},pYk={},
laux={},i,j,ii,jj,Maximo=0,maux,lni={},w={},d1,d2,d3,sg={},puntosAux={},lkaux={0,0,0},
daux1=0,daux2=0,daux3=0,ddAux,daux=0,listaAux,vAux,iMas1,iMas2,vpAux,tablaaux,pYkAux={}},
Convexo=ConvexHullMesh[vv];
(* Calculo caras del convexo, son desigualdades *)
carasDeVV=facesOfConvexLRS[vv];
(* Como el cono tiene tres aristas, calculo los v\[EAcute]rtices del convexo que est\[AAcute]n en esas aristas *)
vTriangulo=verticesOfCone[vv];

If[Length[vTriangulo]!=3,Print["The semigroup is not Cohen-Macaulay"];Return[{}];];


lni=ni/@{vTriangulo[[1,1]],vTriangulo[[2,1]],vTriangulo[[3,1]]};
AppendTo[w,lni[[2]]\[Cross]lni[[3]]];
AppendTo[w,lni[[3]]\[Cross]lni[[1]]];
AppendTo[w,lni[[1]]\[Cross]lni[[2]]];
AppendTo[sg,w[[1]].lni[[1]] //Sign];
AppendTo[sg,w[[2]].lni[[2]]//Sign];
AppendTo[sg,w[[3]].lni[[3]]//Sign];
w=Table[w[[i]] sg[[i]],{i,3}];
(*Print["w=",w,"\nlni=",lni];*)
(*Print[Table[w[[i]].lni[[i]],{i,1,3}]];*)
Print[Table[w[[i]].vTriangulo[[i,1]],{i,1,3}]//N];

(*Print["-----"];*)

Print["vTriangulo=",vTriangulo];
(*Print["vTriangulo=",vTriangulo//N];*)
For[i=1,i<=3,i++,
	(*Print["i=",i," en primer For"];*)
	p={};lpuntosPoligono={};lpuntosAux={};vAdyacentes={};
	Print["\nvTriangulo[[",i,"]]=",vTriangulo[[i]]];
	If[Length[vTriangulo[[i]]]>1,
		AppendTo[pYk,kSegmento[vTriangulo[[i]]]];
		(*Print["pYk=",pYk];*)
		If[pYk[[-1]]>Maximo,Maximo=pYk[[-1]]];
		,
		(* Para cada uno de los tres puntos anteriores de vTriangulo, calculo sus v\[EAcute]rtices adyantes en el convexo *)
		vAdyacentes=Select[
			verticesAdyacentes[vTriangulo[[i,1]],Convexo],
			(distintoAtodos[ vTriangulo[[ Mod[i,3]+1 ]],#  ])\[And](distintoAtodos[ vTriangulo[[ Mod[i+1,3]+1 ]],# ]) &
		];
		(*Print[vAdyacentes," ",Table[w[[i]].vAdyacentes[[j]],{j,1,Length[vAdyacentes]}]];*)
		If[Length[vAdyacentes]>0,
			(* Contruyo una lista de parejas con los v\[EAcute]rtices de vTriangulo y sus adyacentes *)
			p=Table[{vTriangulo[[i,1]],vAdyacentes[[j]]},{j,Length[vAdyacentes]}];
			(* Las parejas anteriores junto con el origen definen un plano. El corte de ese plano con el convexo es un pol\[IAcute]gono. Obtengo los v\[EAcute]rtices de ese pol\[IAcute]gono  *)
			lpuntosPoligono=verticesOfPoligon[carasDeVV,#]&/@p;
			(*Print["lpuntosPoligono=",Flatten[lpuntosPoligono,1]," ",#.w[[i]]&/@Flatten[lpuntosPoligono,1]];*)
			(* En cada uno de los pol\[IAcute]gono anteriores hay un elemento de vTriangulo. Calculo los v\[EAcute]rtices adyacent al correspondiente elemento de vTriangulo *)
			lpuntosAux=puntosAdyacentesPoligono[#,vTriangulo[[i,1]]]& /@lpuntosPoligono;
			(* Las parejas anteriores y el correspondiente elemento de vTriangulo definen lados de los pol\[IAcute]gono. Para cada uno de estos lados calculo la iteraci\[OAcute]n k-\[EAcute]sima en la que se cortan y el punto de corte *)
			(*Print["lpuntosAux:",lpuntosAux];*)
			(*Print[#.w[[i]]&/@Flatten[lpuntosAux,1]];*)
			AppendTo[pYk,puntoYKPoligono[vTriangulo[[i,1]],#]&/@lpuntosAux];
			(*Print[pYk[[i]]];*)
			(*Print[Table[pYk[[i,j,1]],{j,Length[pYk[[i]]]}]];*)
			(*Print[  #.w[[i]]& /@ Table[pYk[[i,j,1]],{j,Length[pYk[[i]]]}] ];*)
			maux=Max[(#[[2]])& /@ pYk[[-1]]];
			(*Print[maux];*)
			If[maux>Maximo,Maximo=maux];
			,
			AppendTo[pYk,0];
		];
	];
];

Print["pYk[[1]]=",pYk[[1]]];
Print[ #.w[[1]]&/@ Table[pYk[[1,j,1]],{j,Length[pYk[[1]]]} ] ];
Print["pYk[[2]]=",pYk[[2]]];
Print[ #.w[[2]]&/@ Table[pYk[[2,j,1]],{j,Length[pYk[[2]]]} ] ];
Print["pYk[[3]]=",pYk[[3]]];
Print[ #.w[[3]]&/@ Table[pYk[[3,j,1]],{j,Length[pYk[[3]]]} ] ];

(*d1=Max[(w1.#)&/@()];*)
Print["Maximo=",Maximo];

Print["--------------"];

For[i=1,i<=3,i++,
	daux=0;
	iMas1=Mod[i,3]+1;
	iMas2=Mod[i+1,3]+1;
	If[(pYk[[i]]//Head)==List,
		If[(pYk[[iMas1]]//Head)==List,
			For[j=1,j<=Length[pYk[[iMas1]]],j++,
				ddAux=w[[i]].pYk[[iMas1,j,1]];
				If[ddAux>daux,daux=ddAux;];
			];
		];
		If[(pYk[[iMas2]]//Head)==List,
			For[j=1,j<=Length[pYk[[iMas2]]],j++,
				ddAux=w[[i]].pYk[[iMas2,j,1]];
				If[ddAux>daux,daux=ddAux;];
		];
	];
	lkaux[[i]]=0;
	Print["daux=",daux//N];
	listaAux=Table[pYk[[i,j,1]]+(Maximo-pYk[[i,j,2]]) vTriangulo[[i,1]],{j,Length[pYk[[i]]]}];
	Print["listaAux=",listaAux];
	vAux=w[[i]].# & /@  listaAux;
	Print[vAux//N];
	While[Min[vAux]<daux,
		lkaux[[i]]=lkaux[[i]]+1;
		listaAux=Table[pYk[[i,j,1]]+(Maximo-pYk[[i,j,2]]+lkaux[[i]])vTriangulo[[i,1]],{j,Length[pYk[[i]]]}];
		vAux=w[[i]].# & /@  listaAux;
		Print["vAux=",vAux," ",Min[vAux]," ",lkaux];
	];
	(*Print["listaAux=",listaAux," vAux=",vAux," lkaux=",lkaux];*)
	Print["lkaux[[i]]=",lkaux[[i]]];
];
];

Return[{Maximo,pYk,vTriangulo,lni,Max[lkaux]+Maximo,carasDeVV}];
];



isCohenMacaulay[vertices_,cota_]:=Module[
{lni,k,albAux,puntosDeFuera,i,j,caux=0,lineq},
(*lineq=facesOfConvexLRS[vertices];*)
lineq=cota[[-1]];
(*Print["--------"];*)
k=cota[[-2]];
lni=cota[[4]];
Print["Generators of the rays we use to check the CM condition: ",lni];
albAux=chSemigroup[vertices,k,False,False,False];
puntosDeFuera=albAux[[2]];
For[i=1,i<=Length[puntosDeFuera],i++,
	(*Print["punto de fuera=",puntosDeFuera[[i]]];*)
	caux=0;
	(*Print[belongToCHSgr[lineq,vertices,puntosDeFuera[[i]]]];*)
	For[j=1,j<=3,j++,
		If[belongToCHSgr[lineq,vertices,puntosDeFuera[[i]]+lni[[j]]][[1]],
			caux++;
			(*Print["Pertenece i,j=",i," ",j," puntosDeFuera[[i]]=",puntosDeFuera[[i]]," ni[[j]]=",lni[[j]]];
			,
			Print["No pertenece i,j=",i," ",j," puntosDeFuera[[i]]=",puntosDeFuera[[i]]," ni[[j]]=",lni[[j]]];*)
		];
	];
	(*Print["caux=",caux];*)
	If[caux>=2,
		Print["The point ",puntosDeFuera[[i]]," does not fulfill the condition"];
		Return[False];
	];
];
Return[True];
];


(*facesOf3Cone[p1_,p2_,p3_]:=Module[
{n1,n2,n3},
n1=p1\[Cross]p2;n2=p2\[Cross]p3;n3=p3\[Cross]p1;
Return[
{Sign[n1.p3] (n1.{x1,x2,x3})>= 0,
Sign[n2.p1] (n2.{x1,x2,x3})>= 0,
Sign[n3.p2] (n3.{x1,x2,x3})>= 0}];
];
proportionals[lv_,v_]:=Select[lv,Solve[\[Lambda] #==v,\[Lambda]]!= {} &];*)


chSemigroup[v_,n_,t1_,t2_,t3_]:=Module[
{vConCero,rayos,ConoN,topes,ineqConvexo,ineqCono,i,j,k,puntosCubo,puntosCono,
puntosConoNoEnSemigrupo,
puntosConoEnSemigrupo,AllHighlightMesh={},R,graficos,lp1,lp2,lp3,v1,v2,v3,
lvRayos={},vTriangulo,w},

vConCero={{0.,0.,0.}}~Join~v;
vTriangulo=verticesOfCone[v];
For[i=1,i<=Length[vTriangulo],i++,
	w=Select[vTriangulo[[i]],Norm[#]==Min[Norm/@vTriangulo[[i]]]&][[1]];
	AppendTo[lvRayos,w];
];
Print["vTriangulo=",vTriangulo];
Print["lvRayos=",lvRayos];

If[Length[vTriangulo]!= 3,Print["Semigrupo no simplicial"];];

ineqConvexo=facesOfConvexLRS[v];
Print[ineqConvexo];

ineqCono=facesOfConvexLRS[{{0,0,0}}~Join~(n lvRayos)];
Print[ineqCono];

ConoN=ConvexHullMesh[Union[{{0,0,0}},n*v]];
topes=RegionBounds[ConoN];
puntosCubo=Flatten[Table[{i,j,k},{i,0,topes[[1,2]]},{j,0,topes[[2,2]]},{k,0,topes[[3,2]]}],2];
puntosCono=Select[puntosCubo,And @@(ineqCono/.{x1->#[[1]],x2->#[[2]],x3->#[[3]]})&];
puntosConoEnSemigrupo=Select[puntosCono,belongToCHSgr[ineqConvexo,v,#][[1]]&];

puntosConoNoEnSemigrupo=Complement[puntosCono,puntosConoEnSemigrupo];

Print[puntosCubo//Length," ",puntosCono//Length," ",puntosConoEnSemigrupo//Length," ",puntosConoNoEnSemigrupo//Length];

For[k=1,k<=n,k++,
	R=ConvexHullMesh[k*v];
	AllHighlightMesh=Join[AllHighlightMesh,{HighlightMesh[R,Style[2,Opacity[.5],RGBColor[RandomReal[{0,1},3]]]]}];
];
graficos={AllHighlightMesh,
ListPointPlot3D[Flatten[vTriangulo,1],PlotStyle->{PointSize[Medium],Red}]
};
If[t1,graficos=graficos~Join~
{ListPointPlot3D[puntosConoEnSemigrupo,PlotStyle->{PointSize[Medium],Blue}]}
];

If[t2,graficos=graficos~Join~
{ListPointPlot3D[puntosConoNoEnSemigrupo,PlotStyle->{PointSize[Medium],Black}]}
];

If[t3,graficos=graficos~Join~
	(
		Graphics3D/@
			(
			{Red}
				~Join~
			Table[Line[{{0,0,0},((n+1) lvRayos[[i]])}],{i,1,Length[lvRayos]}]
			)
	)
];

Return[{graficos,puntosConoNoEnSemigrupo,puntosConoEnSemigrupo,lvRayos}];
];


isBuchsbaum[vv_,cota_]:=Module[
{i,j,seguir,inP,c123,f123,rastreo,gen,extP,barP={},genbarP, extbarP,cond2,Vtri,
rayos,puntos,lineq,vTriangulo,lni,puntosDeFuera,caux},
(*test de "simplialidad"*)
{c123,f123,vTriangulo,lni,lineq}={cota[[1]],cota[[5]],cota[[3]],cota[[4]],cota[[-1]]};
If[Length[vTriangulo]!=3,Print["The semigroup is not simplicial"];Return[False];];
gen=generatorsOfConvexHSgr[vv];
gen=msgCHSgr[vv,gen];
extP=chSemigroup[vv,c123,False,False,False][[2]];
For[i=1,i<=Length[extP],i++,
	seguir=True;
	j=0;
	While[seguir \[And] j<Length[gen] ,
		j++;
		inP=extP[[i]]+gen[[j]];
		If[\[Not]belongToCHSgr[lineq,vv,inP],seguir=False;];
	];
	If[j==Length[gen]\[And]seguir,AppendTo[barP,extP[[i]]]];
];
puntosDeFuera=Complement[extP,barP];
For[i=1,i<=Length[puntosDeFuera],i++,
	caux=0;
	Print[belongToCHSgr[lineq,vv,puntosDeFuera[[i]]]];
	For[j=1,j<=3,j++,
		If[belongToCHSgr[lineq,vv,puntosDeFuera[[i]]+lni[[j]]] [[1]]\[And]Not[belongToCHSgr[lineq,vv,puntosDeFuera[[i]]]],
			caux++;
			Print["Pertenece i,j=",i," ",j," puntosDeFuera[[i]]=",puntosDeFuera[[i]]," lni[[j]]=",lni[[j]]];,
			Print["No pertenece i,j=",i," ",j," puntosDeFuera[[i]]=",puntosDeFuera[[i]]," lni[[j]]=",lni[[j]]];
		];
	];
	Print["caux=",caux];
	If[caux>=2,Return[False]];
];
Return[True];
];



End[]


EndPackage[]
