(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    992567,      25822]
NotebookOptionsPosition[    939286,      24320]
NotebookOutlinePosition[    939625,      24335]
CellTagsIndexPosition[    939582,      24332]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["C\[AAcute]lculo de cota", "Section",
 CellChangeTimes->{{3.6400626877544994`*^9, 3.640062692075549*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6410491101147895`*^9, 3.641049111068471*^9}, {
  3.6416241096263*^9, 3.6416241102200737`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", 
   RowBox[{"\"\<convexHullSemigroups3D`\>\"", ",", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
     "\"\<\\\\convexHullSemigroups3DLibraryV6.wl\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6413672154453716`*^9, 3.6413673099854956`*^9}, 
   3.6416212537002673`*^9}],

Cell[BoxData["\<\"J. I. Garc\[IAcute]a-Garc\[IAcute]a and A. \
Vigneron-Tenorio,\\nDpto. Matem\[AAcute]ticas, \\nUniversidad de \
C\[AAcute]diz\\nignacio.garcia@uca.es, alberto.vigneron@uca.es\\n\\nThis \
package contains the commands: \\n....\\nTry command::usage for more \
help\"\>"], "Print",
 CellChangeTimes->{3.6416223844997067`*^9, 3.6416224622647743`*^9, 
  3.6416240509982386`*^9, 3.641624113227578*^9, 3.641624148340065*^9, 
  3.6416242137122536`*^9, 3.641624295671147*^9, 3.6416245152265215`*^9, 
  3.6427418933670087`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"configuration", "[", 
   RowBox[{
   "\"\<C:\\\\tmp\\\\lrs\\\\lrs.exe\>\"", ",", "\"\<C:\\\\tmp\\\\\>\"", ",", 
    "\"\<C:\\\\tmp\\\\Normaliz2.12\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"showConfiguration", "[", "]"}]}], "Input",
 CellChangeTimes->{{3.64104912673164*^9, 3.6410491300119753`*^9}, 
   3.641049284252866*^9, {3.6411073213478384`*^9, 3.641107352088739*^9}, {
   3.6411074438150835`*^9, 3.64110744640294*^9}, {3.641291681429268*^9, 
   3.6412916825410633`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C:\\\\tmp\\\\lrs\\\\lrs.exe\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\Normaliz2.12\"\>"}],
  SequenceForm[
  "C:\\tmp\\lrs\\lrs.exe", "\n", "C:\\tmp\\", "\n", "C:\\tmp\\Normaliz2.12"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916915704775`*^9, 3.6412920530581627`*^9, 3.641292107821059*^9, 
   3.6412923027524824`*^9, 3.6412926124162135`*^9, 3.6413671123761806`*^9, 
   3.6413671663835325`*^9, 3.6413673164110575`*^9, 3.641572860448511*^9, 
   3.641621409961348*^9, 3.641621957588744*^9, 3.6416220967311087`*^9, 
   3.6416221637162447`*^9, 3.641622315087103*^9, {3.6416223651152782`*^9, 
   3.6416223854535227`*^9}, 3.641622462358528*^9, 3.641624051091992*^9, 
   3.641624113294647*^9, 3.6416241484338183`*^9, 3.6416242137747564`*^9, 
   3.6416242957648993`*^9, 3.6416245158802032`*^9, 3.64274189502423*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vww", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "3", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "/", "2"}], ",", "3", ",", 
      RowBox[{"9", "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"33", "/", "16"}], ",", 
      RowBox[{"27", "/", "8"}], ",", 
      RowBox[{"63", "/", "16"}]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.642741899243373*^9, 3.6427419409089723`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", "2"], ",", "3", ",", 
     FractionBox["9", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["33", "16"], ",", 
     FractionBox["27", "8"], ",", 
     FractionBox["63", "16"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.642741941737134*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msgCHSgr", "::", "usage"}]], "Input",
 CellChangeTimes->{{3.6427419568448477`*^9, 3.642741961161625*^9}}],

Cell[BoxData["\<\"Computes a minimal set of generators of the convex \
semigroup defined by the polyhedron \\nwith vertices verticesOfPolyhedron and \
geenrators \
generatorsOfSemigroup.\\n\\nExample:\\nmsgCHSgr[verticesOfPolyhedron,\
generatorsOfSemigroup]\\n\"\>"], "Output",
 CellChangeTimes->{3.6427419616303816`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"generatorsOfConvexHSgr", "::", "usage"}]], "Input",
 CellChangeTimes->{{3.642741968291008*^9, 3.6427419724202657`*^9}}],

Cell[BoxData["\<\"Returns a set of generators of the convex semigroup \
generated with the polyhedron with vertices verticesOfPolyhedron. \\nIt uses \
the program \
normaliz.exe.\\n\\nExample:\\ngeneratorsOfConvexHSgr[verticesOfPolyhedron]\\n\
\"\>"], "Output",
 CellChangeTimes->{3.642741973108839*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"genvww", "=", 
  RowBox[{"generatorsOfConvexHSgr", "[", "vww", "]"}]}]], "Input",
 CellChangeTimes->{{3.642741977979003*^9, 3.6427419843362665`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.6427419851654067`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "3", ",", "3", ",", "2", ",", "2", ",", "3", ",", "1", ",", "1", ",", "2",
      ",", "3", ",", 
     FractionBox["3", "2"], ",", "3", ",", 
     FractionBox["9", "2"], ",", 
     FractionBox["33", "16"], ",", 
     FractionBox["27", "8"], ",", 
     FractionBox["63", "16"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {3, 3, 2, 2, 3, 1, 1, 2, 3, 
    Rational[3, 2], 3, 
    Rational[9, 2], 
    Rational[33, 16], 
    Rational[27, 8], 
    Rational[63, 16]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6427419851654067`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"48", ",", "48", ",", "32"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"32", ",", "48", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"16", ",", "32", ",", "48"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"24", ",", "48", ",", "72"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"33", ",", "54", ",", "63"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{48, 48, 32}, {32, 48, 16}, {16, 32, 48}, {24, 48, 72}, {33, 54, 
   63}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6427419851654067`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6427419851654067`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\tmp\\\
\\aux1\"\>"], "Print",
 CellChangeTimes->{3.6427419851654067`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "13", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "23", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "30", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "30", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "40", ",", "44"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "47", ",", "54"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "54", ",", "63"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.642741986619616*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msgCHSgr", "[", 
  RowBox[{"vww", ",", "genvww"}], "]"}]], "Input",
 CellChangeTimes->{{3.642741995765708*^9, 3.6427420064931803`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.642742007854553*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v2", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5", ",", "7"}], "}"}]}], "}"}], "*", 
   RowBox[{"5", "/", "7"}], "*", 
   RowBox[{"1", "/", "7"}]}]}]], "Input",
 CellChangeTimes->{{3.6416213024972525`*^9, 3.6416213116166744`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["10", "49"], ",", 
     FractionBox["10", "49"], ",", 
     FractionBox["10", "49"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["30", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["20", "49"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["15", "49"], ",", 
     FractionBox["25", "49"], ",", 
     FractionBox["15", "49"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["15", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["45", "49"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["25", "49"], ",", 
     FractionBox["25", "49"], ",", 
     FractionBox["5", "7"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6416213152801924`*^9, 3.641621414423068*^9, 3.641621959793275*^9, 
   3.6416220988256907`*^9, 3.641622165030876*^9, 3.6416223162748775`*^9, {
   3.641622367217602*^9, 3.6416223872604055`*^9}, 3.6416224633468857`*^9, 
   3.641624052263914*^9, 3.641624113963585*^9, 3.641624149935889*^9, 
   3.6416242148841753`*^9, 3.641624297063163*^9, 3.641624517397046*^9, 
   3.6416346034805717`*^9, 3.6416358178975463`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cotav2", "=", 
  RowBox[{"boundCohenMacaulay", "[", "v2", "]"}]}]], "Input",
 CellChangeTimes->{{3.641621592295582*^9, 3.6416216060918517`*^9}, {
  3.6416245450306396`*^9, 3.6416245476928515`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358189344063`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["10", "49"], ",", 
     FractionBox["10", "49"], ",", 
     FractionBox["10", "49"], ",", 
     FractionBox["30", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["20", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["25", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["45", "49"], ",", 
     FractionBox["25", "49"], ",", 
     FractionBox["25", "49"], ",", 
     FractionBox["5", "7"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[10, 49], 
    Rational[10, 49], 
    Rational[10, 49], 
    Rational[30, 49], 
    Rational[15, 49], 
    Rational[20, 49], 
    Rational[15, 49], 
    Rational[25, 49], 
    Rational[15, 49], 
    Rational[15, 49], 
    Rational[15, 49], 
    Rational[45, 49], 
    Rational[25, 49], 
    Rational[25, 49], 
    Rational[5, 7]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358189344063`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "10", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "15", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "25", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15", ",", "45"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "25", ",", "35"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{10, 10, 10}, {30, 15, 20}, {15, 25, 15}, {15, 15, 45}, {25, 25, 
   35}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358189344063`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358189344063`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.641635819059411*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "352.0408163265306`", ",", "352.0408163265306`", ",", 
   "352.0408163265306`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.64163581916879*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["30", "49"], ",", 
        FractionBox["15", "49"], ",", 
        FractionBox["20", "49"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "49"], ",", 
        FractionBox["25", "49"], ",", 
        FractionBox["15", "49"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "49"], ",", 
        FractionBox["15", "49"], ",", 
        FractionBox["45", "49"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[30, 49], 
      Rational[15, 49], 
      Rational[20, 49]}}, {{
      Rational[15, 49], 
      Rational[25, 49], 
      Rational[15, 49]}}, {{
      Rational[15, 49], 
      Rational[15, 49], 
      Rational[45, 49]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.641635819184416*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["30", "49"], ",", 
      FractionBox["15", "49"], ",", 
      FractionBox["20", "49"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 1, "]]=", {{
     Rational[30, 49], 
     Rational[15, 49], 
     Rational[20, 49]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.641635819184416*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["15", "49"], ",", 
      FractionBox["25", "49"], ",", 
      FractionBox["15", "49"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 2, "]]=", {{
     Rational[15, 49], 
     Rational[25, 49], 
     Rational[15, 49]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358194188004`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["15", "49"], ",", 
      FractionBox["15", "49"], ",", 
      FractionBox["45", "49"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 3, "]]=", {{
     Rational[15, 49], 
     Rational[15, 49], 
     Rational[45, 49]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358196743836`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[1]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["15", "28"], ",", 
         FractionBox["45", "98"], ",", 
         FractionBox["125", "196"]}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["400", "833"], ",", 
         FractionBox["355", "833"], ",", 
         FractionBox["370", "833"]}], "}"}], ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["pYk[[1]]=", {{{
      Rational[15, 28], 
      Rational[45, 98], 
      Rational[125, 196]}, 1}, {{
      Rational[400, 833], 
      Rational[355, 833], 
      Rational[370, 833]}, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199400196`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["17625", "98"], ",", 
   FractionBox["144750", "833"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199400196`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[2]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["355", "833"], ",", 
         FractionBox["55", "119"], ",", 
         FractionBox["355", "833"]}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["45", "98"], ",", 
         FractionBox["25", "49"], ",", 
         FractionBox["30", "49"]}], "}"}], ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["pYk[[2]]=", {{{
      Rational[355, 833], 
      Rational[55, 119], 
      Rational[355, 833]}, 1}, {{
      Rational[45, 98], 
      Rational[25, 49], 
      Rational[30, 49]}, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199400196`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11250", "49"], ",", 
   FractionBox["22125", "98"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199556456`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[3]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["45", "98"], ",", 
         FractionBox["45", "98"], ",", 
         FractionBox["75", "98"]}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["45", "98"], ",", 
         FractionBox["45", "98"], ",", 
         FractionBox["75", "98"]}], "}"}], ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["pYk[[3]]=", {{{
      Rational[45, 98], 
      Rational[45, 98], 
      Rational[75, 98]}, 1}, {{
      Rational[45, 98], 
      Rational[45, 98], 
      Rational[75, 98]}, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199556456`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["10125", "49"], ",", 
   FractionBox["10125", "49"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199556456`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximo=\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Maximo=", 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199556456`*^9}],

Cell[BoxData["\<\"--------------\"\>"], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199712706`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "111.64465786314526`"}],
  SequenceForm["daux=", 111.64465786314526`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199712706`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "28"], ",", 
       FractionBox["45", "98"], ",", 
       FractionBox["125", "196"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["400", "833"], ",", 
       FractionBox["355", "833"], ",", 
       FractionBox["370", "833"]}], "}"}]}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[15, 28], 
     Rational[45, 98], 
     Rational[125, 196]}, {
     Rational[400, 833], 
     Rational[355, 833], 
     Rational[370, 833]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199712706`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"179.8469387755102`", ",", "173.76950780312126`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199712706`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199712706`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "167.46698679471788`"}],
  SequenceForm["daux=", 167.46698679471788`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199868965`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["355", "833"], ",", 
       FractionBox["55", "119"], ",", 
       FractionBox["355", "833"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["45", "98"], ",", 
       FractionBox["25", "49"], ",", 
       FractionBox["30", "49"]}], "}"}]}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[355, 833], 
     Rational[55, 119], 
     Rational[355, 833]}, {
     Rational[45, 98], 
     Rational[25, 49], 
     Rational[30, 49]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199868965`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"229.59183673469389`", ",", "225.76530612244898`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199868965`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358199868965`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "118.62244897959184`"}],
  SequenceForm["daux=", 118.62244897959184`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.641635820002646*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["45", "98"], ",", 
       FractionBox["45", "98"], ",", 
       FractionBox["75", "98"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["45", "98"], ",", 
       FractionBox["45", "98"], ",", 
       FractionBox["75", "98"]}], "}"}]}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[45, 98], 
     Rational[45, 98], 
     Rational[75, 98]}, {
     Rational[45, 98], 
     Rational[45, 98], 
     Rational[75, 98]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358200066504`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"206.6326530612245`", ",", "206.6326530612245`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358200106535`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416216067115927`*^9, 3.6416219268279104`*^9, 3.6416219624147124`*^9, 
   3.641622101941196*^9, 3.6416221674214153`*^9, 3.6416223188136144`*^9, {
   3.641622368085146*^9, 3.641622389620453*^9}, 3.641622465891431*^9, 
   3.641624055223098*^9, 3.64162411661994*^9, 3.641624152519643*^9, 
   3.6416242174211855`*^9, 3.641624299583577*^9, {3.6416245198531065`*^9, 
   3.641624548861513*^9}, 3.6416346047156754`*^9, 3.6416358200136566`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["15", "28"], ",", 
           FractionBox["45", "98"], ",", 
           FractionBox["125", "196"]}], "}"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["400", "833"], ",", 
           FractionBox["355", "833"], ",", 
           FractionBox["370", "833"]}], "}"}], ",", "1"}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["355", "833"], ",", 
           FractionBox["55", "119"], ",", 
           FractionBox["355", "833"]}], "}"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["45", "98"], ",", 
           FractionBox["25", "49"], ",", 
           FractionBox["30", "49"]}], "}"}], ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["45", "98"], ",", 
           FractionBox["45", "98"], ",", 
           FractionBox["75", "98"]}], "}"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["45", "98"], ",", 
           FractionBox["45", "98"], ",", 
           FractionBox["75", "98"]}], "}"}], ",", "1"}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["30", "49"], ",", 
        FractionBox["15", "49"], ",", 
        FractionBox["20", "49"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "49"], ",", 
        FractionBox["25", "49"], ",", 
        FractionBox["15", "49"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "49"], ",", 
        FractionBox["15", "49"], ",", 
        FractionBox["45", "49"]}], "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"30", ",", "15", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "25", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15", ",", "45"}], "}"}]}], "}"}], ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"155", "-", 
       RowBox[{"196", " ", "x1"}], "-", 
       RowBox[{"245", " ", "x2"}], "+", 
       RowBox[{"98", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"180", "-", 
       RowBox[{"245", " ", "x1"}], "+", 
       RowBox[{"98", " ", "x2"}], "-", 
       RowBox[{"147", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"60", "+", 
       RowBox[{"98", " ", "x1"}], "-", 
       RowBox[{"147", " ", "x2"}], "-", 
       RowBox[{"49", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "40"}], "-", 
       RowBox[{"245", " ", "x1"}], "-", 
       RowBox[{"98", " ", "x2"}], "+", 
       RowBox[{"539", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "180"}], "-", 
       RowBox[{"245", " ", "x1"}], "+", 
       RowBox[{"1274", " ", "x2"}], "-", 
       RowBox[{"147", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "60"}], "+", 
       RowBox[{"490", " ", "x1"}], "-", 
       RowBox[{"147", " ", "x2"}], "-", 
       RowBox[{"49", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.641621600569519*^9, 3.6416216967574215`*^9, 3.641621927062294*^9, 
   3.641622092041119*^9, 3.6416221487397413`*^9, 3.6416223095074005`*^9, {
   3.641622360247445*^9, 3.6416223795747147`*^9}, 3.64162245674627*^9, 
   3.6416225390205297`*^9, 3.64162408493032*^9, 3.641624142153811*^9, 
   3.641624208675401*^9, {3.6416242904745016`*^9, 3.6416243006697326`*^9}, {
   3.641624520844437*^9, 3.641624549847475*^9}, 3.6416346057313404`*^9, 
   3.641635820019662*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"v2", ",", "2", ",", "False", ",", "False", ",", "True"}], "]"}], 
   "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.6416214451565046`*^9, 3.641621556053341*^9}, {
  3.6416225425379543`*^9, 3.641622548530098*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.641621549543579*^9, 3.641621556568989*^9}, {
   3.6416225441105404`*^9, 3.6416225489125605`*^9}, {3.641624530294053*^9, 
   3.641624551550668*^9}, 3.6416346093754787`*^9, 3.641635821733494*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["10", "49"], ",", 
     FractionBox["10", "49"], ",", 
     FractionBox["10", "49"], ",", 
     FractionBox["30", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["20", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["25", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["45", "49"], ",", 
     FractionBox["25", "49"], ",", 
     FractionBox["25", "49"], ",", 
     FractionBox["5", "7"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[10, 49], 
    Rational[10, 49], 
    Rational[10, 49], 
    Rational[30, 49], 
    Rational[15, 49], 
    Rational[20, 49], 
    Rational[15, 49], 
    Rational[25, 49], 
    Rational[15, 49], 
    Rational[15, 49], 
    Rational[15, 49], 
    Rational[45, 49], 
    Rational[25, 49], 
    Rational[25, 49], 
    Rational[5, 7]}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641621549543579*^9, 3.641621556568989*^9}, {
   3.6416225441105404`*^9, 3.6416225489125605`*^9}, {3.641624530294053*^9, 
   3.641624551550668*^9}, 3.6416346093754787`*^9, 3.641635821733494*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "10", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "15", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "25", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15", ",", "45"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "25", ",", "35"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{10, 10, 10}, {30, 15, 20}, {15, 25, 15}, {15, 15, 45}, {25, 25, 
   35}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641621549543579*^9, 3.641621556568989*^9}, {
   3.6416225441105404`*^9, 3.6416225489125605`*^9}, {3.641624530294053*^9, 
   3.641624551550668*^9}, 3.6416346093754787`*^9, 3.6416358217491198`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641621549543579*^9, 3.641621556568989*^9}, {
   3.6416225441105404`*^9, 3.6416225489125605`*^9}, {3.641624530294053*^9, 
   3.641624551550668*^9}, 3.6416346093754787`*^9, 3.6416358217491198`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.641621549543579*^9, 3.641621556568989*^9}, {
   3.6416225441105404`*^9, 3.6416225489125605`*^9}, {3.641624530294053*^9, 
   3.641624551550668*^9}, 3.6416346093754787`*^9, 3.6416358218116217`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["30", "49"], ",", 
        FractionBox["15", "49"], ",", 
        FractionBox["20", "49"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "49"], ",", 
        FractionBox["25", "49"], ",", 
        FractionBox["15", "49"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "49"], ",", 
        FractionBox["15", "49"], ",", 
        FractionBox["45", "49"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[30, 49], 
      Rational[15, 49], 
      Rational[20, 49]}}, {{
      Rational[15, 49], 
      Rational[25, 49], 
      Rational[15, 49]}}, {{
      Rational[15, 49], 
      Rational[15, 49], 
      Rational[45, 49]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641621549543579*^9, 3.641621556568989*^9}, {
   3.6416225441105404`*^9, 3.6416225489125605`*^9}, {3.641624530294053*^9, 
   3.641624551550668*^9}, 3.6416346093754787`*^9, 3.6416358219210014`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["30", "49"], ",", 
       FractionBox["15", "49"], ",", 
       FractionBox["20", "49"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "49"], ",", 
       FractionBox["25", "49"], ",", 
       FractionBox["15", "49"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "49"], ",", 
       FractionBox["15", "49"], ",", 
       FractionBox["45", "49"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{
     Rational[30, 49], 
     Rational[15, 49], 
     Rational[20, 49]}, {
     Rational[15, 49], 
     Rational[25, 49], 
     Rational[15, 49]}, {
     Rational[15, 49], 
     Rational[15, 49], 
     Rational[45, 49]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641621549543579*^9, 3.641621556568989*^9}, {
   3.6416225441105404`*^9, 3.6416225489125605`*^9}, {3.641624530294053*^9, 
   3.641624551550668*^9}, 3.6416346093754787`*^9, 3.641635821936627*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"155", "-", 
     RowBox[{"196", " ", "x1"}], "-", 
     RowBox[{"245", " ", "x2"}], "+", 
     RowBox[{"98", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"180", "-", 
     RowBox[{"245", " ", "x1"}], "+", 
     RowBox[{"98", " ", "x2"}], "-", 
     RowBox[{"147", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"60", "+", 
     RowBox[{"98", " ", "x1"}], "-", 
     RowBox[{"147", " ", "x2"}], "-", 
     RowBox[{"49", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "40"}], "-", 
     RowBox[{"245", " ", "x1"}], "-", 
     RowBox[{"98", " ", "x2"}], "+", 
     RowBox[{"539", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "180"}], "-", 
     RowBox[{"245", " ", "x1"}], "+", 
     RowBox[{"1274", " ", "x2"}], "-", 
     RowBox[{"147", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "60"}], "+", 
     RowBox[{"490", " ", "x1"}], "-", 
     RowBox[{"147", " ", "x2"}], "-", 
     RowBox[{"49", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.641621549543579*^9, 3.641621556568989*^9}, {
   3.6416225441105404`*^9, 3.6416225489125605`*^9}, {3.641624530294053*^9, 
   3.641624551550668*^9}, 3.6416346093754787`*^9, 3.6416358221085086`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "11"}], " ", "x1"}], "-", 
     RowBox[{"6", " ", "x2"}], "+", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"6", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], " ", "x1"}], "+", 
     RowBox[{"14", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"690", "-", 
     RowBox[{"245", " ", "x1"}], "-", 
     RowBox[{"441", " ", "x2"}], "-", 
     RowBox[{"147", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.641621549543579*^9, 3.641621556568989*^9}, {
   3.6416225441105404`*^9, 3.6416225489125605`*^9}, {3.641624530294053*^9, 
   3.641624551550668*^9}, 3.6416346093754787`*^9, 3.641635822233514*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm[8, " ", 1, " ", 1, " ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641621549543579*^9, 3.641621556568989*^9}, {
   3.6416225441105404`*^9, 3.6416225489125605`*^9}, {3.641624530294053*^9, 
   3.641624551550668*^9}, 3.6416346093754787`*^9, 3.6416358222491393`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{0.20408163265306123`, 0.20408163265306123`, 
    0.20408163265306123`}, {0.30612244897959184`, 0.30612244897959184`, 
    0.9183673469387755}, {0.30612244897959184`, 0.5102040816326531, 
    0.30612244897959184`}, {0.5102040816326531, 0.5102040816326531, 
    0.7142857142857143}, {0.6122448979591837, 0.30612244897959184`, 
    0.40816326530612246`}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.4978335884424161, 0.5538302857072932, 0.32468546949767907`], Opacity[
     0.5]}], Polygon3DBox[{{2, 5, 4}, {1, 5, 2}, {1, 2, 3}, {2, 4, 3}, {4, 5, 
      3}, {5, 1, 3}}]}], 
   GraphicsComplex3DBox[{{0.40816326530612246`, 0.40816326530612246`, 
    0.40816326530612246`}, {0.6122448979591837, 0.6122448979591837, 
    1.836734693877551}, {0.6122448979591837, 1.0204081632653061`, 
    0.6122448979591837}, {1.0204081632653061`, 1.0204081632653061`, 
    1.4285714285714286`}, {1.2244897959183674`, 0.6122448979591837, 
    0.8163265306122449}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.5073311809248133, 0.4465494675340069, 0.035954483553719996`], Opacity[
     0.5]}], Polygon3DBox[{{2, 5, 4}, {1, 5, 2}, {1, 2, 3}, {2, 4, 3}, {4, 5, 
      3}, {5, 1, 3}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[
     NCache[{{Rational[30, 49], Rational[15, 49], Rational[20, 49]}, {
       Rational[15, 49], Rational[25, 49], Rational[15, 49]}, {
       Rational[15, 49], Rational[15, 49], Rational[45, 49]}}, {{
      0.6122448979591837, 0.30612244897959184`, 0.40816326530612246`}, {
      0.30612244897959184`, 0.5102040816326531, 0.30612244897959184`}, {
      0.30612244897959184`, 0.30612244897959184`, 0.9183673469387755}}]]}, 
   {RGBColor[1, 0, 0], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[90, 49], Rational[45, 49], Rational[60, 49]}}, {{0, 0, 0}, {
       1.836734693877551, 0.9183673469387755, 1.2244897959183674`}}]], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[45, 49], Rational[75, 49], Rational[45, 49]}}, {{0, 0, 0}, {
       0.9183673469387755, 1.530612244897959, 0.9183673469387755}}]], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[45, 49], Rational[45, 49], Rational[135, 49]}}, {{0, 0, 0}, {
       0.9183673469387755, 0.9183673469387755, 2.7551020408163267`}}]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{350.6473124754832, 384.397132311236},
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All,
  ViewPoint->{0.37007456559449103`, -0.8270564013933277, 3.2602181713520904`},
  ViewVertical->{-0.7254841480628262, 0.7401179535395234, 
   0.7726645767711781}]], "Output",
 CellChangeTimes->{{3.6416214519536996`*^9, 3.641621557303391*^9}, {
   3.6416225451607556`*^9, 3.6416225494594574`*^9}, {3.6416245309034524`*^9, 
   3.6416245521148305`*^9}, 3.64163460998234*^9, 3.6416358223428926`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isCohenMacaulay", "[", 
  RowBox[{"v2", ",", "cotav2"}], "]"}]], "Input",
 CellChangeTimes->{{3.641624538377606*^9, 3.641624570586091*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generators of the rays we use to check the CM condition: \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"30", ",", "15", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "25", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15", ",", "45"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Generators of the rays we use to check the CM condition: ", {{30, 15, 
   20}, {15, 25, 15}, {15, 15, 45}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64162457150634*^9, 3.641634612560521*^9, 
  3.6416358266984515`*^9}],

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.64162457150634*^9, 3.641634612560521*^9, 
  3.6416358266984515`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["10", "49"], ",", 
     FractionBox["10", "49"], ",", 
     FractionBox["10", "49"], ",", 
     FractionBox["30", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["20", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["25", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["15", "49"], ",", 
     FractionBox["45", "49"], ",", 
     FractionBox["25", "49"], ",", 
     FractionBox["25", "49"], ",", 
     FractionBox["5", "7"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[10, 49], 
    Rational[10, 49], 
    Rational[10, 49], 
    Rational[30, 49], 
    Rational[15, 49], 
    Rational[20, 49], 
    Rational[15, 49], 
    Rational[25, 49], 
    Rational[15, 49], 
    Rational[15, 49], 
    Rational[15, 49], 
    Rational[45, 49], 
    Rational[25, 49], 
    Rational[25, 49], 
    Rational[5, 7]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64162457150634*^9, 3.641634612560521*^9, 
  3.641635826714077*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "10", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "15", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "25", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15", ",", "45"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "25", ",", "35"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{10, 10, 10}, {30, 15, 20}, {15, 25, 15}, {15, 15, 45}, {25, 25, 
   35}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64162457150634*^9, 3.641634612560521*^9, 
  3.641635826714077*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64162457150634*^9, 3.641634612560521*^9, 
  3.641635826714077*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.64162457150634*^9, 3.641634612560521*^9, 
  3.641635826729703*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["30", "49"], ",", 
        FractionBox["15", "49"], ",", 
        FractionBox["20", "49"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "49"], ",", 
        FractionBox["25", "49"], ",", 
        FractionBox["15", "49"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "49"], ",", 
        FractionBox["15", "49"], ",", 
        FractionBox["45", "49"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[30, 49], 
      Rational[15, 49], 
      Rational[20, 49]}}, {{
      Rational[15, 49], 
      Rational[25, 49], 
      Rational[15, 49]}}, {{
      Rational[15, 49], 
      Rational[15, 49], 
      Rational[45, 49]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64162457150634*^9, 3.641634612560521*^9, 
  3.6416358268703337`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["30", "49"], ",", 
       FractionBox["15", "49"], ",", 
       FractionBox["20", "49"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "49"], ",", 
       FractionBox["25", "49"], ",", 
       FractionBox["15", "49"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "49"], ",", 
       FractionBox["15", "49"], ",", 
       FractionBox["45", "49"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{
     Rational[30, 49], 
     Rational[15, 49], 
     Rational[20, 49]}, {
     Rational[15, 49], 
     Rational[25, 49], 
     Rational[15, 49]}, {
     Rational[15, 49], 
     Rational[15, 49], 
     Rational[45, 49]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64162457150634*^9, 3.641634612560521*^9, 
  3.6416358268703337`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"155", "-", 
     RowBox[{"196", " ", "x1"}], "-", 
     RowBox[{"245", " ", "x2"}], "+", 
     RowBox[{"98", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"180", "-", 
     RowBox[{"245", " ", "x1"}], "+", 
     RowBox[{"98", " ", "x2"}], "-", 
     RowBox[{"147", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"60", "+", 
     RowBox[{"98", " ", "x1"}], "-", 
     RowBox[{"147", " ", "x2"}], "-", 
     RowBox[{"49", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "40"}], "-", 
     RowBox[{"245", " ", "x1"}], "-", 
     RowBox[{"98", " ", "x2"}], "+", 
     RowBox[{"539", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "180"}], "-", 
     RowBox[{"245", " ", "x1"}], "+", 
     RowBox[{"1274", " ", "x2"}], "-", 
     RowBox[{"147", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "60"}], "+", 
     RowBox[{"490", " ", "x1"}], "-", 
     RowBox[{"147", " ", "x2"}], "-", 
     RowBox[{"49", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.64162457150634*^9, 3.641634612560521*^9, 
  3.641635827010964*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "11"}], " ", "x1"}], "-", 
     RowBox[{"6", " ", "x2"}], "+", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"6", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], " ", "x1"}], "+", 
     RowBox[{"14", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"345", "-", 
     RowBox[{"245", " ", "x1"}], "-", 
     RowBox[{"441", " ", "x2"}], "-", 
     RowBox[{"147", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.64162457150634*^9, 3.641634612560521*^9, 
  3.641635827151594*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm[1, " ", 1, " ", 1, " ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.64162457150634*^9, 3.641634612560521*^9, 
  3.641635827151594*^9}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.6416245595997267`*^9, 3.641624571990734*^9}, 
   3.641634613060541*^9, 3.641635827198471*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "Section"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6410491101147895`*^9, 3.641049111068471*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", 
   RowBox[{"\"\<convexHullSemigroups3D`\>\"", ",", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
     "\"\<\\\\convexHullSemigroups3DLibraryV6.wl\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6413672154453716`*^9, 3.6413673099854956`*^9}, 
   3.6416212537158933`*^9}],

Cell[BoxData["\<\"J. I. Garc\[IAcute]a-Garc\[IAcute]a and A. \
Vigneron-Tenorio,\\nDpto. Matem\[AAcute]ticas, \\nUniversidad de \
C\[AAcute]diz\\nignacio.garcia@uca.es, alberto.vigneron@uca.es\\n\\nThis \
package contains the commands: \\n....\\nTry command::usage for more \
help\"\>"], "Print",
 CellChangeTimes->{3.6415427362860737`*^9, 3.641624584318495*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"configuration", "[", 
   RowBox[{
   "\"\<C:\\\\tmp\\\\lrs\\\\lrs.exe\>\"", ",", "\"\<C:\\\\tmp\\\\\>\"", ",", 
    "\"\<C:\\\\tmp\\\\Normaliz2.12\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"showConfiguration", "[", "]"}]}], "Input",
 CellChangeTimes->{{3.64104912673164*^9, 3.6410491300119753`*^9}, 
   3.641049284252866*^9, {3.6411073213478384`*^9, 3.641107352088739*^9}, {
   3.6411074438150835`*^9, 3.64110744640294*^9}, {3.641291681429268*^9, 
   3.6412916825410633`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C:\\\\tmp\\\\lrs\\\\lrs.exe\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\Normaliz2.12\"\>"}],
  SequenceForm[
  "C:\\tmp\\lrs\\lrs.exe", "\n", "C:\\tmp\\", "\n", "C:\\tmp\\Normaliz2.12"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6415427373348045`*^9, 3.641624586025628*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v2", "=", 
  RowBox[{
   RowBox[{"8", "/", "3"}], "*", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", "/", "10"}], "*", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
      RowBox[{
       RowBox[{"3", "/", "11"}], "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
      RowBox[{
       RowBox[{"3", "/", "11"}], "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
      RowBox[{
       RowBox[{"3", "/", "11"}], "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "5"}], ",", 
         RowBox[{
          RowBox[{"-", "11"}], "/", "10"}], ",", 
         RowBox[{
          RowBox[{"-", "11"}], "/", "10"}]}], "}"}]}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.6415427319549885`*^9, 3.6415427446900177`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["12", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["8", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["152", "33"], ",", 
     FractionBox["152", "33"], ",", 
     FractionBox["16", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["152", "33"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["152", "33"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["856", "165"], ",", 
     FractionBox["68", "15"], ",", 
     FractionBox["68", "15"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.641542745906892*^9, 3.6416245876835756`*^9, 
  3.641634619400796*^9, 3.6416358318257647`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"chSemigroup", "[", 
     RowBox[{"v2", ",", "4", ",", "False", ",", "True", ",", "True"}], "]"}], 
    "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.641542763036048*^9, 3.6415427787041845`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.6415427793256235`*^9, 3.6416245890442557`*^9, 
  3.6416346215561094`*^9, 3.641635832893358*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["152", "33"], ",", 
     FractionBox["152", "33"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["152", "33"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["152", "33"], ",", 
     FractionBox["856", "165"], ",", 
     FractionBox["68", "15"], ",", 
     FractionBox["68", "15"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[24, 5], 
    Rational[12, 5], 
    Rational[12, 5], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[152, 33], 
    Rational[152, 33], 
    Rational[16, 3], 
    Rational[152, 33], 
    Rational[16, 3], 
    Rational[152, 33], 
    Rational[856, 165], 
    Rational[68, 15], 
    Rational[68, 15]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6415427793256235`*^9, 3.6416245890442557`*^9, 
  3.6416346215561094`*^9, 3.641635832893358*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"792", ",", "396", ",", "396"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"440", ",", "880", ",", "440"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"440", ",", "440", ",", "880"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"760", ",", "760", ",", "880"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"760", ",", "880", ",", "760"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"856", ",", "748", ",", "748"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{792, 396, 396}, {440, 880, 440}, {440, 440, 880}, {760, 760, 880}, {
   760, 880, 760}, {856, 748, 748}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6415427793256235`*^9, 3.6416245890442557`*^9, 
  3.6416346215561094`*^9, 3.641635832893358*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6415427793256235`*^9, 3.6416245890442557`*^9, 
  3.6416346215561094`*^9, 3.641635832908983*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.6415427793256235`*^9, 3.6416245890442557`*^9, 
  3.6416346215561094`*^9, 3.6416358329558597`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["24", "5"], ",", 
        FractionBox["12", "5"], ",", 
        FractionBox["12", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"], ",", 
        FractionBox["8", "3"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[24, 5], 
      Rational[12, 5], 
      Rational[12, 5]}}, {{
      Rational[8, 3], 
      Rational[16, 3], 
      Rational[8, 3]}}, {{
      Rational[8, 3], 
      Rational[8, 3], 
      Rational[16, 3]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6415427793256235`*^9, 3.6416245890442557`*^9, 
  3.6416346215561094`*^9, 3.641635833065239*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["24", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["12", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["16", "3"], ",", 
       FractionBox["8", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["8", "3"], ",", 
       FractionBox["16", "3"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{
     Rational[24, 5], 
     Rational[12, 5], 
     Rational[12, 5]}, {
     Rational[8, 3], 
     Rational[16, 3], 
     Rational[8, 3]}, {
     Rational[8, 3], 
     Rational[8, 3], 
     Rational[16, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6415427793256235`*^9, 3.6416245890442557`*^9, 
  3.6416346215561094`*^9, 3.641635833080865*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"16", "+", 
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"48", "-", 
     RowBox[{"11", " ", "x1"}], "+", 
     RowBox[{"11", " ", "x2"}], "-", 
     RowBox[{"9", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"1112", "-", 
     RowBox[{"99", " ", "x1"}], "-", 
     RowBox[{"66", " ", "x2"}], "-", 
     RowBox[{"66", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"48", "-", 
     RowBox[{"11", " ", "x1"}], "-", 
     RowBox[{"9", " ", "x2"}], "+", 
     RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "24"}], "+", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"2", " ", "x2"}], "+", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6415427793256235`*^9, 3.6416245890442557`*^9, 
  3.6416346215561094`*^9, 3.6416358332214956`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"96", "-", 
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"2", " ", "x2"}], "-", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6415427793256235`*^9, 3.6416245890442557`*^9, 
  3.6416346215561094`*^9, 3.6416358333539267`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10164", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "829", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "274", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "555"}],
  SequenceForm[10164, " ", 829, " ", 274, " ", 555],
  Editable->False]], "Print",
 CellChangeTimes->{3.6415427793256235`*^9, 3.6416245890442557`*^9, 
  3.6416346215561094`*^9, 3.641635835511727*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{2.6666666666666665`, 2.6666666666666665`, 
    5.333333333333333}, {2.6666666666666665`, 5.333333333333333, 
    2.6666666666666665`}, {4.606060606060606, 4.606060606060606, 
    5.333333333333333}, {4.606060606060606, 5.333333333333333, 
    4.606060606060606}, {4.8, 2.4, 2.4}, {5.1878787878787875`, 
    4.533333333333333, 4.533333333333333}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.6766135021750137, 0.49422627299523914`, 0.09410777798794623], Opacity[
     0.5]}], Polygon3DBox[{{3, 5, 6}, {4, 5, 2}, {5, 4, 6}, {2, 5, 1}, {5, 3, 
      1}, {3, 4, 1}, {4, 2, 1}, {4, 3, 6}}]}], 
   GraphicsComplex3DBox[{{5.333333333333333, 5.333333333333333, 
    10.666666666666666`}, {5.333333333333333, 10.666666666666666`, 
    5.333333333333333}, {9.212121212121213, 9.212121212121213, 
    10.666666666666666`}, {9.212121212121213, 10.666666666666666`, 
    9.212121212121213}, {9.6, 4.8, 4.8}, {10.375757575757575`, 
    9.066666666666666, 9.066666666666666}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.9382667168168917, 0.5329637205314617, 0.2901581348898499], Opacity[
     0.5]}], Polygon3DBox[{{3, 5, 6}, {4, 5, 2}, {5, 4, 6}, {2, 5, 1}, {5, 3, 
      1}, {3, 4, 1}, {4, 2, 1}, {4, 3, 6}}]}], 
   GraphicsComplex3DBox[{{8., 8., 16.}, {8., 16., 8.}, {13.818181818181818`, 
    13.818181818181818`, 16.}, {13.818181818181818`, 16., 
    13.818181818181818`}, {14.4, 7.2, 7.2}, {15.563636363636364`, 13.6, 
    13.6}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.32863507276109205`, 0.5471038757266662, 0.8208795348091042], Opacity[
     0.5]}], Polygon3DBox[{{4, 6, 2}, {1, 5, 3}, {3, 5, 6}, {4, 3, 6}, {6, 5, 
      2}, {5, 1, 2}, {1, 3, 2}, {3, 4, 2}}]}], 
   GraphicsComplex3DBox[{{10.666666666666666`, 10.666666666666666`, 
    21.333333333333332`}, {10.666666666666666`, 21.333333333333332`, 
    10.666666666666666`}, {18.424242424242426`, 18.424242424242426`, 
    21.333333333333332`}, {18.424242424242426`, 21.333333333333332`, 
    18.424242424242426`}, {19.2, 9.6, 9.6}, {20.75151515151515, 
    18.133333333333333`, 18.133333333333333`}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.012323037780170853`, 0.8905488024256845, 0.8752760008995137], Opacity[
     0.5]}], Polygon3DBox[{{3, 5, 6}, {4, 5, 2}, {5, 4, 6}, {2, 5, 1}, {5, 3, 
      1}, {3, 4, 1}, {4, 2, 1}, {4, 3, 6}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[
     NCache[{{Rational[24, 5], Rational[12, 5], Rational[12, 5]}, {
       Rational[8, 3], Rational[16, 3], Rational[8, 3]}, {
       Rational[8, 3], Rational[8, 3], Rational[16, 3]}}, {{4.8, 2.4, 2.4}, {
      2.6666666666666665`, 5.333333333333333, 2.6666666666666665`}, {
      2.6666666666666665`, 2.6666666666666665`, 5.333333333333333}}]]}, 
   {GrayLevel[0], PointSize[Medium], Point3DBox[CompressedData["
1:eJwtlFmWnTgQRMsFSDlpgOcN9HfvxkvwBrz/v45LmzrFEyiHyIgQ//z+8+v3
99fX17+6Hfr9wfX9/v345jq+v09ux/H3V6v3/zjO42jczuu4TpYK1eps59nP
0/T6vK7zaufVedeuszV2+vVuHuyToCDtdWK52nVpbdfl1xVk60VrV+tXs6u5
irHf29X71Y1Aa5d1wr2RIViAUGqjJxW1UILivL1vG1dvzVrL1oraeuq99Wg9
6aMd82ahhs2tubfoLYzw7GQwpICAm2zQGKCoq0KKTgDyoEX1PnqfwtstumW3
6ja6e/font2LzmE9vEf0SKEgL62n9wwKlPVyygyjkiiGpsb0QCTZSFDcMEuz
MtNimi1G8TBP8zIf5lOTASTcIizSoiwGuJSXbhmWaVnAVJlyq7BKQabkcBtB
4enURqrmkKs+jOSMIdwFc/RQRa2VRoL/DUr3ch/ut/sDDQIY4ZEe5bE9bogR
ZAVmeKbn8tyiiiGUWuE1vRYDqcwYPqYm81k+hwvYSl/lO3wnTe6gj1zVGmRD
QIMDNBDpmvl/EgVEpOhRM08EYQYhE4gVlLuRiCC91aXHJ+IT8VO6waUmyB15
Rz6RH6itFbWj7qgnxoyxYuwYd0iHOWLOmCvmjuWxKtaINWMtONgZu2KP2FN8
0OrOuCvuQc8n4yk6f5LmuFmuwXkoibECB+EGBxeiDgyFJA5MnwlNasP80Bwr
6ao2qv7BBXlnPpla/8zaWXfWk/VJ+WWsHDvHnePJ6TlnzpVz57zRakWukWvm
Wrm2pIOVXblH7pl7wZBq35X3yHvClvo8lc8QbTT8FD11RDlC9irf8SM+rnod
Vj4KyUXcLOgTXyJIVVbRTNWfIvqu4TU2lplRc8k4yLKy1kQcTbYHEmm+uySU
puS0YXlO1HhPCDWwmmTTIRgD/SSYFNIMIncOZtaE9wDZGipKgmR3lJ+J+KJt
FRYQebtkBFE49YF4T+bknAR04m8l4UIgYx15ReYQfVJOxcT4wu8MP+cLSwgw
FHuFrRAk1vsVWO/xw2WcJU0vQwcqYdBBrGyHIQJWUFc0weyCzYExGa+wJ6rG
Ntvu+BRtdTYChfG6JsNVOxNeUSXhiNMuF3OEEB+y47VAPPoKRPwHKr9CtQ==

     "]]}, 
   {RGBColor[1, 0, 0], Line3DBox[{{0, 0, 0}, {24, 12, 12}}], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[40, 3], Rational[80, 3], Rational[40, 3]}}, {{0, 0, 0}, {
       13.333333333333334`, 26.666666666666668`, 13.333333333333334`}}]], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[40, 3], Rational[40, 3], Rational[80, 3]}}, {{0, 0, 0}, {
       13.333333333333334`, 13.333333333333334`, 26.666666666666668`}}]]}},
  AutomaticImageSize->True,
  Axes->False,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{393.56293181951344`, 430.04386177659114`},
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All,
  ViewPoint->{1.5567432638750138`, -1.0349761146903318`, 2.820527406780561},
  ViewVertical->{-0.2411971112380241, 0.2852151709610796, 
   0.9335575550619748}]], "Output",
 CellChangeTimes->{{3.6415427641738625`*^9, 3.641542782792074*^9}, 
   3.6416245927660704`*^9, 3.6416346245162573`*^9, 3.641635835654423*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Funci\[OAcute]n a funci\[OAcute]n", "Section",
 CellChangeTimes->{{3.641084950618944*^9, 3.6410849536040726`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"rutaHastaLRS", ",", "dirFicheros", ",", "dirNormaliz"}], 
  "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"E:\\\\lrs\\\\lrs.exe\"\>", 
   ",", "\<\"E:\\\\dropbox-usuario\\\\Dropbox\\\\convex_hull_semigroups\\\\\
calculos\\\\paquete\\\\\"\>", 
   ",", "\<\"F:\\\\Downloads-usuario\\\\Normaliz2.12.2Windows64\\\\Normaliz2.\
12\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.6410492865014687`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"vv", "=", 
   RowBox[{
    RowBox[{"4", "/", "3"}], "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{
       FractionBox["9", "10"], "*", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["5", "10"], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "1", ",", "1"}], "}"}], "+", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], ")"}]}], "-", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["2", "10"], ",", 
         FractionBox["1", "10"], ",", 
         FractionBox["2", "10"]}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["95", "100"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["2", "10"], ",", "0", ",", 
         FractionBox["1", "10"]}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["17", "10"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{"-", "3"}], "10"], ",", "0", ",", "0"}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["17", "10"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["3", "10"], ",", "0", ",", "0"}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["17", "10"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["3", "10"], ",", "0", ",", 
         FractionBox["5", "10"]}], "}"}]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6400626834254117`*^9, 3.6400626853928204`*^9}, {
  3.6400628554354563`*^9, 3.6400628622693152`*^9}, {3.640064018359559*^9, 
  3.640064088223129*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Convexo", "=", 
   RowBox[{"ConvexHullMesh", "[", "vv", "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"carasDeVV", "=", 
  RowBox[{"facesOfConvexLRS", "[", "vv", "]"}]}]], "Input",
 CellChangeTimes->{{3.639381710007959*^9, 3.639381715309721*^9}, 
   3.640062729073803*^9, 3.6400627672749166`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"138", "-", 
     RowBox[{"5", " ", "x1"}], "-", 
     RowBox[{"55", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"282", "+", 
     RowBox[{"25", " ", "x1"}], "-", 
     RowBox[{"115", " ", "x2"}], "-", 
     RowBox[{"30", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"8", "-", 
     RowBox[{"3", " ", "x1"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "100"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"66", " ", "x2"}], "+", 
     RowBox[{"15", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"116", "+", 
     RowBox[{"35", " ", "x1"}], "-", 
     RowBox[{"38", " ", "x2"}], "-", 
     RowBox[{"42", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"12", "-", 
     RowBox[{"7", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "16"}], "+", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"9", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "348"}], "+", 
     RowBox[{"163", " ", "x1"}], "+", 
     RowBox[{"52", " ", "x2"}], "+", 
     RowBox[{"23", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"96", "+", 
     RowBox[{"53", " ", "x1"}], "-", 
     RowBox[{"47", " ", "x2"}], "-", 
     RowBox[{"39", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"24", "-", 
     RowBox[{"9", " ", "x1"}], "-", 
     RowBox[{"11", " ", "x2"}], "+", 
     RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "36"}], "+", "x1", "+", 
     RowBox[{"4", " ", "x2"}], "+", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6400627678293076`*^9, 3.640062870087856*^9, 3.6400640933938017`*^9, {
   3.6400644308812447`*^9, 3.640064457686265*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vTriangulo", "=", 
  RowBox[{"verticesOfCone", "[", "vv", "]"}]}]], "Input",
 CellChangeTimes->{{3.6391197784476347`*^9, 3.6391197938676124`*^9}, {
  3.6391326969434643`*^9, 3.639132699345173*^9}, {3.6399124604914494`*^9, 
  3.639912464710432*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["8", "3"], ",", 
   FractionBox["4", "3"], ",", 
   FractionBox["4", "3"], ",", 
   FractionBox["6", "5"], ",", 
   FractionBox["12", "5"], ",", 
   FractionBox["6", "5"], ",", 
   FractionBox["4", "3"], ",", 
   FractionBox["4", "3"], ",", 
   FractionBox["8", "3"], ",", 
   FractionBox["26", "15"], ",", 
   FractionBox["6", "5"], ",", 
   FractionBox["26", "15"], ",", 
   FractionBox["23", "15"], ",", 
   FractionBox["19", "15"], ",", 
   FractionBox["7", "5"], ",", 
   FractionBox["28", "15"], ",", 
   FractionBox["34", "15"], ",", 
   FractionBox["34", "15"], ",", 
   FractionBox["8", "3"], ",", 
   FractionBox["34", "15"], ",", 
   FractionBox["34", "15"], ",", 
   FractionBox["8", "3"], ",", 
   FractionBox["34", "15"], ",", 
   FractionBox["44", "15"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.640064104309531*^9, {3.64006443212812*^9, 3.640064459449504*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"40", ",", "20", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "36", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "18", ",", "26"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", "19", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "44"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{40, 20, 20}, {18, 36, 18}, {20, 20, 40}, {26, 18, 26}, {23, 19, 
   21}, {28, 34, 34}, {40, 34, 34}, {40, 34, 44}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.640064104309531*^9, {3.64006443212812*^9, 3.640064459456518*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.640062785553872*^9, 3.640062876675523*^9, 3.640064104565723*^9, {
   3.640064432405326*^9, 3.6400644596656666`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"classifyVertices", "[", 
  RowBox[{"vv", ",", "vTriangulo"}], "]"}]], "Input",
 CellChangeTimes->{{3.639120262285095*^9, 3.6391202754754763`*^9}, {
  3.639132746209538*^9, 3.6391327484381247`*^9}, {3.639912418164408*^9, 
  3.6399124214357285`*^9}, {3.639912470359439*^9, 3.639912472280802*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["26", "15"], ",", 
       FractionBox["6", "5"], ",", 
       FractionBox["26", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["23", "15"], ",", 
       FractionBox["19", "15"], ",", 
       FractionBox["7", "5"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["28", "15"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["44", "15"]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.640064152630826*^9, {3.6400644335921683`*^9, 3.640064460277093*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vAdyacentes1", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"verticesAdyacentes", "[", 
     RowBox[{
      RowBox[{"vTriangulo", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "Convexo"}], "]"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"vTriangulo", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[NotEqual]", " ", "#"}], ")"}], 
       " ", "\[And]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"vTriangulo", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[NotEqual]", " ", "#"}], ")"}]}], 
      ")"}], "&"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6399124468047276`*^9, 3.6399124494476027`*^9}, {
  3.639912485381098*^9, 3.6399125313196907`*^9}, {3.639913663097703*^9, 
  3.63991366828537*^9}, {3.6399640360723667`*^9, 3.639964086331025*^9}, {
  3.6399641427170277`*^9, 3.6399641715354776`*^9}, {3.6399644636427283`*^9, 
  3.639964522120217*^9}, {3.6399645851479363`*^9, 3.639964635918955*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2.6666666666666665`", ",", "2.2666666666666666`", ",", 
     "2.933333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2.6666666666666665`", ",", "2.2666666666666666`", ",", 
     "2.2666666666666666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5333333333333334`", ",", "1.2666666666666666`", ",", "1.4`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.7333333333333334`", ",", "1.2`", ",", "1.7333333333333334`"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.640064166267501*^9, 3.6400644630750856`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vAdyacentes2", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"verticesAdyacentes", "[", 
     RowBox[{
      RowBox[{"vTriangulo", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", "Convexo"}], "]"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"vTriangulo", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[NotEqual]", " ", "#"}], ")"}], 
       " ", "\[And]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"vTriangulo", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", " ", "#"}], ")"}]}], 
      ")"}], "&"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2.6666666666666665`", ",", "2.2666666666666666`", ",", 
     "2.933333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.8666666666666667`", ",", "2.2666666666666666`", ",", 
     "2.2666666666666666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2.6666666666666665`", ",", "2.2666666666666666`", ",", 
     "2.2666666666666666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5333333333333334`", ",", "1.2666666666666666`", ",", "1.4`"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.640064476895894*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vAdyacentes3", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"verticesAdyacentes", "[", 
     RowBox[{
      RowBox[{"vTriangulo", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", "Convexo"}], "]"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"vTriangulo", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[NotEqual]", " ", "#"}], ")"}], 
       " ", "\[And]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"vTriangulo", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[NotEqual]", " ", "#"}], ")"}]}], 
      ")"}], "&"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.639964665969268*^9, 3.6399646757121887`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.8666666666666667`", ",", "2.2666666666666666`", ",", 
     "2.2666666666666666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2.6666666666666665`", ",", "2.2666666666666666`", ",", 
     "2.933333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5333333333333334`", ",", "1.2666666666666666`", ",", "1.4`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.7333333333333334`", ",", "1.2`", ",", "1.7333333333333334`"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6400644831683426`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"vTriangulo", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"vAdyacentes1", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "vAdyacentes1", "]"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.6399626030256033`*^9, 3.639962677763631*^9}, {
  3.639964687163317*^9, 3.639964696708091*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "2.6666666666666665`", ",", "2.2666666666666666`", ",", 
       "2.933333333333333`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "2.6666666666666665`", ",", "2.2666666666666666`", ",", 
       "2.2666666666666666`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.5333333333333334`", ",", "1.2666666666666666`", ",", "1.4`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.7333333333333334`", ",", "1.2`", ",", "1.7333333333333334`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6400644925570035`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p2", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"vTriangulo", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ",", 
      RowBox[{"vAdyacentes2", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "vAdyacentes2", "]"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.6399626831864777`*^9, 3.639962690004328*^9}, {
  3.6399647039251957`*^9, 3.639964708521469*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["6", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["6", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "2.6666666666666665`", ",", "2.2666666666666666`", ",", 
       "2.933333333333333`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["6", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["6", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.8666666666666667`", ",", "2.2666666666666666`", ",", 
       "2.2666666666666666`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["6", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["6", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "2.6666666666666665`", ",", "2.2666666666666666`", ",", 
       "2.2666666666666666`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["6", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["6", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.5333333333333334`", ",", "1.2666666666666666`", ",", "1.4`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6400644991166573`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p3", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"vTriangulo", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ",", 
      RowBox[{"vAdyacentes3", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "vAdyacentes3", "]"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.639962695328104*^9, 3.639962702603264*^9}, {
  3.6399647131877832`*^9, 3.639964718720708*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["8", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.8666666666666667`", ",", "2.2666666666666666`", ",", 
       "2.2666666666666666`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["8", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "2.6666666666666665`", ",", "2.2666666666666666`", ",", 
       "2.933333333333333`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["8", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.5333333333333334`", ",", "1.2666666666666666`", ",", "1.4`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["8", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1.7333333333333334`", ",", "1.2`", ",", "1.7333333333333334`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.640064504538516*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"lpuntosPoligono1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"verticesOfPoligon", "[", 
      RowBox[{"carasDeVV", ",", "#"}], "]"}], "&"}], "/@", "p1"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6399627657590747`*^9, 3.639962791628426*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.8888888888888884`"}], " ", "x1"}], "+", 
     RowBox[{"4.266666666666666`", " ", "x2"}], "-", 
     RowBox[{"2.488888888888889`", " ", "x3"}]}], "\[GreaterEqual]", "0"}], 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"0.8888888888888884`", " ", "x1"}], "-", 
     RowBox[{"4.266666666666666`", " ", "x2"}], "+", 
     RowBox[{"2.488888888888889`", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[(-0.8888888888888884) $CellContext`x1 + 
    4.266666666666666 $CellContext`x2 - 2.488888888888889 $CellContext`x3 >= 
   0, " ", 0.8888888888888884 $CellContext`x1 - 
    4.266666666666666 $CellContext`x2 + 2.488888888888889 $CellContext`x3 >= 
   0],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064509240831*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"0.`", "\[VeryThinSpace]", "+", 
    RowBox[{"2.488888888888889`", " ", "x2"}], "-", 
    RowBox[{"2.488888888888889`", " ", "x3"}]}], "\[GreaterEqual]", 
   RowBox[{
    RowBox[{
    "0", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "0.`"}], 
    "\[VeryThinSpace]", "-", 
    RowBox[{"2.488888888888889`", " ", "x2"}], "+", 
    RowBox[{"2.488888888888889`", " ", "x3"}]}], "\[GreaterEqual]", "0"}],
  SequenceForm[
  0. + 2.488888888888889 $CellContext`x2 - 2.488888888888889 $CellContext`x3 >= 
   0, " ", 0. - 2.488888888888889 $CellContext`x2 + 
    2.488888888888889 $CellContext`x3 >= 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064509408951*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.1777777777777778`"}], " ", "x1"}], "+", 
     RowBox[{"1.6888888888888887`", " ", "x2"}], "-", 
     RowBox[{"1.333333333333333`", " ", "x3"}]}], "\[GreaterEqual]", "0"}], 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"0.1777777777777778`", " ", "x1"}], "-", 
     RowBox[{"1.6888888888888887`", " ", "x2"}], "+", 
     RowBox[{"1.333333333333333`", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[(-0.1777777777777778) $CellContext`x1 + 
    1.6888888888888887` $CellContext`x2 - 1.333333333333333 $CellContext`x3 >= 
   0, " ", 0.1777777777777778 $CellContext`x1 - 
    1.6888888888888887` $CellContext`x2 + 1.333333333333333 $CellContext`x3 >= 
   0],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645095660615`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.711111111111111`"}], " ", "x1"}], "+", 
     RowBox[{"2.311111111111111`", " ", "x2"}], "-", 
     RowBox[{"0.8888888888888888`", " ", "x3"}]}], "\[GreaterEqual]", "0"}], 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"0.711111111111111`", " ", "x1"}], "-", 
     RowBox[{"2.311111111111111`", " ", "x2"}], "+", 
     RowBox[{"0.8888888888888888`", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[(-0.711111111111111) $CellContext`x1 + 
    2.311111111111111 $CellContext`x2 - 0.8888888888888888 $CellContext`x3 >= 
   0, " ", 0.711111111111111 $CellContext`x1 - 
    2.311111111111111 $CellContext`x2 + 0.8888888888888888 $CellContext`x3 >= 
   0],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645097512093`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"lpuntosPoligono2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"verticesOfPoligon", "[", 
      RowBox[{"carasDeVV", ",", "#"}], "]"}], "&"}], "/@", "p2"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.639962809335981*^9, 3.6399628176589*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.3199999999999985`"}], " ", "x1"}], "+", 
     RowBox[{"0.3199999999999994`", " ", "x2"}], "+", 
     RowBox[{"3.68`", " ", "x3"}]}], "\[GreaterEqual]", "0"}], 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"4.3199999999999985`", " ", "x1"}], "-", 
     RowBox[{"0.3199999999999994`", " ", "x2"}], "-", 
     RowBox[{"3.68`", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[(-4.3199999999999985`) $CellContext`x1 + 
    0.3199999999999994 $CellContext`x2 + 3.68 $CellContext`x3 >= 0, " ", 
   4.3199999999999985` $CellContext`x1 - 0.3199999999999994 $CellContext`x2 - 
    3.68 $CellContext`x3 >= 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645156153545`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.72`"}], " ", "x1"}], "+", 
     RowBox[{"0.4800000000000004`", " ", "x2"}], "+", 
     RowBox[{"1.7599999999999993`", " ", "x3"}]}], "\[GreaterEqual]", "0"}], 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"2.72`", " ", "x1"}], "-", 
     RowBox[{"0.4800000000000004`", " ", "x2"}], "-", 
     RowBox[{"1.7599999999999993`", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[(-2.72) $CellContext`x1 + 0.4800000000000004 $CellContext`x2 + 
    1.7599999999999993` $CellContext`x3 >= 0, " ", 
   2.72 $CellContext`x1 - 0.4800000000000004 $CellContext`x2 - 
    1.7599999999999993` $CellContext`x3 >= 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645157624598`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.72`"}], " ", "x1"}], "-", 
     RowBox[{"0.48`", " ", "x2"}], "+", 
     RowBox[{"3.68`", " ", "x3"}]}], "\[GreaterEqual]", "0"}], 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"2.72`", " ", "x1"}], "+", 
     RowBox[{"0.48`", " ", "x2"}], "-", 
     RowBox[{"3.68`", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[(-2.72) $CellContext`x1 - 0.48 $CellContext`x2 + 
    3.68 $CellContext`x3 >= 0, " ", 
   2.72 $CellContext`x1 + 0.48 $CellContext`x2 - 3.68 $CellContext`x3 >= 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064515932579*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.8399999999999994`"}], " ", "x1"}], "-", 
     RowBox[{"0.1600000000000006`", " ", "x2"}], "+", 
     RowBox[{"2.1600000000000006`", " ", "x3"}]}], "\[GreaterEqual]", "0"}], 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"1.8399999999999994`", " ", "x1"}], "+", 
     RowBox[{"0.1600000000000006`", " ", "x2"}], "-", 
     RowBox[{"2.1600000000000006`", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[(-1.8399999999999994`) $CellContext`x1 - 
    0.1600000000000006 $CellContext`x2 + 2.1600000000000006` $CellContext`x3 >= 
   0, " ", 1.8399999999999994` $CellContext`x1 + 
    0.1600000000000006 $CellContext`x2 - 2.1600000000000006` $CellContext`x3 >= 
   0],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064516072688*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"lpuntosPoligono3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"verticesOfPoligon", "[", 
      RowBox[{"carasDeVV", ",", "#"}], "]"}], "&"}], "/@", "p3"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6399628216237106`*^9, 3.639962823301893*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3.022222222222222`", " ", "x1"}], "-", 
     RowBox[{"1.9555555555555557`", " ", "x2"}], "-", 
     RowBox[{"0.5333333333333332`", " ", "x3"}]}], "\[GreaterEqual]", "0"}], 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.022222222222222`"}], " ", "x1"}], "+", 
     RowBox[{"1.9555555555555557`", " ", "x2"}], "+", 
     RowBox[{"0.5333333333333332`", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[
  3.022222222222222 $CellContext`x1 - 1.9555555555555557` $CellContext`x2 - 
    0.5333333333333332 $CellContext`x3 >= 0, 
   " ", (-3.022222222222222) $CellContext`x1 + 
    1.9555555555555557` $CellContext`x2 + 0.5333333333333332 $CellContext`x3 >= 
   0],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645209081182`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2.1333333333333337`", " ", "x1"}], "-", 
     RowBox[{"3.2`", " ", "x2"}], "+", 
     RowBox[{"0.5333333333333332`", " ", "x3"}]}], "\[GreaterEqual]", "0"}], 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.1333333333333337`"}], " ", "x1"}], "+", 
     RowBox[{"3.2`", " ", "x2"}], "-", 
     RowBox[{"0.5333333333333332`", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[
  2.1333333333333337` $CellContext`x1 - 3.2 $CellContext`x2 + 
    0.5333333333333332 $CellContext`x3 >= 0, 
   " ", (-2.1333333333333337`) $CellContext`x1 + 3.2 $CellContext`x2 - 
    0.5333333333333332 $CellContext`x3 >= 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064521068223*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1.5111111111111108`", " ", "x1"}], "-", 
     RowBox[{"2.2222222222222223`", " ", "x2"}], "+", 
     RowBox[{"0.3555555555555556`", " ", "x3"}]}], "\[GreaterEqual]", "0"}], 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.5111111111111108`"}], " ", "x1"}], "+", 
     RowBox[{"2.2222222222222223`", " ", "x2"}], "-", 
     RowBox[{"0.3555555555555556`", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[
  1.5111111111111108` $CellContext`x1 - 2.2222222222222223` $CellContext`x2 + 
    0.3555555555555556 $CellContext`x3 >= 0, 
   " ", (-1.5111111111111108`) $CellContext`x1 + 
    2.2222222222222223` $CellContext`x2 - 0.3555555555555556 $CellContext`x3 >= 
   0],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645212073307`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"0.8888888888888888`", " ", "x1"}], "-", 
     RowBox[{"2.311111111111111`", " ", "x2"}], "+", 
     RowBox[{"0.711111111111111`", " ", "x3"}]}], "\[GreaterEqual]", "0"}], 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.8888888888888888`"}], " ", "x1"}], "+", 
     RowBox[{"2.311111111111111`", " ", "x2"}], "-", 
     RowBox[{"0.711111111111111`", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}],
  SequenceForm[
  0.8888888888888888 $CellContext`x1 - 2.311111111111111 $CellContext`x2 + 
    0.711111111111111 $CellContext`x3 >= 0, 
   " ", (-0.8888888888888888) $CellContext`x1 + 
    2.311111111111111 $CellContext`x2 - 0.711111111111111 $CellContext`x3 >= 
   0],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064521360446*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"lpuntosAux1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"puntosAdyacentesPoligono", "[", 
      RowBox[{"#", ",", 
       RowBox[{"vTriangulo", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "&"}], " ", "/@", 
    "lpuntosPoligono1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lpuntosAux2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"puntosAdyacentesPoligono", "[", 
      RowBox[{"#", ",", 
       RowBox[{"vTriangulo", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "&"}], " ", "/@", 
    "lpuntosPoligono2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lpuntosAux3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"puntosAdyacentesPoligono", "[", 
      RowBox[{"#", ",", 
       RowBox[{"vTriangulo", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "&"}], " ", "/@", 
    "lpuntosPoligono3"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.639962900343564*^9, 3.6399629908868027`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellChangeTimes->{3.640064526389008*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["44", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["2648", "1635"], ",", 
       FractionBox["2024", "1635"], ",", 
       FractionBox["2524", "1635"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1016", "681"], ",", 
       FractionBox["872", "681"], ",", 
       FractionBox["1132", "681"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["152", "117"], ",", 
       FractionBox["188", "117"], ",", 
       FractionBox["268", "117"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["452", "285"], ",", 
       FractionBox["506", "285"], ",", 
       FractionBox["706", "285"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["44", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["2648", "1635"], ",", 
       FractionBox["2024", "1635"], ",", 
       FractionBox["2524", "1635"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1016", "681"], ",", 
       FractionBox["872", "681"], ",", 
       FractionBox["1132", "681"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["152", "117"], ",", 
       FractionBox["188", "117"], ",", 
       FractionBox["268", "117"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["452", "285"], ",", 
       FractionBox["506", "285"], ",", 
       FractionBox["706", "285"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"]}], "}"}]}],
  SequenceForm[{{
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[44, 15]}, {
     Rational[2648, 1635], 
     Rational[2024, 1635], 
     Rational[2524, 1635]}, {
     Rational[1016, 681], 
     Rational[872, 681], 
     Rational[1132, 681]}, {
     Rational[152, 117], 
     Rational[188, 117], 
     Rational[268, 117]}, {
     Rational[452, 285], 
     Rational[506, 285], 
     Rational[706, 285]}}, "\n", {{
     Rational[8, 3], 
     Rational[4, 3], 
     Rational[4, 3]}, {
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[44, 15]}, {
     Rational[2648, 1635], 
     Rational[2024, 1635], 
     Rational[2524, 1635]}, {
     Rational[1016, 681], 
     Rational[872, 681], 
     Rational[1132, 681]}, {
     Rational[152, 117], 
     Rational[188, 117], 
     Rational[268, 117]}, {
     Rational[452, 285], 
     Rational[506, 285], 
     Rational[706, 285]}}, "\n", {
    Rational[8, 3], 
    Rational[4, 3], 
    Rational[4, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526391009*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.9333333333333333`", ",", "1.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0470948012232415`"}], ",", 
     RowBox[{"-", "0.09541284403669725`"}], ",", "0.21039755351681957`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1747430249632893`"}], ",", 
     RowBox[{"-", "0.05286343612334802`"}], ",", "0.328928046989721`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3675213675213675`"}], ",", "0.27350427350427353`", ",", 
     "0.9572649572649573`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.080701754385965`"}], ",", "0.4421052631578947`", ",", 
     "1.143859649122807`"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645263940115`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.823533235230026`", ",", 
     RowBox[{"-", "2.4610613803665276`"}], ",", 
     RowBox[{"-", "2.264050626714135`"}], ",", 
     RowBox[{"-", "1.1857297223998502`"}], ",", 
     RowBox[{"-", "0.4693931067142373`"}]}], "}"}]}],
  SequenceForm[
  "laux=", {
   1.823533235230026, -2.4610613803665276`, -2.264050626714135, \
-1.1857297223998502`, -0.4693931067142373}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526395064*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "1"}],
  SequenceForm[2, 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645263960032`*^9}],

Cell[BoxData["1"], "Print",
 CellChangeTimes->{3.6400645263970137`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "7"], ",", 
       FractionBox["81", "35"], ",", 
       FractionBox["81", "35"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", 
       FractionBox["69", "50"], ",", 
       FractionBox["69", "50"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["24", "19"], ",", 
       FractionBox["36", "19"], ",", 
       FractionBox["36", "19"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["28", "15"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "7"], ",", 
       FractionBox["81", "35"], ",", 
       FractionBox["81", "35"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", 
       FractionBox["69", "50"], ",", 
       FractionBox["69", "50"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["24", "19"], ",", 
       FractionBox["36", "19"], ",", 
       FractionBox["36", "19"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["28", "15"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"]}], "}"}]}],
  SequenceForm[{{
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[34, 15]}, {
     Rational[15, 7], 
     Rational[81, 35], 
     Rational[81, 35]}, {
     Rational[3, 2], 
     Rational[69, 50], 
     Rational[69, 50]}, {
     Rational[24, 19], 
     Rational[36, 19], 
     Rational[36, 19]}, {
     Rational[28, 15], 
     Rational[34, 15], 
     Rational[34, 15]}}, "\n", {{
     Rational[8, 3], 
     Rational[4, 3], 
     Rational[4, 3]}, {
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[34, 15]}, {
     Rational[15, 7], 
     Rational[81, 35], 
     Rational[81, 35]}, {
     Rational[3, 2], 
     Rational[69, 50], 
     Rational[69, 50]}, {
     Rational[24, 19], 
     Rational[36, 19], 
     Rational[36, 19]}, {
     Rational[28, 15], 
     Rational[34, 15], 
     Rational[34, 15]}}, "\n", {
    Rational[8, 3], 
    Rational[4, 3], 
    Rational[4, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645263990145`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.9333333333333333`", ",", "0.9333333333333333`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5238095238095238`"}], ",", "0.9809523809523809`", ",", 
     "0.9809523809523809`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1666666666666667`"}], ",", "0.04666666666666667`", ",", 
     "0.04666666666666667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4035087719298245`"}], ",", "0.5614035087719298`", ",", 
     "0.5614035087719298`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8`"}], ",", "0.9333333333333333`", ",", 
     "0.9333333333333333`"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645264010158`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.8856180831641267`", ",", "0.8220851228316973`", ",", 
     RowBox[{"-", "2.5559138042587892`"}], ",", 
     RowBox[{"-", "1.3926212476455828`"}], ",", "0.2303649134883627`"}], 
    "}"}]}],
  SequenceForm[
  "laux=", {1.8856180831641267`, 
   0.8220851228316973, -2.5559138042587892`, -1.3926212476455828`, 
   0.2303649134883627}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526403017*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "1"}],
  SequenceForm[3, 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264040184`*^9}],

Cell[BoxData["1"], "Print",
 CellChangeTimes->{3.6400645264040184`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["566", "225"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1401", "590"], ",", 
       FractionBox["1353", "590"], ",", 
       FractionBox["1527", "590"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["23", "15"], ",", 
       FractionBox["19", "15"], ",", 
       FractionBox["7", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["408", "319"], ",", 
       FractionBox["564", "319"], ",", 
       FractionBox["60", "29"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["148", "85"], ",", 
       FractionBox["174", "85"], ",", 
       FractionBox["602", "255"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["324", "145"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["3358", "1305"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["566", "225"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1401", "590"], ",", 
       FractionBox["1353", "590"], ",", 
       FractionBox["1527", "590"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["23", "15"], ",", 
       FractionBox["19", "15"], ",", 
       FractionBox["7", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["408", "319"], ",", 
       FractionBox["564", "319"], ",", 
       FractionBox["60", "29"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["148", "85"], ",", 
       FractionBox["174", "85"], ",", 
       FractionBox["602", "255"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["324", "145"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["3358", "1305"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"]}], "}"}]}],
  SequenceForm[{{
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[566, 225]}, {
     Rational[1401, 590], 
     Rational[1353, 590], 
     Rational[1527, 590]}, {
     Rational[23, 15], 
     Rational[19, 15], 
     Rational[7, 5]}, {
     Rational[408, 319], 
     Rational[564, 319], 
     Rational[60, 29]}, {
     Rational[148, 85], 
     Rational[174, 85], 
     Rational[602, 255]}, {
     Rational[324, 145], 
     Rational[34, 15], 
     Rational[3358, 1305]}}, "\n", {{
     Rational[8, 3], 
     Rational[4, 3], 
     Rational[4, 3]}, {
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[566, 225]}, {
     Rational[1401, 590], 
     Rational[1353, 590], 
     Rational[1527, 590]}, {
     Rational[23, 15], 
     Rational[19, 15], 
     Rational[7, 5]}, {
     Rational[408, 319], 
     Rational[564, 319], 
     Rational[60, 29]}, {
     Rational[148, 85], 
     Rational[174, 85], 
     Rational[602, 255]}, {
     Rational[324, 145], 
     Rational[34, 15], 
     Rational[3358, 1305]}}, "\n", {
    Rational[8, 3], 
    Rational[4, 3], 
    Rational[4, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526406019*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.9333333333333333`", ",", "1.1822222222222223`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.292090395480226`"}], ",", "0.9598870056497175`", ",", 
     "1.2548022598870057`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1333333333333333`"}], ",", 
     RowBox[{"-", "0.06666666666666667`"}], ",", "0.06666666666666667`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.387669801462905`"}], ",", "0.4346917450365726`", ",", 
     "0.735632183908046`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9254901960784314`"}], ",", "0.7137254901960784`", ",", 
     "1.0274509803921568`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.432183908045977`"}], ",", "0.9333333333333333`", ",", 
     "1.239846743295019`"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.640064526408021*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.872702738816596`", ",", "1.3531581728688549`", ",", 
     RowBox[{"-", "2.6574870639811565`"}], ",", 
     RowBox[{"-", "1.3131831775836316`"}], ",", 
     RowBox[{"-", "0.09408191055957338`"}], ",", "1.0832728833638454`"}], 
    "}"}]}],
  SequenceForm[
  "laux=", {1.872702738816596, 
   1.3531581728688549`, -2.6574870639811565`, -1.3131831775836316`, \
-0.09408191055957338, 1.0832728833638454`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264090214`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "1"}],
  SequenceForm[3, 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526411025*^9}],

Cell[BoxData["1"], "Print",
 CellChangeTimes->{3.6400645264120836`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["68", "41"], ",", 
       FractionBox["64", "41"], ",", 
       FractionBox["112", "41"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["26", "15"], ",", 
       FractionBox["6", "5"], ",", 
       FractionBox["26", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["146", "105"], ",", 
       FractionBox["46", "35"], ",", 
       FractionBox["242", "105"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["216", "163"], ",", 
       FractionBox["228", "163"], ",", 
       FractionBox["420", "163"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["188", "135"], ",", 
       FractionBox["194", "135"], ",", 
       FractionBox["118", "45"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["68", "41"], ",", 
       FractionBox["64", "41"], ",", 
       FractionBox["112", "41"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["26", "15"], ",", 
       FractionBox["6", "5"], ",", 
       FractionBox["26", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["146", "105"], ",", 
       FractionBox["46", "35"], ",", 
       FractionBox["242", "105"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["216", "163"], ",", 
       FractionBox["228", "163"], ",", 
       FractionBox["420", "163"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["188", "135"], ",", 
       FractionBox["194", "135"], ",", 
       FractionBox["118", "45"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"]}], "}"}]}],
  SequenceForm[{{
     Rational[68, 41], 
     Rational[64, 41], 
     Rational[112, 41]}, {
     Rational[26, 15], 
     Rational[6, 5], 
     Rational[26, 15]}, {
     Rational[146, 105], 
     Rational[46, 35], 
     Rational[242, 105]}, {
     Rational[216, 163], 
     Rational[228, 163], 
     Rational[420, 163]}, {
     Rational[188, 135], 
     Rational[194, 135], 
     Rational[118, 45]}}, "\n", {{
     Rational[8, 3], 
     Rational[4, 3], 
     Rational[4, 3]}, {
     Rational[68, 41], 
     Rational[64, 41], 
     Rational[112, 41]}, {
     Rational[26, 15], 
     Rational[6, 5], 
     Rational[26, 15]}, {
     Rational[146, 105], 
     Rational[46, 35], 
     Rational[242, 105]}, {
     Rational[216, 163], 
     Rational[228, 163], 
     Rational[420, 163]}, {
     Rational[188, 135], 
     Rational[194, 135], 
     Rational[118, 45]}}, "\n", {
    Rational[8, 3], 
    Rational[4, 3], 
    Rational[4, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526414016*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.008130081300813`"}], ",", "0.22764227642276422`", ",", 
     "1.3983739837398375`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9333333333333333`"}], ",", 
     RowBox[{"-", "0.13333333333333333`"}], ",", "0.4`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.276190476190476`"}], ",", 
     RowBox[{"-", "0.01904761904761905`"}], ",", "0.9714285714285714`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.3415132924335378`"}], ",", "0.065439672801636`", ",", 
     "1.243353783231084`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2740740740740741`"}], ",", "0.1037037037037037`", ",", 
     "1.288888888888889`"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645264170184`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.29923535524969236`"}], ",", 
     RowBox[{"-", "2.083022575693182`"}], ",", 
     RowBox[{"-", "1.3300387067677744`"}], ",", 
     RowBox[{"-", "1.0011179433340132`"}], ",", 
     RowBox[{"-", "0.8487604483330906`"}]}], "}"}]}],
  SequenceForm[
  "laux=", {-0.29923535524969236`, -2.083022575693182, -1.3300387067677744`, \
-1.0011179433340132`, -0.8487604483330906}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264170184`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "1"}],
  SequenceForm[2, 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264180183`*^9}],

Cell[BoxData["1"], "Print",
 CellChangeTimes->{3.6400645264190197`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["583", "390"], ",", 
       FractionBox["499", "390"], ",", 
       FractionBox["641", "390"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["307", "183"], ",", 
       FractionBox["223", "183"], ",", 
       FractionBox["341", "183"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["142", "75"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["158", "75"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["44", "15"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["6", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["6", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["583", "390"], ",", 
       FractionBox["499", "390"], ",", 
       FractionBox["641", "390"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["307", "183"], ",", 
       FractionBox["223", "183"], ",", 
       FractionBox["341", "183"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["142", "75"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["158", "75"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["44", "15"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"]}], "}"}]}],
  SequenceForm[{{
     Rational[583, 390], 
     Rational[499, 390], 
     Rational[641, 390]}, {
     Rational[307, 183], 
     Rational[223, 183], 
     Rational[341, 183]}, {
     Rational[142, 75], 
     Rational[4, 3], 
     Rational[158, 75]}, {
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[44, 15]}}, "\n", {{
     Rational[6, 5], 
     Rational[12, 5], 
     Rational[6, 5]}, {
     Rational[583, 390], 
     Rational[499, 390], 
     Rational[641, 390]}, {
     Rational[307, 183], 
     Rational[223, 183], 
     Rational[341, 183]}, {
     Rational[142, 75], 
     Rational[4, 3], 
     Rational[158, 75]}, {
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[44, 15]}}, "\n", {
    Rational[6, 5], 
    Rational[12, 5], 
    Rational[6, 5]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526420029*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2948717948717949`", ",", 
     RowBox[{"-", "1.1205128205128205`"}], ",", "0.44358974358974357`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.47759562841530057`", ",", 
     RowBox[{"-", "1.1814207650273223`"}], ",", "0.6633879781420765`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6933333333333334`", ",", 
     RowBox[{"-", "1.0666666666666667`"}], ",", "0.9066666666666666`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4666666666666666`", ",", 
     RowBox[{"-", "0.13333333333333333`"}], ",", "1.7333333333333334`"}], 
    "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645264220314`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4533051811525934`"}], ",", 
     RowBox[{"-", "1.0205959003743903`"}], ",", 
     RowBox[{"-", "0.40967324519935133`"}], ",", "1.54759540784785`"}], 
    "}"}]}],
  SequenceForm[
  "laux=", {-1.4533051811525934`, -1.0205959003743903`, -0.40967324519935133`,
    1.54759540784785}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264220314`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "4"}],
  SequenceForm[1, 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264230313`*^9}],

Cell[BoxData["1"], "Print",
 CellChangeTimes->{3.6400645264230313`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["28", "15"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1148", "789"], ",", 
       FractionBox["340", "263"], ",", 
       FractionBox["1496", "789"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["620", "393"], ",", 
       FractionBox["164", "131"], ",", 
       FractionBox["824", "393"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["12", "7"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["16", "7"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["276", "127"], ",", 
       FractionBox["244", "127"], ",", 
       FractionBox["360", "127"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["6", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["6", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["28", "15"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1148", "789"], ",", 
       FractionBox["340", "263"], ",", 
       FractionBox["1496", "789"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["620", "393"], ",", 
       FractionBox["164", "131"], ",", 
       FractionBox["824", "393"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["12", "7"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["16", "7"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["276", "127"], ",", 
       FractionBox["244", "127"], ",", 
       FractionBox["360", "127"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"]}], "}"}]}],
  SequenceForm[{{
     Rational[28, 15], 
     Rational[34, 15], 
     Rational[34, 15]}, {
     Rational[1148, 789], 
     Rational[340, 263], 
     Rational[1496, 789]}, {
     Rational[620, 393], 
     Rational[164, 131], 
     Rational[824, 393]}, {
     Rational[12, 7], 
     Rational[4, 3], 
     Rational[16, 7]}, {
     Rational[276, 127], 
     Rational[244, 127], 
     Rational[360, 127]}}, "\n", {{
     Rational[6, 5], 
     Rational[12, 5], 
     Rational[6, 5]}, {
     Rational[28, 15], 
     Rational[34, 15], 
     Rational[34, 15]}, {
     Rational[1148, 789], 
     Rational[340, 263], 
     Rational[1496, 789]}, {
     Rational[620, 393], 
     Rational[164, 131], 
     Rational[824, 393]}, {
     Rational[12, 7], 
     Rational[4, 3], 
     Rational[16, 7]}, {
     Rational[276, 127], 
     Rational[244, 127], 
     Rational[360, 127]}}, "\n", {
    Rational[6, 5], 
    Rational[12, 5], 
    Rational[6, 5]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264250336`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.6666666666666666`", ",", 
     RowBox[{"-", "0.13333333333333333`"}], ",", "1.0666666666666667`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2550063371356147`", ",", 
     RowBox[{"-", "1.1072243346007604`"}], ",", "0.6960709759188847`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.37760814249363867`", ",", 
     RowBox[{"-", "1.1480916030534352`"}], ",", "0.8966921119592876`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5142857142857142`", ",", 
     RowBox[{"-", "1.0666666666666667`"}], ",", "1.0857142857142856`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9732283464566929`", ",", 
     RowBox[{"-", "0.47874015748031495`"}], ",", "1.6346456692913385`"}], 
    "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.640064526432039*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.391402170474087`", ",", 
     RowBox[{"-", "1.1377669343305985`"}], ",", 
     RowBox[{"-", "0.8148382444866148`"}], ",", 
     RowBox[{"-", "0.39836607528874934`"}], ",", "1.0095478166180865`"}], 
    "}"}]}],
  SequenceForm[
  "laux=", {
   1.391402170474087, -1.1377669343305985`, -0.8148382444866148, \
-0.39836607528874934`, 1.0095478166180865`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526432039*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "1"}],
  SequenceForm[2, 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264330397`*^9}],

Cell[BoxData["1"], "Print",
 CellChangeTimes->{3.6400645264340296`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["224", "135"], ",", 
       FractionBox["172", "135"], ",", 
       FractionBox["188", "135"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1136", "573"], ",", 
       FractionBox["236", "191"], ",", 
       FractionBox["932", "573"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["11", "5"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["9", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["1412", "765"], ",", 
       FractionBox["188", "85"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["6", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["6", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["224", "135"], ",", 
       FractionBox["172", "135"], ",", 
       FractionBox["188", "135"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1136", "573"], ",", 
       FractionBox["236", "191"], ",", 
       FractionBox["932", "573"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["11", "5"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["9", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["1412", "765"], ",", 
       FractionBox["188", "85"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"]}], "}"}]}],
  SequenceForm[{{
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[34, 15]}, {
     Rational[224, 135], 
     Rational[172, 135], 
     Rational[188, 135]}, {
     Rational[1136, 573], 
     Rational[236, 191], 
     Rational[932, 573]}, {
     Rational[11, 5], 
     Rational[4, 3], 
     Rational[9, 5]}, {
     Rational[8, 3], 
     Rational[1412, 765], 
     Rational[188, 85]}}, "\n", {{
     Rational[6, 5], 
     Rational[12, 5], 
     Rational[6, 5]}, {
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[34, 15]}, {
     Rational[224, 135], 
     Rational[172, 135], 
     Rational[188, 135]}, {
     Rational[1136, 573], 
     Rational[236, 191], 
     Rational[932, 573]}, {
     Rational[11, 5], 
     Rational[4, 3], 
     Rational[9, 5]}, {
     Rational[8, 3], 
     Rational[1412, 765], 
     Rational[188, 85]}}, "\n", {
    Rational[6, 5], 
    Rational[12, 5], 
    Rational[6, 5]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264350405`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.4666666666666666`", ",", 
     RowBox[{"-", "0.13333333333333333`"}], ",", "1.0666666666666667`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.45925925925925926`", ",", 
     RowBox[{"-", "1.125925925925926`"}], ",", "0.1925925925925926`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0.7825479930191972`", ",", 
     RowBox[{"-", "1.1643979057591622`"}], ",", "0.42652705061082025`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "1.0666666666666667`"}], ",", "0.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4666666666666666`", ",", 
     RowBox[{"-", "0.5542483660130719`"}], ",", "1.011764705882353`"}], 
    "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645264370327`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.4958005732178035`", ",", 
     RowBox[{"-", "1.559522749960874`"}], ",", 
     RowBox[{"-", "0.9163443446071101`"}], ",", 
     RowBox[{"-", "0.4049515589852139`"}], ",", "0.8809851129134941`"}], 
    "}"}]}],
  SequenceForm[
  "laux=", {
   1.4958005732178035`, -1.559522749960874, -0.9163443446071101, \
-0.4049515589852139, 0.8809851129134941}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526438072*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "1"}],
  SequenceForm[2, 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526438072*^9}],

Cell[BoxData["1"], "Print",
 CellChangeTimes->{3.640064526439043*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["988", "405"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["23", "15"], ",", 
       FractionBox["19", "15"], ",", 
       FractionBox["7", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["341", "183"], ",", 
       FractionBox["223", "183"], ",", 
       FractionBox["307", "183"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["158", "75"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["142", "75"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["914", "465"], ",", 
       FractionBox["1124", "465"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["6", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["6", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["988", "405"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["23", "15"], ",", 
       FractionBox["19", "15"], ",", 
       FractionBox["7", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["341", "183"], ",", 
       FractionBox["223", "183"], ",", 
       FractionBox["307", "183"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["158", "75"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["142", "75"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["914", "465"], ",", 
       FractionBox["1124", "465"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"]}], "}"}]}],
  SequenceForm[{{
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[988, 405]}, {
     Rational[23, 15], 
     Rational[19, 15], 
     Rational[7, 5]}, {
     Rational[341, 183], 
     Rational[223, 183], 
     Rational[307, 183]}, {
     Rational[158, 75], 
     Rational[4, 3], 
     Rational[142, 75]}, {
     Rational[8, 3], 
     Rational[914, 465], 
     Rational[1124, 465]}}, "\n", {{
     Rational[6, 5], 
     Rational[12, 5], 
     Rational[6, 5]}, {
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[988, 405]}, {
     Rational[23, 15], 
     Rational[19, 15], 
     Rational[7, 5]}, {
     Rational[341, 183], 
     Rational[223, 183], 
     Rational[307, 183]}, {
     Rational[158, 75], 
     Rational[4, 3], 
     Rational[142, 75]}, {
     Rational[8, 3], 
     Rational[914, 465], 
     Rational[1124, 465]}}, "\n", {
    Rational[6, 5], 
    Rational[12, 5], 
    Rational[6, 5]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526440044*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.4666666666666666`", ",", 
     RowBox[{"-", "0.13333333333333333`"}], ",", "1.2395061728395063`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3333333333333333`", ",", 
     RowBox[{"-", "1.1333333333333333`"}], ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6633879781420765`", ",", 
     RowBox[{"-", "1.1814207650273223`"}], ",", "0.47759562841530057`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9066666666666666`", ",", 
     RowBox[{"-", "1.0666666666666667`"}], ",", "0.6933333333333334`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4666666666666666`", ",", 
     RowBox[{"-", "0.4344086021505376`"}], ",", "1.217204301075269`"}], 
    "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.640064526443037*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.520805109964551`", ",", 
     RowBox[{"-", "1.7360144383129306`"}], ",", 
     RowBox[{"-", "1.0205959003743903`"}], ",", 
     RowBox[{"-", "0.40967324519935133`"}], ",", "1.114189396485484`"}], 
    "}"}]}],
  SequenceForm[
  "laux=", {
   1.520805109964551, -1.7360144383129306`, -1.0205959003743903`, \
-0.40967324519935133`, 1.114189396485484}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526444046*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "1"}],
  SequenceForm[2, 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526444046*^9}],

Cell[BoxData["5"], "Print",
 CellChangeTimes->{3.640064526445038*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["27", "17"], ",", 
       FractionBox["36", "17"], ",", 
       FractionBox["21", "17"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["262", "145"], ",", 
       FractionBox["68", "29"], ",", 
       FractionBox["238", "145"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["494", "265"], ",", 
       FractionBox["124", "53"], ",", 
       FractionBox["526", "265"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["28", "15"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1818", "1315"], ",", 
       FractionBox["468", "263"], ",", 
       FractionBox["1722", "1315"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["27", "17"], ",", 
       FractionBox["36", "17"], ",", 
       FractionBox["21", "17"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["262", "145"], ",", 
       FractionBox["68", "29"], ",", 
       FractionBox["238", "145"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["494", "265"], ",", 
       FractionBox["124", "53"], ",", 
       FractionBox["526", "265"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["28", "15"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["8", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1818", "1315"], ",", 
       FractionBox["468", "263"], ",", 
       FractionBox["1722", "1315"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"]}], "}"}]}],
  SequenceForm[{{
     Rational[27, 17], 
     Rational[36, 17], 
     Rational[21, 17]}, {
     Rational[262, 145], 
     Rational[68, 29], 
     Rational[238, 145]}, {
     Rational[494, 265], 
     Rational[124, 53], 
     Rational[526, 265]}, {
     Rational[28, 15], 
     Rational[34, 15], 
     Rational[34, 15]}, {
     Rational[1818, 1315], 
     Rational[468, 263], 
     Rational[1722, 1315]}}, "\n", {{
     Rational[27, 17], 
     Rational[36, 17], 
     Rational[21, 17]}, {
     Rational[262, 145], 
     Rational[68, 29], 
     Rational[238, 145]}, {
     Rational[494, 265], 
     Rational[124, 53], 
     Rational[526, 265]}, {
     Rational[28, 15], 
     Rational[34, 15], 
     Rational[34, 15]}, {
     Rational[4, 3], 
     Rational[4, 3], 
     Rational[8, 3]}, {
     Rational[1818, 1315], 
     Rational[468, 263], 
     Rational[1722, 1315]}}, "\n", {
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[8, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264460487`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2549019607843137`", ",", "0.7843137254901961`", ",", 
     RowBox[{"-", "1.4313725490196079`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4735632183908046`", ",", "1.0114942528735633`", ",", 
     RowBox[{"-", "1.025287356321839`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5308176100628931`", ",", "1.0062893081761006`", ",", 
     RowBox[{"-", "0.6817610062893081`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5333333333333333`", ",", "0.9333333333333333`", ",", 
     RowBox[{"-", "0.4`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04917617237008872`", ",", "0.4461343472750317`", ",", 
     RowBox[{"-", "1.3571609632446133`"}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645264480486`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4718165688691844`"}], ",", 
     RowBox[{"-", "0.4973397567796091`"}], ",", "0.17449987227434569`", ",", 
     "0.7749842582921286`", ",", 
     RowBox[{"-", "2.069797936214892`"}]}], "}"}]}],
  SequenceForm[
  "laux=", {-1.4718165688691844`, -0.4973397567796091, 0.17449987227434569`, 
   0.7749842582921286, -2.069797936214892}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526449041*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "4"}],
  SequenceForm[5, 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526449041*^9}],

Cell[BoxData["5"], "Print",
 CellChangeTimes->{3.640064526450041*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["27", "17"], ",", 
       FractionBox["36", "17"], ",", 
       FractionBox["21", "17"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["262", "145"], ",", 
       FractionBox["68", "29"], ",", 
       FractionBox["238", "145"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["494", "265"], ",", 
       FractionBox["124", "53"], ",", 
       FractionBox["526", "265"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["28", "15"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1818", "1315"], ",", 
       FractionBox["468", "263"], ",", 
       FractionBox["1722", "1315"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["27", "17"], ",", 
       FractionBox["36", "17"], ",", 
       FractionBox["21", "17"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["262", "145"], ",", 
       FractionBox["68", "29"], ",", 
       FractionBox["238", "145"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["494", "265"], ",", 
       FractionBox["124", "53"], ",", 
       FractionBox["526", "265"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["28", "15"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["34", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["8", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1818", "1315"], ",", 
       FractionBox["468", "263"], ",", 
       FractionBox["1722", "1315"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"]}], "}"}]}],
  SequenceForm[{{
     Rational[27, 17], 
     Rational[36, 17], 
     Rational[21, 17]}, {
     Rational[262, 145], 
     Rational[68, 29], 
     Rational[238, 145]}, {
     Rational[494, 265], 
     Rational[124, 53], 
     Rational[526, 265]}, {
     Rational[28, 15], 
     Rational[34, 15], 
     Rational[34, 15]}, {
     Rational[1818, 1315], 
     Rational[468, 263], 
     Rational[1722, 1315]}}, "\n", {{
     Rational[27, 17], 
     Rational[36, 17], 
     Rational[21, 17]}, {
     Rational[262, 145], 
     Rational[68, 29], 
     Rational[238, 145]}, {
     Rational[494, 265], 
     Rational[124, 53], 
     Rational[526, 265]}, {
     Rational[28, 15], 
     Rational[34, 15], 
     Rational[34, 15]}, {
     Rational[4, 3], 
     Rational[4, 3], 
     Rational[8, 3]}, {
     Rational[1818, 1315], 
     Rational[468, 263], 
     Rational[1722, 1315]}}, "\n", {
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[8, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264510508`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2549019607843137`", ",", "0.7843137254901961`", ",", 
     RowBox[{"-", "1.4313725490196079`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4735632183908046`", ",", "1.0114942528735633`", ",", 
     RowBox[{"-", "1.025287356321839`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5308176100628931`", ",", "1.0062893081761006`", ",", 
     RowBox[{"-", "0.6817610062893081`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5333333333333333`", ",", "0.9333333333333333`", ",", 
     RowBox[{"-", "0.4`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04917617237008872`", ",", "0.4461343472750317`", ",", 
     RowBox[{"-", "1.3571609632446133`"}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645264530535`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4718165688691844`"}], ",", 
     RowBox[{"-", "0.4973397567796091`"}], ",", "0.17449987227434569`", ",", 
     "0.7749842582921286`", ",", 
     RowBox[{"-", "2.069797936214892`"}]}], "}"}]}],
  SequenceForm[
  "laux=", {-1.4718165688691844`, -0.4973397567796091, 0.17449987227434569`, 
   0.7749842582921286, -2.069797936214892}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264541063`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "4"}],
  SequenceForm[5, 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264550543`*^9}],

Cell[BoxData["7"], "Print",
 CellChangeTimes->{3.6400645264550543`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["852", "391"], ",", 
       FractionBox["660", "391"], ",", 
       FractionBox["504", "391"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["136", "63"], ",", 
       FractionBox["136", "63"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["17", "6"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["53", "20"], ",", 
       FractionBox["499", "220"], ",", 
       FractionBox["641", "220"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["2422", "915"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["2669", "915"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["23", "15"], ",", 
       FractionBox["19", "15"], ",", 
       FractionBox["7", "5"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["852", "391"], ",", 
       FractionBox["660", "391"], ",", 
       FractionBox["504", "391"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["136", "63"], ",", 
       FractionBox["136", "63"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["17", "6"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["53", "20"], ",", 
       FractionBox["499", "220"], ",", 
       FractionBox["641", "220"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["2422", "915"], ",", 
       FractionBox["34", "15"], ",", 
       FractionBox["2669", "915"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["23", "15"], ",", 
       FractionBox["19", "15"], ",", 
       FractionBox["7", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["8", "3"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"]}], "}"}]}],
  SequenceForm[{{
     Rational[852, 391], 
     Rational[660, 391], 
     Rational[504, 391]}, {
     Rational[8, 3], 
     Rational[136, 63], 
     Rational[136, 63]}, {
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[17, 6]}, {
     Rational[53, 20], 
     Rational[499, 220], 
     Rational[641, 220]}, {
     Rational[2422, 915], 
     Rational[34, 15], 
     Rational[2669, 915]}, {
     Rational[23, 15], 
     Rational[19, 15], 
     Rational[7, 5]}}, "\n", {{
     Rational[852, 391], 
     Rational[660, 391], 
     Rational[504, 391]}, {
     Rational[8, 3], 
     Rational[136, 63], 
     Rational[136, 63]}, {
     Rational[8, 3], 
     Rational[34, 15], 
     Rational[17, 6]}, {
     Rational[53, 20], 
     Rational[499, 220], 
     Rational[641, 220]}, {
     Rational[2422, 915], 
     Rational[34, 15], 
     Rational[2669, 915]}, {
     Rational[23, 15], 
     Rational[19, 15], 
     Rational[7, 5]}, {
     Rational[4, 3], 
     Rational[4, 3], 
     Rational[8, 3]}}, "\n", {
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[8, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264570456`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.8456947996589941`", ",", "0.3546462063086104`", ",", 
     RowBox[{"-", "1.3776641091219097`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3333333333333333`", ",", "0.8253968253968254`", ",", 
     RowBox[{"-", "0.5079365079365079`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.3333333333333333`", ",", "0.9333333333333333`", ",", 
     "0.16666666666666666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.3166666666666667`", ",", "0.9348484848484848`", ",", 
     "0.24696969696969698`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.3136612021857923`", ",", "0.9333333333333333`", ",", 
     "0.2502732240437158`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", 
     RowBox[{"-", "0.06666666666666667`"}], ",", 
     RowBox[{"-", "1.2666666666666666`"}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645264600487`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2527803464944416`"}], ",", "0.9244454589256144`", ",", 
     "2.1189218496438933`", ",", "2.2408644144978522`", ",", 
     "2.246398037631593`", ",", 
     RowBox[{"-", "2.492035831925592`"}]}], "}"}]}],
  SequenceForm[
  "laux=", {-1.2527803464944416`, 0.9244454589256144, 2.1189218496438933`, 
   2.2408644144978522`, 2.246398037631593, -2.492035831925592}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264610605`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "5"}],
  SequenceForm[6, 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264610605`*^9}],

Cell[BoxData["6"], "Print",
 CellChangeTimes->{3.64006452646205*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["420", "163"], ",", 
       FractionBox["228", "163"], ",", 
       FractionBox["216", "163"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["40", "27"], ",", 
       FractionBox["40", "27"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["200", "129"], ",", 
       FractionBox["220", "129"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["7", "3"], ",", 
       FractionBox["67", "51"], ",", 
       FractionBox["23", "17"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["26", "15"], ",", 
       FractionBox["6", "5"], ",", 
       FractionBox["26", "15"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["420", "163"], ",", 
       FractionBox["228", "163"], ",", 
       FractionBox["216", "163"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["40", "27"], ",", 
       FractionBox["40", "27"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["200", "129"], ",", 
       FractionBox["220", "129"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["7", "3"], ",", 
       FractionBox["67", "51"], ",", 
       FractionBox["23", "17"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["26", "15"], ",", 
       FractionBox["6", "5"], ",", 
       FractionBox["26", "15"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["8", "3"]}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"]}], "}"}]}],
  SequenceForm[{{
     Rational[420, 163], 
     Rational[228, 163], 
     Rational[216, 163]}, {
     Rational[8, 3], 
     Rational[40, 27], 
     Rational[40, 27]}, {
     Rational[8, 3], 
     Rational[200, 129], 
     Rational[220, 129]}, {
     Rational[7, 3], 
     Rational[67, 51], 
     Rational[23, 17]}, {
     Rational[26, 15], 
     Rational[6, 5], 
     Rational[26, 15]}}, "\n", {{
     Rational[420, 163], 
     Rational[228, 163], 
     Rational[216, 163]}, {
     Rational[8, 3], 
     Rational[40, 27], 
     Rational[40, 27]}, {
     Rational[8, 3], 
     Rational[200, 129], 
     Rational[220, 129]}, {
     Rational[7, 3], 
     Rational[67, 51], 
     Rational[23, 17]}, {
     Rational[26, 15], 
     Rational[6, 5], 
     Rational[26, 15]}, {
     Rational[4, 3], 
     Rational[4, 3], 
     Rational[8, 3]}}, "\n", {
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[8, 3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6400645264630594`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.243353783231084`", ",", "0.065439672801636`", ",", 
     RowBox[{"-", "1.3415132924335378`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3333333333333333`", ",", "0.14814814814814814`", ",", 
     RowBox[{"-", "1.1851851851851851`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3333333333333333`", ",", "0.21705426356589147`", ",", 
     RowBox[{"-", "0.9612403100775194`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.0196078431372549`"}], ",", 
     RowBox[{"-", "1.3137254901960784`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", 
     RowBox[{"-", "0.13333333333333333`"}], ",", 
     RowBox[{"-", "0.9333333333333333`"}]}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.640064526466053*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"laux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.0011179433340132`"}], ",", 
     RowBox[{"-", "0.6620847108818944`"}], ",", 
     RowBox[{"-", "0.29923535524969236`"}], ",", 
     RowBox[{"-", "1.3300387067677744`"}], ",", 
     RowBox[{"-", "2.083022575693182`"}]}], "}"}]}],
  SequenceForm[
  "laux=", {-1.0011179433340132`, -0.6620847108818944, -0.29923535524969236`, \
-1.3300387067677744`, -2.083022575693182}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526467063*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "3"}],
  SequenceForm[5, 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.640064526467063*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", 
  RowBox[{"{", 
   RowBox[{"lpuntosAux1", ",", "lpuntosAux2", ",", "lpuntosAux3"}], 
   "}"}]}]], "Input",
 CellChangeTimes->{{3.6399647809778767`*^9, 3.6399648097643023`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "4", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.640064546091987*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pYk1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"puntoYKPoligono", "[", 
      RowBox[{
       RowBox[{"vTriangulo", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "#"}], "]"}], "&"}], "/@", 
    "lpuntosAux1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pYk2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"puntoYKPoligono", "[", 
      RowBox[{
       RowBox[{"vTriangulo", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "#"}], "]"}], "&"}], "/@", 
    "lpuntosAux2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pYk3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"puntoYKPoligono", "[", 
      RowBox[{
       RowBox[{"vTriangulo", "[", 
        RowBox[{"[", "3", "]"}], "]"}], ",", "#"}], "]"}], "&"}], "/@", 
    "lpuntosAux3"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.63996302339587*^9, 3.639963058379689*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    FractionBox["8", "3"], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"14", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"8", " ", "\[Lambda]"}], "5"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"3424", " ", "\[Mu]"}], "1635"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "-", 
     FractionBox[
      RowBox[{"104", " ", "\[Mu]"}], "545"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"688", " ", "\[Mu]"}], "1635"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064550913398*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["125", "107"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["545", "428"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509234056`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["8", "3"], ",", 
   FractionBox["778", "321"], ",", 
   FractionBox["1028", "321"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509244146`*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.6400645509254065`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    FractionBox["16", "3"], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"28", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"16", " ", "\[Lambda]"}], "5"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"1712", " ", "\[Mu]"}], "545"]}], ",", 
    RowBox[{"4", "-", 
     FractionBox[
      RowBox[{"156", " ", "\[Mu]"}], "545"]}], ",", 
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"344", " ", "\[Mu]"}], "545"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509254065`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["125", "214"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["545", "642"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509264164`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["16", "3"], ",", 
   FractionBox["402", "107"], ",", 
   FractionBox["1456", "321"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509284143`*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.6400645509334135`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    FractionBox["8", "3"], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"14", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"14", " ", "\[Lambda]"}], "15"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"7", " ", "\[Mu]"}], "3"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"7", " ", "\[Mu]"}], "75"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"7", " ", "\[Mu]"}], "75"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509354134`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["54", "35"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["8", "7"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509364243`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["8", "3"], ",", 
   FractionBox["208", "75"], ",", 
   FractionBox["208", "75"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064550938428*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.6400645509404273`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    FractionBox["16", "3"], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"28", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"28", " ", "\[Lambda]"}], "15"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"7", " ", "\[Mu]"}], "2"]}], ",", 
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"7", " ", "\[Mu]"}], "50"]}], ",", 
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"7", " ", "\[Mu]"}], "50"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064550941427*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["27", "35"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["16", "21"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.640064550942419*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["16", "3"], ",", 
   FractionBox["308", "75"], ",", 
   FractionBox["308", "75"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064550943432*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.640064550943432*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    FractionBox["8", "3"], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"14", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"266", " ", "\[Lambda]"}], "225"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"34", " ", "\[Mu]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "-", 
     FractionBox[
      RowBox[{"2", " ", "\[Mu]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"2", " ", "\[Mu]"}], "15"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509444203`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["150", "119"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["20", "17"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.640064550945433*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["8", "3"], ",", 
   FractionBox["128", "51"], ",", 
   FractionBox["48", "17"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064550945433*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.6400645509464326`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    FractionBox["16", "3"], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"28", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"532", " ", "\[Lambda]"}], "225"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"17", " ", "\[Mu]"}], "5"]}], ",", 
    RowBox[{"4", "-", 
     FractionBox["\[Mu]", "5"]}], ",", 
    RowBox[{"4", "+", 
     FractionBox["\[Mu]", "5"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509474335`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["75", "119"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["40", "51"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.640064550948434*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["16", "3"], ",", 
   FractionBox["196", "51"], ",", 
   FractionBox["212", "51"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064550948434*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.640064550949435*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["8", "3"], "-", 
     FractionBox[
      RowBox[{"124", " ", "\[Lambda]"}], "123"]}], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"28", " ", "\[Lambda]"}], "123"]}], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"172", " ", "\[Lambda]"}], "123"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"28", " ", "\[Mu]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "-", 
     FractionBox[
      RowBox[{"4", " ", "\[Mu]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"4", " ", "\[Mu]"}], "5"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064550950435*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["41", "16"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["45", "16"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509514356`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "12"], ",", 
   FractionBox["23", "12"], ",", 
   FractionBox["59", "12"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509514356`*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.6400645509534383`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"248", " ", "\[Lambda]"}], "123"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"56", " ", "\[Lambda]"}], "123"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"344", " ", "\[Lambda]"}], "123"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"14", " ", "\[Mu]"}], "5"]}], ",", 
    RowBox[{"4", "-", 
     FractionBox[
      RowBox[{"2", " ", "\[Mu]"}], "5"]}], ",", 
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"6", " ", "\[Mu]"}], "5"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509544373`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["41", "32"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["15", "8"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509554386`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11", "4"], ",", 
   FractionBox["13", "4"], ",", 
   FractionBox["25", "4"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509564395`*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.6400645509574404`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"124", " ", "\[Lambda]"}], "41"]}], ",", 
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"28", " ", "\[Lambda]"}], "41"]}], ",", 
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"172", " ", "\[Lambda]"}], "41"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["32", "3"], "-", 
     FractionBox[
      RowBox[{"56", " ", "\[Mu]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"8", " ", "\[Mu]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "+", 
     FractionBox[
      RowBox[{"8", " ", "\[Mu]"}], "5"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509574404`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["41", "48"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["45", "32"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509584413`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["65", "12"], ",", 
   FractionBox["55", "12"], ",", 
   FractionBox["91", "12"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509594307`*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.6400645509594307`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["6", "5"], "+", 
     FractionBox[
      RowBox[{"22", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "-", 
     FractionBox[
      RowBox[{"2", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["6", "5"], "+", 
     FractionBox[
      RowBox[{"26", " ", "\[Lambda]"}], "15"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"23", " ", "\[Mu]"}], "39"]}], ",", 
    RowBox[{
     FractionBox["24", "5"], "-", 
     FractionBox[
      RowBox[{"437", " ", "\[Mu]"}], "195"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"173", " ", "\[Mu]"}], "195"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064550960442*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["87", "68"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["39", "34"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.640064550961443*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["523", "170"], ",", 
   FractionBox["379", "170"], ",", 
   FractionBox["581", "170"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509624443`*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.6400645509624443`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"44", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["24", "5"], "-", 
     FractionBox[
      RowBox[{"4", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"52", " ", "\[Lambda]"}], "15"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["18", "5"], "+", 
     FractionBox[
      RowBox[{"23", " ", "\[Mu]"}], "26"]}], ",", 
    RowBox[{
     FractionBox["36", "5"], "-", 
     FractionBox[
      RowBox[{"437", " ", "\[Mu]"}], "130"]}], ",", 
    RowBox[{
     FractionBox["18", "5"], "+", 
     FractionBox[
      RowBox[{"173", " ", "\[Mu]"}], "130"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509634438`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["87", "136"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["13", "17"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.640064550964445*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["727", "170"], ",", 
   FractionBox["787", "170"], ",", 
   FractionBox["157", "34"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509654446`*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.6400645509664445`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["6", "5"], "+", 
     FractionBox[
      RowBox[{"2", " ", "\[Lambda]"}], "3"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "-", 
     FractionBox[
      RowBox[{"2", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["6", "5"], "+", 
     FractionBox[
      RowBox[{"16", " ", "\[Lambda]"}], "15"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"2012", " ", "\[Mu]"}], "3945"]}], ",", 
    RowBox[{
     FractionBox["24", "5"], "-", 
     FractionBox[
      RowBox[{"2912", " ", "\[Mu]"}], "1315"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"5492", " ", "\[Mu]"}], "3945"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509664445`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["2610", "947"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["2367", "1894"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509684467`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["14382", "4735"], ",", 
   FractionBox["9624", "4735"], ",", 
   FractionBox["19602", "4735"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509684467`*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.640064550969449*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"4", " ", "\[Lambda]"}], "3"]}], ",", 
    RowBox[{
     FractionBox["24", "5"], "-", 
     FractionBox[
      RowBox[{"4", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"32", " ", "\[Lambda]"}], "15"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["18", "5"], "+", 
     FractionBox[
      RowBox[{"1006", " ", "\[Mu]"}], "1315"]}], ",", 
    RowBox[{
     FractionBox["36", "5"], "-", 
     FractionBox[
      RowBox[{"4368", " ", "\[Mu]"}], "1315"]}], ",", 
    RowBox[{
     FractionBox["18", "5"], "+", 
     FractionBox[
      RowBox[{"2746", " ", "\[Mu]"}], "1315"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509704494`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["1305", "947"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["789", "947"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.64006455097144*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["20064", "4735"], ",", 
   FractionBox["20988", "4735"], ",", 
   FractionBox["25284", "4735"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064550972451*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.6400645509735003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["18", "5"], "+", 
     RowBox[{"2", " ", "\[Lambda]"}]}], ",", 
    RowBox[{
     FractionBox["36", "5"], "-", 
     FractionBox[
      RowBox[{"2", " ", "\[Lambda]"}], "5"]}], ",", 
    RowBox[{
     FractionBox["18", "5"], "+", 
     FractionBox[
      RowBox[{"16", " ", "\[Lambda]"}], "5"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["24", "5"], "+", 
     FractionBox[
      RowBox[{"4024", " ", "\[Mu]"}], "3945"]}], ",", 
    RowBox[{
     FractionBox["48", "5"], "-", 
     FractionBox[
      RowBox[{"5824", " ", "\[Mu]"}], "1315"]}], ",", 
    RowBox[{
     FractionBox["24", "5"], "+", 
     FractionBox[
      RowBox[{"10984", " ", "\[Mu]"}], "3945"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.64006455097445*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["870", "947"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["2367", "3788"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509754515`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["25746", "4735"], ",", 
   FractionBox["32352", "4735"], ",", 
   FractionBox["30966", "4735"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509754515`*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.6400645509764557`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["6", "5"], "+", 
     FractionBox[
      RowBox[{"22", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "-", 
     FractionBox[
      RowBox[{"2", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["6", "5"], "+", 
     FractionBox[
      RowBox[{"16", " ", "\[Lambda]"}], "15"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"124", " ", "\[Mu]"}], "135"]}], ",", 
    RowBox[{
     FractionBox["24", "5"], "-", 
     FractionBox[
      RowBox[{"304", " ", "\[Mu]"}], "135"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"52", " ", "\[Mu]"}], "135"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509764557`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["54", "35"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["81", "70"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509774528`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["606", "175"], ",", 
   FractionBox["384", "175"], ",", 
   FractionBox["498", "175"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509784546`*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.640064550979458*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"44", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["24", "5"], "-", 
     FractionBox[
      RowBox[{"4", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"32", " ", "\[Lambda]"}], "15"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["18", "5"], "+", 
     FractionBox[
      RowBox[{"62", " ", "\[Mu]"}], "45"]}], ",", 
    RowBox[{
     FractionBox["36", "5"], "-", 
     FractionBox[
      RowBox[{"152", " ", "\[Mu]"}], "45"]}], ",", 
    RowBox[{
     FractionBox["18", "5"], "+", 
     FractionBox[
      RowBox[{"26", " ", "\[Mu]"}], "45"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064550980455*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["27", "35"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["27", "35"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509814568`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["816", "175"], ",", 
   FractionBox["804", "175"], ",", 
   FractionBox["708", "175"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509814568`*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.640064550982457*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["6", "5"], "+", 
     FractionBox[
      RowBox[{"22", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "-", 
     FractionBox[
      RowBox[{"2", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["6", "5"], "+", 
     FractionBox[
      RowBox[{"502", " ", "\[Lambda]"}], "405"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"2", " ", "\[Mu]"}], "3"]}], ",", 
    RowBox[{
     FractionBox["24", "5"], "-", 
     FractionBox[
      RowBox[{"34", " ", "\[Mu]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"2", " ", "\[Mu]"}], "5"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064550983448*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["243", "182"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["207", "182"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.640064550984458*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1437", "455"], ",", 
   FractionBox["1011", "455"], ",", 
   FractionBox["1299", "455"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064550984458*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.640064550985465*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"44", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["24", "5"], "-", 
     FractionBox[
      RowBox[{"4", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["12", "5"], "+", 
     FractionBox[
      RowBox[{"1004", " ", "\[Lambda]"}], "405"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["18", "5"], "+", "\[Mu]"}], ",", 
    RowBox[{
     FractionBox["36", "5"], "-", 
     FractionBox[
      RowBox[{"17", " ", "\[Mu]"}], "5"]}], ",", 
    RowBox[{
     FractionBox["18", "5"], "+", 
     FractionBox[
      RowBox[{"3", " ", "\[Mu]"}], "5"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064550986459*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["243", "364"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["69", "91"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.640064550987459*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1983", "455"], ",", 
   FractionBox["2103", "455"], ",", 
   FractionBox["369", "91"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064550987459*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.640064550988461*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"8", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"14", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "-", 
     FractionBox[
      RowBox[{"2", " ", "\[Lambda]"}], "5"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"388", " ", "\[Mu]"}], "3945"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"704", " ", "\[Mu]"}], "789"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"10708", " ", "\[Mu]"}], "3945"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509894614`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["2610", "947"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["1315", "947"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.640064550990453*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["7964", "2841"], ",", 
   FractionBox["11096", "2841"], ",", 
   FractionBox["4444", "2841"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064550990453*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.6400645509914627`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"16", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"28", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"4", " ", "\[Lambda]"}], "5"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"194", " ", "\[Mu]"}], "1315"]}], ",", 
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"352", " ", "\[Mu]"}], "263"]}], ",", 
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"5354", " ", "\[Mu]"}], "1315"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064550992463*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["1305", "947"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["2630", "2841"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509934645`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11752", "2841"], ",", 
   FractionBox["14884", "2841"], ",", 
   FractionBox["12020", "2841"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509934645`*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.6400645509944563`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"8", " ", "\[Lambda]"}], "5"]}], ",", 
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"14", " ", "\[Lambda]"}], "5"]}], ",", 
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"6", " ", "\[Lambda]"}], "5"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["16", "3"], "+", 
     FractionBox[
      RowBox[{"776", " ", "\[Mu]"}], "3945"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "+", 
     FractionBox[
      RowBox[{"1408", " ", "\[Mu]"}], "789"]}], ",", 
    RowBox[{
     FractionBox["32", "3"], "-", 
     FractionBox[
      RowBox[{"21416", " ", "\[Mu]"}], "3945"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509954653`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["870", "947"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["1315", "1894"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645509964666`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5180", "947"], ",", 
   FractionBox["6224", "947"], ",", 
   FractionBox["6532", "947"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064550997458*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.640064550997458*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"8", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"14", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "-", 
     FractionBox[
      RowBox[{"2", " ", "\[Lambda]"}], "5"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"388", " ", "\[Mu]"}], "3945"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"704", " ", "\[Mu]"}], "789"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"10708", " ", "\[Mu]"}], "3945"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.6400645509984603`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["2610", "947"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["1315", "947"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.640064550999468*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["7964", "2841"], ",", 
   FractionBox["11096", "2841"], ",", 
   FractionBox["4444", "2841"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645510004835`*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.64006455100147*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"16", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"28", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"4", " ", "\[Lambda]"}], "5"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"194", " ", "\[Mu]"}], "1315"]}], ",", 
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"352", " ", "\[Mu]"}], "263"]}], ",", 
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"5354", " ", "\[Mu]"}], "1315"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.64006455100147*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["1305", "947"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["2630", "2841"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645510024705`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11752", "2841"], ",", 
   FractionBox["14884", "2841"], ",", 
   FractionBox["12020", "2841"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064551003471*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.640064551003471*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"8", " ", "\[Lambda]"}], "5"]}], ",", 
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"14", " ", "\[Lambda]"}], "5"]}], ",", 
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"6", " ", "\[Lambda]"}], "5"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["16", "3"], "+", 
     FractionBox[
      RowBox[{"776", " ", "\[Mu]"}], "3945"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "+", 
     FractionBox[
      RowBox[{"1408", " ", "\[Mu]"}], "789"]}], ",", 
    RowBox[{
     FractionBox["32", "3"], "-", 
     FractionBox[
      RowBox[{"21416", " ", "\[Mu]"}], "3945"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064551004472*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["870", "947"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["1315", "1894"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.640064551005473*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5180", "947"], ",", 
   FractionBox["6224", "947"], ",", 
   FractionBox["6532", "947"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064551006488*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.640064551006488*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"1202", " ", "\[Lambda]"}], "915"]}], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"14", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"229", " ", "\[Lambda]"}], "915"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"2", " ", "\[Mu]"}], "5"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "-", 
     FractionBox[
      RowBox[{"2", " ", "\[Mu]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"38", " ", "\[Mu]"}], "15"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.64006455100749*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["1220", "941"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["870", "941"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645510084743`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["8572", "2823"], ",", 
   FractionBox["7180", "2823"], ",", 
   FractionBox["8444", "2823"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645510095344`*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.6400645510095344`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"2404", " ", "\[Lambda]"}], "915"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"28", " ", "\[Lambda]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "+", 
     FractionBox[
      RowBox[{"458", " ", "\[Lambda]"}], "915"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"3", " ", "\[Mu]"}], "5"]}], ",", 
    RowBox[{"4", "-", 
     FractionBox["\[Mu]", "5"]}], ",", 
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"19", " ", "\[Mu]"}], "5"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064551010476*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["610", "941"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["580", "941"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645510114765`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["4112", "941"], ",", 
   FractionBox["3648", "941"], ",", 
   FractionBox["5324", "941"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645510124965`*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.6400645510124965`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"4", " ", "\[Lambda]"}], "3"]}], ",", 
    RowBox[{
     FractionBox["4", "3"], "+", 
     FractionBox[
      RowBox[{"28", " ", "\[Lambda]"}], "129"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "-", 
     FractionBox[
      RowBox[{"124", " ", "\[Lambda]"}], "129"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"4", " ", "\[Mu]"}], "5"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "-", 
     FractionBox[
      RowBox[{"4", " ", "\[Mu]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"28", " ", "\[Mu]"}], "15"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064551013478*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["43", "16"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["45", "16"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645510144787`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["59", "12"], ",", 
   FractionBox["23", "12"], ",", 
   FractionBox["1", "12"]}], "}"}]], "Print",
 CellChangeTimes->{3.6400645510154705`*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.640064551016472*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"8", " ", "\[Lambda]"}], "3"]}], ",", 
    RowBox[{
     FractionBox["8", "3"], "+", 
     FractionBox[
      RowBox[{"56", " ", "\[Lambda]"}], "129"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"248", " ", "\[Lambda]"}], "129"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"6", " ", "\[Mu]"}], "5"]}], ",", 
    RowBox[{"4", "-", 
     FractionBox[
      RowBox[{"2", " ", "\[Mu]"}], "5"]}], ",", 
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"14", " ", "\[Mu]"}], "5"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064551016472*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["43", "32"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["15", "8"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.640064551017482*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["25", "4"], ",", 
   FractionBox["13", "4"], ",", 
   FractionBox["11", "4"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064551018482*^9}],

Cell[BoxData["False"], "Print",
 CellChangeTimes->{3.640064551019534*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"4", "+", 
     RowBox[{"4", " ", "\[Lambda]"}]}], ",", 
    RowBox[{"4", "+", 
     FractionBox[
      RowBox[{"28", " ", "\[Lambda]"}], "43"]}], ",", 
    RowBox[{"8", "-", 
     FractionBox[
      RowBox[{"124", " ", "\[Lambda]"}], "43"]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["16", "3"], "+", 
     FractionBox[
      RowBox[{"8", " ", "\[Mu]"}], "5"]}], ",", 
    RowBox[{
     FractionBox["16", "3"], "-", 
     FractionBox[
      RowBox[{"8", " ", "\[Mu]"}], "15"]}], ",", 
    RowBox[{
     FractionBox["32", "3"], "-", 
     FractionBox[
      RowBox[{"56", " ", "\[Mu]"}], "15"]}]}], "}"}]}]], "Print",
 CellChangeTimes->{3.640064551019534*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Lambda]", "\[Rule]", 
     FractionBox["43", "48"]}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     FractionBox["45", "32"]}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.6400645510204835`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["91", "12"], ",", 
   FractionBox["55", "12"], ",", 
   FractionBox["65", "12"]}], "}"}]], "Print",
 CellChangeTimes->{3.640064551021484*^9}],

Cell[BoxData["True"], "Print",
 CellChangeTimes->{3.6400645510224752`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"pYk1", ",", "pYk2", ",", "pYk3"}], "}"}]], "Input",
 CellChangeTimes->{{3.640061711448056*^9, 3.6400617224538536`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["16", "3"], ",", 
         FractionBox["402", "107"], ",", 
         FractionBox["1456", "321"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["16", "3"], ",", 
         FractionBox["308", "75"], ",", 
         FractionBox["308", "75"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["16", "3"], ",", 
         FractionBox["196", "51"], ",", 
         FractionBox["212", "51"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["65", "12"], ",", 
         FractionBox["55", "12"], ",", 
         FractionBox["91", "12"]}], "}"}], ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["727", "170"], ",", 
         FractionBox["787", "170"], ",", 
         FractionBox["157", "34"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["25746", "4735"], ",", 
         FractionBox["32352", "4735"], ",", 
         FractionBox["30966", "4735"]}], "}"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["816", "175"], ",", 
         FractionBox["804", "175"], ",", 
         FractionBox["708", "175"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["1983", "455"], ",", 
         FractionBox["2103", "455"], ",", 
         FractionBox["369", "91"]}], "}"}], ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["5180", "947"], ",", 
         FractionBox["6224", "947"], ",", 
         FractionBox["6532", "947"]}], "}"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["5180", "947"], ",", 
         FractionBox["6224", "947"], ",", 
         FractionBox["6532", "947"]}], "}"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["4112", "941"], ",", 
         FractionBox["3648", "941"], ",", 
         FractionBox["5324", "941"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["91", "12"], ",", 
         FractionBox["55", "12"], ",", 
         FractionBox["65", "12"]}], "}"}], ",", "3"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6400645639916873`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Nueva funci\[OAcute]n chSemigroup", "Section",
 CellChangeTimes->{{3.6412105217147627`*^9, 3.64121055946167*^9}}],

Cell["\<\
chSemigroup[vertices,n,True o False]
Devuelve {gr\[AAcute]fico, elementos del cono que no est\[AAcute]n (hasta \
iteraci\[OAcute]n k), elementos del cono que est\[AAcute]n (hasta iteraci\
\[OAcute]n k)}\
\>", "Text",
 CellChangeTimes->{{3.641210571749425*^9, 3.6412106608939447`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vv", "=", 
   RowBox[{
    RowBox[{"4", "/", "3"}], "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{
       FractionBox["9", "10"], "*", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["5", "10"], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "1", ",", "1"}], "}"}], "+", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], ")"}]}], "-", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["2", "10"], ",", 
         FractionBox["1", "10"], ",", 
         FractionBox["2", "10"]}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["95", "100"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["2", "10"], ",", "0", ",", 
         FractionBox["1", "10"]}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["17", "10"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{"-", "3"}], "10"], ",", "0", ",", "0"}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["17", "10"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["3", "10"], ",", "0", ",", "0"}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["17", "10"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["3", "10"], ",", "0", ",", 
         FractionBox["5", "10"]}], "}"}]}]}], "}"}]}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"raysOfConeOfCHSgr", "[", "vv", "]"}]], "Input",
 CellChangeTimes->{{3.6412107959481583`*^9, 3.641210797642376*^9}, {
  3.6412110072337155`*^9, 3.6412110073968334`*^9}, {3.6412143803841496`*^9, 
  3.6412143807273817`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.641211010400959*^9, 3.641211026125174*^9}, {
  3.6412143322678623`*^9, 3.641214382032319*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"belongToCHSgr", "::", "usage"}]], "Input",
 CellChangeTimes->{{3.6412112839218583`*^9, 3.6412112905075526`*^9}}],

Cell[BoxData["\<\"Check if the point P belong to the polyhedron with vertices \
verticesOfPolyhedron and definiing \\ninequalities \
listOfInequalities.\\n\\nExample:\\nbelongToCHSgr[listOfInequalities,\
verticesOfPolyhedron,P]\\n\"\>"], "Output",
 CellChangeTimes->{3.6412112909048333`*^9, 3.6412143344504066`*^9, 
  3.6412143853777013`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", "j", ",", "k"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "10", ",", "11"}], "}"}]}], "]"}], ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6412113216627483`*^9, 3.6412113883762875`*^9}, {
  3.641211464823757*^9, 3.6412114712913656`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "1", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "2", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "2", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "1", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "2", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "2", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "1", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "2", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "2", ",", "11"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.641211389276916*^9, 3.641211471538538*^9, 
  3.641214338050973*^9, 3.641214388169693*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"facesOf3Cone", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "7", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6412119016730075`*^9, 3.641211922982192*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"35", " ", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"28", " ", "x1"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"20", " ", "x2"}], "\[GreaterEqual]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6412119235566096`*^9, 3.6412119532187443`*^9}, 
   3.6412136824098167`*^9, 3.6412139511733265`*^9, 3.6412144054209847`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vv", ",", "4", ",", "True"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.64121336779566*^9, 3.641213396009765*^9}, {
  3.6412139818351755`*^9, 3.6412139822894945`*^9}, {3.641214033703123*^9, 
  3.641214034245518*^9}, {3.6412141139873343`*^9, 3.6412141203378572`*^9}, {
  3.641214438451523*^9, 3.641214489524912*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.64121352320639*^9, 3.6412136362139096`*^9}, 
   3.641213671992403*^9, 3.6412137219029646`*^9, {3.641213774692569*^9, 
   3.6412137849258604`*^9}, 3.641213821490923*^9, 3.641213861438386*^9, 
   3.6412139023765554`*^9, {3.6412139557445717`*^9, 3.6412139844970584`*^9}, {
   3.6412140265280595`*^9, 3.6412140350300803`*^9}, {3.641214082193682*^9, 
   3.641214162225703*^9}, {3.6412144207079287`*^9, 3.641214489983227*^9}, 
   3.6412160288366985`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"138", "-", 
     RowBox[{"5", " ", "x1"}], "-", 
     RowBox[{"55", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"282", "+", 
     RowBox[{"25", " ", "x1"}], "-", 
     RowBox[{"115", " ", "x2"}], "-", 
     RowBox[{"30", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"8", "-", 
     RowBox[{"3", " ", "x1"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "100"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"66", " ", "x2"}], "+", 
     RowBox[{"15", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"116", "+", 
     RowBox[{"35", " ", "x1"}], "-", 
     RowBox[{"38", " ", "x2"}], "-", 
     RowBox[{"42", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"12", "-", 
     RowBox[{"7", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "16"}], "+", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"9", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "348"}], "+", 
     RowBox[{"163", " ", "x1"}], "+", 
     RowBox[{"52", " ", "x2"}], "+", 
     RowBox[{"23", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"96", "+", 
     RowBox[{"53", " ", "x1"}], "-", 
     RowBox[{"47", " ", "x2"}], "-", 
     RowBox[{"39", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"24", "-", 
     RowBox[{"9", " ", "x1"}], "-", 
     RowBox[{"11", " ", "x2"}], "+", 
     RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "36"}], "+", "x1", "+", 
     RowBox[{"4", " ", "x2"}], "+", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.64121352320639*^9, 3.6412136362139096`*^9}, 
   3.641213671992403*^9, 3.6412137219029646`*^9, {3.641213774692569*^9, 
   3.6412137849258604`*^9}, 3.641213821490923*^9, 3.641213861438386*^9, 
   3.6412139023765554`*^9, {3.6412139557445717`*^9, 3.6412139844970584`*^9}, {
   3.6412140265280595`*^9, 3.6412140350300803`*^9}, {3.641214082193682*^9, 
   3.641214162225703*^9}, {3.6412144207079287`*^9, 3.641214489983227*^9}, 
   3.641216029035841*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{"48", "-", 
     RowBox[{"2", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.64121352320639*^9, 3.6412136362139096`*^9}, 
   3.641213671992403*^9, 3.6412137219029646`*^9, {3.641213774692569*^9, 
   3.6412137849258604`*^9}, 3.641213821490923*^9, 3.641213861438386*^9, 
   3.6412139023765554`*^9, {3.6412139557445717`*^9, 3.6412139844970584`*^9}, {
   3.6412140265280595`*^9, 3.6412140350300803`*^9}, {3.641214082193682*^9, 
   3.641214162225703*^9}, {3.6412144207079287`*^9, 3.641214489983227*^9}, 
   3.6412160291519227`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1320", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "122", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "60", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "62"}],
  SequenceForm[1320, " ", 122, " ", 60, " ", 62],
  Editable->False]], "Print",
 CellChangeTimes->{{3.64121352320639*^9, 3.6412136362139096`*^9}, 
   3.641213671992403*^9, 3.6412137219029646`*^9, {3.641213774692569*^9, 
   3.6412137849258604`*^9}, 3.641213821490923*^9, 3.641213861438386*^9, 
   3.6412139023765554`*^9, {3.6412139557445717`*^9, 3.6412139844970584`*^9}, {
   3.6412140265280595`*^9, 3.6412140350300803`*^9}, {3.641214082193682*^9, 
   3.641214162225703*^9}, {3.6412144207079287`*^9, 3.641214489983227*^9}, 
   3.6412160292489824`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{1.2, 2.4, 1.2}, {1.3333333333333333`, 
    1.3333333333333333`, 2.6666666666666665`}, {1.5333333333333334`, 
    1.2666666666666666`, 1.4}, {1.7333333333333334`, 1.2, 
    1.7333333333333334`}, {1.8666666666666667`, 2.2666666666666666`, 
    2.2666666666666666`}, {2.6666666666666665`, 1.3333333333333333`, 
    1.3333333333333333`}, {2.6666666666666665`, 2.2666666666666666`, 
    2.2666666666666666`}, {2.6666666666666665`, 2.2666666666666666`, 
    2.933333333333333}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.21727918065047835`, 0.7393886667684082, 0.33555772748762314`], Opacity[
     0.5]}], Polygon3DBox[{{8, 5, 2}, {7, 8, 6}, {4, 3, 6}, {5, 8, 1}, {8, 7, 
      1}, {5, 1, 2}, {1, 3, 2}, {3, 1, 6}, {1, 7, 6}, {3, 4, 2}, {4, 6, 2}, {
      6, 8, 2}}]}], 
   GraphicsComplex3DBox[{{2.4, 4.8, 2.4}, {2.6666666666666665`, 
    2.6666666666666665`, 5.333333333333333}, {3.066666666666667, 
    2.533333333333333, 2.8}, {3.466666666666667, 2.4, 3.466666666666667}, {
    3.7333333333333334`, 4.533333333333333, 4.533333333333333}, {
    5.333333333333333, 2.6666666666666665`, 2.6666666666666665`}, {
    5.333333333333333, 4.533333333333333, 4.533333333333333}, {
    5.333333333333333, 4.533333333333333, 5.866666666666666}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.7579290528328082, 0.3254245027093896, 0.7601974967140528], Opacity[
     0.5]}], Polygon3DBox[{{8, 5, 2}, {7, 8, 6}, {4, 3, 6}, {5, 8, 1}, {8, 7, 
      1}, {5, 1, 2}, {1, 3, 2}, {3, 1, 6}, {1, 7, 6}, {3, 4, 2}, {4, 6, 2}, {
      6, 8, 2}}]}], 
   GraphicsComplex3DBox[{{3.6, 7.2, 3.6}, {4., 4., 8.}, {4.6, 3.8, 4.2}, {5.2,
     3.6, 5.2}, {5.6, 6.8, 6.8}, {8., 4., 4.}, {8., 6.8, 6.8}, {8., 6.8, 
    8.8}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.43933626933991277`, 0.672804146739111, 0.949286040420438], Opacity[
     0.5]}], Polygon3DBox[{{8, 5, 2}, {7, 8, 6}, {4, 3, 6}, {5, 8, 1}, {8, 7, 
      1}, {5, 1, 2}, {1, 3, 2}, {3, 1, 6}, {1, 7, 6}, {3, 4, 2}, {4, 6, 2}, {
      6, 8, 2}}]}], 
   GraphicsComplex3DBox[{{4.8, 9.6, 4.8}, {5.333333333333333, 
    5.333333333333333, 10.666666666666666`}, {6.133333333333334, 
    5.066666666666666, 5.6}, {6.933333333333334, 4.8, 6.933333333333334}, {
    7.466666666666667, 9.066666666666666, 9.066666666666666}, {
    10.666666666666666`, 5.333333333333333, 5.333333333333333}, {
    10.666666666666666`, 9.066666666666666, 9.066666666666666}, {
    10.666666666666666`, 9.066666666666666, 11.733333333333333`}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.25034796879846, 0.2842714394988646, 0.008657188782771552], Opacity[
     0.5]}], Polygon3DBox[{{8, 5, 2}, {7, 8, 6}, {4, 3, 6}, {5, 8, 1}, {8, 7, 
      1}, {5, 1, 2}, {1, 3, 2}, {3, 1, 6}, {1, 7, 6}, {3, 4, 2}, {4, 6, 2}, {
      6, 8, 2}}]}], 
   {GrayLevel[0], PointSize[Medium], 
    Point3DBox[{{1, 1, 1}, {1, 1, 2}, {1, 2, 1}, {2, 1, 1}, {2, 2, 3}, {2, 2, 
     4}, {2, 3, 2}, {2, 3, 3}, {2, 4, 2}, {3, 2, 2}, {3, 2, 3}, {3, 3, 2}, {3,
      3, 6}, {3, 4, 5}, {3, 5, 3}, {3, 5, 4}, {3, 6, 3}, {4, 2, 2}, {4, 3, 
     5}, {4, 4, 6}, {4, 4, 7}, {4, 5, 3}, {4, 5, 4}, {4, 5, 5}, {4, 5, 7}, {4,
      6, 6}, {4, 7, 5}, {4, 8, 4}, {5, 3, 4}, {5, 4, 3}, {5, 5, 8}, {5, 5, 
     9}, {5, 5, 10}, {5, 6, 7}, {5, 6, 8}, {5, 6, 9}, {5, 7, 4}, {5, 7, 6}, {
     5, 7, 7}, {5, 7, 8}, {5, 8, 5}, {5, 8, 6}, {6, 3, 3}, {6, 4, 4}, {6, 5, 
     8}, {6, 5, 9}, {6, 6, 4}, {6, 7, 5}, {6, 8, 5}, {7, 4, 4}, {7, 5, 4}, {7,
      5, 8}, {7, 6, 5}, {7, 7, 5}, {8, 5, 6}, {8, 5, 7}, {8, 6, 5}, {8, 7, 
     5}, {9, 5, 5}, {9, 5, 6}, {9, 6, 5}, {10, 5, 5}}]}, 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[{{2, 1, 1}, {1, 2, 1}, {1, 1, 2}}]}, 
   {RGBColor[0, 0, 1], PointSize[Medium], 
    Point3DBox[{{0, 0, 0}, {2, 2, 2}, {3, 3, 3}, {3, 3, 4}, {3, 3, 5}, {3, 4, 
     3}, {3, 4, 4}, {4, 3, 3}, {4, 3, 4}, {4, 4, 3}, {4, 4, 4}, {4, 4, 5}, {4,
      4, 8}, {4, 5, 6}, {4, 6, 4}, {4, 6, 5}, {4, 7, 4}, {5, 3, 3}, {5, 4, 4},
      {5, 4, 5}, {5, 4, 6}, {5, 4, 7}, {5, 5, 4}, {5, 5, 5}, {5, 5, 6}, {5, 5,
      7}, {5, 6, 4}, {5, 6, 5}, {5, 6, 6}, {5, 7, 5}, {5, 8, 7}, {5, 9, 5}, {
     6, 4, 5}, {6, 4, 6}, {6, 5, 4}, {6, 5, 5}, {6, 5, 6}, {6, 5, 7}, {6, 6, 
     5}, {6, 6, 6}, {6, 6, 7}, {6, 6, 8}, {6, 6, 9}, {6, 7, 6}, {6, 7, 7}, {6,
      8, 6}, {7, 4, 5}, {7, 5, 5}, {7, 5, 6}, {7, 5, 7}, {7, 6, 6}, {7, 6, 
     7}, {7, 6, 8}, {7, 7, 6}, {7, 8, 5}, {8, 4, 4}, {8, 5, 5}, {8, 6, 6}, {8,
      6, 7}, {9, 6, 6}}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All]], "Output",
 CellChangeTimes->{
  3.641213404954134*^9, 3.641213448116887*^9, 3.641213484735978*^9, {
   3.6412135234495535`*^9, 3.6412136363580027`*^9}, 3.6412136721285005`*^9, 
   3.641213721998023*^9, {3.641213774830667*^9, 3.6412137850459557`*^9}, 
   3.641213821586009*^9, 3.6412138615964904`*^9, 3.641213902532657*^9, {
   3.641213955895691*^9, 3.641213984789276*^9}, {3.6412140267031384`*^9, 
   3.6412140352332125`*^9}, {3.641214082563945*^9, 3.6412141626470037`*^9}, {
   3.641214421119172*^9, 3.641214490443564*^9}, 3.6412160293300405`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"chSemigroup", "[", 
   RowBox[{"vv", ",", "4", ",", "True"}], "]"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6412145051890755`*^9, 3.641214518895838*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.641214496673995*^9, 3.641214519363161*^9}, 
   3.641216035780652*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"138", "-", 
     RowBox[{"5", " ", "x1"}], "-", 
     RowBox[{"55", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"282", "+", 
     RowBox[{"25", " ", "x1"}], "-", 
     RowBox[{"115", " ", "x2"}], "-", 
     RowBox[{"30", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"8", "-", 
     RowBox[{"3", " ", "x1"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "100"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"66", " ", "x2"}], "+", 
     RowBox[{"15", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"116", "+", 
     RowBox[{"35", " ", "x1"}], "-", 
     RowBox[{"38", " ", "x2"}], "-", 
     RowBox[{"42", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"12", "-", 
     RowBox[{"7", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "16"}], "+", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"9", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "348"}], "+", 
     RowBox[{"163", " ", "x1"}], "+", 
     RowBox[{"52", " ", "x2"}], "+", 
     RowBox[{"23", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"96", "+", 
     RowBox[{"53", " ", "x1"}], "-", 
     RowBox[{"47", " ", "x2"}], "-", 
     RowBox[{"39", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"24", "-", 
     RowBox[{"9", " ", "x1"}], "-", 
     RowBox[{"11", " ", "x2"}], "+", 
     RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "36"}], "+", "x1", "+", 
     RowBox[{"4", " ", "x2"}], "+", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.641214496673995*^9, 3.641214519363161*^9}, 
   3.641216035969773*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{"48", "-", 
     RowBox[{"2", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.641214496673995*^9, 3.641214519363161*^9}, 
   3.6412160360628376`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1320", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "122", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "60", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "62"}],
  SequenceForm[1320, " ", 122, " ", 60, " ", 62],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641214496673995*^9, 3.641214519363161*^9}, 
   3.6412160361639194`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "8", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "8", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "8", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "8", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "5", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.641214497099313*^9, 3.6412145197984705`*^9}, 
   3.6412160362210255`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Prueba de la funci\[OAcute]n Cota", "Section",
 CellChangeTimes->{{3.64006506028081*^9, 3.640065065873767*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6410491101147895`*^9, 3.641049111068471*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", 
   RowBox[{"\"\<convexHullSemigroups3D`\>\"", ",", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
     "\"\<\\\\convexHullSemigroups3DLibraryV6.wl\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6413672154453716`*^9, 3.6413673099854956`*^9}, 
   3.64162125386036*^9}],

Cell[BoxData["\<\"J. I. Garc\[IAcute]a-Garc\[IAcute]a and A. \
Vigneron-Tenorio,\\nDpto. Matem\[AAcute]ticas, \\nUniversidad de \
C\[AAcute]diz\\nignacio.garcia@uca.es, alberto.vigneron@uca.es\\n\\nThis \
package contains the commands: \\n....\\nTry command::usage for more \
help\"\>"], "Print",
 CellChangeTimes->{3.6416342393684006`*^9, 3.641634579719228*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"configuration", "[", 
   RowBox[{
   "\"\<C:\\\\tmp\\\\lrs\\\\lrs.exe\>\"", ",", "\"\<C:\\\\tmp\\\\\>\"", ",", 
    "\"\<C:\\\\tmp\\\\Normaliz2.12\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"showConfiguration", "[", "]"}]}], "Input",
 CellChangeTimes->{{3.64104912673164*^9, 3.6410491300119753`*^9}, 
   3.641049284252866*^9, {3.6411073213478384`*^9, 3.641107352088739*^9}, {
   3.6411074438150835`*^9, 3.64110744640294*^9}, {3.641291681429268*^9, 
   3.6412916825410633`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C:\\\\tmp\\\\lrs\\\\lrs.exe\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\Normaliz2.12\"\>"}],
  SequenceForm[
  "C:\\tmp\\lrs\\lrs.exe", "\n", "C:\\tmp\\", "\n", "C:\\tmp\\Normaliz2.12"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6416274212925386`*^9, 3.641627484877808*^9, 3.6416275399532785`*^9, 
   3.6416335297828674`*^9, 3.641634027077982*^9, 3.641634180436275*^9, {
   3.6416342346260386`*^9, 3.6416342402779074`*^9}, 3.6416345798129816`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"vv", "=", 
   RowBox[{
    RowBox[{"4", "/", "3"}], "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{
       FractionBox["9", "10"], "*", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["5", "10"], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "1", ",", "1"}], "}"}], "+", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], ")"}]}], "-", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["2", "10"], ",", 
         FractionBox["1", "10"], ",", 
         FractionBox["2", "10"]}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["95", "100"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["2", "10"], ",", "0", ",", 
         FractionBox["1", "10"]}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["17", "10"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{"-", "3"}], "10"], ",", "0", ",", "0"}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["17", "10"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["3", "10"], ",", "0", ",", "0"}], "}"}]}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["17", "10"], "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["3", "10"], ",", "0", ",", 
         FractionBox["5", "10"]}], "}"}]}]}], "}"}]}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cotaDevv", "=", 
   RowBox[{"boundCohenMacaulay", "[", "vv", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.64006505099822*^9, 3.640065053999339*^9}, {
  3.6405036992669125`*^9, 3.6405037001565485`*^9}, {3.640567392664887*^9, 
  3.6405673933623796`*^9}, {3.6405784120107975`*^9, 3.6405784154322248`*^9}, {
  3.640580038186573*^9, 3.640580038749965*^9}, {3.6411199908297405`*^9, 
  3.641119991919513*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.64163584103671*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["23", "15"], ",", 
     FractionBox["19", "15"], ",", 
     FractionBox["7", "5"], ",", 
     FractionBox["28", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["44", "15"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[8, 3], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[6, 5], 
    Rational[12, 5], 
    Rational[6, 5], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[8, 3], 
    Rational[26, 15], 
    Rational[6, 5], 
    Rational[26, 15], 
    Rational[23, 15], 
    Rational[19, 15], 
    Rational[7, 5], 
    Rational[28, 15], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[44, 15]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.64163584103671*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"40", ",", "20", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "36", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "18", ",", "26"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", "19", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "44"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{40, 20, 20}, {18, 36, 18}, {20, 20, 40}, {26, 18, 26}, {23, 19, 
   21}, {28, 34, 34}, {40, 34, 34}, {40, 34, 44}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.64163584103671*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358410523357`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358411148376`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"128.`", ",", "76.8`", ",", "128.`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358412242184`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["4", "3"], ",", 
        FractionBox["4", "3"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["6", "5"], ",", 
        FractionBox["12", "5"], ",", 
        FractionBox["6", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["4", "3"], ",", 
        FractionBox["4", "3"], ",", 
        FractionBox["8", "3"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[8, 3], 
      Rational[4, 3], 
      Rational[4, 3]}}, {{
      Rational[6, 5], 
      Rational[12, 5], 
      Rational[6, 5]}}, {{
      Rational[4, 3], 
      Rational[4, 3], 
      Rational[8, 3]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358412242184`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["8", "3"], ",", 
      FractionBox["4", "3"], ",", 
      FractionBox["4", "3"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 1, "]]=", {{
     Rational[8, 3], 
     Rational[4, 3], 
     Rational[4, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358412398434`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["6", "5"], ",", 
      FractionBox["12", "5"], ",", 
      FractionBox["6", "5"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 2, "]]=", {{
     Rational[6, 5], 
     Rational[12, 5], 
     Rational[6, 5]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.641635841989873*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["4", "3"], ",", 
      FractionBox["4", "3"], ",", 
      FractionBox["8", "3"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 3, "]]=", {{
     Rational[4, 3], 
     Rational[4, 3], 
     Rational[8, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358426617765`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[1]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["16", "3"], ",", 
         FractionBox["402", "107"], ",", 
         FractionBox["1456", "321"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["16", "3"], ",", 
         FractionBox["308", "75"], ",", 
         FractionBox["308", "75"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["16", "3"], ",", 
         FractionBox["196", "51"], ",", 
         FractionBox["212", "51"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["43", "4"], ",", 
         FractionBox["29", "4"], ",", 
         FractionBox["41", "4"]}], "}"}], ",", "5"}], "}"}]}], "}"}]}],
  SequenceForm["pYk[[1]]=", {{{
      Rational[16, 3], 
      Rational[402, 107], 
      Rational[1456, 321]}, 2}, {{
      Rational[16, 3], 
      Rational[308, 75], 
      Rational[308, 75]}, 2}, {{
      Rational[16, 3], 
      Rational[196, 51], 
      Rational[212, 51]}, 2}, {{
      Rational[43, 4], 
      Rational[29, 4], 
      Rational[41, 4]}, 5}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.641635843333677*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["19792", "107"], ",", 
   FractionBox["4672", "25"], ",", "192", ",", "354"}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.641635843333677*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[2]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["727", "170"], ",", 
         FractionBox["787", "170"], ",", 
         FractionBox["157", "34"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["25746", "4735"], ",", 
         FractionBox["32352", "4735"], ",", 
         FractionBox["30966", "4735"]}], "}"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["816", "175"], ",", 
         FractionBox["804", "175"], ",", 
         FractionBox["708", "175"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["1983", "455"], ",", 
         FractionBox["2103", "455"], ",", 
         FractionBox["369", "91"]}], "}"}], ",", "2"}], "}"}]}], "}"}]}],
  SequenceForm["pYk[[2]]=", {{{
      Rational[727, 170], 
      Rational[787, 170], 
      Rational[157, 34]}, 2}, {{
      Rational[25746, 4735], 
      Rational[32352, 4735], 
      Rational[30966, 4735]}, 3}, {{
      Rational[816, 175], 
      Rational[804, 175], 
      Rational[708, 175]}, 2}, {{
      Rational[1983, 455], 
      Rational[2103, 455], 
      Rational[369, 91]}, 2}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433493023`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["6792", "85"], ",", 
   FractionBox["645504", "4735"], ",", 
   FractionBox["14208", "175"], ",", 
   FractionBox["39696", "455"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433493023`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[3]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["5180", "947"], ",", 
         FractionBox["6224", "947"], ",", 
         FractionBox["6532", "947"]}], "}"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["136", "31"], ",", 
         FractionBox["120", "31"], ",", 
         FractionBox["176", "31"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["4112", "941"], ",", 
         FractionBox["3648", "941"], ",", 
         FractionBox["5324", "941"]}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["41", "4"], ",", 
         FractionBox["29", "4"], ",", 
         FractionBox["43", "4"]}], "}"}], ",", "5"}], "}"}]}], "}"}]}],
  SequenceForm["pYk[[3]]=", {{{
      Rational[5180, 947], 
      Rational[6224, 947], 
      Rational[6532, 947]}, 3}, {{
      Rational[136, 31], 
      Rational[120, 31], 
      Rational[176, 31]}, 2}, {{
      Rational[4112, 941], 
      Rational[3648, 941], 
      Rational[5324, 941]}, 2}, {{
      Rational[41, 4], 
      Rational[29, 4], 
      Rational[43, 4]}, 5}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433493023`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["196608", "947"], ",", 
   FractionBox["6528", "31"], ",", 
   FractionBox["197088", "941"], ",", "354"}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433493023`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximo=\"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["Maximo=", 5],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433649273`*^9}],

Cell[BoxData["\<\"--------------\"\>"], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433649273`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "306.`"}],
  SequenceForm["daux=", 306.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433649273`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["40", "3"], ",", 
       FractionBox["830", "107"], ",", 
       FractionBox["2740", "321"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["40", "3"], ",", 
       FractionBox["608", "75"], ",", 
       FractionBox["608", "75"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["40", "3"], ",", 
       FractionBox["400", "51"], ",", 
       FractionBox["416", "51"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["43", "4"], ",", 
       FractionBox["29", "4"], ",", 
       FractionBox["41", "4"]}], "}"}]}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[40, 3], 
     Rational[830, 107], 
     Rational[2740, 321]}, {
     Rational[40, 3], 
     Rational[608, 75], 
     Rational[608, 75]}, {
     Rational[40, 3], 
     Rational[400, 51], 
     Rational[416, 51]}, {
     Rational[43, 4], 
     Rational[29, 4], 
     Rational[41, 4]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433649273`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"568.9719626168225`", ",", "570.88`", ",", "576.`", ",", "354.`"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433805532`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433805532`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "117.59239704329461`"}],
  SequenceForm["daux=", 117.59239704329461`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433805532`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1339", "170"], ",", 
       FractionBox["2011", "170"], ",", 
       FractionBox["1397", "170"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["7422", "947"], ",", 
       FractionBox["11016", "947"], ",", 
       FractionBox["8466", "947"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1446", "175"], ",", 
       FractionBox["2064", "175"], ",", 
       FractionBox["1338", "175"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3621", "455"], ",", 
       FractionBox["5379", "455"], ",", 
       FractionBox["3483", "455"]}], "}"}]}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[1339, 170], 
     Rational[2011, 170], 
     Rational[1397, 170]}, {
     Rational[7422, 947], 
     Rational[11016, 947], 
     Rational[8466, 947]}, {
     Rational[1446, 175], 
     Rational[2064, 175], 
     Rational[1338, 175]}, {
     Rational[3621, 455], 
     Rational[5379, 455], 
     Rational[3483, 455]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.6416358433805532`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "310.3058823529412`", ",", "289.9260823653643`", ",", "311.5885714285714`", 
   ",", "317.64395604395605`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.641635843396179*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.641635843396179*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "306.`"}],
  SequenceForm["daux=", 306.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.641635843396179*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["23116", "2841"], ",", 
       FractionBox["26248", "2841"], ",", 
       FractionBox["34748", "2841"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["260", "31"], ",", 
       FractionBox["244", "31"], ",", 
       FractionBox["424", "31"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["7876", "941"], ",", 
       FractionBox["7412", "941"], ",", 
       FractionBox["12852", "941"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["41", "4"], ",", 
       FractionBox["29", "4"], ",", 
       FractionBox["43", "4"]}], "}"}]}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[23116, 2841], 
     Rational[26248, 2841], 
     Rational[34748, 2841]}, {
     Rational[260, 31], 
     Rational[244, 31], 
     Rational[424, 31]}, {
     Rational[7876, 941], 
     Rational[7412, 941], 
     Rational[12852, 941]}, {
     Rational[41, 4], 
     Rational[29, 4], 
     Rational[43, 4]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.641635843411804*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "463.6114044350581`", ",", "594.5806451612904`", ",", "593.4452709883103`", 
   ",", "354.`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.641635843411804*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412916971094027`*^9, 3.641292059058424*^9, 3.6412921121391153`*^9, 
   3.6413570081051607`*^9, {3.6413671032016563`*^9, 3.6413671182943735`*^9}, 
   3.6413673254054656`*^9, 3.6413673937129664`*^9, 3.6413674898430133`*^9, 
   3.6413684019617133`*^9, 3.641383300168275*^9, 3.641624604384416*^9, 
   3.6416246439338064`*^9, 3.6416247656205044`*^9, 3.641625957998163*^9, 
   3.6416261072006435`*^9, 3.64162621385336*^9, 3.6416264246939945`*^9, 
   3.641626507597111*^9, 3.6416265930133095`*^9, 3.641626662229593*^9, {
   3.6416267396024218`*^9, 3.6416267589500027`*^9}, 3.641626813755993*^9, 
   3.6416270379688773`*^9, 3.641627085175152*^9, 3.6416274250075803`*^9, 
   3.6416274883162813`*^9, 3.641627542838682*^9, 3.6416335346593685`*^9, 
   3.6416340307102575`*^9, 3.641634184067082*^9, 3.6416342435141215`*^9, 
   3.6416345832428617`*^9, 3.641634634197332*^9, 3.641635843411804*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["cotaDevv"], "Input",
 CellChangeTimes->{{3.641214653164508*^9, 3.6412146570412683`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["16", "3"], ",", 
           FractionBox["402", "107"], ",", 
           FractionBox["1456", "321"]}], "}"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["16", "3"], ",", 
           FractionBox["308", "75"], ",", 
           FractionBox["308", "75"]}], "}"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["16", "3"], ",", 
           FractionBox["196", "51"], ",", 
           FractionBox["212", "51"]}], "}"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["43", "4"], ",", 
           FractionBox["29", "4"], ",", 
           FractionBox["41", "4"]}], "}"}], ",", "5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["727", "170"], ",", 
           FractionBox["787", "170"], ",", 
           FractionBox["157", "34"]}], "}"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["25746", "4735"], ",", 
           FractionBox["32352", "4735"], ",", 
           FractionBox["30966", "4735"]}], "}"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["816", "175"], ",", 
           FractionBox["804", "175"], ",", 
           FractionBox["708", "175"]}], "}"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["1983", "455"], ",", 
           FractionBox["2103", "455"], ",", 
           FractionBox["369", "91"]}], "}"}], ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["5180", "947"], ",", 
           FractionBox["6224", "947"], ",", 
           FractionBox["6532", "947"]}], "}"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["136", "31"], ",", 
           FractionBox["120", "31"], ",", 
           FractionBox["176", "31"]}], "}"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["4112", "941"], ",", 
           FractionBox["3648", "941"], ",", 
           FractionBox["5324", "941"]}], "}"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["41", "4"], ",", 
           FractionBox["29", "4"], ",", 
           FractionBox["43", "4"]}], "}"}], ",", "5"}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["4", "3"], ",", 
        FractionBox["4", "3"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["6", "5"], ",", 
        FractionBox["12", "5"], ",", 
        FractionBox["6", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["4", "3"], ",", 
        FractionBox["4", "3"], ",", 
        FractionBox["8", "3"]}], "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8", ",", "4", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4", ",", "8"}], "}"}]}], "}"}], ",", "5", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"138", "-", 
       RowBox[{"5", " ", "x1"}], "-", 
       RowBox[{"55", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"282", "+", 
       RowBox[{"25", " ", "x1"}], "-", 
       RowBox[{"115", " ", "x2"}], "-", 
       RowBox[{"30", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"8", "-", 
       RowBox[{"3", " ", "x1"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "100"}], "-", 
       RowBox[{"3", " ", "x1"}], "+", 
       RowBox[{"66", " ", "x2"}], "+", 
       RowBox[{"15", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"116", "+", 
       RowBox[{"35", " ", "x1"}], "-", 
       RowBox[{"38", " ", "x2"}], "-", 
       RowBox[{"42", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], "-", 
       RowBox[{"3", " ", "x1"}], "+", 
       RowBox[{"12", " ", "x2"}], "-", 
       RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"12", "-", 
       RowBox[{"7", " ", "x1"}], "+", 
       RowBox[{"12", " ", "x2"}], "-", 
       RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "16"}], "+", 
       RowBox[{"3", " ", "x1"}], "+", 
       RowBox[{"9", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "348"}], "+", 
       RowBox[{"163", " ", "x1"}], "+", 
       RowBox[{"52", " ", "x2"}], "+", 
       RowBox[{"23", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"96", "+", 
       RowBox[{"53", " ", "x1"}], "-", 
       RowBox[{"47", " ", "x2"}], "-", 
       RowBox[{"39", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"24", "-", 
       RowBox[{"9", " ", "x1"}], "-", 
       RowBox[{"11", " ", "x2"}], "+", 
       RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "36"}], "+", "x1", "+", 
       RowBox[{"4", " ", "x2"}], "+", 
       RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.641214657694734*^9, 3.64121607955083*^9, 
  3.6412164781218853`*^9, 3.6412633704155455`*^9, 3.6412916626829553`*^9, 
  3.6412921164842005`*^9, 3.6413570114325085`*^9, 3.6413671256395893`*^9, 
  3.641367329673484*^9, 3.641367397194422*^9, 3.6413675026691294`*^9, 
  3.6413684049298306`*^9, 3.641383307152244*^9, 3.6416346390415745`*^9, 
  3.641635846476743*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vv", ",", "2", ",", "False", ",", "False", ",", "True"}], "]"}], 
   "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.6412146724262424`*^9, 3.6412146743435974`*^9}, {
  3.641292126286169*^9, 3.641292138047517*^9}, {3.641625606290553*^9, 
  3.6416256342376795`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.6412921298837175`*^9, 3.6412921394665203`*^9}, 
   3.6413570139913254`*^9, 3.641367128672744*^9, 3.6413673363372073`*^9, 
   3.6413673980900583`*^9, 3.6413675054130774`*^9, 3.6413684062407603`*^9, 
   3.641383309046588*^9, {3.641625606806199*^9, 3.6416256345846767`*^9}, 
   3.6416346406601768`*^9, 3.6416358502959337`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["23", "15"], ",", 
     FractionBox["19", "15"], ",", 
     FractionBox["7", "5"], ",", 
     FractionBox["28", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["44", "15"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[8, 3], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[6, 5], 
    Rational[12, 5], 
    Rational[6, 5], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[8, 3], 
    Rational[26, 15], 
    Rational[6, 5], 
    Rational[26, 15], 
    Rational[23, 15], 
    Rational[19, 15], 
    Rational[7, 5], 
    Rational[28, 15], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[44, 15]}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412921298837175`*^9, 3.6412921394665203`*^9}, 
   3.6413570139913254`*^9, 3.641367128672744*^9, 3.6413673363372073`*^9, 
   3.6413673980900583`*^9, 3.6413675054130774`*^9, 3.6413684062407603`*^9, 
   3.641383309046588*^9, {3.641625606806199*^9, 3.6416256345846767`*^9}, 
   3.6416346406601768`*^9, 3.6416358502959337`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"40", ",", "20", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "36", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "18", ",", "26"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", "19", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "44"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{40, 20, 20}, {18, 36, 18}, {20, 20, 40}, {26, 18, 26}, {23, 19, 
   21}, {28, 34, 34}, {40, 34, 34}, {40, 34, 44}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412921298837175`*^9, 3.6412921394665203`*^9}, 
   3.6413570139913254`*^9, 3.641367128672744*^9, 3.6413673363372073`*^9, 
   3.6413673980900583`*^9, 3.6413675054130774`*^9, 3.6413684062407603`*^9, 
   3.641383309046588*^9, {3.641625606806199*^9, 3.6416256345846767`*^9}, 
   3.6416346406601768`*^9, 3.6416358503115597`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412921298837175`*^9, 3.6412921394665203`*^9}, 
   3.6413570139913254`*^9, 3.641367128672744*^9, 3.6413673363372073`*^9, 
   3.6413673980900583`*^9, 3.6413675054130774`*^9, 3.6413684062407603`*^9, 
   3.641383309046588*^9, {3.641625606806199*^9, 3.6416256345846767`*^9}, 
   3.6416346406601768`*^9, 3.6416358503115597`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.6412921298837175`*^9, 3.6412921394665203`*^9}, 
   3.6413570139913254`*^9, 3.641367128672744*^9, 3.6413673363372073`*^9, 
   3.6413673980900583`*^9, 3.6413675054130774`*^9, 3.6413684062407603`*^9, 
   3.641383309046588*^9, {3.641625606806199*^9, 3.6416256345846767`*^9}, 
   3.6416346406601768`*^9, 3.6416358503271847`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["4", "3"], ",", 
        FractionBox["4", "3"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["6", "5"], ",", 
        FractionBox["12", "5"], ",", 
        FractionBox["6", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["4", "3"], ",", 
        FractionBox["4", "3"], ",", 
        FractionBox["8", "3"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[8, 3], 
      Rational[4, 3], 
      Rational[4, 3]}}, {{
      Rational[6, 5], 
      Rational[12, 5], 
      Rational[6, 5]}}, {{
      Rational[4, 3], 
      Rational[4, 3], 
      Rational[8, 3]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412921298837175`*^9, 3.6412921394665203`*^9}, 
   3.6413570139913254`*^9, 3.641367128672744*^9, 3.6413673363372073`*^9, 
   3.6413673980900583`*^9, 3.6413675054130774`*^9, 3.6413684062407603`*^9, 
   3.641383309046588*^9, {3.641625606806199*^9, 3.6416256345846767`*^9}, 
   3.6416346406601768`*^9, 3.6416358504990673`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["6", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["6", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["8", "3"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{
     Rational[8, 3], 
     Rational[4, 3], 
     Rational[4, 3]}, {
     Rational[6, 5], 
     Rational[12, 5], 
     Rational[6, 5]}, {
     Rational[4, 3], 
     Rational[4, 3], 
     Rational[8, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412921298837175`*^9, 3.6412921394665203`*^9}, 
   3.6413570139913254`*^9, 3.641367128672744*^9, 3.6413673363372073`*^9, 
   3.6413673980900583`*^9, 3.6413675054130774`*^9, 3.6413684062407603`*^9, 
   3.641383309046588*^9, {3.641625606806199*^9, 3.6416256345846767`*^9}, 
   3.6416346406601768`*^9, 3.6416358504990673`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"138", "-", 
     RowBox[{"5", " ", "x1"}], "-", 
     RowBox[{"55", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"282", "+", 
     RowBox[{"25", " ", "x1"}], "-", 
     RowBox[{"115", " ", "x2"}], "-", 
     RowBox[{"30", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"8", "-", 
     RowBox[{"3", " ", "x1"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "100"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"66", " ", "x2"}], "+", 
     RowBox[{"15", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"116", "+", 
     RowBox[{"35", " ", "x1"}], "-", 
     RowBox[{"38", " ", "x2"}], "-", 
     RowBox[{"42", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"12", "-", 
     RowBox[{"7", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "16"}], "+", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"9", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "348"}], "+", 
     RowBox[{"163", " ", "x1"}], "+", 
     RowBox[{"52", " ", "x2"}], "+", 
     RowBox[{"23", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"96", "+", 
     RowBox[{"53", " ", "x1"}], "-", 
     RowBox[{"47", " ", "x2"}], "-", 
     RowBox[{"39", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"24", "-", 
     RowBox[{"9", " ", "x1"}], "-", 
     RowBox[{"11", " ", "x2"}], "+", 
     RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "36"}], "+", "x1", "+", 
     RowBox[{"4", " ", "x2"}], "+", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.6412921298837175`*^9, 3.6412921394665203`*^9}, 
   3.6413570139913254`*^9, 3.641367128672744*^9, 3.6413673363372073`*^9, 
   3.6413673980900583`*^9, 3.6413675054130774`*^9, 3.6413684062407603`*^9, 
   3.641383309046588*^9, {3.641625606806199*^9, 3.6416256345846767`*^9}, 
   3.6416346406601768`*^9, 3.6416358507500486`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{"24", "-", 
     RowBox[{"2", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.6412921298837175`*^9, 3.6412921394665203`*^9}, 
   3.6413570139913254`*^9, 3.641367128672744*^9, 3.6413673363372073`*^9, 
   3.6413673980900583`*^9, 3.6413675054130774`*^9, 3.6413684062407603`*^9, 
   3.641383309046588*^9, {3.641625606806199*^9, 3.6416256345846767`*^9}, 
   3.6416346406601768`*^9, 3.6416358508750563`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "180", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "13"}],
  SequenceForm[180, " ", 19, " ", 6, " ", 13],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412921298837175`*^9, 3.6412921394665203`*^9}, 
   3.6413570139913254`*^9, 3.641367128672744*^9, 3.6413673363372073`*^9, 
   3.6413673980900583`*^9, 3.6413675054130774`*^9, 3.6413684062407603`*^9, 
   3.641383309046588*^9, {3.641625606806199*^9, 3.6416256345846767`*^9}, 
   3.6416346406601768`*^9, 3.64163585096881*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{1.2, 2.4, 1.2}, {1.3333333333333333`, 
    1.3333333333333333`, 2.6666666666666665`}, {1.5333333333333334`, 
    1.2666666666666666`, 1.4}, {1.7333333333333334`, 1.2, 
    1.7333333333333334`}, {1.8666666666666667`, 2.2666666666666666`, 
    2.2666666666666666`}, {2.6666666666666665`, 1.3333333333333333`, 
    1.3333333333333333`}, {2.6666666666666665`, 2.2666666666666666`, 
    2.2666666666666666`}, {2.6666666666666665`, 2.2666666666666666`, 
    2.933333333333333}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.08833889000496575, 0.24070494495484507`, 0.9705285633429501], Opacity[
     0.5]}], Polygon3DBox[{{8, 5, 2}, {7, 8, 6}, {4, 3, 6}, {5, 8, 1}, {8, 7, 
      1}, {5, 1, 2}, {1, 3, 2}, {3, 1, 6}, {1, 7, 6}, {3, 4, 2}, {4, 6, 2}, {
      6, 8, 2}}]}], 
   GraphicsComplex3DBox[{{2.4, 4.8, 2.4}, {2.6666666666666665`, 
    2.6666666666666665`, 5.333333333333333}, {3.066666666666667, 
    2.533333333333333, 2.8}, {3.466666666666667, 2.4, 3.466666666666667}, {
    3.7333333333333334`, 4.533333333333333, 4.533333333333333}, {
    5.333333333333333, 2.6666666666666665`, 2.6666666666666665`}, {
    5.333333333333333, 4.533333333333333, 4.533333333333333}, {
    5.333333333333333, 4.533333333333333, 5.866666666666666}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.648288703191475, 0.1804315445859659, 0.10037043707034687`], Opacity[
     0.5]}], Polygon3DBox[{{8, 5, 2}, {7, 8, 6}, {4, 3, 6}, {5, 8, 1}, {8, 7, 
      1}, {5, 1, 2}, {1, 3, 2}, {3, 1, 6}, {1, 7, 6}, {3, 4, 2}, {4, 6, 2}, {
      6, 8, 2}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[
     NCache[{{Rational[8, 3], Rational[4, 3], Rational[4, 3]}, {
       Rational[6, 5], Rational[12, 5], Rational[6, 5]}, {
       Rational[4, 3], Rational[4, 3], Rational[8, 3]}}, {{
      2.6666666666666665`, 1.3333333333333333`, 1.3333333333333333`}, {1.2, 
      2.4, 1.2}, {1.3333333333333333`, 1.3333333333333333`, 
      2.6666666666666665`}}]]}, 
   {RGBColor[1, 0, 0], Line3DBox[{{0, 0, 0}, {8, 4, 4}}], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[18, 5], Rational[36, 5], Rational[18, 5]}}, {{0, 0, 0}, {3.6, 
       7.2, 3.6}}]], Line3DBox[{{0, 0, 0}, {4, 4, 8}}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{537.2163801359704, 678.},
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All,
  ViewPoint->{1.994826240432767, -0.2603756526178904, 2.720822079814239},
  ViewVertical->{-0.3320139387050716, 0.062146050207952865`, 
   0.9416147927601929}]], "Output",
 CellChangeTimes->{
  3.641214677352731*^9, 3.6412160828671923`*^9, 3.6412164821497335`*^9, 
   3.6412609697496595`*^9, 3.64126104399439*^9, 3.6412610743949685`*^9, 
   3.641261172933942*^9, {3.6412612143743687`*^9, 3.6412612366952324`*^9}, 
   3.641261477838456*^9, 3.6412616331667852`*^9, 3.641261716508937*^9, 
   3.641263376968199*^9, {3.641292121394688*^9, 3.6412921406173472`*^9}, 
   3.6413570154463577`*^9, 3.6413671311915407`*^9, 3.6413673387429247`*^9, 
   3.6413674003806844`*^9, 3.6413675084102063`*^9, 3.6413684085143747`*^9, 
   3.6413833116544523`*^9, {3.6416256078308187`*^9, 3.641625635368039*^9}, 
   3.6416346423364983`*^9, 3.641635851093814*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vv", ",", "6", ",", "True", ",", "False", ",", "True"}], "]"}], 
   "[", 
   RowBox[{"[", "2", "]"}], "]"}], "//", "Length"}]], "Input",
 CellChangeTimes->{{3.6412147215001984`*^9, 3.6412147419157343`*^9}, {
  3.641292154201991*^9, 3.641292161749352*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.6412147300532813`*^9, 3.641214742630243*^9}, 
   3.641216099453004*^9, 3.6412164977778215`*^9, 3.6412921640219593`*^9, 
   3.6413570174157577`*^9, 3.6413671374389687`*^9, 3.6413673395324755`*^9, 
   3.6413674005518055`*^9, 3.641367511250215*^9, 3.6413684089166512`*^9, 
   3.6413833130484295`*^9, 3.641634645987096*^9, 3.641635854461035*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["23", "15"], ",", 
     FractionBox["19", "15"], ",", 
     FractionBox["7", "5"], ",", 
     FractionBox["28", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["44", "15"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[8, 3], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[6, 5], 
    Rational[12, 5], 
    Rational[6, 5], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[8, 3], 
    Rational[26, 15], 
    Rational[6, 5], 
    Rational[26, 15], 
    Rational[23, 15], 
    Rational[19, 15], 
    Rational[7, 5], 
    Rational[28, 15], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[44, 15]}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412147300532813`*^9, 3.641214742630243*^9}, 
   3.641216099453004*^9, 3.6412164977778215`*^9, 3.6412921640219593`*^9, 
   3.6413570174157577`*^9, 3.6413671374389687`*^9, 3.6413673395324755`*^9, 
   3.6413674005518055`*^9, 3.641367511250215*^9, 3.6413684089166512`*^9, 
   3.6413833130484295`*^9, 3.641634645987096*^9, 3.6416358544766607`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"40", ",", "20", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "36", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "18", ",", "26"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", "19", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "44"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{40, 20, 20}, {18, 36, 18}, {20, 20, 40}, {26, 18, 26}, {23, 19, 
   21}, {28, 34, 34}, {40, 34, 34}, {40, 34, 44}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412147300532813`*^9, 3.641214742630243*^9}, 
   3.641216099453004*^9, 3.6412164977778215`*^9, 3.6412921640219593`*^9, 
   3.6413570174157577`*^9, 3.6413671374389687`*^9, 3.6413673395324755`*^9, 
   3.6413674005518055`*^9, 3.641367511250215*^9, 3.6413684089166512`*^9, 
   3.6413833130484295`*^9, 3.641634645987096*^9, 3.6416358544766607`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412147300532813`*^9, 3.641214742630243*^9}, 
   3.641216099453004*^9, 3.6412164977778215`*^9, 3.6412921640219593`*^9, 
   3.6413570174157577`*^9, 3.6413671374389687`*^9, 3.6413673395324755`*^9, 
   3.6413674005518055`*^9, 3.641367511250215*^9, 3.6413684089166512`*^9, 
   3.6413833130484295`*^9, 3.641634645987096*^9, 3.6416358544766607`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.6412147300532813`*^9, 3.641214742630243*^9}, 
   3.641216099453004*^9, 3.6412164977778215`*^9, 3.6412921640219593`*^9, 
   3.6413570174157577`*^9, 3.6413671374389687`*^9, 3.6413673395324755`*^9, 
   3.6413674005518055`*^9, 3.641367511250215*^9, 3.6413684089166512`*^9, 
   3.6413833130484295`*^9, 3.641634645987096*^9, 3.641635854523537*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["4", "3"], ",", 
        FractionBox["4", "3"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["6", "5"], ",", 
        FractionBox["12", "5"], ",", 
        FractionBox["6", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["4", "3"], ",", 
        FractionBox["4", "3"], ",", 
        FractionBox["8", "3"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[8, 3], 
      Rational[4, 3], 
      Rational[4, 3]}}, {{
      Rational[6, 5], 
      Rational[12, 5], 
      Rational[6, 5]}}, {{
      Rational[4, 3], 
      Rational[4, 3], 
      Rational[8, 3]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412147300532813`*^9, 3.641214742630243*^9}, 
   3.641216099453004*^9, 3.6412164977778215`*^9, 3.6412921640219593`*^9, 
   3.6413570174157577`*^9, 3.6413671374389687`*^9, 3.6413673395324755`*^9, 
   3.6413674005518055`*^9, 3.641367511250215*^9, 3.6413684089166512`*^9, 
   3.6413833130484295`*^9, 3.641634645987096*^9, 3.641635854648543*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["6", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["6", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["8", "3"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{
     Rational[8, 3], 
     Rational[4, 3], 
     Rational[4, 3]}, {
     Rational[6, 5], 
     Rational[12, 5], 
     Rational[6, 5]}, {
     Rational[4, 3], 
     Rational[4, 3], 
     Rational[8, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412147300532813`*^9, 3.641214742630243*^9}, 
   3.641216099453004*^9, 3.6412164977778215`*^9, 3.6412921640219593`*^9, 
   3.6413570174157577`*^9, 3.6413671374389687`*^9, 3.6413673395324755`*^9, 
   3.6413674005518055`*^9, 3.641367511250215*^9, 3.6413684089166512`*^9, 
   3.6413833130484295`*^9, 3.641634645987096*^9, 3.641635854648543*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"138", "-", 
     RowBox[{"5", " ", "x1"}], "-", 
     RowBox[{"55", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"282", "+", 
     RowBox[{"25", " ", "x1"}], "-", 
     RowBox[{"115", " ", "x2"}], "-", 
     RowBox[{"30", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"8", "-", 
     RowBox[{"3", " ", "x1"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "100"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"66", " ", "x2"}], "+", 
     RowBox[{"15", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"116", "+", 
     RowBox[{"35", " ", "x1"}], "-", 
     RowBox[{"38", " ", "x2"}], "-", 
     RowBox[{"42", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"12", "-", 
     RowBox[{"7", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "16"}], "+", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"9", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "348"}], "+", 
     RowBox[{"163", " ", "x1"}], "+", 
     RowBox[{"52", " ", "x2"}], "+", 
     RowBox[{"23", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"96", "+", 
     RowBox[{"53", " ", "x1"}], "-", 
     RowBox[{"47", " ", "x2"}], "-", 
     RowBox[{"39", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"24", "-", 
     RowBox[{"9", " ", "x1"}], "-", 
     RowBox[{"11", " ", "x2"}], "+", 
     RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "36"}], "+", "x1", "+", 
     RowBox[{"4", " ", "x2"}], "+", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.6412147300532813`*^9, 3.641214742630243*^9}, 
   3.641216099453004*^9, 3.6412164977778215`*^9, 3.6412921640219593`*^9, 
   3.6413570174157577`*^9, 3.6413671374389687`*^9, 3.6413673395324755`*^9, 
   3.6413674005518055`*^9, 3.641367511250215*^9, 3.6413684089166512`*^9, 
   3.6413833130484295`*^9, 3.641634645987096*^9, 3.641635854914178*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{"72", "-", 
     RowBox[{"2", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.6412147300532813`*^9, 3.641214742630243*^9}, 
   3.641216099453004*^9, 3.6412164977778215`*^9, 3.6412921640219593`*^9, 
   3.6413570174157577`*^9, 3.6413671374389687`*^9, 3.6413673395324755`*^9, 
   3.6413674005518055`*^9, 3.641367511250215*^9, 3.6413684089166512`*^9, 
   3.6413833130484295`*^9, 3.641634645987096*^9, 3.6416358550548086`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4590", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "371", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "241", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "130"}],
  SequenceForm[4590, " ", 371, " ", 241, " ", 130],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412147300532813`*^9, 3.641214742630243*^9}, 
   3.641216099453004*^9, 3.6412164977778215`*^9, 3.6412921640219593`*^9, 
   3.6413570174157577`*^9, 3.6413671374389687`*^9, 3.6413673395324755`*^9, 
   3.6413674005518055`*^9, 3.641367511250215*^9, 3.6413684089166512`*^9, 
   3.6413833130484295`*^9, 3.641634645987096*^9, 3.6416358567736263`*^9}]
}, Open  ]],

Cell[BoxData["130"], "Output",
 CellChangeTimes->{{3.641214731065015*^9, 3.641214743754053*^9}, 
   3.6412161001485095`*^9, 3.641216498501335*^9, 3.641292164850546*^9, 
   3.6413570183904486`*^9, 3.6413671391071615`*^9, 3.641367341176653*^9, 
   3.641367402166967*^9, 3.641367512862359*^9, 3.6413684104407344`*^9, 
   3.6413833148296957`*^9, 3.6416346484545693`*^9, 3.641635856836129*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isCohenMacaulay", "[", 
  RowBox[{"vv", ",", "cotaDevv"}], "]"}]], "Input",
 CellChangeTimes->{{3.6405782724147496`*^9, 3.6405782787002*^9}, {
   3.640578438932886*^9, 3.6405784395553274`*^9}, 3.6410493531899853`*^9, {
   3.6410861471070595`*^9, 3.641086154445286*^9}, {3.641120021058277*^9, 
   3.641120022183076*^9}, {3.6413570427317457`*^9, 3.641357049971885*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generators of the rays we use to check the CM condition: \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8", ",", "4", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4", ",", "8"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Generators of the rays we use to check the CM condition: ", {{8, 4, 4}, {6,
    12, 6}, {4, 4, 8}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.641635857166013*^9}],

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.641635857166013*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["23", "15"], ",", 
     FractionBox["19", "15"], ",", 
     FractionBox["7", "5"], ",", 
     FractionBox["28", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["44", "15"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[8, 3], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[6, 5], 
    Rational[12, 5], 
    Rational[6, 5], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[8, 3], 
    Rational[26, 15], 
    Rational[6, 5], 
    Rational[26, 15], 
    Rational[23, 15], 
    Rational[19, 15], 
    Rational[7, 5], 
    Rational[28, 15], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[44, 15]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.6416358571816397`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"40", ",", "20", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "36", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "18", ",", "26"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", "19", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "44"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{40, 20, 20}, {18, 36, 18}, {20, 20, 40}, {26, 18, 26}, {23, 19, 
   21}, {28, 34, 34}, {40, 34, 34}, {40, 34, 44}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.6416358571816397`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.6416358571816397`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.6416358572441416`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["4", "3"], ",", 
        FractionBox["4", "3"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["6", "5"], ",", 
        FractionBox["12", "5"], ",", 
        FractionBox["6", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["4", "3"], ",", 
        FractionBox["4", "3"], ",", 
        FractionBox["8", "3"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[8, 3], 
      Rational[4, 3], 
      Rational[4, 3]}}, {{
      Rational[6, 5], 
      Rational[12, 5], 
      Rational[6, 5]}}, {{
      Rational[4, 3], 
      Rational[4, 3], 
      Rational[8, 3]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.641635857353522*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["6", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["6", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["4", "3"], ",", 
       FractionBox["4", "3"], ",", 
       FractionBox["8", "3"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{
     Rational[8, 3], 
     Rational[4, 3], 
     Rational[4, 3]}, {
     Rational[6, 5], 
     Rational[12, 5], 
     Rational[6, 5]}, {
     Rational[4, 3], 
     Rational[4, 3], 
     Rational[8, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.641635857369147*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"138", "-", 
     RowBox[{"5", " ", "x1"}], "-", 
     RowBox[{"55", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"282", "+", 
     RowBox[{"25", " ", "x1"}], "-", 
     RowBox[{"115", " ", "x2"}], "-", 
     RowBox[{"30", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"8", "-", 
     RowBox[{"3", " ", "x1"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "100"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"66", " ", "x2"}], "+", 
     RowBox[{"15", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"116", "+", 
     RowBox[{"35", " ", "x1"}], "-", 
     RowBox[{"38", " ", "x2"}], "-", 
     RowBox[{"42", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"12", "-", 
     RowBox[{"7", " ", "x1"}], "+", 
     RowBox[{"12", " ", "x2"}], "-", 
     RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "16"}], "+", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"9", " ", "x2"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "348"}], "+", 
     RowBox[{"163", " ", "x1"}], "+", 
     RowBox[{"52", " ", "x2"}], "+", 
     RowBox[{"23", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"96", "+", 
     RowBox[{"53", " ", "x1"}], "-", 
     RowBox[{"47", " ", "x2"}], "-", 
     RowBox[{"39", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"24", "-", 
     RowBox[{"9", " ", "x1"}], "-", 
     RowBox[{"11", " ", "x2"}], "+", 
     RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "36"}], "+", "x1", "+", 
     RowBox[{"4", " ", "x2"}], "+", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.6416358576191564`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{"60", "-", 
     RowBox[{"2", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.641635857744162*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2730", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "220", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "126", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "94"}],
  SequenceForm[2730, " ", 220, " ", 126, " ", 94],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.6416358587711043`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The point \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" does not fulfill the condition\"\>"}],
  SequenceForm["The point ", {4, 5, 4}, " does not fulfill the condition"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.640578280816701*^9, 3.640578369450596*^9, {3.6405784414786916`*^9, 
   3.6405784555826993`*^9}, 3.64057854827547*^9, {3.6405786134096766`*^9, 
   3.640578634362542*^9}, {3.640578679954894*^9, 3.6405787307129135`*^9}, 
   3.6405793316802907`*^9, 3.640579387097611*^9, 3.640580053725584*^9, 
   3.6410493214243517`*^9, 3.6410493546300106`*^9, {3.6410861272428927`*^9, 
   3.641086155197812*^9}, 3.6411037789367886`*^9, 3.6411093780282617`*^9, 
   3.641110750554212*^9, 3.641111128572541*^9, 3.641111236934761*^9, 
   3.641120022971629*^9, 3.6412147574838276`*^9, 3.6412148122888756`*^9, 
   3.6412165036509924`*^9, 3.6412633852010584`*^9, 3.6412922000365324`*^9, {
   3.6413570317549553`*^9, 3.641357050388171*^9}, 3.6413571278621855`*^9, {
   3.6413572246369147`*^9, 3.641357233979554*^9}, 3.6413671430879893`*^9, 
   3.6413673414498425`*^9, 3.641367404277461*^9, 3.64136751378102*^9, 
   3.641368411420439*^9, 3.6413833181040206`*^9, 3.641634649873472*^9, 
   3.64163585914612*^9}]
}, Open  ]],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.6413570512057514`*^9, 3.6413571287117977`*^9, {3.6413572254865246`*^9, 
   3.6413572347921257`*^9}, 3.6413671444609537`*^9, 3.641367342853835*^9, 
   3.641367405686452*^9, 3.641367515122964*^9, 3.6413684127513747`*^9, 
   3.641383319493997*^9, 3.6416346521115494`*^9, 3.6416358591617455`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quit", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.6413677825578794`*^9, 3.64136778646966*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", 
   RowBox[{"\"\<convexHullSemigroups3D`\>\"", ",", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
     "\"\<\\\\convexHullSemigroups3DLibraryV6.wl\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6413672154453716`*^9, 3.6413673099854956`*^9}, 
   3.6416212539228635`*^9}],

Cell[BoxData["\<\"J. I. Garc\[IAcute]a-Garc\[IAcute]a and A. \
Vigneron-Tenorio,\\nDpto. Matem\[AAcute]ticas, \\nUniversidad de \
C\[AAcute]diz\\nignacio.garcia@uca.es, alberto.vigneron@uca.es\\n\\nThis \
package contains the commands: \\n....\\nTry command::usage for more \
help\"\>"], "Print",
 CellChangeTimes->{3.6413677885371304`*^9, 3.6413679225402727`*^9, 
  3.64136795806051*^9, 3.6413681653086643`*^9, 3.6413682419340897`*^9, 
  3.641368351335763*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"configuration", "[", 
   RowBox[{
   "\"\<C:\\\\tmp\\\\lrs\\\\lrs.exe\>\"", ",", "\"\<C:\\\\tmp\\\\\>\"", ",", 
    "\"\<C:\\\\tmp\\\\Normaliz2.12\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"showConfiguration", "[", "]"}]}], "Input",
 CellChangeTimes->{{3.64104912673164*^9, 3.6410491300119753`*^9}, 
   3.641049284252866*^9, {3.6411073213478384`*^9, 3.641107352088739*^9}, {
   3.6411074438150835`*^9, 3.64110744640294*^9}, {3.641291681429268*^9, 
   3.6412916825410633`*^9}, {3.6413682292780914`*^9, 3.641368235275359*^9}, 
   3.641368343206004*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C:\\\\tmp\\\\lrs\\\\lrs.exe\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\Normaliz2.12\"\>"}],
  SequenceForm[
  "C:\\tmp\\lrs\\lrs.exe", "\n", "C:\\tmp\\", "\n", "C:\\tmp\\Normaliz2.12"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641367725215162*^9, 3.641367756389298*^9, 
  3.6413677896098785`*^9, 3.6413679229655848`*^9, 3.64136795848081*^9, 
  3.641368165408738*^9, 3.641368243801412*^9, 3.6413683518411226`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vv", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox["8", "3"], ",", 
      FractionBox["4", "3"], ",", 
      FractionBox["4", "3"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["6", "5"], ",", 
      FractionBox["12", "5"], ",", 
      FractionBox["6", "5"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["4", "3"], ",", 
      FractionBox["4", "3"], ",", 
      FractionBox["8", "3"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["26", "15"], ",", 
      FractionBox["6", "5"], ",", 
      FractionBox["26", "15"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["23", "15"], ",", 
      FractionBox["19", "15"], ",", 
      FractionBox["7", "5"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["28", "15"], ",", 
      FractionBox["34", "15"], ",", 
      FractionBox["34", "15"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["8", "3"], ",", 
      FractionBox["34", "15"], ",", 
      FractionBox["34", "15"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["8", "3"], ",", 
      FractionBox["34", "15"], ",", 
      FractionBox["44", "15"]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.6413677164719515`*^9, 3.6413677170553694`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["26", "15"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["26", "15"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["23", "15"], ",", 
     FractionBox["19", "15"], ",", 
     FractionBox["7", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["28", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["44", "15"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.64136772649406*^9, 3.6413677576742105`*^9, 
  3.641367790862778*^9, 3.641367924274514*^9, 3.6413679589281225`*^9, 
  3.6413681659821424`*^9, 3.641368248938059*^9, 3.6413683524955964`*^9, 
  3.641368420208679*^9, 3.641383327769884*^9, 3.6416346610147734`*^9, 
  3.641635862333256*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"genVV", "=", 
   RowBox[{"generatorsOfConvexHSgr", "[", "vv", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.64110976560241*^9, 3.641109768464452*^9}, {
  3.641110970042599*^9, 3.6411109799936895`*^9}, {3.6412165215677238`*^9, 
  3.6412165225674376`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.64136817946972*^9, 3.6413682523764915`*^9, 
  3.641368353700442*^9, 3.641368421764787*^9, 3.6413833306459165`*^9, 
  3.6416346622179456`*^9, 3.641635863619117*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["23", "15"], ",", 
     FractionBox["19", "15"], ",", 
     FractionBox["7", "5"], ",", 
     FractionBox["28", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["44", "15"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[8, 3], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[6, 5], 
    Rational[12, 5], 
    Rational[6, 5], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[8, 3], 
    Rational[26, 15], 
    Rational[6, 5], 
    Rational[26, 15], 
    Rational[23, 15], 
    Rational[19, 15], 
    Rational[7, 5], 
    Rational[28, 15], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[44, 15]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64136817946972*^9, 3.6413682523764915`*^9, 
  3.641368353700442*^9, 3.641368421764787*^9, 3.6413833306459165`*^9, 
  3.6416346622179456`*^9, 3.641635863619117*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"40", ",", "20", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "36", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "18", ",", "26"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", "19", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "44"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{40, 20, 20}, {18, 36, 18}, {20, 20, 40}, {26, 18, 26}, {23, 19, 
   21}, {28, 34, 34}, {40, 34, 34}, {40, 34, 44}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.64136817946972*^9, 3.6413682523764915`*^9, 
  3.641368353700442*^9, 3.641368421764787*^9, 3.6413833306459165`*^9, 
  3.6416346622179456`*^9, 3.641635863634742*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.64136817946972*^9, 3.6413682523764915`*^9, 
  3.641368353700442*^9, 3.641368421764787*^9, 3.6413833306459165`*^9, 
  3.6416346622179456`*^9, 3.6416358636503677`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\tmp\\\
\\aux1\"\>"], "Print",
 CellChangeTimes->{3.64136817946972*^9, 3.6413682523764915`*^9, 
  3.641368353700442*^9, 3.641368421764787*^9, 3.6413833306459165`*^9, 
  3.6416346622179456`*^9, 3.6416358636503677`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["vv"], "Input",
 CellChangeTimes->{{3.6413682750035686`*^9, 3.6413682751266584`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["26", "15"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["26", "15"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["23", "15"], ",", 
     FractionBox["19", "15"], ",", 
     FractionBox["7", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["28", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["44", "15"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6413682754348755`*^9, 3.6413683590982866`*^9, {3.6413684291510344`*^9, 
   3.6413684412736387`*^9}, 3.6413833372286005`*^9, 3.6416346703872604`*^9, 
   3.6416358692603035`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"raysOfConeOfCHSgr", "[", "vv", "]"}]], "Input",
 CellChangeTimes->{{3.641110948111974*^9, 3.6411109489685836`*^9}, {
  3.641214839910571*^9, 3.641214840170755*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.641292215152276*^9, 3.64135727529989*^9, 
  3.641368442588563*^9, 3.641383339418146*^9, 3.641634672779409*^9, 
  3.641635871479142*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["4", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["26", "15"], ",", 
     FractionBox["23", "15"], ",", 
     FractionBox["19", "15"], ",", 
     FractionBox["7", "5"], ",", 
     FractionBox["28", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["34", "15"], ",", 
     FractionBox["44", "15"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[8, 3], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[6, 5], 
    Rational[12, 5], 
    Rational[6, 5], 
    Rational[4, 3], 
    Rational[4, 3], 
    Rational[8, 3], 
    Rational[26, 15], 
    Rational[6, 5], 
    Rational[26, 15], 
    Rational[23, 15], 
    Rational[19, 15], 
    Rational[7, 5], 
    Rational[28, 15], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[34, 15], 
    Rational[8, 3], 
    Rational[34, 15], 
    Rational[44, 15]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641292215152276*^9, 3.64135727529989*^9, 
  3.641368442588563*^9, 3.641383339418146*^9, 3.641634672779409*^9, 
  3.641635871479142*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"40", ",", "20", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "36", ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20", ",", "40"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "18", ",", "26"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", "19", ",", "21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "34", ",", "44"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{40, 20, 20}, {18, 36, 18}, {20, 20, 40}, {26, 18, 26}, {23, 19, 
   21}, {28, 34, 34}, {40, 34, 34}, {40, 34, 44}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641292215152276*^9, 3.64135727529989*^9, 
  3.641368442588563*^9, 3.641383339418146*^9, 3.641634672779409*^9, 
  3.641635871494768*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641292215152276*^9, 3.64135727529989*^9, 
  3.641368442588563*^9, 3.641383339418146*^9, 3.641634672779409*^9, 
  3.641635871494768*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.641292215152276*^9, 3.64135727529989*^9, 
  3.641368442588563*^9, 3.641383339418146*^9, 3.641634672779409*^9, 
  3.641635871588522*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6411109494589195`*^9, 3.6411109858258495`*^9, {3.6411110252859516`*^9, 
   3.6411110499435267`*^9}, 3.641111088786203*^9, 3.6411112618455105`*^9, 
   3.641120080487712*^9, {3.641214835113149*^9, 3.641214840607053*^9}, 
   3.6412165286167293`*^9, 3.641292215323388*^9, 3.6413572754740133`*^9, 
   3.641368442768699*^9, 3.6413833396082907`*^9, 3.641634672982542*^9, 
   3.64163587166665*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msgCHSgr", "[", 
  RowBox[{"vv", ",", "genVV"}], "]"}]], "Input",
 CellChangeTimes->{{3.6411109660357447`*^9, 3.6411109915869417`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "7", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "8", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "9", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "9", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "9", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "6", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "14", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.641110993760495*^9, 3.6411112689926014`*^9, 
  3.641120088062022*^9, 3.6411204827242465`*^9, 3.641214845015194*^9, 
  3.641216530963403*^9, 3.641292217974271*^9, 3.641357277475441*^9, 
  3.641368448992109*^9, 3.641383346207982*^9, 3.641634680853286*^9, 
  3.641635880240548*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["genVV"], "Input",
 CellChangeTimes->{{3.641111303814414*^9, 3.6411113046630225`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "7", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "9", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "8", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "9", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "9", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "9", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "14", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "11", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "14", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "9", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "9", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "9", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "15", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "10", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "9", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "9", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "14", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "14", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "7", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "11", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "9", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "6", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "16", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "10", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "16", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "9", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "20", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "7", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "18", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "13", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "17", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "16", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "11", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "16", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "11", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "18", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "7", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "11", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "9", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "11", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "9", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "17", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "11", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "9", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "21", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "11", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "16", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "9", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "25", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "19", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "9", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "23", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "18", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "14", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "17", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "13", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "12", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "16", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "15", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "11", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "21", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "9", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "16", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "15", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "21", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "16", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "9", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "14", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "9", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "21", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "16", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "10", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "16", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "10", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "16", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "13", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "10", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "18", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "16", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "13", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "11", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "11", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "10", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "16", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "25", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "9", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "16", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "13", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "14", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "24", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "10", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "25", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "11", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "10", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "9", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "11", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "24", ",", "26"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "13", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "9", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "14", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "11", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "13", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "23", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "16", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "14", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "17", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "23", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "11", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "20", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "10", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "11", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "11", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "24", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "10", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "14", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "19", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "23", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "18", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "18", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "18", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "11", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "16", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "20", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "18", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "11", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "16", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "10", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "18", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "19", ",", "26"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "14", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "31", ",", "31"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "23", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "18", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "14", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "23", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "18", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "14", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "30", ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "23", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "14", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "23", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "11", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "16", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "31", ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "23", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "23", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "19", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "25", ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "14", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "15", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "31", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "20", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "34", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "15", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "20", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "15", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "25", ",", "29"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "20", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "15", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "20", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "21", ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "19", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "15", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "27", ",", "31"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "20", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "14", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "20", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "18", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "29", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "25", ",", "30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "21", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "24", ",", "31"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "32", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "18", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "27", ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "15", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "18", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "21", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "14", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "25", ",", "30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "24", ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "25", ",", "29"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "15", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "25", ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "25", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "25", ",", "26"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "25", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "16", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "25", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "24", ",", "31"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "38", ",", "40"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "34", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "15", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "17", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "19", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "19", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "36", ",", "39"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "20", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "19", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "23", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "19", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "26", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "34", ",", "38"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "16", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "19", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "17", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "26", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "17", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "17", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "34", ",", "39"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "27", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "29", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "27", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "41", ",", "42"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "27", ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "32", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "27", ",", "31"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "26", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "27", ",", "30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "17", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "29", ",", "38"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "27", ",", "29"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "27", ",", "28"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "27", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "18", ",", "26"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "43", ",", "46"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "34", ",", "42"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "31", ",", "40"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "36", ",", "44"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "34", ",", "43"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "34", ",", "42"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "34", ",", "41"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "34", ",", "40"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "34", ",", "44"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "34", ",", "39"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "34", ",", "43"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "34", ",", "38"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "41", ",", "47"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "34", ",", "42"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "34", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "34", ",", "41"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "34", ",", "36"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "34", ",", "40"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "34", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "33", ",", "42"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "34", ",", "39"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "34", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "34", ",", "38"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "34", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "34", ",", "36"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "34", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "34", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "43", ",", "51"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6411119244486275`*^9, 3.641120089936352*^9, 
  3.6411204840241365`*^9, 3.6412148481974707`*^9, 3.641216531061472*^9, 
  3.6412922205100718`*^9, 3.641357278054838*^9, 3.641368453105039*^9, 
  3.641383348826828*^9, 3.641634681010929*^9, 3.6416358803494387`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"boundCohenMacaulay", "::", "usage"}]], "Input",
 CellChangeTimes->{{3.6411197006810017`*^9, 3.641119702842544*^9}, {
  3.6411200929485025`*^9, 3.641120095103033*^9}}],

Cell[BoxData["\<\"Returns some datas that are needed by the function \
isCohenMacaulay to check if the convex hull semigroups defined by \\nthe \
polyhedron with vertices verticesOf Polyhedron is \
Conhen-Macaulay\\n\\nExample:\\nCota[verticesOfPolyhedron]\\n\"\>"], "Output",
 CellChangeTimes->{3.6411197032848554`*^9, 3.641120095529338*^9, 
  3.641120488415276*^9, 3.6412148520942383`*^9, 3.64121653272865*^9, 
  3.6412922231179237`*^9, 3.6413572800872903`*^9, 3.6413684553586397`*^9, 
  3.641383350855276*^9, 3.641634685920485*^9, 3.6416358834939146`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msgSgr", "[", "genVV", "]"}]], "Input",
 CellChangeTimes->{{3.6411110083258634`*^9, 3.6411110204295006`*^9}, {
  3.6411118534290285`*^9, 3.641111854910084*^9}, {3.6411119292940845`*^9, 
  3.641111931528676*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {2, 2, 2}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572841661863`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {3, 3, 3}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284243245*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {3, 3, 4}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284254241*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {3, 3, 5}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284262246*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {3, 4, 3}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572842712564`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {3, 4, 4}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284301284*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {4, 3, 3}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572843042746`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {4, 3, 4}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572843252907`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {4, 4, 3}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572843293467`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {4, 4, 5}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284337308*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "8"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {4, 4, 8}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572843413095`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {4, 5, 6}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284344304*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {4, 6, 4}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572843473053`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {4, 6, 5}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572843653207`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4", ",", "7", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {4, 7, 4}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572843673363`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "3"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {5, 3, 3}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572843703384`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {5, 4, 4}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572843873434`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {5, 4, 5}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284404355*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "6"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {5, 4, 6}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572844513807`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "7"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {5, 4, 7}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572844723945`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {5, 5, 4}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284498414*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {5, 6, 4}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572845214386`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {5, 7, 5}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572845484495`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "8", ",", "7"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {5, 8, 7}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284573476*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "9", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {5, 9, 5}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572845834837`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {6, 4, 5}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572846194997`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "6"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {6, 4, 6}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572846535234`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "4"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {6, 5, 4}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284689549*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "7"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {6, 5, 7}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284770607*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"6", ",", "9", ",", "7"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {6, 9, 7}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572848666754`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"6", ",", "12", ",", "6"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {6, 12, 6}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357284883687*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"7", ",", "4", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {7, 4, 5}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572848877044`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5", ",", "6"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {7, 5, 6}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572850558095`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5", ",", "7"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {7, 5, 7}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.6413572853049855`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6", ",", "10"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {7, 6, 10}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357286034505*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {7, 8, 5}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641111978716285*^9, 3.6411120425627894`*^9, 
  3.641357286119598*^9}]
}, Open  ]],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.6411112987448015`*^9, 3.6411118611635356`*^9, 
  3.641111971838394*^9, 3.6411120039062433`*^9, 3.6411187684057417`*^9, 
  3.6413572879098444`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msgSgr", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"17", ",", "5", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10", ",", "10"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.641111862298345*^9, 3.641111912410054*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {1, 0, 0}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6412165378883142`*^9, 3.6412922274970403`*^9, 
  3.6413684620764008`*^9, 3.6413833549982195`*^9, 3.641634688623718*^9, 
  3.641635885583282*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"New element \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" added\"\>"}],
  SequenceForm["New element ", {1, 1, 1}, " added"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6412165378883142`*^9, 3.6412922274970403`*^9, 
  3.6413684620764008`*^9, 3.6413833549982195`*^9, 3.641634688623718*^9, 
  3.641635885583282*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.641111888124747*^9, 3.64111191315257*^9}, 
   3.6412165380574355`*^9, 3.641292227505039*^9, 3.6413684620814037`*^9, 
   3.6413833550182247`*^9, 3.6416346887799745`*^9, 3.641635885583282*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "Section",
 CellChangeTimes->{{3.640578766388216*^9, 3.6405787673809233`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vv2", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"12", ",", "6", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "6", ",", "12"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.640578768838954*^9, 3.6405788564221087`*^9}, {
  3.640579101926281*^9, 3.6405791026487927`*^9}, {3.6405800653888702`*^9, 
  3.6405800655549808`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "6", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6", ",", "12"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.640580248424733*^9, 3.6405803177819433`*^9, 3.6410493709376307`*^9, 
   3.641086165882452*^9, 3.6411037857266254`*^9, 3.641214861148699*^9, 
   3.641216540416108*^9, 3.6412615003834743`*^9, {3.641292283588873*^9, 
   3.6412923099786124`*^9}, 3.641357297056343*^9, 3.6413684653537283`*^9, 
   3.64138335701265*^9, 3.6416346904469905`*^9, 3.641635890005352*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConvexHullMesh", "[", "vv2", "]"}], "//", 
  "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.640578861357607*^9, 3.6405788730298786`*^9}, {
  3.640581132603052*^9, 3.6405811408799376`*^9}, {3.6412148732503242`*^9, 
  3.641214873330371*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[{{5., 5., 5.}, {6., 6., 12.}, {6., 12., 6.}, {12., 6., 
   6.}}, 
   {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], 
    Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}],
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All]], "Output",
 CellChangeTimes->{{3.640578864892115*^9, 3.640578873451187*^9}, 
   3.6405791059681587`*^9, 3.6405800684190187`*^9, 3.6405802497896924`*^9, 
   3.6405803186675615`*^9, 3.6410493720804453`*^9, 3.641086167010239*^9, 
   3.641103787227705*^9, {3.641214862923962*^9, 3.641214873748677*^9}, 
   3.641216541522895*^9, {3.641292284860776*^9, 3.6412923109603014`*^9}, 
   3.6413572983642597`*^9, 3.6413684671129875`*^9, 3.641383358968029*^9, 
   3.6416346920501614`*^9, 3.6416358935224524`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vv2", ",", "3", ",", "False", ",", "False", ",", "True"}], "]"}],
    "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.641215036514643*^9, 3.64121505792791*^9}, {
  3.6412922892859163`*^9, 3.641292292404136*^9}, {3.641292335733904*^9, 
  3.641292371747471*^9}, {3.641292436213251*^9, 3.6412924397357616`*^9}, {
  3.6413685093469825`*^9, 3.641368513853176*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.641215047838709*^9, 3.641215058609385*^9}, 
   3.6412165435683374`*^9, 3.641261505016756*^9, {3.641292292948512*^9, 
   3.6412923723338823`*^9}, {3.641292422219344*^9, 3.6412924459021254`*^9}, 
   3.6413572999663963`*^9, 3.641368468443931*^9, 3.641368515299195*^9, 
   3.6413833628948183`*^9, 3.6416346959280396`*^9, 3.641635895866295*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "5", ",", "5", ",", "12", ",", "6", ",", "6", ",", "6", ",", 
     "12", ",", "6", ",", "6", ",", "6", ",", "12"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {5, 5, 5, 12, 6, 6, 6, 12, 6, 6, 6, 12}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641215047838709*^9, 3.641215058609385*^9}, 
   3.6412165435683374`*^9, 3.641261505016756*^9, {3.641292292948512*^9, 
   3.6412923723338823`*^9}, {3.641292422219344*^9, 3.6412924459021254`*^9}, 
   3.6413572999663963`*^9, 3.641368468443931*^9, 3.641368515299195*^9, 
   3.6413833628948183`*^9, 3.6416346959280396`*^9, 3.641635895866295*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "6", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6", ",", "12"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{5, 5, 5}, {12, 6, 6}, {6, 12, 6}, {6, 6, 12}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641215047838709*^9, 3.641215058609385*^9}, 
   3.6412165435683374`*^9, 3.641261505016756*^9, {3.641292292948512*^9, 
   3.6412923723338823`*^9}, {3.641292422219344*^9, 3.6412924459021254`*^9}, 
   3.6413572999663963`*^9, 3.641368468443931*^9, 3.641368515299195*^9, 
   3.6413833628948183`*^9, 3.6416346959280396`*^9, 3.641635895866295*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641215047838709*^9, 3.641215058609385*^9}, 
   3.6412165435683374`*^9, 3.641261505016756*^9, {3.641292292948512*^9, 
   3.6412923723338823`*^9}, {3.641292422219344*^9, 3.6412924459021254`*^9}, 
   3.6413572999663963`*^9, 3.641368468443931*^9, 3.641368515299195*^9, 
   3.6413833628948183`*^9, 3.6416346959280396`*^9, 3.6416358958819213`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.641215047838709*^9, 3.641215058609385*^9}, 
   3.6412165435683374`*^9, 3.641261505016756*^9, {3.641292292948512*^9, 
   3.6412923723338823`*^9}, {3.641292422219344*^9, 3.6412924459021254`*^9}, 
   3.6413572999663963`*^9, 3.641368468443931*^9, 3.641368515299195*^9, 
   3.6413833628948183`*^9, 3.6416346959280396`*^9, 3.6416358958975472`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"12", ",", "6", ",", "6"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "12", ",", "6"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "6", ",", "12"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{12, 6, 6}}, {{6, 12, 6}}, {{6, 6, 12}}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641215047838709*^9, 3.641215058609385*^9}, 
   3.6412165435683374`*^9, 3.641261505016756*^9, {3.641292292948512*^9, 
   3.6412923723338823`*^9}, {3.641292422219344*^9, 3.6412924459021254`*^9}, 
   3.6413572999663963`*^9, 3.641368468443931*^9, 3.641368515299195*^9, 
   3.6413833628948183`*^9, 3.6416346959280396`*^9, 3.6416358960405507`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "6", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6", ",", "12"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{12, 6, 6}, {6, 12, 6}, {6, 6, 12}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641215047838709*^9, 3.641215058609385*^9}, 
   3.6412165435683374`*^9, 3.641261505016756*^9, {3.641292292948512*^9, 
   3.6412923723338823`*^9}, {3.641292422219344*^9, 3.6412924459021254`*^9}, 
   3.6413572999663963`*^9, 3.641368468443931*^9, 3.641368515299195*^9, 
   3.6413833628948183`*^9, 3.6416346959280396`*^9, 3.6416358960405507`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "30"}], "-", "x1", "-", "x2", "+", 
     RowBox[{"8", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "30"}], "+", 
     RowBox[{"8", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "30"}], "-", "x1", "+", 
     RowBox[{"8", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"24", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.641215047838709*^9, 3.641215058609385*^9}, 
   3.6412165435683374`*^9, 3.641261505016756*^9, {3.641292292948512*^9, 
   3.6412923723338823`*^9}, {3.641292422219344*^9, 3.6412924459021254`*^9}, 
   3.6413572999663963`*^9, 3.641368468443931*^9, 3.641368515299195*^9, 
   3.6413833628948183`*^9, 3.6416346959280396`*^9, 3.6416358962124314`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"72", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.641215047838709*^9, 3.641215058609385*^9}, 
   3.6412165435683374`*^9, 3.641261505016756*^9, {3.641292292948512*^9, 
   3.6412923723338823`*^9}, {3.641292422219344*^9, 3.6412924459021254`*^9}, 
   3.6413572999663963`*^9, 3.641368468443931*^9, 3.641368515299195*^9, 
   3.6413833628948183`*^9, 3.6416346959280396`*^9, 3.6416358963374357`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "50653", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "4255", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "2234", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "2021"}],
  SequenceForm[50653, " ", 4255, " ", 2234, " ", 2021],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641215047838709*^9, 3.641215058609385*^9}, 
   3.6412165435683374`*^9, 3.641261505016756*^9, {3.641292292948512*^9, 
   3.6412923723338823`*^9}, {3.641292422219344*^9, 3.6412924459021254`*^9}, 
   3.6413572999663963`*^9, 3.641368468443931*^9, 3.641368515299195*^9, 
   3.6413833628948183`*^9, 3.6416346959280396`*^9, 3.641635904807229*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{5., 5., 5.}, {6., 6., 12.}, {6., 12., 6.}, {12., 6.,
     6.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.8432573550090465, 0.5514125654949114, 0.856941867006177], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   GraphicsComplex3DBox[{{10., 10., 10.}, {12., 12., 24.}, {12., 24., 12.}, {
    24., 12., 12.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.017080633961086944`, 0.8168122360823928, 0.12013140195832972`], 
     Opacity[0.5]}], 
     Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   GraphicsComplex3DBox[{{15., 15., 15.}, {18., 18., 36.}, {18., 36., 18.}, {
    36., 18., 18.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.3536750962224775, 0.513285402822421, 0.48819365709110607`], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[{{12, 6, 6}, {6, 12, 6}, {6, 6, 12}}]}, 
   {RGBColor[1, 0, 0], Line3DBox[{{0, 0, 0}, {48, 24, 24}}], 
    Line3DBox[{{0, 0, 0}, {24, 48, 24}}], 
    Line3DBox[{{0, 0, 0}, {24, 24, 48}}]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{430.87829360871046`, 412.8446750587326},
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All,
  ViewPoint->{1.8416802376347554`, 0.08918821365159157, 2.8372978985032975`},
  ViewVertical->{-0.10798499240544632`, 0.6471864476390856, 
   0.7546449121325185}]], "Output",
 CellChangeTimes->{{3.6412150522468596`*^9, 3.6412150627043176`*^9}, 
   3.6412165461331673`*^9, 3.641261508044915*^9, {3.641292298250275*^9, 
   3.6412923751288757`*^9}, {3.6412924249122295`*^9, 3.641292448575021*^9}, 
   3.641357302754376*^9, 3.6413684743010902`*^9, 3.6413685211413546`*^9, 
   3.641383368793005*^9, 3.6416347048665895`*^9, 3.641635904885357*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vv2", ",", "3", ",", "False", ",", "True", ",", "True"}], "]"}], 
   "[", 
   RowBox[{"[", "2", "]"}], "]"}], "//", "Length"}]], "Input",
 CellChangeTimes->{{3.64058013234137*^9, 3.6405801547572765`*^9}, {
  3.641215016004037*^9, 3.64121503528677*^9}, {3.6412923212526164`*^9, 
  3.641292326783543*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{
  3.6412150219812856`*^9, 3.6412165584599133`*^9, 3.6412923273679523`*^9, {
   3.641292428923066*^9, 3.6412924554529057`*^9}, 3.641357302840438*^9, 
   3.6413684823507986`*^9, 3.641383372433591*^9, 3.64163470618711*^9, 
   3.6416359061161757`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "5", ",", "5", ",", "12", ",", "6", ",", "6", ",", "6", ",", 
     "12", ",", "6", ",", "6", ",", "6", ",", "12"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {5, 5, 5, 12, 6, 6, 6, 12, 6, 6, 6, 12}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412150219812856`*^9, 3.6412165584599133`*^9, 3.6412923273679523`*^9, {
   3.641292428923066*^9, 3.6412924554529057`*^9}, 3.641357302840438*^9, 
   3.6413684823507986`*^9, 3.641383372433591*^9, 3.64163470618711*^9, 
   3.6416359061161757`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "6", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6", ",", "12"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{5, 5, 5}, {12, 6, 6}, {6, 12, 6}, {6, 6, 12}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412150219812856`*^9, 3.6412165584599133`*^9, 3.6412923273679523`*^9, {
   3.641292428923066*^9, 3.6412924554529057`*^9}, 3.641357302840438*^9, 
   3.6413684823507986`*^9, 3.641383372433591*^9, 3.64163470618711*^9, 
   3.6416359061161757`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412150219812856`*^9, 3.6412165584599133`*^9, 3.6412923273679523`*^9, {
   3.641292428923066*^9, 3.6412924554529057`*^9}, 3.641357302840438*^9, 
   3.6413684823507986`*^9, 3.641383372433591*^9, 3.64163470618711*^9, 
   3.6416359061161757`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{
  3.6412150219812856`*^9, 3.6412165584599133`*^9, 3.6412923273679523`*^9, {
   3.641292428923066*^9, 3.6412924554529057`*^9}, 3.641357302840438*^9, 
   3.6413684823507986`*^9, 3.641383372433591*^9, 3.64163470618711*^9, 
   3.6416359061474266`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"12", ",", "6", ",", "6"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "12", ",", "6"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "6", ",", "12"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{12, 6, 6}}, {{6, 12, 6}}, {{6, 6, 12}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412150219812856`*^9, 3.6412165584599133`*^9, 3.6412923273679523`*^9, {
   3.641292428923066*^9, 3.6412924554529057`*^9}, 3.641357302840438*^9, 
   3.6413684823507986`*^9, 3.641383372433591*^9, 3.64163470618711*^9, 
   3.641635906288057*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "6", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6", ",", "12"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{12, 6, 6}, {6, 12, 6}, {6, 6, 12}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412150219812856`*^9, 3.6412165584599133`*^9, 3.6412923273679523`*^9, {
   3.641292428923066*^9, 3.6412924554529057`*^9}, 3.641357302840438*^9, 
   3.6413684823507986`*^9, 3.641383372433591*^9, 3.64163470618711*^9, 
   3.641635906288057*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "30"}], "-", "x1", "-", "x2", "+", 
     RowBox[{"8", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "30"}], "+", 
     RowBox[{"8", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "30"}], "-", "x1", "+", 
     RowBox[{"8", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"24", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412150219812856`*^9, 3.6412165584599133`*^9, 3.6412923273679523`*^9, {
   3.641292428923066*^9, 3.6412924554529057`*^9}, 3.641357302840438*^9, 
   3.6413684823507986`*^9, 3.641383372433591*^9, 3.64163470618711*^9, 
   3.641635906397436*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"72", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412150219812856`*^9, 3.6412165584599133`*^9, 3.6412923273679523`*^9, {
   3.641292428923066*^9, 3.6412924554529057`*^9}, 3.641357302840438*^9, 
   3.6413684823507986`*^9, 3.641383372433591*^9, 3.64163470618711*^9, 
   3.6416359065380664`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "50653", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "4255", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "2234", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "2021"}],
  SequenceForm[50653, " ", 4255, " ", 2234, " ", 2021],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412150219812856`*^9, 3.6412165584599133`*^9, 3.6412923273679523`*^9, {
   3.641292428923066*^9, 3.6412924554529057`*^9}, 3.641357302840438*^9, 
   3.6413684823507986`*^9, 3.641383372433591*^9, 3.64163470618711*^9, 
   3.641635915086149*^9}]
}, Open  ]],

Cell[BoxData["2021"], "Output",
 CellChangeTimes->{{3.6405801332289915`*^9, 3.6405801552806373`*^9}, 
   3.6405802572950225`*^9, 3.6405803214775543`*^9, 3.6405814173021135`*^9, 
   3.641049383308454*^9, 3.6410861718806987`*^9, 3.6411037918139725`*^9, 
   3.6412150261762857`*^9, 3.6412165608686323`*^9, 3.6412923300918946`*^9, {
   3.6412924318581495`*^9, 3.6412924580807705`*^9}, 3.641357305498326*^9, 
   3.641368488337058*^9, 3.6413833788631654`*^9, 3.641634715341176*^9, 
   3.641635915179904*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cotaDevv2", "=", 
   RowBox[{"boundCohenMacaulay", "[", "vv2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.640578955254216*^9, 3.6405789797856226`*^9}, {
  3.640580078080864*^9, 3.6405800816123714`*^9}, {3.6412148921798115`*^9, 
  3.64121489306544*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.641635915383037*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "5", ",", "5", ",", "12", ",", "6", ",", "6", ",", "6", ",", 
     "12", ",", "6", ",", "6", ",", "6", ",", "12"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {5, 5, 5, 12, 6, 6, 6, 12, 6, 6, 6, 12}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.641635915383037*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "6", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6", ",", "12"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{5, 5, 5}, {12, 6, 6}, {6, 12, 6}, {6, 6, 12}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.641635915383037*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359153986626`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359154299145`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"864.`", ",", "864.`", ",", "864.`"}], "}"}]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359155549192`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"12", ",", "6", ",", "6"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "12", ",", "6"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "6", ",", "12"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{12, 6, 6}}, {{6, 12, 6}}, {{6, 6, 12}}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359155705447`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"12", ",", "6", ",", "6"}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 1, "]]=", {{12, 6, 6}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359155705447`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"6", ",", "12", ",", "6"}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 2, "]]=", {{6, 12, 6}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359156799235`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"6", ",", "6", ",", "12"}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 3, "]]=", {{6, 6, 12}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359157893033`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[1]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox["52", "3"], ",", 
        FractionBox["46", "3"], ",", 
        FractionBox["46", "3"]}], "}"}], ",", "2"}], "}"}], "}"}]}],
  SequenceForm["pYk[[1]]=", {{{
      Rational[52, 3], 
      Rational[46, 3], 
      Rational[46, 3]}, 2}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359158986826`*^9}],

Cell[BoxData[
 RowBox[{"{", "768", "}"}]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159143085`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[2]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox["46", "3"], ",", 
        FractionBox["52", "3"], ",", 
        FractionBox["46", "3"]}], "}"}], ",", "2"}], "}"}], "}"}]}],
  SequenceForm["pYk[[2]]=", {{{
      Rational[46, 3], 
      Rational[52, 3], 
      Rational[46, 3]}, 2}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159143085`*^9}],

Cell[BoxData[
 RowBox[{"{", "768", "}"}]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159143085`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[3]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox["46", "3"], ",", 
        FractionBox["46", "3"], ",", 
        FractionBox["52", "3"]}], "}"}], ",", "2"}], "}"}], "}"}]}],
  SequenceForm["pYk[[3]]=", {{{
      Rational[46, 3], 
      Rational[46, 3], 
      Rational[52, 3]}, 2}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159299335`*^9}],

Cell[BoxData[
 RowBox[{"{", "768", "}"}]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159299335`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximo=\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Maximo=", 2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159299335`*^9}],

Cell[BoxData["\<\"--------------\"\>"], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159299335`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "480.`"}],
  SequenceForm["daux=", 480.],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159455595`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["52", "3"], ",", 
      FractionBox["46", "3"], ",", 
      FractionBox["46", "3"]}], "}"}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[52, 3], 
     Rational[46, 3], 
     Rational[46, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159455595`*^9}],

Cell[BoxData[
 RowBox[{"{", "768.`", "}"}]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159455595`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159455595`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "480.`"}],
  SequenceForm["daux=", 480.],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159611855`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["46", "3"], ",", 
      FractionBox["52", "3"], ",", 
      FractionBox["46", "3"]}], "}"}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[46, 3], 
     Rational[52, 3], 
     Rational[46, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159611855`*^9}],

Cell[BoxData[
 RowBox[{"{", "768.`", "}"}]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159611855`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.6416359159611855`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "480.`"}],
  SequenceForm["daux=", 480.],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.641635915976811*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["46", "3"], ",", 
      FractionBox["46", "3"], ",", 
      FractionBox["52", "3"]}], "}"}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[46, 3], 
     Rational[46, 3], 
     Rational[52, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.641635915976811*^9}],

Cell[BoxData[
 RowBox[{"{", "768.`", "}"}]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.641635915976811*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6405789696294155`*^9, 3.640578980718292*^9}, 
   3.6405791104403305`*^9, {3.640580078980502*^9, 3.640580082416941*^9}, 
   3.6405801601701164`*^9, 3.6405803234669657`*^9, 3.640581426860836*^9, 
   3.6410493892716937`*^9, 3.64108617423938*^9, 3.6411037939845257`*^9, 
   3.6412148968871536`*^9, 3.641216564698351*^9, 3.6412924634285684`*^9, 
   3.6413573079910965`*^9, 3.6413684903184547`*^9, 3.641383379012271*^9, 
   3.6416347173100057`*^9, 3.641635915976811*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["cotaDevv2"], "Input",
 CellChangeTimes->{{3.6405791554322505`*^9, 3.640579160279685*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          FractionBox["52", "3"], ",", 
          FractionBox["46", "3"], ",", 
          FractionBox["46", "3"]}], "}"}], ",", "2"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          FractionBox["46", "3"], ",", 
          FractionBox["52", "3"], ",", 
          FractionBox["46", "3"]}], "}"}], ",", "2"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          FractionBox["46", "3"], ",", 
          FractionBox["46", "3"], ",", 
          FractionBox["52", "3"]}], "}"}], ",", "2"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"12", ",", "6", ",", "6"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "12", ",", "6"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "6", ",", "12"}], "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "6", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6", ",", "12"}], "}"}]}], "}"}], ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "30"}], "-", "x1", "-", "x2", "+", 
       RowBox[{"8", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "30"}], "+", 
       RowBox[{"8", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
      "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "30"}], "-", "x1", "+", 
       RowBox[{"8", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"24", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
      "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.640579160945155*^9, 3.6405800946706443`*^9, 
  3.6405801663965244`*^9, 3.640580328041213*^9, 3.6405814335765915`*^9, 
  3.641086192873665*^9, 3.641103798443697*^9, 3.6412149030175223`*^9, 
  3.641216571492167*^9, 3.64129246586831*^9, 3.6413573096112556`*^9, 
  3.6413684952049255`*^9, 3.6413833898479657`*^9, 3.6416347237850685`*^9, 
  3.6416359244807696`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isCohenMacaulay", "[", 
  RowBox[{"vv2", ",", "cotaDevv2"}], "]"}]], "Input",
 CellChangeTimes->{{3.640578992588714*^9, 3.6405789986640234`*^9}, {
  3.641086218259746*^9, 3.6410862186910524`*^9}, {3.641214907157483*^9, 
  3.6412149083683443`*^9}, {3.641357311213396*^9, 3.6413573113895226`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generators of the rays we use to check the CM condition: \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "6", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6", ",", "12"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Generators of the rays we use to check the CM condition: ", {{12, 6, 6}, {
   6, 12, 6}, {6, 6, 12}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405789993675146`*^9, 3.6405791122806263`*^9, 3.64057916683033*^9, 
   3.640580168232827*^9, 3.640580329709395*^9, {3.6405810124017687`*^9, 
   3.6405810316054077`*^9}, 3.64058143609838*^9, 3.640581490473961*^9, 
   3.6410494086755295`*^9, {3.6410861953674335`*^9, 3.6410862198348756`*^9}, 
   3.6411038016339593`*^9, 3.6412149100815706`*^9, 3.641216581199069*^9, 
   3.6412924687110376`*^9, 3.641357312543337*^9, 3.6413684965358806`*^9, 
   3.6413833932173595`*^9, 3.64163472539714*^9, 3.6416359272790675`*^9}],

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{
  3.6405789993675146`*^9, 3.6405791122806263`*^9, 3.64057916683033*^9, 
   3.640580168232827*^9, 3.640580329709395*^9, {3.6405810124017687`*^9, 
   3.6405810316054077`*^9}, 3.64058143609838*^9, 3.640581490473961*^9, 
   3.6410494086755295`*^9, {3.6410861953674335`*^9, 3.6410862198348756`*^9}, 
   3.6411038016339593`*^9, 3.6412149100815706`*^9, 3.641216581199069*^9, 
   3.6412924687110376`*^9, 3.641357312543337*^9, 3.6413684965358806`*^9, 
   3.6413833932173595`*^9, 3.64163472539714*^9, 3.6416359272790675`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "5", ",", "5", ",", "12", ",", "6", ",", "6", ",", "6", ",", 
     "12", ",", "6", ",", "6", ",", "6", ",", "12"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {5, 5, 5, 12, 6, 6, 6, 12, 6, 6, 6, 12}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405789993675146`*^9, 3.6405791122806263`*^9, 3.64057916683033*^9, 
   3.640580168232827*^9, 3.640580329709395*^9, {3.6405810124017687`*^9, 
   3.6405810316054077`*^9}, 3.64058143609838*^9, 3.640581490473961*^9, 
   3.6410494086755295`*^9, {3.6410861953674335`*^9, 3.6410862198348756`*^9}, 
   3.6411038016339593`*^9, 3.6412149100815706`*^9, 3.641216581199069*^9, 
   3.6412924687110376`*^9, 3.641357312543337*^9, 3.6413684965358806`*^9, 
   3.6413833932173595`*^9, 3.64163472539714*^9, 3.6416359272946925`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "6", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6", ",", "12"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{5, 5, 5}, {12, 6, 6}, {6, 12, 6}, {6, 6, 12}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405789993675146`*^9, 3.6405791122806263`*^9, 3.64057916683033*^9, 
   3.640580168232827*^9, 3.640580329709395*^9, {3.6405810124017687`*^9, 
   3.6405810316054077`*^9}, 3.64058143609838*^9, 3.640581490473961*^9, 
   3.6410494086755295`*^9, {3.6410861953674335`*^9, 3.6410862198348756`*^9}, 
   3.6411038016339593`*^9, 3.6412149100815706`*^9, 3.641216581199069*^9, 
   3.6412924687110376`*^9, 3.641357312543337*^9, 3.6413684965358806`*^9, 
   3.6413833932173595`*^9, 3.64163472539714*^9, 3.6416359272946925`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405789993675146`*^9, 3.6405791122806263`*^9, 3.64057916683033*^9, 
   3.640580168232827*^9, 3.640580329709395*^9, {3.6405810124017687`*^9, 
   3.6405810316054077`*^9}, 3.64058143609838*^9, 3.640581490473961*^9, 
   3.6410494086755295`*^9, {3.6410861953674335`*^9, 3.6410862198348756`*^9}, 
   3.6411038016339593`*^9, 3.6412149100815706`*^9, 3.641216581199069*^9, 
   3.6412924687110376`*^9, 3.641357312543337*^9, 3.6413684965358806`*^9, 
   3.6413833932173595`*^9, 3.64163472539714*^9, 3.6416359272946925`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{
  3.6405789993675146`*^9, 3.6405791122806263`*^9, 3.64057916683033*^9, 
   3.640580168232827*^9, 3.640580329709395*^9, {3.6405810124017687`*^9, 
   3.6405810316054077`*^9}, 3.64058143609838*^9, 3.640581490473961*^9, 
   3.6410494086755295`*^9, {3.6410861953674335`*^9, 3.6410862198348756`*^9}, 
   3.6411038016339593`*^9, 3.6412149100815706`*^9, 3.641216581199069*^9, 
   3.6412924687110376`*^9, 3.641357312543337*^9, 3.6413684965358806`*^9, 
   3.6413833932173595`*^9, 3.64163472539714*^9, 3.64163592734157*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"12", ",", "6", ",", "6"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "12", ",", "6"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "6", ",", "12"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{12, 6, 6}}, {{6, 12, 6}}, {{6, 6, 12}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405789993675146`*^9, 3.6405791122806263`*^9, 3.64057916683033*^9, 
   3.640580168232827*^9, 3.640580329709395*^9, {3.6405810124017687`*^9, 
   3.6405810316054077`*^9}, 3.64058143609838*^9, 3.640581490473961*^9, 
   3.6410494086755295`*^9, {3.6410861953674335`*^9, 3.6410862198348756`*^9}, 
   3.6411038016339593`*^9, 3.6412149100815706`*^9, 3.641216581199069*^9, 
   3.6412924687110376`*^9, 3.641357312543337*^9, 3.6413684965358806`*^9, 
   3.6413833932173595`*^9, 3.64163472539714*^9, 3.6416359274665747`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "6", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "12", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6", ",", "12"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{12, 6, 6}, {6, 12, 6}, {6, 6, 12}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405789993675146`*^9, 3.6405791122806263`*^9, 3.64057916683033*^9, 
   3.640580168232827*^9, 3.640580329709395*^9, {3.6405810124017687`*^9, 
   3.6405810316054077`*^9}, 3.64058143609838*^9, 3.640581490473961*^9, 
   3.6410494086755295`*^9, {3.6410861953674335`*^9, 3.6410862198348756`*^9}, 
   3.6411038016339593`*^9, 3.6412149100815706`*^9, 3.641216581199069*^9, 
   3.6412924687110376`*^9, 3.641357312543337*^9, 3.6413684965358806`*^9, 
   3.6413833932173595`*^9, 3.64163472539714*^9, 3.6416359274822006`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "30"}], "-", "x1", "-", "x2", "+", 
     RowBox[{"8", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "30"}], "+", 
     RowBox[{"8", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "30"}], "-", "x1", "+", 
     RowBox[{"8", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"24", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6405789993675146`*^9, 3.6405791122806263`*^9, 3.64057916683033*^9, 
   3.640580168232827*^9, 3.640580329709395*^9, {3.6405810124017687`*^9, 
   3.6405810316054077`*^9}, 3.64058143609838*^9, 3.640581490473961*^9, 
   3.6410494086755295`*^9, {3.6410861953674335`*^9, 3.6410862198348756`*^9}, 
   3.6411038016339593`*^9, 3.6412149100815706`*^9, 3.641216581199069*^9, 
   3.6412924687110376`*^9, 3.641357312543337*^9, 3.6413684965358806`*^9, 
   3.6413833932173595`*^9, 3.64163472539714*^9, 3.64163592759158*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"48", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6405789993675146`*^9, 3.6405791122806263`*^9, 3.64057916683033*^9, 
   3.640580168232827*^9, 3.640580329709395*^9, {3.6405810124017687`*^9, 
   3.6405810316054077`*^9}, 3.64058143609838*^9, 3.640581490473961*^9, 
   3.6410494086755295`*^9, {3.6410861953674335`*^9, 3.6410862198348756`*^9}, 
   3.6411038016339593`*^9, 3.6412149100815706`*^9, 3.641216581199069*^9, 
   3.6412924687110376`*^9, 3.641357312543337*^9, 3.6413684965358806`*^9, 
   3.6413833932173595`*^9, 3.64163472539714*^9, 3.641635927716585*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "15625", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "1325", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "606", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "719"}],
  SequenceForm[15625, " ", 1325, " ", 606, " ", 719],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405789993675146`*^9, 3.6405791122806263`*^9, 3.64057916683033*^9, 
   3.640580168232827*^9, 3.640580329709395*^9, {3.6405810124017687`*^9, 
   3.6405810316054077`*^9}, 3.64058143609838*^9, 3.640581490473961*^9, 
   3.6410494086755295`*^9, {3.6410861953674335`*^9, 3.6410862198348756`*^9}, 
   3.6411038016339593`*^9, 3.6412149100815706`*^9, 3.641216581199069*^9, 
   3.6412924687110376`*^9, 3.641357312543337*^9, 3.6413684965358806`*^9, 
   3.6413833932173595`*^9, 3.64163472539714*^9, 3.6416359301912413`*^9}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.6410494276670523`*^9, {3.641086211092638*^9, 3.6410862354029684`*^9}, 
   3.641103817289116*^9, 3.641214970627711*^9, 3.64121659864946*^9, 
   3.641292470275277*^9, 3.6413573142215357`*^9, 3.641368500776882*^9, 
   3.6413833974573765`*^9, 3.641634731836731*^9, 3.641635933686635*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "Section",
 CellChangeTimes->{{3.6405803389549646`*^9, 3.6405803452624435`*^9}, 
   3.6406180940662303`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vv3", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3", ",", "6"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.640580247245901*^9, 3.640580247782272*^9}, {
  3.6405803004436455`*^9, 3.640580308382271*^9}, {3.640580348622815*^9, 
  3.640580385787184*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "6"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6412151062523394`*^9, 3.6412166097773623`*^9, 
  3.641261515085906*^9, 3.6412924810629373`*^9, 3.6413573167793455`*^9, 
  3.6413685362750998`*^9, 3.6413834005915966`*^9, 3.6416347351656475`*^9, 
  3.6416359360162554`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vv3", ",", "3", ",", "False", ",", "False", ",", "True"}], "]"}],
    "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.641215084439798*^9, 3.641215095502681*^9}, {
  3.6412924855771575`*^9, 3.6412924882230215`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.6412151022034492`*^9, 3.641215109613725*^9}, 
   3.641216613515023*^9, 3.6412615177798176`*^9, 3.6412924894639034`*^9, 
   3.6413573181653214`*^9, 3.641368537576022*^9, 3.641383401697381*^9, 
   3.6416347385901384`*^9, 3.641635936938167*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "6", ",", "3", ",", "3", ",", "3", ",", "6",
      ",", "3", ",", "3", ",", "3", ",", "6"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {2, 2, 2, 6, 3, 3, 3, 6, 3, 3, 3, 6}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412151022034492`*^9, 3.641215109613725*^9}, 
   3.641216613515023*^9, 3.6412615177798176`*^9, 3.6412924894639034`*^9, 
   3.6413573181653214`*^9, 3.641368537576022*^9, 3.641383401697381*^9, 
   3.6416347385901384`*^9, 3.6416359369537926`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "6"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{2, 2, 2}, {6, 3, 3}, {3, 6, 3}, {3, 3, 6}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412151022034492`*^9, 3.641215109613725*^9}, 
   3.641216613515023*^9, 3.6412615177798176`*^9, 3.6412924894639034`*^9, 
   3.6413573181653214`*^9, 3.641368537576022*^9, 3.641383401697381*^9, 
   3.6416347385901384`*^9, 3.6416359369537926`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412151022034492`*^9, 3.641215109613725*^9}, 
   3.641216613515023*^9, 3.6412615177798176`*^9, 3.6412924894639034`*^9, 
   3.6413573181653214`*^9, 3.641368537576022*^9, 3.641383401697381*^9, 
   3.6416347385901384`*^9, 3.6416359369537926`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.6412151022034492`*^9, 3.641215109613725*^9}, 
   3.641216613515023*^9, 3.6412615177798176`*^9, 3.6412924894639034`*^9, 
   3.6413573181653214`*^9, 3.641368537576022*^9, 3.641383401697381*^9, 
   3.6416347385901384`*^9, 3.64163593696942*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "3", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3", ",", "6", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", "6"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{6, 3, 3}}, {{3, 6, 3}}, {{3, 3, 6}}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412151022034492`*^9, 3.641215109613725*^9}, 
   3.641216613515023*^9, 3.6412615177798176`*^9, 3.6412924894639034`*^9, 
   3.6413573181653214`*^9, 3.641368537576022*^9, 3.641383401697381*^9, 
   3.6416347385901384`*^9, 3.6416359371100483`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "6"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{6, 3, 3}, {3, 6, 3}, {3, 3, 6}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412151022034492`*^9, 3.641215109613725*^9}, 
   3.641216613515023*^9, 3.6412615177798176`*^9, 3.6412924894639034`*^9, 
   3.6413573181653214`*^9, 3.641368537576022*^9, 3.641383401697381*^9, 
   3.6416347385901384`*^9, 3.6416359371256742`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], "-", "x1", "-", "x2", "+", 
     RowBox[{"5", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], "+", 
     RowBox[{"5", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], "-", "x1", "+", 
     RowBox[{"5", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"12", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.6412151022034492`*^9, 3.641215109613725*^9}, 
   3.641216613515023*^9, 3.6412615177798176`*^9, 3.6412924894639034`*^9, 
   3.6413573181653214`*^9, 3.641368537576022*^9, 3.641383401697381*^9, 
   3.6416347385901384`*^9, 3.6416359372364483`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"36", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.6412151022034492`*^9, 3.641215109613725*^9}, 
   3.641216613515023*^9, 3.6412615177798176`*^9, 3.6412924894639034`*^9, 
   3.6413573181653214`*^9, 3.641368537576022*^9, 3.641383401697381*^9, 
   3.6416347385901384`*^9, 3.641635937377081*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "6859", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "589", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "408", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "181"}],
  SequenceForm[6859, " ", 589, " ", 408, " ", 181],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412151022034492`*^9, 3.641215109613725*^9}, 
   3.641216613515023*^9, 3.6412615177798176`*^9, 3.6412924894639034`*^9, 
   3.6413573181653214`*^9, 3.641368537576022*^9, 3.641383401697381*^9, 
   3.6416347385901384`*^9, 3.641635938566119*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{2., 2., 2.}, {3., 3., 6.}, {3., 6., 3.}, {6., 3., 
    3.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.0024826475243067136`, 0.4364736187655003, 0.7736748278669103], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   GraphicsComplex3DBox[{{4., 4., 4.}, {6., 6., 12.}, {6., 12., 6.}, {12., 6.,
     6.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.09099197570763318, 0.06282916950872863, 0.8199375808086689], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   GraphicsComplex3DBox[{{6., 6., 6.}, {9., 9., 18.}, {9., 18., 9.}, {18., 9.,
     9.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.27046593073769887`, 0.5570345861131787, 0.6751898052564662], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[{{6, 3, 3}, {3, 6, 3}, {3, 3, 6}}]}, 
   {RGBColor[1, 0, 0], Line3DBox[{{0, 0, 0}, {24, 12, 12}}], 
    Line3DBox[{{0, 0, 0}, {12, 24, 12}}], 
    Line3DBox[{{0, 0, 0}, {12, 12, 24}}]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{391.57762535152625`, 402.33016330290496`},
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All,
  ViewPoint->{0.8881696385532051, -0.8229992553576945, 3.159719436727405},
  ViewVertical->{-0.4359051778122869, 0.32363075450344503`, 
   0.8397915281163353}]], "Output",
 CellChangeTimes->{{3.641215103195166*^9, 3.6412151103362646`*^9}, 
   3.641216614103434*^9, 3.6412615183552375`*^9, 3.6412924902604694`*^9, 
   3.641357318961896*^9, 3.6413685387708616`*^9, 3.6413834029662848`*^9, 
   3.6416347402511873`*^9, 3.641635938612996*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cotaDevv3", "=", 
  RowBox[{"boundCohenMacaulay", "[", "vv3", "]"}]}]], "Input",
 CellChangeTimes->{{3.640580407609665*^9, 3.640580429878476*^9}, {
   3.641216643742484*^9, 3.6412166453165984`*^9}, 3.641292504704733*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359404315243`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "6", ",", "3", ",", "3", ",", "3", ",", "6",
      ",", "3", ",", "3", ",", "3", ",", "6"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {2, 2, 2, 6, 3, 3, 3, 6, 3, 3, 3, 6}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359404471493`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "6"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{2, 2, 2}, {6, 3, 3}, {3, 6, 3}, {3, 3, 6}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359404471493`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359404471493`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359404784007`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"108.`", ",", "108.`", ",", "108.`"}], "}"}]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359406039577`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "3", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3", ",", "6", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", "6"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{6, 3, 3}}, {{3, 6, 3}}, {{3, 3, 6}}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359406039577`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"6", ",", "3", ",", "3"}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 1, "]]=", {{6, 3, 3}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940619583*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "6", ",", "3"}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 2, "]]=", {{3, 6, 3}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940728963*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3", ",", "6"}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 3, "]]=", {{3, 3, 6}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359408383417`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[1]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", "1"}], "}"}], "}"}]}],
  SequenceForm["pYk[[1]]=", {{{4, 4, 4}, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359409477215`*^9}],

Cell[BoxData[
 RowBox[{"{", "36", "}"}]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359409477215`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[2]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", "1"}], "}"}], "}"}]}],
  SequenceForm["pYk[[2]]=", {{{4, 4, 4}, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359409477215`*^9}],

Cell[BoxData[
 RowBox[{"{", "36", "}"}]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359409477215`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[3]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", "1"}], "}"}], "}"}]}],
  SequenceForm["pYk[[3]]=", {{{4, 4, 4}, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359409633465`*^9}],

Cell[BoxData[
 RowBox[{"{", "36", "}"}]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359409633465`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximo=\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Maximo=", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359409633465`*^9}],

Cell[BoxData["\<\"--------------\"\>"], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940978972*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "36.`"}],
  SequenceForm["daux=", 36.],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940978972*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4", ",", "4"}], "}"}], "}"}]}],
  SequenceForm["listaAux=", {{4, 4, 4}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940978972*^9}],

Cell[BoxData[
 RowBox[{"{", "36.`", "}"}]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940978972*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940978972*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "36.`"}],
  SequenceForm["daux=", 36.],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940994598*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4", ",", "4"}], "}"}], "}"}]}],
  SequenceForm["listaAux=", {{4, 4, 4}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940994598*^9}],

Cell[BoxData[
 RowBox[{"{", "36.`", "}"}]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940994598*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940994598*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "36.`"}],
  SequenceForm["daux=", 36.],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.641635940994598*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4", ",", "4"}], "}"}], "}"}]}],
  SequenceForm["listaAux=", {{4, 4, 4}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359410102234`*^9}],

Cell[BoxData[
 RowBox[{"{", "36.`", "}"}]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359410102234`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640580416426923*^9, 3.6405804314125633`*^9}, 
   3.6405815294456196`*^9, 3.6410494506093984`*^9, 3.641086255323162*^9, 
   3.6411038235856023`*^9, 3.64121664714789*^9, {3.6412924972604403`*^9, 
   3.641292505208084*^9}, 3.6413573199385805`*^9, 3.6413685414787846`*^9, 
   3.64138340866833*^9, 3.6416347439205613`*^9, 3.6416359410102234`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", "1"}], "}"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", "1"}], "}"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", "1"}], "}"}], "}"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "3", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3", ",", "6", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", "6"}], "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "6"}], "}"}]}], "}"}], ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], "-", "x1", "-", "x2", "+", 
       RowBox[{"5", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], "+", 
       RowBox[{"5", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
      "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], "-", "x1", "+", 
       RowBox[{"5", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"12", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
      "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6412925058095117`*^9, 3.641357320379894*^9, 
  3.641368542175287*^9, 3.64138340922173*^9, 3.6416347445299606`*^9, 
  3.6416359410102234`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isCohenMacaulay", "[", 
  RowBox[{"vv3", ",", "cotaDevv3"}], "]"}]], "Input",
 CellChangeTimes->{{3.640580444255678*^9, 3.640580452902813*^9}, {
  3.641086268626646*^9, 3.641086269120998*^9}, {3.641216663636613*^9, 
  3.6412166648034363`*^9}, {3.641292509815363*^9, 3.641292509980486*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generators of the rays we use to check the CM condition: \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "6"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Generators of the rays we use to check the CM condition: ", {{6, 3, 3}, {3,
    6, 3}, {3, 3, 6}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6412166655139313`*^9, 3.6412925137061186`*^9, 
  3.6413573227886033`*^9, 3.641368544901226*^9, 3.6413834136068525`*^9, 
  3.641634752438672*^9, 3.6416359443157463`*^9}],

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.6412166655139313`*^9, 3.6412925137061186`*^9, 
  3.6413573227886033`*^9, 3.641368544901226*^9, 3.6413834136068525`*^9, 
  3.641634752438672*^9, 3.6416359443313713`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "6", ",", "3", ",", "3", ",", "3", ",", "6",
      ",", "3", ",", "3", ",", "3", ",", "6"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {2, 2, 2, 6, 3, 3, 3, 6, 3, 3, 3, 6}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6412166655139313`*^9, 3.6412925137061186`*^9, 
  3.6413573227886033`*^9, 3.641368544901226*^9, 3.6413834136068525`*^9, 
  3.641634752438672*^9, 3.6416359443313713`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "6"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{2, 2, 2}, {6, 3, 3}, {3, 6, 3}, {3, 3, 6}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6412166655139313`*^9, 3.6412925137061186`*^9, 
  3.6413573227886033`*^9, 3.641368544901226*^9, 3.6413834136068525`*^9, 
  3.641634752438672*^9, 3.6416359443313713`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6412166655139313`*^9, 3.6412925137061186`*^9, 
  3.6413573227886033`*^9, 3.641368544901226*^9, 3.6413834136068525`*^9, 
  3.641634752438672*^9, 3.6416359443313713`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.6412166655139313`*^9, 3.6412925137061186`*^9, 
  3.6413573227886033`*^9, 3.641368544901226*^9, 3.6413834136068525`*^9, 
  3.641634752438672*^9, 3.641635944378248*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "3", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3", ",", "6", ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", "6"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{6, 3, 3}}, {{3, 6, 3}}, {{3, 3, 6}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6412166655139313`*^9, 3.6412925137061186`*^9, 
  3.6413573227886033`*^9, 3.641368544901226*^9, 3.6413834136068525`*^9, 
  3.641634752438672*^9, 3.641635944518879*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "6"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{6, 3, 3}, {3, 6, 3}, {3, 3, 6}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6412166655139313`*^9, 3.6412925137061186`*^9, 
  3.6413573227886033`*^9, 3.641368544901226*^9, 3.6413834136068525`*^9, 
  3.641634752438672*^9, 3.641635944534505*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], "-", "x1", "-", "x2", "+", 
     RowBox[{"5", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], "+", 
     RowBox[{"5", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], "-", "x1", "+", 
     RowBox[{"5", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"12", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6412166655139313`*^9, 3.6412925137061186`*^9, 
  3.6413573227886033`*^9, 3.641368544901226*^9, 3.6413834136068525`*^9, 
  3.641634752438672*^9, 3.641635944643884*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"12", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6412166655139313`*^9, 3.6412925137061186`*^9, 
  3.6413573227886033`*^9, 3.641368544901226*^9, 3.6413834136068525`*^9, 
  3.641634752438672*^9, 3.6416359447688885`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "343", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "13"}],
  SequenceForm[343, " ", 35, " ", 22, " ", 13],
  Editable->False]], "Print",
 CellChangeTimes->{3.6412166655139313`*^9, 3.6412925137061186`*^9, 
  3.6413573227886033`*^9, 3.641368544901226*^9, 3.6413834136068525`*^9, 
  3.641634752438672*^9, 3.6416359448313913`*^9}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.640580465782951*^9, 3.6405815363024855`*^9, 3.641049464428254*^9, 
   3.6410862712755194`*^9, 3.6411038285441427`*^9, {3.641216657099966*^9, 
   3.6412166662244906`*^9}, 3.6412925140664015`*^9, 3.6413573232709465`*^9, 
   3.6413685454456167`*^9, 3.641383414087178*^9, 3.64163475298778*^9, 
   3.641635944925145*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"genDevv3", "=", 
   RowBox[{"generatorsOfConvexHSgr", "[", "vv3", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6407796127972145`*^9, 3.640779624871781*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.640779614424952*^9, 3.6407796257095995`*^9}, 
   3.6410494709438868`*^9, 3.641086279884659*^9, 3.6411038312410736`*^9, 
   3.6412166728581576`*^9, 3.6412925157295647`*^9, 3.6413573250432053`*^9, 
   3.641368547860316*^9, 3.6413834160835867`*^9, 3.641634754831604*^9, 
   3.641635946128319*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "2", ",", "6", ",", "3", ",", "3", ",", "3", ",", "6",
      ",", "3", ",", "3", ",", "3", ",", "6"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {2, 2, 2, 6, 3, 3, 3, 6, 3, 3, 3, 6}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640779614424952*^9, 3.6407796257095995`*^9}, 
   3.6410494709438868`*^9, 3.641086279884659*^9, 3.6411038312410736`*^9, 
   3.6412166728581576`*^9, 3.6412925157295647`*^9, 3.6413573250432053`*^9, 
   3.641368547860316*^9, 3.6413834160835867`*^9, 3.641634754831604*^9, 
   3.6416359461439447`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "6"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{2, 2, 2}, {6, 3, 3}, {3, 6, 3}, {3, 3, 6}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640779614424952*^9, 3.6407796257095995`*^9}, 
   3.6410494709438868`*^9, 3.641086279884659*^9, 3.6411038312410736`*^9, 
   3.6412166728581576`*^9, 3.6412925157295647`*^9, 3.6413573250432053`*^9, 
   3.641368547860316*^9, 3.6413834160835867`*^9, 3.641634754831604*^9, 
   3.6416359461439447`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.640779614424952*^9, 3.6407796257095995`*^9}, 
   3.6410494709438868`*^9, 3.641086279884659*^9, 3.6411038312410736`*^9, 
   3.6412166728581576`*^9, 3.6412925157295647`*^9, 3.6413573250432053`*^9, 
   3.641368547860316*^9, 3.6413834160835867`*^9, 3.641634754831604*^9, 
   3.6416359461595697`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\tmp\\\
\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.640779614424952*^9, 3.6407796257095995`*^9}, 
   3.6410494709438868`*^9, 3.641086279884659*^9, 3.6411038312410736`*^9, 
   3.6412166728581576`*^9, 3.6412925157295647`*^9, 3.6413573250432053`*^9, 
   3.641368547860316*^9, 3.6413834160835867`*^9, 3.641634754831604*^9, 
   3.6416359461595697`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"genDevv3", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.6407796188701887`*^9, 3.6407796388341417`*^9}}],

Cell[BoxData["21"], "Output",
 CellChangeTimes->{3.6407796394119*^9, 3.641049473092427*^9, 
  3.641086282596596*^9, 3.6411038329722905`*^9, 3.641216674239127*^9, 
  3.641292517996174*^9, 3.6413573259268417`*^9, 3.6413685493774033`*^9, 
  3.6413834172013807`*^9, 3.641634755723695*^9, 3.641635946949351*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["genDevv3"], "Input",
 CellChangeTimes->{{3.640779695298437*^9, 3.640779696755089*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "4"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.640779697109965*^9, 3.6410494762676907`*^9, 
  3.6410862838735056`*^9, 3.6411038339670067`*^9, 3.641216675598102*^9, 
  3.6412925191049614`*^9, 3.6413573271807213`*^9, 3.6413685502019887`*^9, 
  3.641383418431263*^9, 3.641634756645606*^9, 3.6416359478725686`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msgV3", "=", 
  RowBox[{"msgCHSgr", "[", 
   RowBox[{"vv3", ",", "genDevv3"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6407795863301487`*^9, 3.6407795896286345`*^9}, {
  3.6407796424620686`*^9, 3.6407796446705093`*^9}, {3.6407796845202084`*^9, 
  3.6407796872448316`*^9}, {3.6407797423952107`*^9, 3.6407797490312967`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "3", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.64077964554842*^9, 3.6407796885499516`*^9, 
  3.6407797500294447`*^9, 3.641049478183055*^9, 3.6410862856127357`*^9, 
  3.6411038352879486`*^9, 3.641216677729615*^9, 3.6412925207191076`*^9, 
  3.6413573283215427`*^9, 3.6413685512387147`*^9, 3.64138341994936*^9, 
  3.641634759006647*^9, 3.6416359492169657`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msgV3", "//", "Length"}]], "Input",
 CellChangeTimes->{{3.6407797513472595`*^9, 3.6407797547131996`*^9}}],

Cell[BoxData["20"], "Output",
 CellChangeTimes->{3.6407797551511726`*^9, 3.6410494796000547`*^9, 
  3.6410862870767784`*^9, 3.6411038364777956`*^9, 3.6412166808928614`*^9, 
  3.6412925217418337`*^9, 3.6413573311435456`*^9, 3.6413685535343556`*^9, 
  3.64138342076492*^9, 3.6416347596870766`*^9, 3.6416359495607276`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vv4", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5", ",", "7"}], "}"}]}], "}"}], " ", 
   FractionBox["5", "7"]}]}]], "Input",
 CellChangeTimes->{{3.6406181143876505`*^9, 3.640618138560798*^9}, {
  3.640618275034627*^9, 3.6406182946625524`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["10", "7"], ",", 
     FractionBox["10", "7"], ",", 
     FractionBox["10", "7"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["30", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["20", "7"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["15", "7"], ",", 
     FractionBox["25", "7"], ",", 
     FractionBox["15", "7"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["15", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["45", "7"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["25", "7"], ",", 
     FractionBox["25", "7"], ",", "5"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6406181391492248`*^9, 3.6406182955902214`*^9, 
  3.6410494825361557`*^9, 3.64108629409679*^9, 3.6411038382640595`*^9, 
  3.6412166826150846`*^9, 3.6412615259286137`*^9, 3.6412925233749943`*^9, 
  3.641357332612589*^9, 3.641368555358656*^9, 3.6413834245646086`*^9, 
  3.641572874115226*^9, 3.641634764194148*^9, 3.641635951452569*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vv4", ",", "3", ",", "True", ",", "False", ",", "True"}], "]"}], 
   "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.64121669111112*^9, 3.641216708317339*^9}, {
   3.6412925274398775`*^9, 3.6412925347160444`*^9}, 3.6415728750669007`*^9, 
   3.6416347718923707`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.641216702518209*^9, 3.641216708919771*^9}, 
   3.6412615283663373`*^9, 3.6412925352974515`*^9, 3.6413573339925604`*^9, 
   3.6413685577033157`*^9, 3.6413834263648963`*^9, 3.6415728768841825`*^9, 
   3.6416347657513475`*^9, 3.6416359531870136`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["10", "7"], ",", 
     FractionBox["10", "7"], ",", 
     FractionBox["10", "7"], ",", 
     FractionBox["30", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["20", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["25", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["45", "7"], ",", 
     FractionBox["25", "7"], ",", 
     FractionBox["25", "7"], ",", "5"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[10, 7], 
    Rational[10, 7], 
    Rational[10, 7], 
    Rational[30, 7], 
    Rational[15, 7], 
    Rational[20, 7], 
    Rational[15, 7], 
    Rational[25, 7], 
    Rational[15, 7], 
    Rational[15, 7], 
    Rational[15, 7], 
    Rational[45, 7], 
    Rational[25, 7], 
    Rational[25, 7], 5}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641216702518209*^9, 3.641216708919771*^9}, 
   3.6412615283663373`*^9, 3.6412925352974515`*^9, 3.6413573339925604`*^9, 
   3.6413685577033157`*^9, 3.6413834263648963`*^9, 3.6415728768841825`*^9, 
   3.6416347657513475`*^9, 3.6416359531870136`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "10", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "15", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "25", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15", ",", "45"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "25", ",", "35"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{10, 10, 10}, {30, 15, 20}, {15, 25, 15}, {15, 15, 45}, {25, 25, 
   35}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641216702518209*^9, 3.641216708919771*^9}, 
   3.6412615283663373`*^9, 3.6412925352974515`*^9, 3.6413573339925604`*^9, 
   3.6413685577033157`*^9, 3.6413834263648963`*^9, 3.6415728768841825`*^9, 
   3.6416347657513475`*^9, 3.6416359531870136`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641216702518209*^9, 3.641216708919771*^9}, 
   3.6412615283663373`*^9, 3.6412925352974515`*^9, 3.6413573339925604`*^9, 
   3.6413685577033157`*^9, 3.6413834263648963`*^9, 3.6415728768841825`*^9, 
   3.6416347657513475`*^9, 3.641635953202639*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.641216702518209*^9, 3.641216708919771*^9}, 
   3.6412615283663373`*^9, 3.6412925352974515`*^9, 3.6413573339925604`*^9, 
   3.6413685577033157`*^9, 3.6413834263648963`*^9, 3.6415728768841825`*^9, 
   3.6416347657513475`*^9, 3.6416359532495155`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["30", "7"], ",", 
        FractionBox["15", "7"], ",", 
        FractionBox["20", "7"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "7"], ",", 
        FractionBox["25", "7"], ",", 
        FractionBox["15", "7"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "7"], ",", 
        FractionBox["15", "7"], ",", 
        FractionBox["45", "7"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[30, 7], 
      Rational[15, 7], 
      Rational[20, 7]}}, {{
      Rational[15, 7], 
      Rational[25, 7], 
      Rational[15, 7]}}, {{
      Rational[15, 7], 
      Rational[15, 7], 
      Rational[45, 7]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641216702518209*^9, 3.641216708919771*^9}, 
   3.6412615283663373`*^9, 3.6412925352974515`*^9, 3.6413573339925604`*^9, 
   3.6413685577033157`*^9, 3.6413834263648963`*^9, 3.6415728768841825`*^9, 
   3.6416347657513475`*^9, 3.6416359533745213`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["30", "7"], ",", 
       FractionBox["15", "7"], ",", 
       FractionBox["20", "7"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "7"], ",", 
       FractionBox["25", "7"], ",", 
       FractionBox["15", "7"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "7"], ",", 
       FractionBox["15", "7"], ",", 
       FractionBox["45", "7"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{
     Rational[30, 7], 
     Rational[15, 7], 
     Rational[20, 7]}, {
     Rational[15, 7], 
     Rational[25, 7], 
     Rational[15, 7]}, {
     Rational[15, 7], 
     Rational[15, 7], 
     Rational[45, 7]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641216702518209*^9, 3.641216708919771*^9}, 
   3.6412615283663373`*^9, 3.6412925352974515`*^9, 3.6413573339925604`*^9, 
   3.6413685577033157`*^9, 3.6413834263648963`*^9, 3.6415728768841825`*^9, 
   3.6416347657513475`*^9, 3.6416359533745213`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"155", "-", 
     RowBox[{"28", " ", "x1"}], "-", 
     RowBox[{"35", " ", "x2"}], "+", 
     RowBox[{"14", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"180", "-", 
     RowBox[{"35", " ", "x1"}], "+", 
     RowBox[{"14", " ", "x2"}], "-", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"60", "+", 
     RowBox[{"14", " ", "x1"}], "-", 
     RowBox[{"21", " ", "x2"}], "-", 
     RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "40"}], "-", 
     RowBox[{"35", " ", "x1"}], "-", 
     RowBox[{"14", " ", "x2"}], "+", 
     RowBox[{"77", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "180"}], "-", 
     RowBox[{"35", " ", "x1"}], "+", 
     RowBox[{"182", " ", "x2"}], "-", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "60"}], "+", 
     RowBox[{"70", " ", "x1"}], "-", 
     RowBox[{"21", " ", "x2"}], "-", 
     RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.641216702518209*^9, 3.641216708919771*^9}, 
   3.6412615283663373`*^9, 3.6412925352974515`*^9, 3.6413573339925604`*^9, 
   3.6413685577033157`*^9, 3.6413834263648963`*^9, 3.6415728768841825`*^9, 
   3.6416347657513475`*^9, 3.6416359535464025`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "11"}], " ", "x1"}], "-", 
     RowBox[{"6", " ", "x2"}], "+", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"6", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], " ", "x1"}], "+", 
     RowBox[{"14", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"1035", "-", 
     RowBox[{"35", " ", "x1"}], "-", 
     RowBox[{"63", " ", "x2"}], "-", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.641216702518209*^9, 3.641216708919771*^9}, 
   3.6412615283663373`*^9, 3.6412925352974515`*^9, 3.6413573339925604`*^9, 
   3.6413685577033157`*^9, 3.6413834263648963`*^9, 3.6415728768841825`*^9, 
   3.6416347657513475`*^9, 3.641635953687033*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2860", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "241", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "158", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "83"}],
  SequenceForm[2860, " ", 241, " ", 158, " ", 83],
  Editable->False]], "Print",
 CellChangeTimes->{{3.641216702518209*^9, 3.641216708919771*^9}, 
   3.6412615283663373`*^9, 3.6412925352974515`*^9, 3.6413573339925604`*^9, 
   3.6413685577033157`*^9, 3.6413834263648963`*^9, 3.6415728768841825`*^9, 
   3.6416347657513475`*^9, 3.641635954267225*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{1.4285714285714286`, 1.4285714285714286`, 
    1.4285714285714286`}, {2.142857142857143, 2.142857142857143, 
    6.428571428571429}, {2.142857142857143, 3.5714285714285716`, 
    2.142857142857143}, {3.5714285714285716`, 3.5714285714285716`, 5.}, {
    4.285714285714286, 2.142857142857143, 2.857142857142857}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.8818566401002721, 0.6127387562532032, 0.90817081843213], Opacity[
     0.5]}], Polygon3DBox[{{2, 5, 4}, {1, 5, 2}, {1, 2, 3}, {2, 4, 3}, {4, 5, 
      3}, {5, 1, 3}}]}], 
   GraphicsComplex3DBox[{{2.857142857142857, 2.857142857142857, 
    2.857142857142857}, {4.285714285714286, 4.285714285714286, 
    12.857142857142858`}, {4.285714285714286, 7.142857142857143, 
    4.285714285714286}, {7.142857142857143, 7.142857142857143, 10.}, {
    8.571428571428571, 4.285714285714286, 5.714285714285714}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.4263663378082887, 0.47449653059733343`, 0.8486777447084273], Opacity[
     0.5]}], Polygon3DBox[{{2, 5, 4}, {1, 5, 2}, {1, 2, 3}, {2, 4, 3}, {4, 5, 
      3}, {5, 1, 3}}]}], 
   GraphicsComplex3DBox[{{4.285714285714286, 4.285714285714286, 
    4.285714285714286}, {6.428571428571429, 6.428571428571429, 
    19.285714285714285`}, {6.428571428571429, 10.714285714285714`, 
    6.428571428571429}, {10.714285714285714`, 10.714285714285714`, 15.}, {
    12.857142857142858`, 6.428571428571429, 8.571428571428571}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.7601087537575155, 0.30122505114009446`, 0.7633234727358003], Opacity[
     0.5]}], Polygon3DBox[{{2, 5, 4}, {1, 5, 2}, {1, 2, 3}, {2, 4, 3}, {4, 5, 
      3}, {5, 1, 3}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[
     NCache[{{Rational[30, 7], Rational[15, 7], Rational[20, 7]}, {
       Rational[15, 7], Rational[25, 7], Rational[15, 7]}, {
       Rational[15, 7], Rational[15, 7], Rational[45, 7]}}, {{
      4.285714285714286, 2.142857142857143, 2.857142857142857}, {
      2.142857142857143, 3.5714285714285716`, 2.142857142857143}, {
      2.142857142857143, 2.142857142857143, 6.428571428571429}}]]}, 
   {RGBColor[0, 0, 1], PointSize[Medium], Point3DBox[CompressedData["
1:eJwdT4uVwzAMykskQLLTdoWudCN0gdvoZj1R8iJbH0B+f35/PudxHH/zX8cX
p3GdZ5xnzjnfF3FdGcZERDBCERXRLmRGIpLTSSfIYIYyKg1kMlOZk3bmytyu
AQkmlKgkYImJdMe9uQhZyPagMUMCCpjKAjZwAw/gCbzcJEGBBTa4wA3eZoiQ
oILa7CJnV3uTKfPMnEsRTSxiEzfxoCFyCE0ucpM3OfUn+XJHoopqalGbuj1b
YhWrh6T0QrJ9CS0sYZtn5sy1uMSp3OLDYkZJLS0L1yw975lYhS4sy9tyDLo4
6S7eZU6Vur8vbC9k++aykJerf/qGD1E=
     "]]}, 
   {RGBColor[1, 0, 0], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[120, 7], Rational[60, 7], Rational[80, 7]}}, {{0, 0, 0}, {
       17.142857142857142`, 8.571428571428571, 11.428571428571429`}}]], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[60, 7], Rational[100, 7], Rational[60, 7]}}, {{0, 0, 0}, {
       8.571428571428571, 14.285714285714286`, 8.571428571428571}}]], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[60, 7], Rational[60, 7], Rational[180, 7]}}, {{0, 0, 0}, {
       8.571428571428571, 8.571428571428571, 25.714285714285715`}}]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{360.9722920654848, 374.2363595331157},
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All,
  ViewPoint->{0.20670738856142507`, -0.6375591488309423, 3.3167439435772073`},
  ViewVertical->{-0.7933801645235349, 0.8035407319258135, 
   0.7217757784836936}]], "Output",
 CellChangeTimes->{{3.6412167034058485`*^9, 3.6412167093410625`*^9}, 
   3.641261528870695*^9, 3.641292535999958*^9, 3.6413573347230864`*^9, 
   3.6413685586669903`*^9, 3.6413834272505164`*^9, 3.64157287948804*^9, 
   3.641634766970146*^9, 3.641635954501608*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cotaDeVV4", "=", 
  RowBox[{"boundCohenMacaulay", "[", "vv4", "]"}]}]], "Input",
 CellChangeTimes->{{3.640580407609665*^9, 3.640580429878476*^9}, {
  3.6406181949377985`*^9, 3.6406181966420174`*^9}, {3.6412167286817884`*^9, 
  3.6412167296674967`*^9}, {3.6412925462162046`*^9, 3.641292566618704*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635956954831*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["10", "7"], ",", 
     FractionBox["10", "7"], ",", 
     FractionBox["10", "7"], ",", 
     FractionBox["30", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["20", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["25", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["45", "7"], ",", 
     FractionBox["25", "7"], ",", 
     FractionBox["25", "7"], ",", "5"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[10, 7], 
    Rational[10, 7], 
    Rational[10, 7], 
    Rational[30, 7], 
    Rational[15, 7], 
    Rational[20, 7], 
    Rational[15, 7], 
    Rational[25, 7], 
    Rational[15, 7], 
    Rational[15, 7], 
    Rational[15, 7], 
    Rational[45, 7], 
    Rational[25, 7], 
    Rational[25, 7], 5}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635956970457*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "10", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "15", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "25", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15", ",", "45"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "25", ",", "35"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{10, 10, 10}, {30, 15, 20}, {15, 25, 15}, {15, 15, 45}, {25, 25, 
   35}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635956970457*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635956970457*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.6416359570173335`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2464.285714285714`", ",", "2464.285714285714`", ",", 
   "2464.285714285714`"}], "}"}]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.6416359571423388`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["30", "7"], ",", 
        FractionBox["15", "7"], ",", 
        FractionBox["20", "7"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "7"], ",", 
        FractionBox["25", "7"], ",", 
        FractionBox["15", "7"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "7"], ",", 
        FractionBox["15", "7"], ",", 
        FractionBox["45", "7"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[30, 7], 
      Rational[15, 7], 
      Rational[20, 7]}}, {{
      Rational[15, 7], 
      Rational[25, 7], 
      Rational[15, 7]}}, {{
      Rational[15, 7], 
      Rational[15, 7], 
      Rational[45, 7]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.6416359571423388`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["30", "7"], ",", 
      FractionBox["15", "7"], ",", 
      FractionBox["20", "7"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 1, "]]=", {{
     Rational[30, 7], 
     Rational[15, 7], 
     Rational[20, 7]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.6416359571423388`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["15", "7"], ",", 
      FractionBox["25", "7"], ",", 
      FractionBox["15", "7"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 2, "]]=", {{
     Rational[15, 7], 
     Rational[25, 7], 
     Rational[15, 7]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.6416359574099874`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["15", "7"], ",", 
      FractionBox["15", "7"], ",", 
      FractionBox["45", "7"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 3, "]]=", {{
     Rational[15, 7], 
     Rational[15, 7], 
     Rational[45, 7]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.6416359576707954`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[1]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["15", "4"], ",", 
         FractionBox["45", "14"], ",", 
         FractionBox["125", "28"]}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["400", "119"], ",", 
         FractionBox["355", "119"], ",", 
         FractionBox["370", "119"]}], "}"}], ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["pYk[[1]]=", {{{
      Rational[15, 4], 
      Rational[45, 14], 
      Rational[125, 28]}, 1}, {{
      Rational[400, 119], 
      Rational[355, 119], 
      Rational[370, 119]}, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957936431*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["17625", "14"], ",", 
   FractionBox["144750", "119"]}], "}"}]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957936431*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[2]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["355", "119"], ",", 
         FractionBox["55", "17"], ",", 
         FractionBox["355", "119"]}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["45", "14"], ",", 
         FractionBox["25", "7"], ",", 
         FractionBox["30", "7"]}], "}"}], ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["pYk[[2]]=", {{{
      Rational[355, 119], 
      Rational[55, 17], 
      Rational[355, 119]}, 1}, {{
      Rational[45, 14], 
      Rational[25, 7], 
      Rational[30, 7]}, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957936431*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11250", "7"], ",", 
   FractionBox["22125", "14"]}], "}"}]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957936431*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[3]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["45", "14"], ",", 
         FractionBox["45", "14"], ",", 
         FractionBox["75", "14"]}], "}"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["45", "14"], ",", 
         FractionBox["45", "14"], ",", 
         FractionBox["75", "14"]}], "}"}], ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["pYk[[3]]=", {{{
      Rational[45, 14], 
      Rational[45, 14], 
      Rational[75, 14]}, 1}, {{
      Rational[45, 14], 
      Rational[45, 14], 
      Rational[75, 14]}, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957952057*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["10125", "7"], ",", 
   FractionBox["10125", "7"]}], "}"}]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957952057*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximo=\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Maximo=", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957952057*^9}],

Cell[BoxData["\<\"--------------\"\>"], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957952057*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "781.5126050420168`"}],
  SequenceForm["daux=", 781.5126050420168],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957967683*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "4"], ",", 
       FractionBox["45", "14"], ",", 
       FractionBox["125", "28"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["400", "119"], ",", 
       FractionBox["355", "119"], ",", 
       FractionBox["370", "119"]}], "}"}]}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[15, 4], 
     Rational[45, 14], 
     Rational[125, 28]}, {
     Rational[400, 119], 
     Rational[355, 119], 
     Rational[370, 119]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957967683*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1258.9285714285713`", ",", "1216.3865546218487`"}], "}"}]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957967683*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.6416359579833083`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "1172.2689075630253`"}],
  SequenceForm["daux=", 1172.2689075630253`],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.6416359579833083`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["355", "119"], ",", 
       FractionBox["55", "17"], ",", 
       FractionBox["355", "119"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["45", "14"], ",", 
       FractionBox["25", "7"], ",", 
       FractionBox["30", "7"]}], "}"}]}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[355, 119], 
     Rational[55, 17], 
     Rational[355, 119]}, {
     Rational[45, 14], 
     Rational[25, 7], 
     Rational[30, 7]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.6416359579833083`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1607.142857142857`", ",", "1580.357142857143`"}], "}"}]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.6416359579833083`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957998934*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "830.3571428571429`"}],
  SequenceForm["daux=", 830.3571428571429],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957998934*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["45", "14"], ",", 
       FractionBox["45", "14"], ",", 
       FractionBox["75", "14"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["45", "14"], ",", 
       FractionBox["45", "14"], ",", 
       FractionBox["75", "14"]}], "}"}]}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[45, 14], 
     Rational[45, 14], 
     Rational[75, 14]}, {
     Rational[45, 14], 
     Rational[45, 14], 
     Rational[75, 14]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957998934*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1446.4285714285713`", ",", "1446.4285714285713`"}], "}"}]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.641635957998934*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.640618199894315*^9, 3.6406183098113103`*^9, 
  3.6410494901235523`*^9, 3.641086296663625*^9, 3.641103846868191*^9, 
  3.6412167320231767`*^9, 3.6412925694587092`*^9, 3.641357335721796*^9, 
  3.641368560377204*^9, 3.641383430654934*^9, 3.641572881267296*^9, 
  3.641634776707246*^9, 3.6416359580145597`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["15", "4"], ",", 
           FractionBox["45", "14"], ",", 
           FractionBox["125", "28"]}], "}"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["400", "119"], ",", 
           FractionBox["355", "119"], ",", 
           FractionBox["370", "119"]}], "}"}], ",", "1"}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["355", "119"], ",", 
           FractionBox["55", "17"], ",", 
           FractionBox["355", "119"]}], "}"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["45", "14"], ",", 
           FractionBox["25", "7"], ",", 
           FractionBox["30", "7"]}], "}"}], ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["45", "14"], ",", 
           FractionBox["45", "14"], ",", 
           FractionBox["75", "14"]}], "}"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["45", "14"], ",", 
           FractionBox["45", "14"], ",", 
           FractionBox["75", "14"]}], "}"}], ",", "1"}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["30", "7"], ",", 
        FractionBox["15", "7"], ",", 
        FractionBox["20", "7"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "7"], ",", 
        FractionBox["25", "7"], ",", 
        FractionBox["15", "7"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "7"], ",", 
        FractionBox["15", "7"], ",", 
        FractionBox["45", "7"]}], "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"30", ",", "15", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "25", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15", ",", "45"}], "}"}]}], "}"}], ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"155", "-", 
       RowBox[{"28", " ", "x1"}], "-", 
       RowBox[{"35", " ", "x2"}], "+", 
       RowBox[{"14", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"180", "-", 
       RowBox[{"35", " ", "x1"}], "+", 
       RowBox[{"14", " ", "x2"}], "-", 
       RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"60", "+", 
       RowBox[{"14", " ", "x1"}], "-", 
       RowBox[{"21", " ", "x2"}], "-", 
       RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "40"}], "-", 
       RowBox[{"35", " ", "x1"}], "-", 
       RowBox[{"14", " ", "x2"}], "+", 
       RowBox[{"77", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "180"}], "-", 
       RowBox[{"35", " ", "x1"}], "+", 
       RowBox[{"182", " ", "x2"}], "-", 
       RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "60"}], "+", 
       RowBox[{"70", " ", "x1"}], "-", 
       RowBox[{"21", " ", "x2"}], "-", 
       RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6412925703283267`*^9, 3.641357336731515*^9, 
  3.641368561685134*^9, 3.641383431577598*^9, 3.6415728822449975`*^9, 
  3.6416347777545004`*^9, 3.6416359580145597`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isCohenMacaulay", "[", 
  RowBox[{"vv4", ",", "cotaDeVV4"}], "]"}]], "Input",
 CellChangeTimes->{{3.640580444255678*^9, 3.640580452902813*^9}, {
  3.640618228610694*^9, 3.6406182298505807`*^9}, {3.641086310661595*^9, 
  3.6410863119695277`*^9}, {3.641216739147232*^9, 3.6412167402510123`*^9}, {
  3.6412925716432676`*^9, 3.641292577494422*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generators of the rays we use to check the CM condition: \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"30", ",", "15", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "25", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15", ",", "45"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Generators of the rays we use to check the CM condition: ", {{30, 15, 
   20}, {15, 25, 15}, {15, 15, 45}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6406182303999586`*^9, 3.6406183233729334`*^9, 3.6410494989368343`*^9, {
   3.6410863044992013`*^9, 3.6410863128581476`*^9}, 3.6411038523140707`*^9, 
   3.6412167430589967`*^9, 3.64129257789771*^9, 3.64135733783829*^9, 
   3.641368564448095*^9, 3.6413834383834352`*^9, 3.641572883686022*^9, 
   3.641634785770178*^9, 3.641635960260361*^9}],

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{
  3.6406182303999586`*^9, 3.6406183233729334`*^9, 3.6410494989368343`*^9, {
   3.6410863044992013`*^9, 3.6410863128581476`*^9}, 3.6411038523140707`*^9, 
   3.6412167430589967`*^9, 3.64129257789771*^9, 3.64135733783829*^9, 
   3.641368564448095*^9, 3.6413834383834352`*^9, 3.641572883686022*^9, 
   3.641634785770178*^9, 3.641635960260361*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["10", "7"], ",", 
     FractionBox["10", "7"], ",", 
     FractionBox["10", "7"], ",", 
     FractionBox["30", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["20", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["25", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["15", "7"], ",", 
     FractionBox["45", "7"], ",", 
     FractionBox["25", "7"], ",", 
     FractionBox["25", "7"], ",", "5"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[10, 7], 
    Rational[10, 7], 
    Rational[10, 7], 
    Rational[30, 7], 
    Rational[15, 7], 
    Rational[20, 7], 
    Rational[15, 7], 
    Rational[25, 7], 
    Rational[15, 7], 
    Rational[15, 7], 
    Rational[15, 7], 
    Rational[45, 7], 
    Rational[25, 7], 
    Rational[25, 7], 5}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6406182303999586`*^9, 3.6406183233729334`*^9, 3.6410494989368343`*^9, {
   3.6410863044992013`*^9, 3.6410863128581476`*^9}, 3.6411038523140707`*^9, 
   3.6412167430589967`*^9, 3.64129257789771*^9, 3.64135733783829*^9, 
   3.641368564448095*^9, 3.6413834383834352`*^9, 3.641572883686022*^9, 
   3.641634785770178*^9, 3.641635960260361*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "10", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "15", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "25", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "15", ",", "45"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "25", ",", "35"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{10, 10, 10}, {30, 15, 20}, {15, 25, 15}, {15, 15, 45}, {25, 25, 
   35}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6406182303999586`*^9, 3.6406183233729334`*^9, 3.6410494989368343`*^9, {
   3.6410863044992013`*^9, 3.6410863128581476`*^9}, 3.6411038523140707`*^9, 
   3.6412167430589967`*^9, 3.64129257789771*^9, 3.64135733783829*^9, 
   3.641368564448095*^9, 3.6413834383834352`*^9, 3.641572883686022*^9, 
   3.641634785770178*^9, 3.641635960260361*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6406182303999586`*^9, 3.6406183233729334`*^9, 3.6410494989368343`*^9, {
   3.6410863044992013`*^9, 3.6410863128581476`*^9}, 3.6411038523140707`*^9, 
   3.6412167430589967`*^9, 3.64129257789771*^9, 3.64135733783829*^9, 
   3.641368564448095*^9, 3.6413834383834352`*^9, 3.641572883686022*^9, 
   3.641634785770178*^9, 3.6416359602759867`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{
  3.6406182303999586`*^9, 3.6406183233729334`*^9, 3.6410494989368343`*^9, {
   3.6410863044992013`*^9, 3.6410863128581476`*^9}, 3.6411038523140707`*^9, 
   3.6412167430589967`*^9, 3.64129257789771*^9, 3.64135733783829*^9, 
   3.641368564448095*^9, 3.6413834383834352`*^9, 3.641572883686022*^9, 
   3.641634785770178*^9, 3.6416359603384895`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["30", "7"], ",", 
        FractionBox["15", "7"], ",", 
        FractionBox["20", "7"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "7"], ",", 
        FractionBox["25", "7"], ",", 
        FractionBox["15", "7"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["15", "7"], ",", 
        FractionBox["15", "7"], ",", 
        FractionBox["45", "7"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[30, 7], 
      Rational[15, 7], 
      Rational[20, 7]}}, {{
      Rational[15, 7], 
      Rational[25, 7], 
      Rational[15, 7]}}, {{
      Rational[15, 7], 
      Rational[15, 7], 
      Rational[45, 7]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6406182303999586`*^9, 3.6406183233729334`*^9, 3.6410494989368343`*^9, {
   3.6410863044992013`*^9, 3.6410863128581476`*^9}, 3.6411038523140707`*^9, 
   3.6412167430589967`*^9, 3.64129257789771*^9, 3.64135733783829*^9, 
   3.641368564448095*^9, 3.6413834383834352`*^9, 3.641572883686022*^9, 
   3.641634785770178*^9, 3.641635960447869*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["30", "7"], ",", 
       FractionBox["15", "7"], ",", 
       FractionBox["20", "7"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "7"], ",", 
       FractionBox["25", "7"], ",", 
       FractionBox["15", "7"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["15", "7"], ",", 
       FractionBox["15", "7"], ",", 
       FractionBox["45", "7"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{
     Rational[30, 7], 
     Rational[15, 7], 
     Rational[20, 7]}, {
     Rational[15, 7], 
     Rational[25, 7], 
     Rational[15, 7]}, {
     Rational[15, 7], 
     Rational[15, 7], 
     Rational[45, 7]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6406182303999586`*^9, 3.6406183233729334`*^9, 3.6410494989368343`*^9, {
   3.6410863044992013`*^9, 3.6410863128581476`*^9}, 3.6411038523140707`*^9, 
   3.6412167430589967`*^9, 3.64129257789771*^9, 3.64135733783829*^9, 
   3.641368564448095*^9, 3.6413834383834352`*^9, 3.641572883686022*^9, 
   3.641634785770178*^9, 3.641635960447869*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"155", "-", 
     RowBox[{"28", " ", "x1"}], "-", 
     RowBox[{"35", " ", "x2"}], "+", 
     RowBox[{"14", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"180", "-", 
     RowBox[{"35", " ", "x1"}], "+", 
     RowBox[{"14", " ", "x2"}], "-", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"60", "+", 
     RowBox[{"14", " ", "x1"}], "-", 
     RowBox[{"21", " ", "x2"}], "-", 
     RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "40"}], "-", 
     RowBox[{"35", " ", "x1"}], "-", 
     RowBox[{"14", " ", "x2"}], "+", 
     RowBox[{"77", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "180"}], "-", 
     RowBox[{"35", " ", "x1"}], "+", 
     RowBox[{"182", " ", "x2"}], "-", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "60"}], "+", 
     RowBox[{"70", " ", "x1"}], "-", 
     RowBox[{"21", " ", "x2"}], "-", 
     RowBox[{"7", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6406182303999586`*^9, 3.6406183233729334`*^9, 3.6410494989368343`*^9, {
   3.6410863044992013`*^9, 3.6410863128581476`*^9}, 3.6411038523140707`*^9, 
   3.6412167430589967`*^9, 3.64129257789771*^9, 3.64135733783829*^9, 
   3.641368564448095*^9, 3.6413834383834352`*^9, 3.641572883686022*^9, 
   3.641634785770178*^9, 3.641635960588499*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "11"}], " ", "x1"}], "-", 
     RowBox[{"6", " ", "x2"}], "+", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"6", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], " ", "x1"}], "+", 
     RowBox[{"14", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"345", "-", 
     RowBox[{"35", " ", "x1"}], "-", 
     RowBox[{"63", " ", "x2"}], "-", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6406182303999586`*^9, 3.6406183233729334`*^9, 3.6410494989368343`*^9, {
   3.6410863044992013`*^9, 3.6410863128581476`*^9}, 3.6411038523140707`*^9, 
   3.6412167430589967`*^9, 3.64129257789771*^9, 3.64135733783829*^9, 
   3.641368564448095*^9, 3.6413834383834352`*^9, 3.641572883686022*^9, 
   3.641634785770178*^9, 3.641635960713505*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "140", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm[140, " ", 13, " ", 7, " ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6406182303999586`*^9, 3.6406183233729334`*^9, 3.6410494989368343`*^9, {
   3.6410863044992013`*^9, 3.6410863128581476`*^9}, 3.6411038523140707`*^9, 
   3.6412167430589967`*^9, 3.64129257789771*^9, 3.64135733783829*^9, 
   3.641368564448095*^9, 3.6413834383834352`*^9, 3.641572883686022*^9, 
   3.641634785770178*^9, 3.641635960776007*^9}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.6406182306001096`*^9, 3.6406183239883604`*^9, 3.6410494991890216`*^9, {
   3.6410863046883354`*^9, 3.641086313038289*^9}, 3.6411038524992056`*^9, 
   3.641216743663433*^9, 3.641292578478113*^9, 3.6413573383466673`*^9, 
   3.641368564935444*^9, 3.641383438949839*^9, 3.641572884229422*^9, 
   3.6416347863927755`*^9, 3.6416359608853865`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "Section",
 CellChangeTimes->{{3.640117722741181*^9, 3.6401177238609653`*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6410491101147895`*^9, 3.641049111068471*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", 
   RowBox[{"\"\<convexHullSemigroups3D`\>\"", ",", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
     "\"\<\\\\convexHullSemigroups3DLibraryV6.wl\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{3.6416212540791197`*^9}],

Cell[BoxData["\<\"J. I. Garc\[IAcute]a-Garc\[IAcute]a and A. \
Vigneron-Tenorio,\\nDpto. Matem\[AAcute]ticas, \\nUniversidad de \
C\[AAcute]diz\\nignacio.garcia@uca.es, alberto.vigneron@uca.es\\n\\nThis \
package contains the commands: \\n....\\nTry command::usage for more \
help\"\>"], "Print",
 CellChangeTimes->{{3.6416359774039736`*^9, 3.6416360202503*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"configuration", "[", 
   RowBox[{
   "\"\<C:\\\\tmp\\\\lrs\\\\lrs.exe\>\"", ",", "\"\<C:\\\\tmp\\\\\>\"", ",", 
    "\"\<C:\\\\tmp\\\\Normaliz2.12\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"showConfiguration", "[", "]"}]}], "Input",
 CellChangeTimes->{{3.64104912673164*^9, 3.6410491300119753`*^9}, 
   3.641049284252866*^9, {3.6411073213478384`*^9, 3.641107352088739*^9}, {
   3.6411074438150835`*^9, 3.64110744640294*^9}, {3.641291681429268*^9, 
   3.6412916825410633`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C:\\\\tmp\\\\lrs\\\\lrs.exe\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\Normaliz2.12\"\>"}],
  SequenceForm[
  "C:\\tmp\\lrs\\lrs.exe", "\n", "C:\\tmp\\", "\n", "C:\\tmp\\Normaliz2.12"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6413662482523184`*^9, 3.6413663393069677`*^9, {3.6413686223382125`*^9, 
   3.6413686491382446`*^9}, 3.6413834588119373`*^9, {3.6416359780289984`*^9, 
   3.641636020915183*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vv1", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "12", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.6401177258884125`*^9, 3.6401177804621353`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "12", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.640117781587932*^9, 3.6405029260613213`*^9, 3.640577306770627*^9, 
   3.6405805157403975`*^9, 3.641049507253768*^9, 3.6410495432754345`*^9, 
   3.6410863239150352`*^9, 3.6410875986212883`*^9, 3.6410978102379084`*^9, {
   3.6410979039516892`*^9, 3.641097925786236*^9}, 3.6411038553072033`*^9, 
   3.6412167574192057`*^9, 3.64126154983459*^9, 3.6412925833165584`*^9, 
   3.6412926212414894`*^9, 3.6413559362840405`*^9, 3.64135617503959*^9, 
   3.6413573444670067`*^9, 3.641359345269978*^9, {3.641361178307199*^9, 
   3.641361212288319*^9}, 3.64136516710459*^9, 3.641365202506729*^9, {
   3.641366233219635*^9, 3.6413662490228662`*^9}, 3.6413663499235067`*^9, 
   3.641368575461926*^9, {3.6413686248529987`*^9, 3.6413686497877054`*^9}, {
   3.641383444305637*^9, 3.6413834596345234`*^9}, 3.6416347993157897`*^9, {
   3.6416359650287275`*^9, 3.6416360284127674`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vv1C", "=", 
  RowBox[{"vv1", "~", "Join", "~", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0.", ",", "0.", ",", "0."}], "}"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.6410976658240194`*^9, 3.6410976852778826`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "12", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6410976858412805`*^9, 3.6410978131299753`*^9, 3.6410979266218414`*^9, 
   3.641103857550812*^9, 3.641216758728133*^9, 3.641292585125843*^9, 
   3.641292622336258*^9, 3.641355937113638*^9, 3.6413561759242134`*^9, 
   3.6413573456308236`*^9, 3.641359346670964*^9, {3.6413611791788173`*^9, 
   3.6413612130268435`*^9}, 3.6413651688067894`*^9, 3.6413652031351757`*^9, {
   3.6413662341453066`*^9, 3.6413662498154297`*^9}, 3.6413685775864344`*^9, {
   3.641368625648555*^9, 3.641368651120652*^9}, {3.6413834456265764`*^9, 
   3.641383460386056*^9}, 3.6416348001891947`*^9, {3.641635965843877*^9, 
   3.641635993144184*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ConvexHullMesh", "[", "vv1C", "]"}], ",", 
   RowBox[{"ConvexHullMesh", "[", "vv1", "]"}]}], "}"}]], "Input",
 CellChangeTimes->{{3.6410976888724422`*^9, 3.6410977082382426`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    TagBox[
     DynamicModuleBox[{Typeset`mesh = HoldComplete[
       BoundaryMeshRegion[{{0., 0., 14.}, {0., 12., 0.}, {0., 0., 0.}, {7., 
        0., 0.}}, {
         Polygon[{{4, 1, 3}, {1, 2, 3}, {1, 4, 2}, {2, 4, 3}}]}, 
        Method -> {
         "EliminateUnusedCoordinates" -> True, "DeleteDuplicateCoordinates" -> 
          Automatic, "VertexAlias" -> Identity, "CheckOrientation" -> True, 
          "CoplanarityTolerance" -> Automatic, "CheckIntersections" -> 
          Automatic, "BoundaryNesting" -> {{0, 0}}, "SeparateBoundaries" -> 
          False, "PropagateMarkers" -> True, "Hash" -> 
          8094964827850377929}]]}, 
      TagBox[
       GraphicsComplex3DBox[{{0., 0., 14.}, {0., 12., 0.}, {0., 0., 0.}, {7., 
        0., 0.}}, 
        {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], 
         Polygon3DBox[{{4, 1, 3}, {1, 2, 3}, {1, 4, 2}, {2, 4, 3}}]}],
       MouseAppearanceTag["LinkHand"]],
      AllowKernelInitialization->False],
     "MeshGraphics",
     AutoDelete->True,
     Editable->False,
     Selectable->False],
    Boxed->False,
    DefaultBaseStyle->{
     "Graphics3D", FrontEnd`GraphicsHighlightColor -> Hue[0.1, 1, 0.7]},
    Lighting->{{"Ambient", 
       GrayLevel[0.45]}, {"Directional", 
       GrayLevel[0.3], 
       ImageScaled[{2, 0, 2}]}, {"Directional", 
       GrayLevel[0.33], 
       ImageScaled[{2, 2, 2}]}, {"Directional", 
       GrayLevel[0.3], 
       ImageScaled[{0, 2, 2}]}},
    Method->{"ShrinkWrap" -> True}], ",", 
   Graphics3DBox[
    TagBox[
     DynamicModuleBox[{Typeset`mesh = HoldComplete[
       BoundaryMeshRegion[{{0., 0., 9.}, {0., 0., 14.}, {0., 8., 0.}, {0., 
        12., 0.}, {5., 0., 0.}, {7., 0., 0.}}, {
         Polygon[{{4, 6, 3}, {6, 5, 3}, {1, 5, 6}, {4, 2, 6}, {2, 1, 6}, {5, 
          1, 3}, {1, 2, 3}, {2, 4, 3}}]}, 
        Method -> {
         "EliminateUnusedCoordinates" -> True, "DeleteDuplicateCoordinates" -> 
          Automatic, "VertexAlias" -> Identity, "CheckOrientation" -> True, 
          "CoplanarityTolerance" -> Automatic, "CheckIntersections" -> 
          Automatic, "BoundaryNesting" -> {{0, 0}}, "SeparateBoundaries" -> 
          False, "PropagateMarkers" -> True, "Hash" -> 
          1209256734805569150}]]}, 
      TagBox[
       GraphicsComplex3DBox[{{0., 0., 9.}, {0., 0., 14.}, {0., 8., 0.}, {0., 
        12., 0.}, {5., 0., 0.}, {7., 0., 0.}}, 
        {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], 
         Polygon3DBox[{{4, 6, 3}, {6, 5, 3}, {1, 5, 6}, {4, 2, 6}, {2, 1, 
          6}, {5, 1, 3}, {1, 2, 3}, {2, 4, 3}}]}],
       MouseAppearanceTag["LinkHand"]],
      AllowKernelInitialization->False],
     "MeshGraphics",
     AutoDelete->True,
     Editable->False,
     Selectable->False],
    Boxed->False,
    DefaultBaseStyle->{
     "Graphics3D", FrontEnd`GraphicsHighlightColor -> Hue[0.1, 1, 0.7]},
    Lighting->{{"Ambient", 
       GrayLevel[0.45]}, {"Directional", 
       GrayLevel[0.3], 
       ImageScaled[{2, 0, 2}]}, {"Directional", 
       GrayLevel[0.33], 
       ImageScaled[{2, 2, 2}]}, {"Directional", 
       GrayLevel[0.3], 
       ImageScaled[{0, 2, 2}]}},
    Method->{"ShrinkWrap" -> True}]}], "}"}]], "Output",
 CellChangeTimes->{{3.641097693589805*^9, 3.641097708631518*^9}, 
   3.6410978147481284`*^9, 3.6410979274834547`*^9, 3.641103858532501*^9, 
   3.641216759764869*^9, 3.6412925861405554`*^9, 3.6412926231038165`*^9, 
   3.641355938328499*^9, 3.6413561771901164`*^9, 3.641357346541471*^9, 
   3.6413593483401585`*^9, {3.6413611800614448`*^9, 3.6413612137123303`*^9}, 
   3.6413651698975735`*^9, 3.64136520378964*^9, {3.6413662350439386`*^9, 
   3.641366250575972*^9}, 3.6413685798010063`*^9, {3.641368626180932*^9, 
   3.6413686520903397`*^9}, {3.6413834468074045`*^9, 3.641383461101595*^9}, 
   3.6416348011801653`*^9, {3.6416359683253946`*^9, 3.64163599433641*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ineqVV1", "=", 
  RowBox[{"facesOfConvexLRS", "[", "vv1", "]"}]}]], "Input",
 CellChangeTimes->{{3.641360724224755*^9, 3.641360727956404*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x1", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"84", "-", 
     RowBox[{"12", " ", "x1"}], "-", 
     RowBox[{"7", " ", "x2"}], "-", 
     RowBox[{"6", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "360"}], "+", 
     RowBox[{"72", " ", "x1"}], "+", 
     RowBox[{"45", " ", "x2"}], "+", 
     RowBox[{"40", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6413607283917007`*^9, 3.6413611848118124`*^9, 3.6413612263403063`*^9, {
   3.641365171896983*^9, 3.641365204789341*^9}, 3.641365259198986*^9, {
   3.641366236822193*^9, 3.641366251311491*^9}, 3.641366342551281*^9, 
   3.641368582894204*^9, {3.641368627721036*^9, 3.6413686531020584`*^9}, {
   3.641383448575659*^9, 3.641383461958172*^9}, 3.641634802468421*^9, {
   3.6416359691721916`*^9, 3.641635997003068*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["vv1"], "Input",
 CellChangeTimes->{{3.641368639314258*^9, 3.6413686400347805`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "12", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.641368640354007*^9, 3.641368654263884*^9}, {
   3.641383449832552*^9, 3.641383462765745*^9}, 3.641634805643733*^9, {
   3.641635970053921*^9, 3.6416360316779256`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqOfPlane", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.6413561932275085`*^9, 3.6413562230757017`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"360", "-", 
    RowBox[{"72", " ", "x1"}], "-", 
    RowBox[{"45", " ", "x2"}], "-", 
    RowBox[{"40", " ", "x3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "72"}], ",", 
     RowBox[{"-", "45"}], ",", 
     RowBox[{"-", "40"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6413562238292356`*^9, 3.641357351233802*^9, 3.6413593504366474`*^9, 
   3.641361186866273*^9, 3.641361227589194*^9, 3.641365173355028*^9, 
   3.641365206456534*^9, {3.6413662380030413`*^9, 3.6413662521991425`*^9}, 
   3.6413663442214675`*^9, 3.641368584237158*^9, {3.641368628787793*^9, 
   3.6413686569638023`*^9}, 3.6413834642878265`*^9, 3.6416348067439427`*^9, 
   3.6416359707480984`*^9, {3.6416360063485036`*^9, 3.641636032710085*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqOfPlane", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "12", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.641360343976739*^9, 3.641360348675076*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1176", "-", 
    RowBox[{"168", " ", "x1"}], "-", 
    RowBox[{"98", " ", "x2"}], "-", 
    RowBox[{"84", " ", "x3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "168"}], ",", 
     RowBox[{"-", "98"}], ",", 
     RowBox[{"-", "84"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.641360349110381*^9, 3.6413612286859627`*^9, 
  3.641365174639941*^9, 3.641365208573037*^9, 3.641366253077746*^9, 
  3.6413685867489405`*^9, 3.6413686579214816`*^9, 3.6413834657828875`*^9, 
  3.6416348077503386`*^9, 3.6416360338351297`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vv1", ",", "3", ",", "False", ",", "True", ",", "True"}], "]"}], 
   "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.641097991560113*^9, 3.6410980009427996`*^9}, {
  3.6412167796640034`*^9, 3.641216792173883*^9}, {3.641292634016557*^9, 
  3.641292654321977*^9}, {3.6413559571178465`*^9, 3.6413559572339215`*^9}, {
  3.641356342496504*^9, 3.641356342605584*^9}, {3.641359509694298*^9, 
  3.641359550639385*^9}, {3.6413600042414913`*^9, 3.641360014119504*^9}, {
  3.641360058785221*^9, 3.641360094586644*^9}, {3.6413601844304433`*^9, 
  3.641360194089291*^9}, {3.6413663758959627`*^9, 3.6413663759690104`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.641368659809822*^9, 3.6413834691262627`*^9, 
  3.6416348111609287`*^9, 3.6416360350426793`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "0", ",", "0", ",", "7", ",", "0", ",", "0", ",", "0", ",", "8",
      ",", "0", ",", "0", ",", "12", ",", "0", ",", "0", ",", "0", ",", "9", 
     ",", "0", ",", "0", ",", "14"}], "}"}]}],
  SequenceForm[
  "lptos de pintaAux=", {5, 0, 0, 7, 0, 0, 0, 8, 0, 0, 12, 0, 0, 0, 9, 0, 0, 
   14}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641368659809822*^9, 3.6413834691262627`*^9, 
  3.6416348111609287`*^9, 3.6416360350426793`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "12", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{5, 0, 0}, {7, 0, 0}, {0, 8, 0}, {0, 12, 0}, {0, 0, 9}, {0, 0, 14}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641368659809822*^9, 3.6413834691262627`*^9, 
  3.6416348111609287`*^9, 3.6416360350426793`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641368659809822*^9, 3.6413834691262627`*^9, 
  3.6416348111609287`*^9, 3.641636035058305*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.641368659809822*^9, 3.6413834691262627`*^9, 
  3.6416348111609287`*^9, 3.6416360350739307`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "12", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "vTriangulo=", {{{5, 0, 0}, {7, 0, 0}}, {{0, 8, 0}, {0, 12, 0}}, {{0, 0, 
   9}, {0, 0, 14}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641368659809822*^9, 3.6413834691262627`*^9, 
  3.6416348111609287`*^9, 3.641636036134162*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "9"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{5, 0, 0}, {0, 8, 0}, {0, 0, 9}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641368659809822*^9, 3.6413834691262627`*^9, 
  3.6416348111609287`*^9, 3.641636036149788*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x1", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"84", "-", 
     RowBox[{"12", " ", "x1"}], "-", 
     RowBox[{"7", " ", "x2"}], "-", 
     RowBox[{"6", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "360"}], "+", 
     RowBox[{"72", " ", "x1"}], "+", 
     RowBox[{"45", " ", "x2"}], "+", 
     RowBox[{"40", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.641368659809822*^9, 3.6413834691262627`*^9, 
  3.6416348111609287`*^9, 3.6416360363060436`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x1", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"1080", "-", 
     RowBox[{"72", " ", "x1"}], "-", 
     RowBox[{"45", " ", "x2"}], "-", 
     RowBox[{"40", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.641368659809822*^9, 3.6413834691262627`*^9, 
  3.6416348111609287`*^9, 3.641636036440098*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "35002", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "2002", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "1475", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "527"}],
  SequenceForm[35002, " ", 2002, " ", 1475, " ", 527],
  Editable->False]], "Print",
 CellChangeTimes->{3.641368659809822*^9, 3.6413834691262627`*^9, 
  3.6416348111609287`*^9, 3.641636040945862*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{0., 0., 9.}, {0., 0., 14.}, {0., 8., 0.}, {0., 12., 
    0.}, {5., 0., 0.}, {7., 0., 0.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.9074514514958814, 0.8516950118995337, 0.8207301510602472], Opacity[
     0.5]}], Polygon3DBox[{{4, 6, 3}, {6, 5, 3}, {1, 5, 6}, {4, 2, 6}, {2, 1, 
      6}, {5, 1, 3}, {1, 2, 3}, {2, 4, 3}}]}], 
   GraphicsComplex3DBox[{{0., 0., 18.}, {0., 0., 28.}, {0., 16., 0.}, {0., 
    24., 0.}, {10., 0., 0.}, {14., 0., 0.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.20360811732728812`, 0.4240775529218326, 0.5113321597695959], Opacity[
     0.5]}], Polygon3DBox[{{4, 6, 3}, {6, 5, 3}, {1, 5, 6}, {4, 2, 6}, {2, 1, 
      6}, {5, 1, 3}, {1, 2, 3}, {2, 4, 3}}]}], 
   GraphicsComplex3DBox[{{0., 0., 27.}, {0., 0., 42.}, {0., 24., 0.}, {0., 
    36., 0.}, {15., 0., 0.}, {21., 0., 0.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.4492336201653875, 0.308870985683666, 0.882765038966081], Opacity[
     0.5]}], Polygon3DBox[{{4, 6, 3}, {6, 5, 3}, {1, 5, 6}, {4, 2, 6}, {2, 1, 
      6}, {5, 1, 3}, {1, 2, 3}, {2, 4, 3}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[{{5, 0, 0}, {7, 0, 0}, {0, 8, 0}, {0, 12, 0}, {0, 0, 9}, {0, 0,
      14}}]}, 
   {GrayLevel[0], PointSize[Medium], Point3DBox[CompressedData["
1:eJwlVOvRIzcMA8CXHrv+LnMVpKWUcA2k/38hHY3tWa8kEgRA/v3n33/+CMBP
/xhmEfj/2YEAEihg9QngF/DX7JOgQAMdDDDBAl/wA/6AvyaACAkyyKGAEnqg
F/pAPxPeCBPMYA4L2IU9sBf2mcxOuOAGd/iBX/gDfwdRECGEITbiIC7iGZhJ
pJALuZEHeQd4EZWoQi3URh2swEqswlrYjh3YiV04huM4gZO4wjVcxw08xCM8
hsfxAi/xCq/hA3yIj4aYHw4rw0uX3YU1+kbZgDp9X+hzP8SvoW2WSCOdDDLJ
Sz7kS37In+G19yXKKKcOdamHeofvvmeiGW3TDu3SnhGhg7noi77ph35Hlg4f
xViMzTijUiazmIu5Wc4KVrKKtbiMy7mCK7mKW9zG7dzBnTzkEY/xOC8G8hWv
8cFgfzTiTwVf5cccrX2r2xK2VM1mM9isfcYUU3+X12U04k7TcTvWhBi/zF4v
k5a0pSNd6RkfNR/92kq2ZFt2ZHfM5Skv+ZJvRShSUYqldGUoU1kqqUzlqlCl
Fif8Mi3XCm1oc7Jt03YdDOud+Zguhv6BAP3W2HZ83w9t3G1jmjbKM14eURtj
2VDZ3DVZdww+paZN+s7XCc5Y3sIszcpsmW1zNw/zNC/zNZvhFmGRlpqD6ZZh
BSsOAX2v3BZscciYGBhHDCv4+gL2+9tG06LlWD5eP9NVDGf6yN96d7XuCh+y
mp3lZj5oOn2nLJ/t/t8r3NODHhqk/S/CE54c+ht4uhe8+JUCXyd2v4Z/PBCB
DFQ3XtAmBiOYbb6QQjYhR7mukGGa6oeOToAYuBoyJmEH4ig8xCCSX6kxHq8T
r8VH8dM2t8HV+8ju/JweU9IGad+YHviZOSGmNOwOfKQxR6cuGzkENZoG3aeR
tXJV7syX+emh0sNOI0WXO8m7yVnUKNPV8y2hxHHcmPUpQ40t2gG3lajqeFHb
61hdrZmtXNBXTCxyvMm7hCUunWVYtpevVf21tbUO18VGf7iJzd3vtnXI3BE7
fZf26rc4rKM8Fsf9hJ3U6TlX3cHVA+Iyu3+u2XXd4E08PUm/A+X5tlzb+jF9
x569M6E0k68bdYZfTyv8B8nFGtw=
     "]]}, 
   {RGBColor[1, 0, 0], Line3DBox[{{0, 0, 0}, {20, 0, 0}}], 
    Line3DBox[{{0, 0, 0}, {0, 32, 0}}], Line3DBox[{{0, 0, 0}, {0, 0, 36}}]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{244.94796239200778`, 418.14260299411603`},
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All,
  ViewPoint->{0.5844356460165231, -2.962274634532271, 1.5275352582745678`},
  ViewVertical->{-0.11105007609140649`, -0.2095875707165666, 
   0.9821629748027061}]], "Output",
 CellChangeTimes->{
  3.641365175802767*^9, 3.641365243089548*^9, 3.6413662553383503`*^9, {
   3.641366361625826*^9, 3.6413663796306114`*^9}, 3.6413685877776613`*^9, 
   3.6413686633573403`*^9, 3.641383472603731*^9, 3.6416348161964703`*^9, 
   3.6416360411177454`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"convexo", "=", 
   RowBox[{"ConvexHullMesh", "[", "vv1", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6413662902391376`*^9, 3.6413662975713444`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"distanciaMinimalAlOrigen", "[", "convexo", "]"}]], "Input",
 CellChangeTimes->{{3.641364740058215*^9, 3.641364755384099*^9}, {
  3.641364878819882*^9, 3.641364901969319*^9}, {3.641365004230937*^9, 
  3.6413650167288103`*^9}, {3.641366285837012*^9, 3.641366300195208*^9}}],

Cell[BoxData["3.835651982696635`"], "Output",
 CellChangeTimes->{3.6413664699697533`*^9, 3.6413686726089106`*^9, 
  3.641383477056903*^9, 3.6416348186580267`*^9, 3.641636041430258*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"lfuera", "=", 
   RowBox[{
    RowBox[{"chSemigroup", "[", 
     RowBox[{"vv1", ",", "2", ",", "False", ",", "True", ",", "True"}], "]"}],
     "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6413612572862844`*^9, 3.641361269397879*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.641361269946263*^9, 3.6413664804331913`*^9, 
  3.641368675734131*^9, 3.641383512178833*^9, 3.6416348212780848`*^9, 
  3.6416360443133554`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "0", ",", "0", ",", "7", ",", "0", ",", "0", ",", "0", ",", "8",
      ",", "0", ",", "0", ",", "12", ",", "0", ",", "0", ",", "0", ",", "9", 
     ",", "0", ",", "0", ",", "14"}], "}"}]}],
  SequenceForm[
  "lptos de pintaAux=", {5, 0, 0, 7, 0, 0, 0, 8, 0, 0, 12, 0, 0, 0, 9, 0, 0, 
   14}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641361269946263*^9, 3.6413664804331913`*^9, 
  3.641368675734131*^9, 3.641383512178833*^9, 3.6416348212780848`*^9, 
  3.6416360443133554`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "12", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{5, 0, 0}, {7, 0, 0}, {0, 8, 0}, {0, 12, 0}, {0, 0, 9}, {0, 0, 14}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641361269946263*^9, 3.6413664804331913`*^9, 
  3.641368675734131*^9, 3.641383512178833*^9, 3.6416348212780848`*^9, 
  3.6416360443133554`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641361269946263*^9, 3.6413664804331913`*^9, 
  3.641368675734131*^9, 3.641383512178833*^9, 3.6416348212780848`*^9, 
  3.6416360443133554`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.641361269946263*^9, 3.6413664804331913`*^9, 
  3.641368675734131*^9, 3.641383512178833*^9, 3.6416348212780848`*^9, 
  3.641636044344606*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "12", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "vTriangulo=", {{{5, 0, 0}, {7, 0, 0}}, {{0, 8, 0}, {0, 12, 0}}, {{0, 0, 
   9}, {0, 0, 14}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641361269946263*^9, 3.6413664804331913`*^9, 
  3.641368675734131*^9, 3.641383512178833*^9, 3.6416348212780848`*^9, 
  3.641636044453985*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "9"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{5, 0, 0}, {0, 8, 0}, {0, 0, 9}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641361269946263*^9, 3.6413664804331913`*^9, 
  3.641368675734131*^9, 3.641383512178833*^9, 3.6416348212780848`*^9, 
  3.641636044469611*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x1", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"84", "-", 
     RowBox[{"12", " ", "x1"}], "-", 
     RowBox[{"7", " ", "x2"}], "-", 
     RowBox[{"6", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "360"}], "+", 
     RowBox[{"72", " ", "x1"}], "+", 
     RowBox[{"45", " ", "x2"}], "+", 
     RowBox[{"40", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.641361269946263*^9, 3.6413664804331913`*^9, 
  3.641368675734131*^9, 3.641383512178833*^9, 3.6416348212780848`*^9, 
  3.641636044610242*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x1", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"720", "-", 
     RowBox[{"72", " ", "x1"}], "-", 
     RowBox[{"45", " ", "x2"}], "-", 
     RowBox[{"40", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.641361269946263*^9, 3.6413664804331913`*^9, 
  3.641368675734131*^9, 3.641383512178833*^9, 3.6416348212780848`*^9, 
  3.6416360447196207`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10875", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "656", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "201", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "455"}],
  SequenceForm[10875, " ", 656, " ", 201, " ", 455],
  Editable->False]], "Print",
 CellChangeTimes->{3.641361269946263*^9, 3.6413664804331913`*^9, 
  3.641368675734131*^9, 3.641383512178833*^9, 3.6416348212780848`*^9, 
  3.641636046157073*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lprp", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"lfuera", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"360", "-", 
         RowBox[{"72", " ", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "-", 
         RowBox[{"45", " ", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "-", 
         RowBox[{"40", " ", 
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}], "<=", "0"}], ")"}], "\[And]", 
      " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1176", "-", 
         RowBox[{"168", " ", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "-", 
         RowBox[{"98", " ", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "-", 
         RowBox[{"84", " ", 
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}], "\[GreaterEqual]", "0"}], 
       ")"}]}], "&"}]}], " ", "]"}]}]], "Input",
 CellChangeTimes->{{3.6413604696519794`*^9, 3.6413606417011538`*^9}}],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.6413612852771587`*^9, 3.641366489807849*^9, 
  3.6413686772321978`*^9, 3.6413835177337785`*^9, 3.6416348241982155`*^9, 
  3.6416360462956467`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ContourPlot3D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"360", "-", 
        RowBox[{"72", " ", "x1"}], "-", 
        RowBox[{"45", " ", "x2"}], "-", 
        RowBox[{"40", " ", "x3"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"x1", ",", "0", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x2", ",", "0", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x3", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ContourPlot3D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1176", "-", 
        RowBox[{"168", " ", "x1"}], "-", 
        RowBox[{"98", " ", "x2"}], "-", 
        RowBox[{"84", " ", "x3"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"x1", ",", "0", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x2", ",", "0", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x3", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
    RowBox[{"ListPointPlot3D", "[", 
     RowBox[{"lfuera", ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Black"}], "}"}]}]}],
      "]"}]}], "}"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.641360144589153*^9, 3.6413601644132185`*^9}, {
  3.6413602572521534`*^9, 3.6413602611329007`*^9}, {3.6413603616532784`*^9, 
  3.641360453418455*^9}, {3.6413606541740103`*^9, 3.641360661086918*^9}, {
  3.6413665145964537`*^9, 3.6413665156301765`*^9}}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxlWwk01N8XnzFjjLFLtkK7ijZSKZpvQtojaU8oVNrTQrKVVCp7KkTatSmJ
yJISkV9SVJI9sg1j3//+53Tv68yc8zvnd/r06fPuu+/e+973vjdjbfdb7BSh
0WhWDBpt+D9aXqHs3uyGbq4ny2iQmSFPBeX/9Bz5ookr4XMlqeZEC+J57ptE
D5UPcON0S6ZvH8Hjfjj0PP2WpyLyD+dNmqBW24S4qMhJsfoCHuImNyfPvrFt
BOo8tDcvHeNbjvqaK6puaR9mUcAHfHn+5rA8BxriXyP66mXFZJG/Ycqz+LrO
AeTfSc+XD1tbxAV8XOWBsunJsmjnRacttmfSutBOpZiZ2uk9cQuBH/Q7YvJr
eQXEB9PmywyW9HAPzY4+9oEmjfYDH/CU5Y9mnXft5C5tWv528p1WxAXnBXhV
5upy+ddsSpZ7e6yfYyXijhtUlozplMLxYV6rG79Yq9YS/P7416neSfJCfNXJ
9WLycoo4rvXMgst61j9xvmA/8AH3Ud+wNPuwKPVqymvz8s4sbjTrZUlo/wA3
NLU01I2rivqAv15os9srYBTij7WdsuJ20ingr/Mv8bCvT+VWbE7ln3dnUc6J
b94xThF/A9662MG0zF4JcX+9rA35CmzkP3p3gx3s04b2WD67234uRR79CXjy
k1s+JQUKiNdOWRxX90SEAn5LjY2rW/Rv5IO+63dn+22hfLQT/Ak6gBeZ2bvq
hMkinqMTsVjUWhz5sZlPnq/dJobzANzg6L09Y91YJJ5S18SmXZBB/Kz5rrIt
a95xgf/LvsuRpzCI6wN2QrxhXDTvSPI5Q3D5tBncrAhnnNeH0W0bbScycFzw
Q9ykX75LHolQgw8qY2a0N+G4oAN4xNlJj0uXyyPO8P799VFtPfofcOO1d2Vk
P/eizsfS/AqF+TKoD3mXW9x1Mn9QCvHtd15c4+q0IT515dHAlG985MvyJb6L
Mkgewv8fhY9/b5guj/h/Ei4H/WdXcgF/vqfcp1KtHP1kZ7jGx79DDvmgHzQ+
JtP9gRzaA38/7cGRLW0x0hTECeBgJ+COVuV7S7a84dYUVj2b8UwG9SG/gB/R
xH4pVf+VC3hk5fqfFk2FqLun5lz4vIoxQvNczNpP7RYZhzjMC/igs3l5qEm1
iLrQvwcc/AP4r5e6OluZZLyiWU/XntT+hOue8LbboYtG9ACPvn3DWStXA/Hw
JRMcp+7tQD7MF/6+J6q46qCkCFXgp/513496HF+Qf3RGSInLKBr+uzD3KWLW
kd+4I8omeBsbqWLdhr8H3CU6YWcjrRfxvpnG16anjxbajxLurHObliC8T2nG
emUlS5G6prfzkMqPV404rqA/z2srmUc5qmD9XFQ4VJLvT6OgPgPv57ypsXtW
3MN6DvkCfw+4ZOnkBXOmjUD84MIxDfWZhF/O2mTTMolOAR/sn3+ggFWySBRx
+PcXdjtJmVyRwD9D/W+cI+87ni6BcQ72B368VjnvNwtx4ENdAlyvtTB4r7IY
FTYz56W2ngjGv+D+C/iBRZ9Mdk2QRJ22BdHpxuwW5POvUluV1rBQB+wBfsLK
dTVu9gT/HqPl118sSkEdBj/09O/TkbhBR1xQB/SLTR/3z1lG8OQnzDObbUVR
B+zfkXxWe9F7jpAO6Pta7box8X0d4hGJ25SOy0mivw00eSqL2H24Xwj6B/C7
h9fOUIpjIO79bNq1CcpM5O8boZJytLsP/Ql1tZAaSGCf4+C8wH41lVMvJGM6
MA9g/23QthxR/Kwd8xr2BYh/wG8oVgWcllBBPHS7gU6qaQ3u+4CD/mm3sRHT
TNQoy9QXaXWedagjyJcy+mwYRu8m4yr17Owyq0Y/QJzPloqZVcsXRz/DOFFD
Rtse1vWjPvCD9/PCzjOb8TzjE3Mivy6cxwX8i8qErY83kHPmuPb0pyxGO54P
LSpLHI1CuxCPLi6bH/5SAeOhpnPLJzFGNfKzqGCdA+VMCnCHS1cqtkiQ86rL
TM7IbEYP8vsMzCd/29LEBfxC3SXejpfkXA24t0bi6UQRch4Ce2BeM01sEvPE
S9DOrMumhyTXy+G8QIemnBSa+IicS8EPYE/mJSOrWxtp6Lebh0YvPE4n52fQ
h3qyb24cN2cpE+cF+MwctTBZpyHUB1zlUrH+ladsak9/sAyH8YV7LHTTfwef
y+K5CPyG9XDlUnb4Ainkg53sbSfqzXeII27ZER+ULaOAdoKO3ew/0/vWj8T5
Ah/8luRT9i2khMwX8qVpnY7E5FwFxJkq8xlit8j5EHSAv+2LkfiLFSo4LuAW
Li9zVUcoIT97lJJ3LoeJ51XgGygs1tvDoSEO40KcJx0Mvv0gQBbx+0laQzvW
kvNkk79Sob03yYfvujKsIx4yiHPcC/T3JL7lCvoZ/NC93XSJ0vNu7mentSfO
Mcl50v8ms13NS5ECfMpyl4x1EQ6Yp4Cfzhw9/04yOe+FWObvu+1FpxL7WKHu
478insHnj2ExmORc8NhsnES3HOJfXKLPulrWoJ2gD3k9sKNsQboJ0Qd8wvxT
Ev//zgO+r06W7rwUcs4E/pl64w77l3whHOyx2XA2KmaBAnVwz5k/vkxp1F94
Z1+WpHobF3CLvNVFKVnk/Nl7s8f96xuyb/+e8Gn8WJlKxMcq9lu49ZShX/OZ
Xz8eMZKlDGYPRHU/r0Gd6rW1k257yVH8SSdtXjVlIQ58sOf5DfvxA5uqkQ94
nUWC8xXWM7QT4rDjbkPcx6QM1LlbMP76j54utAd0VM90DeryeYiDTvgGS9OF
UeRcCjrAG7Xanfmc34v2AN7821x6mSQf7QH8StU85W66COYFntcKyi4zysdg
fKK+2exKJx8N5C/WaL8nXl2P50ngX/gTSw0VfUUcxvXgNHuGypFzI+jA+e2t
c6BHbEsL1of4K8eNY5LIeRLyzlL67l6xOEUh3LW+sjRPTFWoPqfO7ZPYwFBG
HOzMDouwfx6vLLSPgD2/87cp7btQhvY8H5txIvGfczbwm9SKLXxpo4XmtaPB
UCFwixLWPcgLqJ8D+itLvdu+Ij6NN++LjJSCkA7U4WBWFt/2O8kvwJe67tIL
setEnSUueXbpL0j/BPIL+PrNlbP2qzVwId8B/zTLvvcc6zPypSVM/K8MkTgC
vr90wuf8QfL9pDLD4Mx7hjiVfa2jPfBQOZ4bTT5unzv5tARFk/85coHXJSE8
1SlGSTS+HuMZdCCPfi3nJBgGi2D9BFxlNW1sgLQYBXyw46XmQlMbtgTq47nk
sGaudggL6xvoXJthXxZ0SQLx2TOO2GqN6kY7wZ+Qvxm8Y+9slSWxXgE+v3Hl
mIWPxVAHcLtrjVWKkxiIb6EbPrryUATjAXDYXzqf3jKWt+7AdVw++Rxrdgo5
38K4vt9TTl19xBLCI8MW+yntk8J1B325gP0LX+4VRxz8eT2vqHdZCw/nC3jO
2hcjj1oMCK3Lxk/MOva6Dq7gOW2DvEJaxWZR3AfhHJLHoQ56bqYjDnyYb7Kf
g827OEnkA37r25rf/gvZWE/WHHj/evtmKdSB9YV1HPXdenOwZD8X8MTakF1y
X3q5gvOFdTGpTw4s1iXzAlyn7XC04ZJ21AF8/Y0747VCf+N8pW+arqGrSQqf
J68dEokezUYc6lKjnXhOvRI5n+O58WRXY+OTt4iDDsSt38SXVudTlBE31hF3
tlEo5wqeT8AP+zUOn+pjqqA+4M1rWNxReYQP+m/cJn/3WaiGfMSNR5hd6lPF
Og86kfV7wq/6q+G6AD4749q4JNNRyJ+knFO1PqgX5wV8afGxZlcC+YgDf8nV
rUpV1zl4rgP+q4BzOV7XyXcHnv//rotZ8GLNWWfk0T+AG85P/BO6XBb1Ia4m
52/auUtxJOoD/vrWuQbfPPKdIlq2cbdLfRf6GcbV+WTpu1q6RejcBTrGtoF6
BbcYWB8APzrL7UKq6SDmtfR5xYatUuT7EfgWDRMio5VplGA+nl1QLXJkA/n+
hbhteFM7V24nHXGI2+zqhbcKRMn5DnTAnuVjmlQNr9WhDuCnlZ5pRWV8wHzR
cE6NsxaTFKrzPk2F10/S2EL7rKlo5ubTeqTfC+syrVM1PXN2hxAO8RPjfnyu
/2nSB1Y1fXn1iKgC5Xkh9np4Ty/2fyRWui+gsRQpnYUBc1xl+NzGpPbJ3ukd
yBfsF03h8rrqmPLUoF/olmK2CH6/A358oHLXit8V2E8AnajFMTedVf24Nsze
q6Zr+MgXvEeYN0/TaitTlhoxc+nTGhqfq/dzT5x5RxPigvcIgP84+YGre2L4
e+DeOmZhbTLqC90L/LVn6YdVx2dJkf0M/DAokyGn4MeiJqTnqGjs/oL2w7js
bs4m3Zh6xAXvEermSUduZdIon4vRfZfpo6heWb+9T7a94gIueI/w0HL6RD8W
m+JL/lTT81GkDgSly+5wPMgFXLBfATqf1hjOlVqoQP0eOugmbsRHXLDP9sE0
suLIcNxePfgtOjZbmeKcMLk7Vb4a+YL6MO6FkP/Wa5yQoepZo8JO321BHPx5
auiYg/9XJiVpeHylNbNcqH++dP7PaduYLdxLzbUHLOikTy5p1R/vx+rmquce
XpLqI0NZWl4cnLNJhAK+oA7oT4saq6torID9UuAbNA9U7hPjcz+VrsywqpFG
HOIW+uGgQzO/q15a6IR9abAn2Nxc8ZdYJcH/8v18irqnsvtwfQEveaPmIFI1
hqLV5938dNka7RTsY//neOPNdLY6ZTTmYk8rs5LrUfzDVzepkAu4YH8V7E+c
oClm6qlBWRx+xjkxNhf9Kdg3hnWUNS7ZGvTpLNe9+rroLElpxAX1f9kUj4kR
G02d6A6btEKBj3ndv3ZJ6QWWMmWsy9mhOOwHwJs2ybgrDZ//PQxFY6V83Lhe
DjsfbPvzA3HBvjTgbq8WPPaW7uO+8XT6ks/JRX3Il/gdjNJcxUHMI0E7Ia/f
0leVs1gkniGvVY1DPkr5kfMy6N8czL3cyBGhdsn6m1/PGML6AHZ6rjprUKpD
1lewzwn441PJZrp9HOzfgv+TVt9zuuzMoqZf2hy8UZyJ8SPYNwb8vLl17taO
4XOkTm/Ifi0GBfkoOC6s1w2zcO35vb2IA/9Qc5BIbHMr1slLtqmOMcP7yOCG
e0qF9D6u3cVjpRermBTkKcwXdAAfuyWoIaevAnHQoU29Jf3ulzOXOm5RfPsU
mS/M68/qIM2sRxzEBes22M9P/23YMcTB/AX7TTW8+CxfUrdh3Nh9KpEPOzmU
UdL6cGnrfsRBf12BWAnDThL9KdivhnlNyeLzvw/SKRlX7YE37B7MR8H6BvgD
j/I3KYOkDoN+8yTdnQ8Wq1E2C1d+Hphdi3kn2NcFfLNZdIJBujIVrPHrtWJF
E9Y3GDdx9mPfjP9ycF6C97bgn0n7RWKC+sl3IfALfEr1Jc0UKL62xedN4u04
Luhv4+tkaZ2rRx3Q3/5qkG87fG4BHHTRD3/tHJvzkh19UpFKGHuUWZragucB
8LOPyxPzR+OqcT+FeHA0jjHOS+9FHPvwM3s+2Pd1ow72RcKPpzaad2E+wvrm
Sfalbcj6gTjUf6pplKZYlCvqwLhPHhmcHn29HHHQWRDgn5Ki9gX9AP6hRazL
/fSAhnkN/tnbc/ei+Ysh9AOMG1zalmLwhuwXYP+LCb7qh+NlEYf5nt1b9PM4
JYvxCfyQEZ07Kz3kMF+wD/e+NNS7oBzjEOp5pZlCBs0thQv1GfQ5u4qiR/a1
Yf0EnRnyiZrS7Gasw4DfPqx5MM+2FvmgE7D+c6Z7WRXqA99JftaKIVc6BesI
+NltB7Z97mdQsC44rv5PQ85IcfQDrEvSKf17Rg9FsY7BulzYlPC84xEN6w/g
Zovm5b6yFcH6A3ZayTisq9Nioz+B/87Yb5rmkw5cX1ivvp8ci49Pe7H+AG7k
ZPJJbVUt5h3gqrbssNdq7YiD/at7fVLsNHqwngCerxdrHnmtBdcL6kDjqCh5
O7sfGD+AX309OdbgWDnqQLwNzgrYf156EO0HffnHojzny3T0G+BZ+VFaEpvE
MH/BP6dDisxVqsSRD7jt3LQ3Bt6knsN6xQSuSWTQxNH/2P/UlM30p7rQfrDz
Ttql2jlG/VhnBO+bYL/m+CXrTyrrxT4h5OOrh72h/e2t+F0P/G1mjrISbQQH
PifL1uZKVQXe4wBfx2dg+z1eBfIhPv27X3VySnqRD/FpFxfgc/0nwYF/5b7p
B99he8BO4O9uM85OcyL9BOA/bDSqnNRHx+9T4Ac2J5pIdNHx+xf4q03dquli
Evj9C/yk6am7VLo5iAN/wcct9MueLNSB+YoYtInsOk9w8M+deKt7Dp101AE+
y36txsluOtoP8cDo+pC8ca4C6gDu5Me/1/dKGXGIK+vyrU/6PMh9DfC36zjs
sfEk/Q2IH/NarYcyTjLIBzsnRaq4RHzvxb4ZfhccbYq93UPuQQDf7azjN+ew
DH7vQ7w150YNzu6TQxzi89eZGltvFxn8rgf+VCP3cPETRAf0x5wP4i3hkvsO
4Ks2J0gbDMch9POB31wUduydZCX282Fcr/ehJ3XLKvBeAHTCtiuEPaX9w/+r
89bx6dmAtl7kA277vW7Wc1E+9r0BT2Sqar0/rYF2gv+ppDGG+7muGLdQzxXT
7TN9iyoQh/pPM66h0rhLsd8OOMvYYMHzbxU4LtT/XItC258VBAf9mgJTXdc/
vYiDTjCrrbSmuxX1gZ9ZvSlv0u9W7MPg9/6+Q/xmJQ/UgbzY8fHXf2rHyHoB
Hm0tGt9SR3QgX5gaLZ+jXlRgXAH/ck/E4WVNFdifAX8Gfr9i+HqIjn0ewGdR
1nFNLRzsbwP+o5G/pSKA9Itg3Qc43zWe0kgfG9b9TGDu1sgeDonnv3yV8/3R
L06Rfjjk133lNS/tK3pxXlCf6S+dV7L/kHzB/UJl0VpeOcGBH1Xrs1112P+g
j/0Bx4FP9j0EB77M9i0TfFoqsO8E9r8YColc4UT6YGB/S8MUl756OvoH+F7a
9YHPh+sh1FWY1ym/OxrJQ//4869O/x/Zh0lVvbguoLN009mEUdUEB/6flqs1
e4ftB32wPziSdelnF6lvgLu43lrb9IeD9Rn84FoXdJc3SHDg2/rvjuedJ/1k
4O+Y7aadfIHc+0M8GB+qHar5pz8MeOzQ7gyuB6mHgNd51A6O7Cb9WMBnvv+y
qM9EDest+IG+QtvwiDHBwQ8hy2ZraPUSHeBfGbc5M+gfHPh7f/XtsEkm9Rzm
a2FVHGjKl0M+zHewuyPZ5x8c+PIrX6zVPyBD3pP8XV+N1jlhbR1y6B+oS1Yr
2rKOtREc+MHU62u8QzLoN+Bfqf5PPnm4zoOdYA/NM2JJ9hzyDgHmq2U+K+Z5
kjLqA/7A661d4T/7FIxL3/i2Yebwfgf5Ajgr6wfTfzh+IC/AnsjHPPs1vXSs
P2DPu/hZPUF8ggN/8f5Lr5vbOIiD/pWPUw7RTpK6AfyUPTuUP5xjYV4A30/z
kM3Wn6ReAX/fBG7T/AGCA59GDU6fPW0q5i/YWT1RyaEin+Q16Eg13n/zYzjv
AAed8oDosOXfWrEvDfy+dpsCqovkHcTVhsh+r9Lh9cU4/4tXF/V2Tj5K+vaA
z3Tdt+bgsP9BB9aLVTHv2+55pP8cHWxpxGMrUo99lQz2iPC5O8d/jPs6ko/3
treWr1sWxejjSj6RaM3aVI/4yrNLH+4WIX3mSrp5WDFdnjp44flmJ5FKbuUr
6ycLVfuRD7ilp7vqt0N9eJ8L+qATeyyAKTq8j4A9Vq/0E3p3kHf42Y6OuqL/
vDsRL29oYXEUES8Uycw9tuQ53o/4L406dINB3oFvX/zxtrIkm1J09GxgeitS
TVNbmKsp8g4ccOC3pGUaSsgwqcJvsjMsMpWxj+TxsFPPbOUubqrWnUXzT8tQ
Z81cbVd5ErsA/+2xaeeq8w347gXmBfNtrHnn//HXFi6MezvZZF4zjbyHAXyv
UprS2i7yXjrcx3bHbhF5Km1+T9OJ/8i7FBgX9GXv1fA5Et1CuNfOpAR16XLu
xq7Wuy+NFCi75ybFdS7kXQrg0M+cuUZboojdwgX7Af/okferk93NhfUF3GSd
4YrDkuVcWN+l5u7FIyjyvQo4/HnlGCstukw5t3rl3cjFlWOondHraxt/kHfI
gMOfA2iJp46y1TGuPLSqRnIP78H3xoCnG50LfMC+hfcvHK20Hv3hcx3YSS04
GTc59iAX4tlqjp/Rsn/ejQCO44aY029KjMZ1fP/MrTv8TgG+owAcv/v3v1nn
Kq5KCc6XXf/bZgdbnoJ1qcsrHaWqmYl5AesL/JS8U/pWHGXMu9UnvO1OrCXv
BwCXWMbWnPiTvB+AvGixmG6htYa8B1i87OyrGwwJ8p52st7ipJ885LPNto/T
0SbvaQHHvuWPQfG1vC4cd93PuHl7b5L3AIADX5/Xun82jYZ+GPMiZ6ihnbwH
AL8Bv1mm3EpalI3rCHH7WudWlAJ9uP7/tX+fU6THgc5ezF+wE+rbqM1P7TT7
JZB/0S7SelM+uU8He0ZdNnkWcofcj4M9Y72ubQiaKIm4oD33Lz9YbsVg47os
up/ZGNVO+k1QNxZyR78KvEvuqSGv9UyMq+81kj79ylczEhoXq1FWu0+ut59c
g3yoYzAvq6dj3Rv4PC7o+/tQMnF+tegHwfhRlt4ZMFlOkoK83tS5wvLuxC6s
qzDf5mW8LZbv+FivYL5vjdWy7nt0YnzCfEeFppu5BpHfE4H/ZZ3jr0vU1CEO
/r9j6iw7JzoHxwV8Vbu1fsbARxwX9DOkzh3+Ma0F6znYX5I6Oy2u6Bvi4AcL
0WsT+s+T39GAnwsz/DJrvragfyDv7FJt73AdK3BciIePmr6VV6+Rd4DgzwOK
M+92W5J3euA3s2TF7IRM4m/wm3bJEq+2PeQdHeAsUw2KfZr0lUHn2nLDeQ2S
5B0a1KuusWHSx7Mqsc6AjqlO85XCz6XoZ5jXf0sLTCcvouF7J9DfXaZ6+s1b
EcRB58H407zDLPK+CNZlgtTb9C2XyH0srG/xpbMvpy8cQj/j+uaem87YK4J5
Df48cVX9V+TvDvQ/8Ofs8tu+b4wY5hfwn0pm/9DR5qH/YX0rq72WTm9tI+9F
/+aF9/QJgx7RRciHPPKa9qZ5xJQOtBPW8RjNKKBmXi/i4Lf7VT4J4xaWoJ0Q
b15OKgvUvw4hDvEZzlufqLRfDOcL/izQrtuQFETu/UEHzm8BMWy7xQMj0D+A
T6jq1Etul8E8gvP5Ni89jX0ski/4LvFRwsnXbAXkwzmc2sPP8+8fifrwLpRm
2FT1wtsK4xD6LewX5zw9pMoRh76H5UV/v6bOLiE8Wod1Lvy/Mlwv6KtcK1cJ
NeKUY16AvodqguvFRBvE8TtL6/xbS3Y57stgP02F/u1YiDXicM6/d2t5wtl+
OfQznKsnGoaHhHiVYRzCuVq0YPzceP1y3L/gPG8QvSv6wjIPxEG/peDWZPbw
fgHzAv14t5wUlxSyP8J6Kfx0iyxqIfsLnMPfBIbfzpCWxHWBc7jehez1NtJs
ofVq016dlyRfjnEL+lm3r0w15TGwngPuY3WuPOtbF9Y3+N6RdXM6uY9DE9oH
x32f9Xk2QwHnBXhSXdGnfDFyngf8vP6Ly41DMkLn7QW+dNcX4go4XzznhF5e
HTG8vwvuUz82RAbM6B7C+Ae8KDU4/H6/GCV4Ll28NXPaUVoL5im8E/CI0pr6
U+coxiGMa3w27vCRNh7GCegffpo/U15MmRLkZz/L7gkSk0V/4nmekaVpkVcm
dC6aNfemZ0I/Q+jcfnzuFpMfLEmh7xcjY+fjreJMIf87aFmwOjLLhPZx2ujw
UVkPzHHdwc7Gt9HXY0S7Ecf72SR6fDWPrDvg/7U92iDXJxwnEfFB7X0i5LsD
+//siWlDdAUhfLN/UukVEbLvY9xuk8ixHo4fwIHv9q78QE6fHPoB+Ca940tm
dMkI4WIltW05dHLewD65TJt4DJ3EIehPjFtzJGdQBnHIl6Nnx9+yG8ZhvQDf
tC5EdRFTXqh++jTk/k6jKQrpRLpM+qgx7AfA8d3gXD89p3ISt6ATMS8m43X9
EO5HqD92k1sunYnfj6Dfo+IzY8/weRVw0E8wGb9BvJXEP+TvHMP2h9SFMox/
6JPoSE9ZvfxyGe5TUK+kTryNMfjKQz7glmeZSrodXVxB/ZunWHGZ5TwhnaSL
77cNFpfhfKHOP4mUiHzYxMO6DXU+MGlg4CqjBfMR5iVtcZ0TQSd5h/0x3WXj
DoqQcwv4Lcv9qIMEc7QQfmnS6ZqnNGWMH+yHT9SM7mCS7yzQZ64fv37BMF9w
f+m+G1H1sV+GEpxvlMYPuWkDMsgH/4if6XMUE5FFe2C/EEmev0Cyswy/a2B/
oVXnL+ePsMG6AToXpcaImdG7EcffoYwO0uiq5gnhsofVad8Gu3B/ATzX6eAD
uU4G+gH0VczXvWjvFBPCjc5u9aIxJHFeoMPg95ieEmEL4WdExp9+PMwX3E9F
Z7xeUf2zS2i+xYW5V5e18hCHvB4QpZLbh+NfcP+dfo2hn/OnC88J4E+nvo0F
6p94Qvg86ZVvTwz7AewE/bD7JyftGpQQqg/npBTE1w3PS3D/PSXF9j71sAzz
FHSutTqfk6wo4wrmo7ROo+4qe1KfIX5+G82Vd6vpEsJ7WSmq81gtWJ8hDqMc
1JuO5/CQD7j3lL6JA8N+EKwbKSruSeH1Eli3gT+DEzpl8I+YEH5mhiXtQYcE
xjPMdwaLFdX1eQjrAOBrfC841XUwkA9+8KXvN5RtGMI6APacv0j1PBquS4Ln
VbP6md+evCXfm6C/8zJ7YG4PjytY9wbOOMWubGWgDsSn9ZZeftvwPoXfd3/j
8M9Euot/7xDGFeTp5f7YiUu7xShB/JKCatX1xiHMI8DzRm3LmTrEwPoPcRhs
/jmNOcAQyuubepOu6DFoQvF/MI/b2tErJoSLd94suTo8ruD5cOCN51A+n5wT
YNw3wZxd3waHhOJZuWsrc+7nLqH1CtPk2sqWdWEdBr7j6wyx5+k8xN93ZwQ7
9LbhvR7on9Li+xjxyLtf7Mt97lrqOcyHe2HAk6NnBM5pbEM+zGu6uke8cWcb
3gOC/z1kcp/qGuzEccH/889cmFOrsgP18TtxwpQLUfmFiIPOgbbJZnGjNmOf
H+InuelI6OqkQuzzQ7x5tnRO12otxD4/8Gm6mvFyJx0Qxz6t+pl530rI+2qY
17mxv9Yn9JD3rhD/vzw5WR96ybtWPK8qPvGZTyP31NiXlmoQs/rn3hn8mbhR
yeTl2mWoA31LWvZ353X6k/B9KfYt42/myabZ4f0v6K8eevKl5Q95/wn8xpFz
yrsaqvD+F3D6siu+F8oKUQf7DNm3AvJyClEH/DA45lmpbHMh6sC4tBaZT69p
GxAH/m7mqqlZwzoQD+A3Wnt+9mx/a8QhntNjGl7F6dtgXCHf8sz5Beds0R6I
h+jTqRUv3ck9Mtj/Wit75pHj5L4Y4m05fWSgQw95twl28tidjuwT5N4WcD81
57A37uTeFuZbqNLT5Ecj97Mw7uKblssiPpD3kDBumEv43boO8s4T9NW3WXES
B9ownoHvXRflu+ZpIcYb7Av8ca6WFmVViEPcxieVbyk/WIj64E+T6+Prble0
YV4AXvd4o/QTXhvGP/j52M3HeVHXC9EeiGeq+eCPhyb2qA+4o9mBPzc/VaEO
4K42Lvtr8sh7SBh35vSrYjEnyb0erOOv7WnGIf3kfSnUAYcobbfff9pwvqAv
o/Bt+Y0O8nsHWBc7+RSP4MFuzF/s59/yWP29qRvjDde3PVa9t68b4w109k+V
58j88/sFwDPHKT1sbCe/mwD7A53VV57+U4V8WMcchw9xuUNVyId5JRXNKmDI
k3dHwE8JfzrXq4D8DgL4xxyu5X4eT94XAd6rf/rYsqYqxMGePWFua+73VeG6
Q92rLEywzSisQr+BH6xmtZ/nHSfvfGC9dPYeZQcM5wvgECe2jvfsdp0k73YA
D9cost7iTd7hgP/VHa/nBw6R9/mA23o9+ihHI+9t8Lt42vpv9f+8t8H6KdnT
NiRG3tvA9/tFU/9Zd6qqsD4A3+JDxPY4L/KeBPyTXaLbOlaSvBsBf6ZemJBA
8yTvRmBdXIo3lB0dPgfAfAGnz4xNiqaRdyOgc2dGl22aM3mnAXgc78t6+lHy
TgPsibgTueqkC7n/BT/sGLydc/8Yuf+Fea050nTTjUbejQB+gN8fo3+S3C+D
n6PXJ7YNDrHRHhj3LVPvtsNQN+Yd9gllQo1L+OQdOMZn2bxpWb3kPSfYeaTn
lIa5K3kfAvjoWX9O3fQk70Pw+z3p+9WF3d1YT8CetJqAEHYbeQcO+Iq7Lwcb
Jcg7EPCnJ3fO+CAp8g4E75u8b1v4trdhnECdXKFsTA8d6EYc8kK/YsKB2gLy
nhzq7Ti3BWkdEuQdCJzbd9aP2O1aUoX348CPnL52fKwYeR8C/BixdzMtvpN3
5mDPkd78fZxc8n4b7DkjujEnKrkK5wX5eOjxxOfKRVXoB8i7MTuL75rkk9/7
AM78oKtp0NqN6wi4CVf1hOJgG9oD4+58r3w06TP5XRLU24HuBaohgwyMT1gX
r3fhG119yHsJ8P/t4u4P+wfZGLcQh7sO9dnt9ybvJQDPq1JfeYdG3jNAnCy5
rHNftqob/QN+mDKXHr+5nfwuCfD4VZ5T5gzXecDB/v8BKstGmw==
    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNl2WcV0UUhufeu9IhXRKLxC5IiNIlIUjDIqAS4iooUiIgIaGUhAgooSgI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           "]], Polygon3DBox[CompressedData["
1:eJwtl3n0kFMax9973xIRRWiIabO3ncoUP23aQykkopRItiJ7qdRIlshyLMe+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           "]], Polygon3DBox[CompressedData["
1:eJwtlnm0iEUYxmfmQ1kiS1lClpv12stys7sR4tbtkjVCtqRj6SBJiEjpKCGy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           "]], Polygon3DBox[CompressedData["
1:eJwt1HuQl1Mcx/Hn15LLSNk1ihmXlZiR61Q0QzFRUlJakltNS4aiGqPL1OYS
g4lsurC7pUS62hlCNtIU29J2Q81ORkWrUhnDdBkaDK/vPOeP93w/v/dz9jzP
nvM9p7R89MBRLbIs642W+K+QZaerGXl2UZbN9Hum3DblWXI7eYY8Q75FHiy/
IveWd8kb5P2YLT9jqtZ4Fq9z5xjTij/Z7+JCPmY234X/Wt7BT1K/Qh1/Lb9J
/oGvUDfiM/56TOGewnDujUI+fyfje8kvyJ3lenmlfIH8pvyS8Y+oc1HNX4S7
uQ7q1cZ8wX8kX4k9/AbcyF2GEu4f9STuRLQr5HPW8N3RJr5dPc881fFNcn/U
8w0Yz32O9+Nd2Mc1YyDXEcVcqb9dIFfyj6pvxTv4Ir4hrckJ8np5THxn+uaP
5avkdfKH8gBsNsdo9XJ+Lb9CPkt+TZ7k2UPq9IAfjD+4DzCG+x5judOMb5a3
yK3kPfI4+Vb5R3mT3EfeLTfGOshl8jDz3KF+i3X8xfxy+V2+CzpFT6Q+ib2b
7Heb2MPUD9cZv1VeG3stb5HXyL0w19iFagd+Ef92mv9SubNn12Bx9AV/A4rl
EpzpeVV8W9rH8dwElBfynpzI/4I5crl6INZLrlAfiHWXW2IqDkdPcs2ojDUx
zzD11YAr8z3H5AJexFHsiv7EIWPr1R7GNPFfyj0xi69VO/Ir+eXyPfiT36re
lvZis9xXLpXbe/a0+lPai7uwl9udvuEIvzPehWn8vNRj8+MMpJ7vId/r2U3x
LamXoodL0jmN9amJtUt3whnyqfyDcR+kO6EM27lV6SxHr36Szm9j9JNng9CI
1dE/WBT7iMcLeW/EfmVF+RlZL45TV+OxOEf8IXkb31M9iO1pntjrZdHrXC0W
x3oav1M+wj8Xe4WGtLZ18iq+a3wj3uNPif3l+uDJQj6mNvXYEnkePzLmxjtx
1jGfq8IIbmn0dtqjvbHX/GT153R2uuLC2Ku0d3F2Nsr34Th/DM9z+/ANdz/+
5ZowkfsVTTE/Po01xNjYKyzjBuE37ju1n/n3x9mTh8T/Fn/v2Z3qJWjN/R3n
m6tMPTzN76Gxv9ErfDdcEXcVRsR5RAVXhyfiLsGSeK93HY8+wcv4K3qRv50/
Vz7f+CHqgdg7/nCLfI+W8qNi7fEwd3NRfuesiP2NnsDUuJvxu3wQUzzfEb0R
9xKquQVxh/vbhXFXyv8DcS/hpQ==
           "]]}],
        Lighting->{{"Ambient", 
           RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
          "Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0s0r5HEAx/GfyWpr96D1tNNMpIiUrLVoMoY8xS7yFBellouyJmQdcJGL
cVMOTooTeSoHitqTPfGPOPAveH1zePd+f75TM7/vr6n8nR1bzIuiKId1fMY/
tDkc5r/8wGv8n8cxix37A3IowJKzGM+gT1/jh27l8AMnnOVTbgmfYcE+5u/o
j0XRETehGT/tcz5DsU7xBRK6hycwqp94hB+5Cnv4aFfzQbiPruNDFOoa3scn
XcvP4Tf1PL9iSr+EZ+A/3Itf+oovw3tBqZ3mes9fott1F7Z0o7Nuvasn9Ve9
qeM6rivC+7IT4S46Xyf1tE7pkXAvpO3t8N1cwUXOvqDE3rBLOcbF4XmQsSvt
IZ3S5bo/3EMn9YDuQINdZnfqbzrDd1jV9zwY7osbrDhbxm14X5jLe/+PvAES
xi/J
        "]]}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{123, 401, 657, 121, 122, 404, 660, 403, 659, 126, 130, 465, 
        705, 231, 628, 469, 223, 461, 701, 221, 484, 719, 247, 502, 735, 264, 
        505, 737, 265, 235, 471, 708, 234}], Line3DBox[{162, 612, 163}], 
       Line3DBox[{170, 167, 613, 427, 165, 617, 173}], 
       Line3DBox[{175, 432, 618, 177, 240, 474, 711, 710, 475, 242, 140, 668, 
        415, 669, 416, 142, 248, 720, 485, 244, 714, 478, 192, 686, 442, 132, 
        408, 609, 134, 411, 610, 135, 665, 412, 137, 189, 683, 438, 684, 439, 
        180, 181, 682, 437, 187}], 
       Line3DBox[{184, 124, 400, 656, 118, 399, 655, 117, 402, 658, 125, 407, 
        662, 129, 230, 627, 468, 467, 706, 222, 220, 483, 718, 482, 717, 246, 
        263, 504, 736, 251, 487, 722, 237, 470, 707, 233, 239}], 
       Line3DBox[{188, 186, 436, 681, 185, 440, 685, 148, 419, 611, 136, 413, 
        666, 119, 120, 410, 664, 409, 663, 133, 224, 480, 716, 479, 715, 245, 
        249, 488, 723, 143, 417, 670, 141, 477, 713, 243, 476, 712, 241, 629, 
        473, 178, 619, 176}], 
       Line3DBox[{198, 196, 457, 698, 216, 456, 697, 212, 452, 694, 211, 490, 
        725, 210, 207, 451, 693, 450, 692, 206, 154, 421, 673, 153}], 
       Line3DBox[{204, 690, 448, 622, 199, 202, 700, 460, 219, 702, 462, 228, 
        734, 501, 257, 729, 495, 260, 262}], 
       Line3DBox[{146, 147, 621, 447, 203, 625, 217, 458, 699, 459, 218, 227, 
        732, 499, 733, 500, 256, 259, 731, 498, 261}], 
       Line3DBox[{149, 150, 677, 425, 151, 155, 674, 422, 675, 423, 157, 208, 
        727, 492, 728, 493, 254, 252, 726, 491, 213, 624, 453, 193, 687, 443, 
        194, 620, 444, 190, 441, 191}], 
       Line3DBox[{159, 152, 672, 420, 156, 676, 424, 158, 691, 449, 209, 494, 
        632, 255, 724, 489, 253, 214, 695, 454, 696, 455, 215, 195, 688, 445, 
        197}], Line3DBox[{169, 429, 679, 166, 164, 616, 431, 172}], 
       Line3DBox[{174, 171, 615, 430, 160, 678, 426, 161, 614, 428, 168, 433, 
        179}], Line3DBox[{183, 435, 434, 680, 182, 115, 398, 654, 397, 607, 
        116, 127, 406, 661, 405, 128, 608, 131, 466, 626, 145, 418, 671, 144, 
        481, 630, 139, 414, 667, 138, 503, 250, 631, 486, 721, 236, 232, 472, 
        709, 238}], 
       Line3DBox[{205, 623, 200, 689, 446, 201, 225, 703, 463, 704, 464, 226, 
        229, 730, 496, 497, 258}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{281, 282, 747, 415, 801, 417, 288, 846, 285, 414, 286, 780, 
        482, 844, 484, 382, 825, 334, 492, 494, 848, 390, 847, 490, 377, 819, 
        326, 499, 851, 501, 392, 850, 496, 307, 433, 308}], 
       Line3DBox[{304, 756, 303}], 
       Line3DBox[{305, 306, 474, 838, 837, 476, 343, 839, 344, 486, 845, 487, 
        349, 854, 505, 396, 853, 292, 422, 805, 424, 294, 815, 450, 817, 322, 
        332, 458, 823, 460, 333, 827, 463, 296, 753, 426, 297, 754, 429, 
        367}], Line3DBox[{315, 441, 271, 401, 790, 268, 399, 738, 397, 266, 
        750, 280, 413, 800, 279, 799, 411, 743, 277}], 
       Line3DBox[{342, 777, 475, 387, 778, 477, 840, 345, 352, 503, 788, 504, 
        395, 852, 502, 293, 751, 423, 363, 814, 449, 816, 451, 323, 818, 324, 
        459, 380, 826, 462, 828, 464, 338, 299, 807, 428, 366}], 
       Line3DBox[{351, 497, 495, 849, 391, 500, 327, 820, 452, 770, 325, 489, 
        786, 389, 493, 787, 335, 461, 824, 381, 483, 781, 481, 347, 785, 350, 
        488, 784, 361, 416, 748, 749, 287}], 
       Line3DBox[{356, 400, 740, 353, 398, 789, 267, 419, 802, 360, 412, 745, 
        359, 744, 278}], 
       Line3DBox[{364, 298, 806, 427, 365, 809, 431, 430, 808, 300, 320, 446, 
        812, 376, 813, 448, 447, 321, 769, 291, 421, 804, 420, 803, 362, 425, 
        752, 295, 340, 471, 834, 470, 833, 386, 472, 341, 835, 836, 473, 368, 
        810, 432, 302, 755, 301}], 
       Line3DBox[{370, 434, 758, 310, 372, 440, 811, 438, 761, 314, 767, 
        318}], Line3DBox[{373, 437, 760, 369, 757, 309}], 
       Line3DBox[{374, 444, 270, 739, 355, 404, 792, 402, 741, 272, 406, 794, 
        269, 354, 410, 796, 797, 408, 276, 766, 317}], 
       Line3DBox[{375, 445, 768, 319, 443, 273, 793, 403, 791, 357, 407, 742, 
        405, 274, 275, 798, 409, 795, 358, 442, 764, 765, 316}], 
       Line3DBox[{393, 331, 457, 773, 379, 455, 772, 453, 328, 775, 337, 465, 
        829, 384, 831, 468, 466, 336, 774, 383, 480, 842, 478, 779, 346, 783, 
        348}], Line3DBox[{394, 498, 330, 822, 329, 456, 821, 454, 771, 378, 
        491, 339, 830, 385, 832, 469, 467, 776, 290, 418, 289, 843, 479, 841, 
        388, 485, 782, 284, 746, 283}], 
       Line3DBox[{313, 763, 762, 439, 312, 759, 436, 311, 435, 371}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{514, 744, 610, 799, 513, 796, 664, 798, 635, 608, 573, 627, 
        831, 628, 832, 557, 648, 787, 728, 632, 848, 550, 816, 693, 817, 549, 
        625, 547, 622, 813, 623, 593}], 
       Line3DBox[{516, 746, 517, 748, 669, 801, 670, 579, 840, 652, 631, 845, 
        722, 564, 834, 708, 522, 523}], 
       Line3DBox[{518, 749, 747, 668, 578, 778, 713, 839, 567, 721, 598, 833, 
        707, 563}], 
       Line3DBox[{520, 519, 673, 804, 525, 676, 805, 675, 751, 526, 602, 719, 
        844, 718, 781, 580, 671, 639, 843, 716, 842, 589, 686, 764, 766, 
        543}], 
       Line3DBox[{524, 672, 803, 582, 674, 640, 853, 735, 852, 601, 717, 780, 
        630, 653, 785, 568, 715, 841, 714, 779, 544, 765, 644}], 
       Line3DBox[{528, 677, 752, 527, 606, 737, 854, 736, 788, 577, 667, 638, 
        846, 723, 784, 603, 720, 782, 783, 569}], 
       Line3DBox[{532, 615, 808, 531, 559, 703, 827, 702, 826, 597, 732, 553, 
        819, 694, 770, 595, 695, 771, 624, 647, 775, 511, 659, 791, 658, 741, 
        507, 607, 633, 750, 611, 802, 581, 683, 761, 763, 542}], 
       Line3DBox[{533, 755, 534}], 
       Line3DBox[{535, 756, 536, 760, 682, 588, 759, 681, 643, 758, 680, 571, 
        740, 656, 790, 657, 510, 739, 509, 620, 768, 688, 591, 773, 698, 822, 
        555, 731, 605, 849, 729, 850, 730, 561, 530, 807, 614, 754, 679, 585, 
        613, 806, 641, 612, 584}], 
       Line3DBox[{539, 538, 689, 812, 546, 700, 823, 699, 551, 818, 552, 725, 
        847, 724, 786, 604, 726, 562, 830, 705, 829, 572, 662, 742, 661, 794, 
        634, 508, 666, 800, 665, 745, 576, 767, 545}], 
       Line3DBox[{540, 757, 541, 762, 684, 811, 685, 521, 506, 789, 654, 738, 
        655, 570, 792, 660, 793, 512, 687, 590, 772, 696, 821, 697, 554, 820, 
        646, 733, 851, 734, 560, 828, 704, 529, 753, 678, 583, 616, 809, 617, 
        586}], Line3DBox[{565, 650, 836, 629, 600, 838, 711, 651}], 
       Line3DBox[{587, 619, 810, 618, 537, 642}], 
       Line3DBox[{592, 690, 621, 645, 769, 548, 692, 815, 691, 814, 594, 727, 
        556, 825, 701, 824, 596, 706, 776, 626, 558, 774, 574, 663, 795, 797, 
        609, 575, 743, 636}], 
       Line3DBox[{599, 709, 649, 835, 566, 712, 837, 710, 777, 515, 637}]}}},
    VertexNormals->CompressedData["
1:eJztWz1uVkEM/AQlp0DiJ8kZkNJRUiDBASLR0FBBQmpK2oiGO3AgJGpEwh2g
SWNpNB57vO8FIX3VauXn57XH49n3PTx79/LNvcPh8Pr+4fD3d7i5+frg1eef
p0+OPr14++3H6furZ2dfnn8/vQbrcf9HsH5O7NyuHxH75037rvXoZ9YO8nO1
/9Xz3drPXyH+zJ9uHqJ8/jD8vt04nwydlxqHuP8CnGOM8yNzfu4FN/ZeX+58
qOJkNd+YnWxebV2/W6+7/I92UD5k19350OUn7rzt1guL21HwB/G3Lk+b6o9Z
fvgb8AS0zngm2o/sPw1xYOvI/u3+i7D/GDw39n2VP7P3QvaRn9n4s/dC66p9
9dxjPk89t2ofxT+uZ+3EOE/5qe5X64Xtvw7vexn2PyY4mY1/5L1qPbryzZ23
6BxV/JnOh5i3LJ/juVf96eKJ+r57W0f+q3il5okLf9zrCFdV3M72x1X9C+Vn
xAGGD4iX3r5X1AdY/4r7qziDeN10/2L9gp0Xij/Kk2MQf6TrxvNSz72KG1M8
LfKBGP9pnETxVO2r597ty9m5oNrv2Llk5yAX/3fPm9lzr85xLv7A+leVj7n6
eIxndw5l59Wds9S4of7I7imyczrK873wyVXrKj9fzedduJpdr/YXle+t0g1U
HanKW2J9sf6Yjaeab5HXueZlxA9dvK6Kh67+gnQbV11P8SX23GodMV1rKxxj
z0U63pQu4eLzbC7LzinV90X1mJ0j9jansDhMzxEsf2Idqf2L9TV1jkb5rD53
tR0UZ5cO1tUnp/TMLL6heQH5k51/s/MRyvNV/Nw9t961+xq1r2XrZep+1pX/
VV262/ererJ6X8Dqutvf1TmiWl/d83XlFfouiOmQ7J4i+9ys3t7V8VS9q8rf
pnRId16p9k+S8enmucpP3LqH6ueqOlXvibbS01S9K+K5S6d16TDVddf9YFd3
7Z57do7r6oqsHrv6XpVvMF6txq3b35H/qO5UfMvqnN08ZPebVT7PeCnDk2rd
MV6q6tiXwB+XDlOdH6dwhuVJlb9l+aeKV4wnT/PArl6n6mzZ/MnqP6y/M11F
nTe7+lX1HrzLP7NxUPm2yn9c84jrexKXrqj6U+VjXf9dPKqqK7r6zl70fzVP
XPtX6/Z3TZ9H9aje1/9ruvfe9GqXLr1X/RnpEi7dWP0OZLU+/F8H1vLWXY8u
Xbeq33Z5cra+VuPn6v+JMLxS+6ArPlv106364BT/6eK2ikvq988sPirOT9Vj
d66J+MbsV++Ppvq7qveq99pTddHVvbO4pPYdZt/9Xm4dr/o9dtZPVd/LzvXT
/Lyq163+DqTbN914q+JP9RyrenI3zt17/z9ijV+3
     "]], GraphicsComplex3DBox[CompressedData["
1:eJxlfHVYVN/39cAMId3dICImBjZzEVuxCxVUsPVjYIKglGBjKyogImKDjdhi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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw113fgz9Uex/HvSkq6GigzV6SFhi0uQlmhhJJKdaNFWbk3DdGWysqIFKVS
3aayV6S0rpVEUkRUiDb1eN/j/vH+PV/ndd7n8/uMc97nfCv16N3xplwmk2mb
zWTy+Jw/F+FhWFL8zi9RQN7x4lcxiz/EoP3YDn/k3YVrtHvJvwbbaG/j34lr
tXvzr8UV4nz6Spwt7tZ/AD/Mp3uogO9iUWOXYTXRjq6JS/Q9LL/gfh7Wrsov
4GL+cH6e/3Y+3csfeEDfQDn78RdxHf0zTtPXkj4Ed+Hh4nsxXbsjFo13IO8B
+gLsJh6hL8NF+h50/Zz/VUz7DH4JHItjxEjRRXsEdsU746XixXFt487S/Fz7
A1GSXoH363teXwfX7KH9GP8qfCuf3t/vOFPcQTeTM4ceSp9LH0q3j2fAuWIY
/098QLxAd5TTAWvKWe+a7/Of0C7Of1/7aP57eC7vC7o11tBuS5+El2i3obfR
7Y3dSN+GF/PLxXvBi0TJbPo27+STd4jrf8VrKn8rlhV16aNwkziH/hI7yf0H
vZnuSp9Hb6GHus5o7dau820mzc2YT/V4q7Auvsm8HZvKqYyv82tjeTGFbolL
5TyKReTUpxfy+2Et3gr6bDzU/zs5vjt+Gd8Xe+MyMUp/UWNX8U6QsxL/G/OU
/gR/k7MtnkHOdnoSbwB243WS8532u9pjtQ+Tc1l8Z/63/F/532g35tfAZfwz
cCv/Pv0NcDVW5q/Fr7Qfw764OZ/WQB/8DE+XswMvNf5Ceif9h+gX0y/mkDiT
/gNLGLNHXzH/dzk9jnc4vZC+n87SneN7yu+E9/Gf47fnnx5zmV8dd/CKxTPi
njTNM9tFZ+0KGiNjHmj/TUSN2RvvGn/AHf/34l5FkbiOONG4JlgG18QzZNKc
PoI+my6Op4oL6NNwqnsrQ++Rc6R2LfqU6I96kE3Pc1esB2zp/g/jVY/1gofE
teL+cIich2L+ydnPqyh+E0/zy+OP+j7OpvoXNas1thLNxb1yJvLaGXu0nHq8
8tgj5gU+iX/HFvzK2D1qiegmmmr3xAYxl2Idisnyf+EdmUm19R7Xf5zX1vV3
x/XFeO2f9JWKmhb3JGcE73w5P0T9FvtEabkN8Rj8Fw4St8Y60b4C68R7FV1i
TeFxon7U+qiZrrnFNRu55snap8R3wmNjbsb/jhz9pelyB+v3kKgh2It/Bb6C
8/Tdg81j/tDj49vF3qH/CHq3eER7lpyucubT98bkoLNyymXSt1wQ64Lfgt8+
vi2/Y+w3eLnoETU9viHvabxU+xJxpbhWDI6aLBrp7xxrLepcLtX+Z7BV1Gu6
Dd6OvUUv8al2LpvuKepT7I/zxAZeHdyIJ+rrizNzqX4s5g/HSvFN6ar4Ek4W
T4g+oq+4Qbwi/iNejlrsGSfEfC+kBdLCuCl4fzx/zLVY0zGn6P5Rk/T1wTdx
eCbVt3gvR8Q+G/XyYC0ZRnfA2tpv0rXwOu1x9DV4o5hG34QP6Xvd9Tq7h6mx
BsRTYom+DTgT34i6Q5+Hg+Uu5m3Hl/Fz/ku4MGoWvQC/wU1ia9QJYxpnUo19
VNyi/yy81fgJsfbxrajF9KLYC8Rceg7ulve5/rrubRf9KV2HflHfx3KexDv4
f0btijonNsipJ2civZa+mh4Z+5Tcm/H7qLP8Wvzv6FX02bGO6DV0bXqW3M2u
OTfePf8Lfk/+oLhXfjX858FvUDxq0cHat1T+R/Kf1T5O/gS6Cq8Izou9RM5U
LK2dk3OUnIo4g18Jr8ml7xbjH5czmR4Ye7u4Wk53/FhM13+8sc1xfrw7/IQ/
A8vyH4uzBL9u7N34oLEXYodY47GOsFjcI/1hzDntTdq9jB0V34l3S8ydbJq/
PePetV+Kc4CclfTLsfcW0lku1lMpujVdQ/4B7X2xb2FD/h3Gz+G/jRPEe/Q4
3CbnfTnVC2m/e4c+lW5Iv5hJ+91pubSWGubSPrgEu8n5ml5KXxbvgW5An0Hv
jHcU+18hnXHiDLM6k/brD/hX8s/ERbzqUe/iDJpJ+3jst+/QI3GAvvV049i/
9H2ENeN8Qn9I16An0+vpa+l+ufRtI29vPn2TBvwtcbagT6O/oZfT3embcYD8
jfhjPrE+/zacGTUEh2TTWhyUTeeIWINxPt57cD4Nxp/EV3KvM3ZSrNOYm/Tt
+mfLnR3fkL8u5hf/3ziRXzZqWC49a9xfnNmf44/Gx7Op5g2LfSTWPz0wm84q
78o93XWmaH/Cn4Gvirfp13C4nCZ4TJxZRPfYS+Ldi2nGljR2HF2RX8inc0js
f7v1fRTzUXyQSefb+B2yL+qw+JpuEfODXyrOHK7TH6fH3MSxsS/T/bGI9lD5
JXNpf4l9pTPeGN+K/hp/zieeU0i/Zd6gT6DjB9KzxlbAe+TOp0dhn1yqj1Vw
uXZxumjsh2IUfWwu/faJ2lypkM6G0/lj8Hx+I7pVrJtYL3RNfF7fOvoF3B+1
h27Kr5NPdfh63JVLZ6oedOU4t8TcwOr5tL/cmE+/g+LcfBG+KlbSzcLL/W9b
zVSJOhd92p0K6bdY/BbaGfdKHx7PwX/Wfczi343PiDWxF8T+mk1raBr+GnOZ
bmLcSaKEdhljn6Kb6y+Fh/KqyVmnXT7OA3RFvCHqcTa962HaY7CNsWPoFXGG
oEfQLeNsErVfzOVX5a+L56Qr0+vpOXSVWOMxh+iT6U30IvoU+kG6WZxfYm2J
BXFP/E/pt+gu9Hj9y93bWKyZS3M/5vdncmbjiYX0G2ExfSm9gZ5Pn0RfHzXa
2OPjmXLpHDQVx8f7x6vkjKbfoy+nb8EHsqnGxe/mSZk0F1fLeY13cSH9Xo5r
HEP/BXS4+pk=
           "]], Polygon3DBox[CompressedData["
1:eJxFmXkYV9MWhs85+0iUaBIllUppUqhIaFBmMiUq0qRBkSlljMxChsjNEI+5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           "]], Polygon3DBox[CompressedData["
1:eJwtlnmUj1UYx+9970+WySi7QahoElnKmpBdYxlLdTq2wiQkTpxOOkhkC3VO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           "]], Polygon3DBox[CompressedData["
1:eJwl1Xds1lUUgOHPUmm1FCyi0QCyEWQKRhL2KIKIbUMBoaDSMkQKZVpZimyj
RkBEEETAVVbZM+KItIjiAo3GiUZQC24wKBr1Oekfb8657z3f/a17z9egYOKA
oqREIjEIVZGbnEiUEsMuSSRqiFtxvEoicVFM4VKRI38Ec/nGGMzlohq3CQ9z
A62zQ57PjxO340N+BnZwe9GL+xK/czOxhytHP+4HXORmYR83FhO4U7jAFVr/
O/lOvod4Gn/yg/hd8jH8ZM/TS3yUH41x8tEYb34vPg6n/lv5ZL5QfW/xOX4k
8uR3x7XNb8MJ7t64J24uWnCv4yuuwDrH5bP55uIH+JG/HK241riTOyOmcJei
obwRhsb9iy+Gt85S4zrGV7qfWqjCD0Ead0W8a/OPYR6XiuZcVXyGs9gY9dY5
oGa68Rxr9BGX8Jehhbwlhpv/SdwUz4oG8qbIi/cvlnAp1llufJ3xKXyPl/ga
uFneASPM/yJW54arLzNeYlzmukvF5Xwy/zh/VTwDn4H/jPP4V8XxfB3xFXyh
fhh/OJ6T36V2irgsPJrJ2+Iu809hIZeE2lwGTsaz8vO5Eehp3Ann8Bc2c2Ni
D8kfwA1qD+FzrrrrrpNn8iPF82JN/h95NXk6BsQ9in+LaebayK9HBVZwC7hM
PB/fFNO493GWS1h/sTwpfmPYBBeM6/E7xRHx3cVrUKp+KGpydTE4qXJvlHPT
sJpbiXZca3TkumEVtxCtuLexguuLzdwWFHPd4gxw/Vz3CXl9foi4DEf4Pijh
5sde4TpjN/dznFf3XIH+8odwgL8d29VuQ3fuU6zl8uMaXH+M4l7AO1x/lHLr
Yw9xn+AZrjvWcE+jfdTGN+Z6u89F8n9dt3HsHcyJvR97Ls4W7jFfE824JriD
GxT7Mp5JPCMWRG+SZyPN+D3x12iAfC351RiYVLlXy6IWZ02fR1b0PBzk0tEu
7jF6BLcSR7mmcfbiTGMMl45GXLb7fzbeO/8H1sqP8RnobNwF+dya+GbRM9Qf
jW8X59O1S9GZb8m/yS+PXskdRdc403x59GV+N3cEXaLH8Pv5qfxEsSF2xHfh
341vxB9Tu05cFfXIiT0evdJ8Sexdbmz0aO7+6KvR83COuyn2IncfJnFNoidz
bTGBKwqif8R/QPQY190nnxTn0HW34Ea+CIu4JzE1qfIZT3P1kyt79ahYR+0E
tOE78d/wr/FTuNnI5ushi/vN+C0xVU1dbjzmGc+Ic8d9jQ3RAzCHOxhzsXfQ
IZ7L+h/F/xnfK86puIafjg3yrfEu4j8Nq7mOyZXvpDjehfpitIv/FzzIvYyZ
5k9iPddDfYX8MH+r2BNZ8c6wgDuEWVztONtce/Un5Btjr4hdsSfWRhm3H5nc
bcjlRsV/UvQwFHLXxn8YNxsHuDfQl7sFOdz/oGD0bA==
           "]]}],
        Lighting->{{"Ambient", 
           RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
          "Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k1LVHEYQPGbThQ2wiA4ZbMotSZSJCqlYjYtckrRlEmmqIXjaC+rFHQh
Or2haGAkLkrBjQtXigptXAx+gVoW6MJVHyCoXRbU74+Lw3POc++duffO1BeH
c8+PRFG0ghiC/8KPiiiKm3ctzlRG0Qx/jU49oDvMlPnG7gNqnT9tnrabMqt0
PX/LZ5HUzToVzsEq3/UZjbwBCccv2C3wDfOU/sgXsanr9BLfQ4a3h+v5V3zi
1+2+8R5eCs+hx8w/vqPWbpSPYI3/thvmL1HhvJN2L/jT8OyOJfQTPoR1/s9u
kmfDy3H+oHGD/8RjXkTB/pou8Ge8n0/wcdzhR+1ieBV2etss6R3+nU/wMi/z
LjzUaX2LP+BneQ3/Eu4vvG+zzz5pZvQ9PNJNui00T/DL/Cpyulq38rj5V1/h
F3FMH4RrQ/PjnjnH97Glu3Wet/Aq3su7cUmf0NnwG4Zn5Lf5Zyzrm3o+3D9P
83d8Dnl9Tr/n9/n5ysP/3n9XtD3y
        "]]}, {}, {}, 
      {GrayLevel[0.2], Line3DBox[{269, 268}], 
       Line3DBox[{272, 267, 651, 962, 264, 263}], 
       Line3DBox[{278, 276, 725, 1006, 428, 417, 718, 1002, 416, 429, 728, 
        1008, 430, 431}], 
       Line3DBox[{288, 658, 287, 921, 425, 724, 1005, 285, 274, 653, 963, 273,
         283, 726, 1007, 304, 296, 660, 967, 295, 303}], 
       Line3DBox[{294, 289, 657, 966, 286, 659, 293, 923, 284, 656, 965, 281, 
        280, 655, 899, 282, 292, 662, 901, 300, 299, 661, 900, 291, 290}], 
       Line3DBox[{298, 270, 652, 898, 271, 261, 650, 897, 262, 297}], 
       Line3DBox[{311, 310, 686, 978, 349, 348, 684, 977, 324, 671, 323, 907, 
        356, 693, 982, 361, 359, 740, 1015, 450, 440, 733, 1010, 439, 452, 
        741, 1016, 451, 745, 400, 915, 258, 647, 959, 257, 259, 649, 961, 248,
         243, 641, 953, 234, 232, 640, 952, 241, 334}], 
       Line3DBox[{351, 346, 682, 905, 347, 685, 350, 910, 358, 690, 980, 357, 
        362, 691, 981, 360, 438, 732, 1009, 437, 432, 730, 926, 433, 742, 401,
         916, 399, 708, 994, 398, 260, 648, 960, 246, 247, 642, 954, 244, 235,
         638, 950, 233, 242}], 
       Line3DBox[{376, 696, 984, 375, 378, 697, 985, 377, 386, 703, 989, 385, 
        379, 698, 912, 380, 721, 412, 919, 413, 717, 1001, 414, 406, 713, 999,
         393, 391, 706, 992, 338, 336, 680, 976, 339, 342}], 
       Line3DBox[{443, 382, 699, 986, 381, 363, 692, 908, 364, 702, 384, 914, 
        396, 707, 993, 395, 397, 710, 996, 404, 390, 705, 991, 389, 408, 715, 
        1000, 409, 411}], 
       Line3DBox[{445, 442, 735, 928, 441, 383, 700, 987, 373, 372, 701, 988, 
        371, 695, 370, 913, 394, 709, 995, 402, 403, 711, 997, 366, 365, 714, 
        917, 407, 410, 716, 918, 345, 344}], 
       Line3DBox[{277, 654, 964, 275, 279, 723, 922, 266, 265, 727, 924, 427, 
        426, 729, 925, 302, 301}], 
       Line3DBox[{313, 666, 309, 664, 902, 307, 306, 683, 906, 317, 316, 668, 
        903, 319, 670, 321, 909, 369, 739, 1014, 449, 448, 738, 1013, 421, 
        419, 743, 1017, 453, 436, 731, 927, 353, 688, 256, 896, 254, 646, 958,
         253, 250, 644, 956, 236, 237, 639, 951, 239, 245, 677, 973, 332, 
        330}], Line3DBox[{326, 673, 314, 665, 969, 312, 308, 663, 968, 305, 
        318, 667, 970, 315, 322, 669, 971, 320, 672, 325, 930, 447, 737, 1012,
         446, 420, 719, 1003, 418, 422, 744, 1018, 355, 354, 687, 979, 352, 
        689, 255, 895, 252, 645, 957, 251, 249, 643, 955, 240, 238, 678, 974, 
        333, 331, 676, 972, 329}], 
       Line3DBox[{328, 675, 674, 327, 911, 374, 734, 1011, 435, 434, 736, 929,
         444, 388, 704, 990, 387, 423, 720, 1004, 424, 722, 415, 920, 368, 
        694, 983, 367, 405, 712, 998, 392, 337, 679, 975, 335, 340, 681, 904, 
        341, 343}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{459, 458, 658, 1098, 599, 659, 1031, 461, 460, 702, 1114, 
        548, 695, 1058, 547, 566, 721, 1122, 629, 722, 1075, 565, 564, 742, 
        1131, 637, 745, 1089, 535, 532, 688, 1108, 617, 689, 1055, 529, 1050, 
        528}], Line3DBox[{471, 469, 1023, 645, 470, 1093, 646, 465, 466, 1024,
         647, 472, 1116, 708, 545, 543, 1057, 694, 544, 1121, 717, 561, 559, 
        1067, 709, 626, 1115, 707, 482, 597, 1029, 656, 598, 1076, 724, 481, 
        480, 1028, 654, 596}], 
       Line3DBox[{497, 666, 665, 1034, 496, 1035, 498}], 
       Line3DBox[{505, 499, 1036, 667, 609, 1106, 683, 530, 615, 1052, 686, 
        616}], Line3DBox[{511, 673, 512}], 
       Line3DBox[{513, 508, 1039, 672, 610, 1103, 670, 503, 504, 1038, 671, 
        506, 1107, 685, 509, 510, 1042, 674, 516}], 
       Line3DBox[{533, 518, 1044, 1043, 676, 612, 1045, 677, 520, 457, 1019, 
        640, 588, 1090, 638, 454, 526, 1104, 681, 524, 1049, 680, 525, 614, 
        1120, 716, 563, 1070, 715, 485, 601, 1099, 661, 489, 1032, 660, 490, 
        605, 1125, 729, 576, 1079, 728, 491, 474, 1095, 650, 592, 1026, 651, 
        476, 594}], 
       Line3DBox[{536, 531, 1053, 687, 618, 1127, 731, 578, 585, 1086, 741, 
        577, 1126, 730, 574, 573, 1074, 720, 553, 1113, 698, 546, 623, 1062, 
        701, 540, 1111, 692, 487, 484, 1030, 657, 600}], 
       Line3DBox[{537, 619, 1088, 744, 586, 1087, 743, 587, 580, 1081, 733, 
        579, 1080, 732, 572, 556, 1064, 704, 555, 1063, 703, 549, 624, 1061, 
        700, 554, 1060, 699, 488, 602}], 
       Line3DBox[{568, 569, 1083, 737, 581, 1130, 739, 583, 541, 1056, 693, 
        620, 1109, 690, 538, 632, 1082, 734, 625, 1112, 696, 550, 636}], 
       Line3DBox[{595, 652, 1096, 477, 478, 718, 1071, 567, 727, 1124, 630, 
        575, 726, 1078, 606, 662, 1100, 604, 493, 705, 1065, 557, 714, 1119, 
        562, 558, 706, 1066, 613, 679, 1048, 523, 462, 642, 1021, 590, 641, 
        1020, 456, 455, 639, 1091, 589, 678, 1046, 521, 1047, 522}], 
       Line3DBox[{603, 492, 725, 1077, 631, 723, 1123, 593, 475, 653, 1027, 
        479, 655, 1097, 483, 486, 710, 1117, 627, 711, 1068, 622, 542, 713, 
        1118, 560, 712, 1069, 519, 473, 648, 1094, 591, 649, 1025, 468, 467, 
        644, 1092, 464, 643, 1022, 463, 1054, 534}], 
       Line3DBox[{608, 495, 664, 1101, 607, 663, 1033, 494, 1041, 514}], 
       Line3DBox[{634, 735, 1128, 633, 552, 697, 1059, 551, 736, 1129, 635, 
        539, 691, 1110, 621, 740, 1085, 584, 582, 738, 1084, 628, 719, 1072, 
        570, 1073, 571}], 
       Line3DBox[{507, 1040, 502, 1037, 669, 501, 1102, 668, 500, 611, 1051, 
        684, 527, 1105, 682, 515, 675, 517}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{750, 952, 1019, 749, 747, 951, 1091, 748, 955, 1022, 754, 
        932}], Line3DBox[{762, 897, 1095, 761, 833, 1002, 1071, 888, 922, 
        1123, 841, 842, 1005, 1076, 923, 774, 1031, 934, 908, 1111, 870, 987, 
        1061, 875, 823, 985, 1059, 872, 1011, 1082, 818, 910, 810, 1107, 977, 
        1051, 809, 808, 906, 1106, 781, 968, 1033, 860, 1035, 784}], 
       Line3DBox[{764, 763, 962, 1026, 856, 898, 1096, 765, 834, 1006, 1077, 
        768, 964, 1028, 767, 921, 772, 1098, 966, 1030, 858, 935, 986, 1060, 
        874, 928, 1128, 822, 821, 984, 1112, 911, 792, 1042, 940, 905, 1105, 
        867, 978, 1052, 783, 782, 902, 1101, 861, 969, 1034, 862, 939}], 
       Line3DBox[{773, 933, 1000, 1070, 831, 917, 1119, 816, 943, 999, 1118, 
        871, 983, 1057, 817, 916, 882, 1131, 1016, 1086, 894, 851, 1017, 1087,
         836, 1003, 1072, 835, 946}], 
       Line3DBox[{776, 936, 1008, 1079, 844, 924, 1124, 843, 766, 963, 1027, 
        857, 965, 1029, 771, 914, 824, 1114, 988, 1062, 820, 945, 989, 1063, 
        876, 929, 1129, 813, 812, 980, 1109, 907, 788, 1038, 786, 903, 1102, 
        785, 970, 1036, 863, 1041, 791}], 
       Line3DBox[{778, 775, 967, 1032, 859, 901, 1100, 780, 825, 996, 1117, 
        883, 995, 1067, 829, 919, 885, 1122, 1004, 1074, 839, 947, 1009, 1080,
         891, 1015, 1085, 850, 849, 1014, 1130, 930, 790, 1039, 1040, 789}], 
       Line3DBox[{779, 900, 1099, 777, 937, 991, 1065, 878, 997, 1068, 830, 
        886, 1001, 1121, 920, 887, 1075, 948, 926, 1126, 889, 1010, 1081, 892,
         848, 1013, 1084, 893, 1012, 1083, 847}], Line3DBox[{794, 1044, 795}],
        Line3DBox[{799, 797, 973, 1045, 798, 974, 1046, 800, 1054, 811}], 
       Line3DBox[{801, 1047, 793, 1043, 972, 865}], 
       Line3DBox[{804, 904, 1104, 866, 752, 954, 1021, 753, 961, 1025, 755, 
        931, 958, 1093, 895, 853, 1055, 941}], 
       Line3DBox[{805, 746, 950, 1090, 852, 953, 1020, 751, 756, 956, 1092, 
        757, 957, 1023, 758, 1050, 807}], 
       Line3DBox[{806, 803, 976, 1049, 802, 975, 1048, 796, 760, 960, 1094, 
        855, 959, 1024, 759, 896, 854, 1108, 979, 1053, 868, 942}], 
       Line3DBox[{832, 918, 1120, 884, 826, 992, 1066, 827, 998, 1069, 828, 
        880, 994, 1116, 915, 881, 1089, 846, 927, 1127, 890, 1018, 1088, 838, 
        1073, 837}], 
       Line3DBox[{845, 925, 1125, 840, 949, 1007, 1078, 770, 899, 1097, 769, 
        879, 993, 1115, 913, 819, 1058, 944, 912, 1113, 873, 990, 1064, 877, 
        814, 981, 1110, 869, 982, 1056, 815, 909, 787, 1103, 971, 1037, 864, 
        938}]}}},
    VertexNormals->CompressedData["
1:eJzlXDuOVEEMHAHHIOEkewN2GSBHSEQERByElIyIfD9wCE5AADkJZwCJfYml
Un3sfrNaIkTrqdvtT7ls9+yT1++Obx4cDoe3jw6Hh3//vfn86f3jV7/Onv/+
8PPbxx9n//7//ezqdv3Z7fpVWd++/yp+r65fl/3r+gWRx5X/OpST6Y3tf0nW
r8v6F/FcV06k/3oukxPZxbW7u885kT+Vp7uO7Ovuo/pz1YPqn3X9RVlP8aHK
f1PWWdx1z1X9Gemt+iHyT3c99YeKt2h/pjfVvqn/qPK757p4qMq/V/6a8mc3
XqbOvSz7oLyQ4lIqZ92fra/CmdXrKs6odtk736l4yHjR6nhx/We719OQR63m
S129ubyxy9/U/ZE86X1Z3pnK41O8ZRX/7PIZVBdchnpeFUeufrr8s4vP03pY
zaun7TKN/659V9cjaZ2O+iR7x8sU/rv8H8k51Sdx6whU56ryTPP2veNIzSPV
b9NzXf6P+kVqXtvLr5C91Dra/X7TwxHIX/252rHus/UZ0jp9ap3JeRw6V433
m3Ju/R6ts3ORnO4+1b5IP+p9t31emv5Qz3XtWPMF89uu3eu9WN5X9cnkd+NL
9QfXz11/cOMF9Y2rHhD+ID+5KutMn3WfaXxDOFztruqZxRHyK4QD7rnpPiq+
VTuivIP0oMpT90/72O690PfT+Stdd+3bxZ+p+FL5ySo+4+rhrujNjd8L8L0a
j+q6mmdd/ERxx+p35v+Mb0/Pv1S9ofXav2LrzL6nwqvVuLcq7hDPqTyki8Ps
Xu59Wfx257mr9LwKbxGeTMmv6tPFSRU3XL/q5gX3viyPnDqPp3kQ8RNW1yM7
dvM+4s8pXqXxxfSAvu/2PdS4W+0/bpy6elvF/7t9BjffTfGB1O7M31blwbSu
T/lAakf0zg2tq30ztu6+h0T7dHmOKn86d1jlV1U/p+qfTPWjULwzfz51vT+F
/9v6+dB9u/m07oP4D6vTmX7S+U43jljfT413tz/v9rdZXmP6TO+1qj7aiw+o
+TStC1jfQK330zoxrftSfbp9WhZf0/Wa6p/TfCDFf7cOcvuuab3v7lPxBPGT
Tc76O4tufcf2Seen3byP5FTnp90+zN58pssn0z6MW18z/3dxGPGidJ+pPNXF
VXf+gvCT9cG6fEPlRWl9gXB7+17FN/d9jiq/m/en7sveUaBz036Cey/3HYvq
zyzvoO9dP0/r+tV9rb36fox/qvqfupfL31y8ZXyyi5/MXmreUefp0zxE/d7F
2730tjoe0bndfqlat6p+wnjXFJ9hceryCvUd7xRPQ/l3Kj+6+jl1vkj7M6o8
XTxX/YTxE1efjJ9M9V1d/tntH9a8r+Zf1z/ZnKvyscrz03MRbtT7pvXvXvml
i2+r5Uzn6S6Oqd+7/Sj1/YmqB9cPu/6G4prl6y6epPM4d393ToRwBvVRu3pY
Fe978wSm/5Q3qu+X0noN4bn6XmuKD6d8IOXDXT/p2nHqXLWu7PqbivNqv5HJ
4/aXGE9z7TXV73V5slsPTucjNU7r+/9u/mX6T3GjO7dS/USds7i/A03t7vo5
wk82P2X2WtV3RfKofAn5j9s/XP3uDtlF1X93Ls/0gPreU/481V/q6j/FeVWe
6frd5T/p71Kn+J77OzgXh117uXzmvsxPGf9x56Hu3HOKH7r18t7zO5fPqPxw
ik92eWPaN07v5co/tc7q5al5FqrrV8+nunOlNI+smiOneJjiNsvv03nE7Z/c
Ffxn/rmqb5Dynyl/W9VvT/NX9+8MdHlgmr+68vyv+c7NUywfnXo+ct/y1Kp8
lOLe1Lmr+1Epn0/9Nl1P33W4fSc3Lqb6WlM4oP5dL7fv586d3b7KqftXLO//
AeGtwB0=
     "]], 
   {GrayLevel[0], PointSize[Medium], Point3DBox[CompressedData["
1:eJwdVOu57DgMAvSwnWRmzi3htrQlnAa2zG1rxfjLjySOEQKUv7///vMrAP8R
CHjNjb73CRTQwAI28AF+gD/eJ0GBASZYYIMLfIFv8AP+GECEBAWUUEENPdAL
ekMfwwcRQgQiEYW4EQ/ihXi7chIpZCATeSFv5IN8mVERJVSgDupC3ajHNJto
oTf6oC/0beKLWI21sDbWwbqwC7uxF/bGSZzCaZyFK3AlrsLVuIU7cCfuwkM8
whN4Ei/gRbyEV+ANvIm3LMyHVsW6TNvT2LAflkNoys+B+e5D/Fg2L5FBJllk
kzf5kC/yTX6s6+xLVFBJXdRNPdTLes+5ECMYh3ExbsZjEwYsxdzMw7yYt20Z
+FqszTqsyy51sxd7sw9XchVXcy2uzR3cyV3czb14xBM8yVM8zYu8xCt4JW+Y
8i3ewQfm/sjmu4Ov8w7HeD/ujoVj1ag5Co5qb4fC/U9708YwnjKDO1iGcF68
NyukLR3pkm7pcY5Gj3kdS7EVR3EpbocrW7mUW3lUpWrVUm11qkvd6qUlrdBK
rdJqbRp+h3Zqlw506GondFIXrPpUvkI3LL8pfDPr0A+XSe0JJ2ZS8jjIdnQI
rrCOI9wodTvd7rPDtafYoF/Oe1RER6yIHXEiM7IiO3JFbm9WRlVUR8sfdkZX
LMSiu59zK2MjNq2EMeA4WBJ8Q/EdIA/nSux0yi/PEyvZaePH6ekzU5WWaXTZ
GZGmMrWn3kpvz/OsyuwsZsk056kqG9m08MO6Mxdy8WsCvhmcMa1CF9YMWzF8
mlXsCVxJpTCY3ZrGWCE3bRUGGmWisgYuNUC0q9YD1fzai8l1I8xi3qFnwtuz
pGaY13w1WZ+fgdiSVTRTdLDtx3SIthZTfljS5/0LkzWeVgw/o8tFWXJ3hiU6
RJYfy07L4vrPyA193cAmv8nC1uQAB3PxEP8DePkWVQ==
     "]]}},
  AutomaticImageSize->True,
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  BoxRatios->{1, 1, 1},
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{351.2064986064859, 362.81655636126203`},
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]]},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.4321829368329768`, -2.7152296753837293`, 1.4235096927524014`},
  ViewVertical->{0.0574346801871607, -0.19273416329926646`, 
   0.9795686804962326}]], "Output",
 CellChangeTimes->{
  3.641360165017646*^9, 3.6413604206582055`*^9, 3.6413604544771957`*^9, 
   3.6413606618014145`*^9, 3.6413612870233974`*^9, {3.641366493546503*^9, 
   3.6413665161185384`*^9}, 3.6413686783169546`*^9, 3.6413835196591473`*^9, 
   3.64163482587742*^9, 3.6416360477957077`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cotaDevv1", "=", 
  RowBox[{"boundCohenMacaulay", "[", "vv1", "]"}]}]], "Input",
 CellChangeTimes->{{3.6401177953506985`*^9, 3.640117798558975*^9}, {
   3.64058052190477*^9, 3.640580525786524*^9}, {3.6412168153733606`*^9, 
   3.6412168161318955`*^9}, 3.6412926604213085`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360522602377`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "0", ",", "0", ",", "7", ",", "0", ",", "0", ",", "0", ",", "8",
      ",", "0", ",", "0", ",", "12", ",", "0", ",", "0", ",", "0", ",", "9", 
     ",", "0", ",", "0", ",", "14"}], "}"}]}],
  SequenceForm[
  "lptos de pintaAux=", {5, 0, 0, 7, 0, 0, 0, 8, 0, 0, 12, 0, 0, 0, 9, 0, 0, 
   14}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360522602377`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "12", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{5, 0, 0}, {7, 0, 0}, {0, 8, 0}, {0, 12, 0}, {0, 0, 9}, {0, 0, 14}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360522602377`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360522602377`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360523071146`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"360.`", ",", "360.`", ",", "360.`"}], "}"}]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360524164944`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "12", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "vTriangulo=", {{{5, 0, 0}, {7, 0, 0}}, {{0, 8, 0}, {0, 12, 0}}, {{0, 0, 
   9}, {0, 0, 14}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360524321194`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 1, "]]=", {{5, 0, 0}, {7, 0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360524321194`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "12", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 2, "]]=", {{0, 8, 0}, {0, 12, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.641636052447745*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 3, "]]=", {{0, 0, 9}, {0, 0, 14}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.641636052447745*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[1]]=\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["pYk[[1]]=", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.641636052447745*^9}],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360524633703`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[2]]=\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["pYk[[2]]=", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360524633703`*^9}],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360524633703`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[3]]=\"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["pYk[[3]]=", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360524633703`*^9}],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360524789963`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximo=\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["Maximo=", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360524789963`*^9}],

Cell[BoxData["\<\"--------------\"\>"], "Print",
 CellChangeTimes->{3.6401178008495903`*^9, 3.640117961853837*^9, 
  3.6401182236075478`*^9, 3.640502934893585*^9, 3.640502980118684*^9, 
  3.6405033499000235`*^9, 3.640516635736947*^9, 3.640516705586507*^9, 
  3.6405770701477375`*^9, 3.640580526610097*^9, 3.6410495099426756`*^9, 
  3.6410495459983807`*^9, 3.641086326431828*^9, 3.641087601539364*^9, 
  3.6410978318743305`*^9, 3.64109787627696*^9, 3.6410980241333094`*^9, 
  3.6411038679442067`*^9, 3.6412168181483183`*^9, 3.641292661065759*^9, 
  3.6413565229656453`*^9, 3.641357360043065*^9, 3.641366575303551*^9, 
  3.6413686898171215`*^9, 3.6413835236689844`*^9, 3.6416348297921886`*^9, 
  3.6416360524789963`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "12", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "9"}], "}"}]}], "}"}], ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[GreaterEqual]", "0"}], ",", 
     RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"84", "-", 
       RowBox[{"12", " ", "x1"}], "-", 
       RowBox[{"7", " ", "x2"}], "-", 
       RowBox[{"6", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "360"}], "+", 
       RowBox[{"72", " ", "x1"}], "+", 
       RowBox[{"45", " ", "x2"}], "+", 
       RowBox[{"40", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.641292661256895*^9, 3.641356523128769*^9, 
  3.641357360233203*^9, 3.64136657548769*^9, 3.641368690049285*^9, 
  3.6413835238581266`*^9, 3.6416348300265727`*^9, 3.6416360524789963`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isCohenMacaulay", "[", 
  RowBox[{"vv1", ",", "cotaDevv1"}], "]"}]], "Input",
 CellChangeTimes->{{3.6405805385936003`*^9, 3.640580544644902*^9}, {
  3.641216828477666*^9, 3.6412168522495446`*^9}, {3.6412926663635283`*^9, 
  3.6412926665236387`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generators of the rays we use to check the CM condition: \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "9"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Generators of the rays we use to check the CM condition: ", {{5, 0, 0}, {0,
    8, 0}, {0, 0, 9}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.641636055422426*^9}],

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.641636055422426*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "0", ",", "0", ",", "7", ",", "0", ",", "0", ",", "0", ",", "8",
      ",", "0", ",", "0", ",", "12", ",", "0", ",", "0", ",", "0", ",", "9", 
     ",", "0", ",", "0", ",", "14"}], "}"}]}],
  SequenceForm[
  "lptos de pintaAux=", {5, 0, 0, 7, 0, 0, 0, 8, 0, 0, 12, 0, 0, 0, 9, 0, 0, 
   14}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.641636055422426*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "12", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{5, 0, 0}, {7, 0, 0}, {0, 8, 0}, {0, 12, 0}, {0, 0, 9}, {0, 0, 14}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.641636055422426*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.6416360554380517`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.641636055484929*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "12", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "14"}], "}"}]}], "}"}]}], "}"}]}],
  SequenceForm[
  "vTriangulo=", {{{5, 0, 0}, {7, 0, 0}}, {{0, 8, 0}, {0, 12, 0}}, {{0, 0, 
   9}, {0, 0, 14}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.641636055578683*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "8", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "9"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{5, 0, 0}, {0, 8, 0}, {0, 0, 9}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.641636055594308*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x1", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"84", "-", 
     RowBox[{"12", " ", "x1"}], "-", 
     RowBox[{"7", " ", "x2"}], "-", 
     RowBox[{"6", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "360"}], "+", 
     RowBox[{"72", " ", "x1"}], "+", 
     RowBox[{"45", " ", "x2"}], "+", 
     RowBox[{"40", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.6416360557193127`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x1", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"1080", "-", 
     RowBox[{"72", " ", "x1"}], "-", 
     RowBox[{"45", " ", "x2"}], "-", 
     RowBox[{"40", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.6416360558443174`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "35002", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "2002", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "1475", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "527"}],
  SequenceForm[35002, " ", 2002, " ", 1475, " ", 527],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.6416360605201087`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The point \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\" does not fulfill the condition\"\>"}],
  SequenceForm["The point ", {0, 0, 1}, " does not fulfill the condition"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6405805452002954`*^9, 3.6410495178553123`*^9, 3.641049550565619*^9, 
   3.6410977902356687`*^9, 3.641103893456394*^9, {3.6412168305871673`*^9, 
   3.641216853289282*^9}, 3.6412926704865847`*^9, 3.641356527288723*^9, 
   3.6413565859424467`*^9, 3.641356969222543*^9, 3.6413573683059344`*^9, 
   3.641366590981694*^9, 3.641368697822815*^9, 3.641383527984062*^9, 
   3.6416348379503684`*^9, 3.6416360605766363`*^9}]
}, Open  ]],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.6405805454874897`*^9, 3.641049518214569*^9, 3.6410495508658457`*^9, 
   3.6410977904528093`*^9, 3.6411038936475306`*^9, {3.641216845173518*^9, 
   3.641216868616166*^9}, 3.641292672050704*^9, 3.641356530258834*^9, 
   3.6413565874604425`*^9, 3.6413569707806497`*^9, 3.64135736952279*^9, 
   3.6413665944391537`*^9, 3.6413687012722664`*^9, 3.641383531296399*^9, 
   3.641634842877553*^9, 3.6416360605766363`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v2", "=", 
  RowBox[{
   RowBox[{"8", "/", "3"}], "*", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", "/", "10"}], "*", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
      RowBox[{
       RowBox[{"3", "/", "8"}], "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
      RowBox[{
       RowBox[{"3", "/", "8"}], "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
      RowBox[{
       RowBox[{"3", "/", "8"}], "*", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "5"}], ",", 
         RowBox[{
          RowBox[{"-", "11"}], "/", "10"}], ",", 
         RowBox[{
          RowBox[{"-", "11"}], "/", "10"}]}], "}"}]}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.64110392727149*^9, 3.6411039352271605`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["12", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["8", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["13", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["77", "15"], ",", 
     FractionBox["127", "30"], ",", 
     FractionBox["127", "30"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6411039375468035`*^9, 3.6412168794548545`*^9, 
  3.6412926733486166`*^9, 3.6413573712480235`*^9, 3.6413687049088473`*^9, 
  3.6413835344336376`*^9, 3.6416348531856494`*^9, 3.6416360631829405`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vTrV2", "=", 
  RowBox[{"raysOfConeOfCHSgr", "[", "v2", "]"}]}]], "Input",
 CellChangeTimes->{{3.6411039933335614`*^9, 3.6411039959214067`*^9}, {
  3.6411045746547527`*^9, 3.641104581746818*^9}, {3.641216902484206*^9, 
  3.6412169033628387`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.641292675803359*^9, 3.641357372311771*^9, 
  3.6413687060266314`*^9, 3.6413835365141144`*^9, 3.6416348542389717`*^9, 
  3.6416360641762557`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["77", "15"], ",", 
     FractionBox["127", "30"], ",", 
     FractionBox["127", "30"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[24, 5], 
    Rational[12, 5], 
    Rational[12, 5], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[77, 15], 
    Rational[127, 30], 
    Rational[127, 30]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641292675803359*^9, 3.641357372311771*^9, 
  3.6413687060266314`*^9, 3.6413835365141144`*^9, 3.6416348542389717`*^9, 
  3.641636064191881*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"144", ",", "72", ",", "72"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "160", ",", "80"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "80", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "130", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "160", ",", "130"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"154", ",", "127", ",", "127"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{144, 72, 72}, {80, 160, 80}, {80, 80, 160}, {130, 130, 160}, {130, 
   160, 130}, {154, 127, 127}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641292675803359*^9, 3.641357372311771*^9, 
  3.6413687060266314`*^9, 3.6413835365141144`*^9, 3.6416348542389717`*^9, 
  3.641636064207508*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641292675803359*^9, 3.641357372311771*^9, 
  3.6413687060266314`*^9, 3.6413835365141144`*^9, 3.6416348542389717`*^9, 
  3.641636064207508*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.641292675803359*^9, 3.641357372311771*^9, 
  3.6413687060266314`*^9, 3.6413835365141144`*^9, 3.6416348542389717`*^9, 
  3.641636064223132*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6411039966409063`*^9, 3.641104582543372*^9, 3.641104757867304*^9, {
   3.64121688097193*^9, 3.6412169043655434`*^9}, 3.641292675980485*^9, 
   3.6413573724849024`*^9, 3.6413687062357793`*^9, 3.641383536707258*^9, 
   3.6416348544264793`*^9, 3.641636064363763*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"genV2", "=", 
   RowBox[{"generatorsOfConvexHSgr", "[", "v2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6411040243426533`*^9, 3.6411040750447836`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{
  3.6411040386278315`*^9, {3.6411040690505056`*^9, 3.641104076408742*^9}, {
   3.641216882548067*^9, 3.6412169089257812`*^9}, 3.6412926781600437`*^9, 
   3.641357373293468*^9, 3.6413687089497156`*^9, 3.6413835381632886`*^9, 
   3.641634856065946*^9, 3.6416360659186473`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["77", "15"], ",", 
     FractionBox["127", "30"], ",", 
     FractionBox["127", "30"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[24, 5], 
    Rational[12, 5], 
    Rational[12, 5], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[77, 15], 
    Rational[127, 30], 
    Rational[127, 30]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6411040386278315`*^9, {3.6411040690505056`*^9, 3.641104076408742*^9}, {
   3.641216882548067*^9, 3.6412169089257812`*^9}, 3.6412926781600437`*^9, 
   3.641357373293468*^9, 3.6413687089497156`*^9, 3.6413835381632886`*^9, 
   3.641634856065946*^9, 3.6416360659186473`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"144", ",", "72", ",", "72"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "160", ",", "80"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "80", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "130", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "160", ",", "130"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"154", ",", "127", ",", "127"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{144, 72, 72}, {80, 160, 80}, {80, 80, 160}, {130, 130, 160}, {130, 
   160, 130}, {154, 127, 127}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6411040386278315`*^9, {3.6411040690505056`*^9, 3.641104076408742*^9}, {
   3.641216882548067*^9, 3.6412169089257812`*^9}, 3.6412926781600437`*^9, 
   3.641357373293468*^9, 3.6413687089497156`*^9, 3.6413835381632886`*^9, 
   3.641634856065946*^9, 3.641636065934273*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6411040386278315`*^9, {3.6411040690505056`*^9, 3.641104076408742*^9}, {
   3.641216882548067*^9, 3.6412169089257812`*^9}, 3.6412926781600437`*^9, 
   3.641357373293468*^9, 3.6413687089497156`*^9, 3.6413835381632886`*^9, 
   3.641634856065946*^9, 3.641636065934273*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\tmp\\\
\\aux1\"\>"], "Print",
 CellChangeTimes->{
  3.6411040386278315`*^9, {3.6411040690505056`*^9, 3.641104076408742*^9}, {
   3.641216882548067*^9, 3.6412169089257812`*^9}, 3.6412926781600437`*^9, 
   3.641357373293468*^9, 3.6413687089497156`*^9, 3.6413835381632886`*^9, 
   3.641634856065946*^9, 3.641636065934273*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"gAux", "[", 
    RowBox[{"v_", ",", "suma_"}], "]"}], ":=", 
   RowBox[{
    FractionBox["suma", 
     RowBox[{"Plus", "@@", "v"}]], " ", "v"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6411041351616163`*^9, 3.641104213962765*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"genV2Norm", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"gAux", "[", 
      RowBox[{"#", ",", "10"}], "]"}], "&"}], " ", "/@", " ", "genV2"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6411040908860693`*^9, 3.6411041039513807`*^9}, {
  3.6411042245372996`*^9, 3.6411042336738095`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Plus", "@@", " ", "#"}], " ", "&"}], "/@", "genV2Norm"}]], "Input",
 CellChangeTimes->{{3.6411042386913834`*^9, 3.6411042548448944`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",",
    "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
   ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
   "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
   ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
   "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
   ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
   "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
   ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
   "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
   ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
   "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
   ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
   "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", 
   ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", 
   "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10", ",", "10"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.641104241846629*^9, 3.6411042557875624`*^9}, 
   3.6412169168323946`*^9, 3.6412926827092733`*^9, 3.6413573784731455`*^9, 
   3.641368712393162*^9, 3.6413835425303864`*^9, 3.641634858471496*^9, 
   3.641636069200385*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPointPlot3D", "[", "genV2Norm", "]"}], "//", 
  "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.6411042631808205`*^9, 3.6411042822283926`*^9}, {
  3.6412169223883533`*^9, 3.641216922448392*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.3315753, 0.4561011, 0.6388182], 
   Point3DBox[
    NCache[{{Rational[50, 13], Rational[40, 13], Rational[40, 13]}, {
      Rational[40, 13], Rational[50, 13], Rational[40, 13]}, {
      Rational[40, 13], Rational[40, 13], Rational[50, 13]}, {
      Rational[10, 3], Rational[10, 3], Rational[10, 3]}, {
      Rational[40, 11], Rational[40, 11], Rational[30, 11]}, {
      Rational[25, 6], Rational[35, 12], Rational[35, 12]}, {
      Rational[150, 41], Rational[130, 41], Rational[130, 41]}, {
      Rational[40, 11], Rational[30, 11], Rational[40, 11]}, {
      Rational[10, 3], Rational[10, 3], Rational[10, 3]}, {4, 3, 3}, {
      Rational[140, 41], Rational[140, 41], Rational[130, 41]}, {
      Rational[140, 41], Rational[130, 41], Rational[140, 41]}, {
      Rational[30, 11], Rational[30, 11], Rational[50, 11]}, {
      Rational[30, 11], Rational[40, 11], Rational[40, 11]}, {
      Rational[30, 11], Rational[50, 11], Rational[30, 11]}, {
      Rational[45, 11], Rational[35, 11], Rational[30, 11]}, {
      Rational[45, 11], Rational[30, 11], Rational[35, 11]}, {
      Rational[65, 21], Rational[65, 21], Rational[80, 21]}, {
      Rational[65, 21], Rational[80, 21], Rational[65, 21]}, {
      Rational[65, 21], Rational[25, 7], Rational[10, 3]}, {
      Rational[65, 21], Rational[10, 3], Rational[25, 7]}, {
      Rational[38, 11], Rational[36, 11], Rational[36, 11]}, {
      Rational[30, 7], Rational[20, 7], Rational[20, 7]}, {
      Rational[130, 41], Rational[150, 41], Rational[130, 41]}, {
      Rational[130, 41], Rational[140, 41], Rational[140, 41]}, {
      Rational[130, 41], Rational[130, 41], Rational[150, 41]}, {
      Rational[60, 17], Rational[105, 34], Rational[115, 34]}, {
      Rational[60, 17], Rational[115, 34], Rational[105, 34]}, {
      4, Rational[5, 2], Rational[7, 2]}, {
      4, Rational[7, 2], Rational[5, 2]}, {
      Rational[35, 8], Rational[45, 16], Rational[45, 16]}, {3, 4, 3}, {
      3, Rational[15, 4], Rational[13, 4]}, {
      3, Rational[7, 2], Rational[7, 2]}, {3, 3, 4}, {
      3, Rational[13, 4], Rational[15, 4]}, {
      Rational[10, 3], Rational[10, 3], Rational[10, 3]}, {
      Rational[10, 3], Rational[80, 23], Rational[220, 69]}, {
      Rational[10, 3], Rational[220, 69], Rational[80, 23]}, {
      Rational[175, 47], Rational[145, 47], Rational[150, 47]}, {
      Rational[175, 47], Rational[150, 47], Rational[145, 47]}, {
      Rational[14, 3], Rational[8, 3], Rational[8, 3]}, {
      Rational[230, 61], Rational[190, 61], Rational[190, 61]}, {
      Rational[400, 109], Rational[340, 109], Rational[350, 109]}, {
      Rational[400, 109], Rational[350, 109], Rational[340, 109]}, {
      Rational[85, 24], Rational[10, 3], Rational[25, 8]}, {
      Rational[85, 24], Rational[25, 8], Rational[10, 3]}, {
      Rational[55, 19], Rational[80, 19], Rational[55, 19]}, {
      Rational[55, 19], Rational[75, 19], Rational[60, 19]}, {
      Rational[23, 6], Rational[37, 12], Rational[37, 12]}, {
      Rational[20, 7], Rational[20, 7], Rational[30, 7]}, {
      Rational[20, 7], Rational[10, 3], Rational[80, 21]}, {
      Rational[20, 7], Rational[80, 21], Rational[10, 3]}, {
      Rational[20, 7], Rational[30, 7], Rational[20, 7]}, {
      Rational[13, 3], 3, Rational[8, 3]}, {
      Rational[13, 3], Rational[8, 3], 3}, {
      Rational[55, 19], Rational[55, 19], Rational[80, 19]}, {
      Rational[55, 19], Rational[60, 19], Rational[75, 19]}, {
      Rational[55, 19], Rational[65, 19], Rational[70, 19]}, {
      Rational[55, 19], Rational[70, 19], Rational[65, 19]}, {
      Rational[190, 41], Rational[110, 41], Rational[110, 41]}, {
      Rational[190, 39], Rational[100, 39], Rational[100, 39]}, {
      Rational[25, 9], Rational[40, 9], Rational[25, 9]}, {
      Rational[25, 9], Rational[25, 6], Rational[55, 18]}, {
      Rational[25, 9], Rational[25, 9], Rational[40, 9]}, {
      Rational[25, 9], Rational[35, 9], Rational[10, 3]}, {
      Rational[25, 9], Rational[55, 18], Rational[25, 6]}, {
      Rational[25, 9], Rational[10, 3], Rational[35, 9]}, {
      Rational[25, 9], Rational[65, 18], Rational[65, 18]}, {
      Rational[60, 13], Rational[100, 39], Rational[110, 39]}, {
      Rational[60, 13], Rational[110, 39], Rational[100, 39]}, {
      Rational[24, 5], Rational[13, 5], Rational[13, 5]}, {
      Rational[150, 41], Rational[255, 82], Rational[265, 82]}, {
      Rational[150, 41], Rational[265, 82], Rational[255, 82]}, {
      Rational[100, 31], Rational[80, 31], Rational[130, 31]}, {
      Rational[100, 31], Rational[130, 31], Rational[80, 31]}, {
      5, Rational[5, 2], Rational[5, 2]}, {
      Rational[45, 17], Rational[80, 17], Rational[45, 17]}, {
      Rational[45, 17], Rational[65, 17], Rational[60, 17]}, {
      Rational[45, 17], Rational[45, 17], Rational[80, 17]}, {
      Rational[45, 17], Rational[50, 17], Rational[75, 17]}, {
      Rational[45, 17], Rational[70, 17], Rational[55, 17]}, {
      Rational[45, 17], Rational[55, 17], Rational[70, 17]}, {
      Rational[45, 17], Rational[75, 17], Rational[50, 17]}, {
      Rational[45, 17], Rational[60, 17], Rational[65, 17]}, {
      Rational[71, 19], Rational[59, 19], Rational[60, 19]}, {
      Rational[71, 19], Rational[60, 19], Rational[59, 19]}, {
      Rational[5, 2], 5, Rational[5, 2]}, {
      Rational[5, 2], Rational[5, 2], 5}, {
      Rational[5, 2], Rational[15, 4], Rational[15, 4]}, {
      Rational[5, 2], Rational[65, 16], Rational[55, 16]}, {
      Rational[5, 2], Rational[45, 16], Rational[75, 16]}, {
      Rational[5, 2], Rational[35, 8], Rational[25, 8]}, {
      Rational[5, 2], Rational[25, 8], Rational[35, 8]}, {
      Rational[5, 2], Rational[75, 16], Rational[45, 16]}, {
      Rational[5, 2], Rational[55, 16], Rational[65, 16]}, {
      Rational[205, 54], Rational[335, 108], Rational[335, 108]}, {
      Rational[290, 77], Rational[240, 77], Rational[240, 77]}, {
      Rational[405, 109], Rational[345, 109], Rational[340, 109]}, {
      Rational[405, 109], Rational[340, 109], Rational[345, 109]}, {
      Rational[535, 143], Rational[445, 143], Rational[450, 143]}, {
      Rational[535, 143], Rational[450, 143], Rational[445, 143]}, {
      Rational[295, 78], Rational[485, 156], Rational[485, 156]}, {
      Rational[64, 17], Rational[53, 17], Rational[53, 17]}, {
      Rational[385, 102], Rational[635, 204], Rational[635, 204]}}, {{
      3.8461538461538463`, 3.076923076923077, 3.076923076923077}, {
      3.076923076923077, 3.8461538461538463`, 3.076923076923077}, {
      3.076923076923077, 3.076923076923077, 3.8461538461538463`}, {
      3.3333333333333335`, 3.3333333333333335`, 3.3333333333333335`}, {
      3.6363636363636362`, 3.6363636363636362`, 2.727272727272727}, {
      4.166666666666667, 2.9166666666666665`, 2.9166666666666665`}, {
      3.658536585365854, 3.1707317073170733`, 3.1707317073170733`}, {
      3.6363636363636362`, 2.727272727272727, 3.6363636363636362`}, {
      3.3333333333333335`, 3.3333333333333335`, 3.3333333333333335`}, {4, 3, 
      3}, {3.4146341463414633`, 3.4146341463414633`, 3.1707317073170733`}, {
      3.4146341463414633`, 3.1707317073170733`, 3.4146341463414633`}, {
      2.727272727272727, 2.727272727272727, 4.545454545454546}, {
      2.727272727272727, 3.6363636363636362`, 3.6363636363636362`}, {
      2.727272727272727, 4.545454545454546, 2.727272727272727}, {
      4.090909090909091, 3.1818181818181817`, 2.727272727272727}, {
      4.090909090909091, 2.727272727272727, 3.1818181818181817`}, {
      3.0952380952380953`, 3.0952380952380953`, 3.8095238095238093`}, {
      3.0952380952380953`, 3.8095238095238093`, 3.0952380952380953`}, {
      3.0952380952380953`, 3.5714285714285716`, 3.3333333333333335`}, {
      3.0952380952380953`, 3.3333333333333335`, 3.5714285714285716`}, {
      3.4545454545454546`, 3.272727272727273, 3.272727272727273}, {
      4.285714285714286, 2.857142857142857, 2.857142857142857}, {
      3.1707317073170733`, 3.658536585365854, 3.1707317073170733`}, {
      3.1707317073170733`, 3.4146341463414633`, 3.4146341463414633`}, {
      3.1707317073170733`, 3.1707317073170733`, 3.658536585365854}, {
      3.5294117647058822`, 3.088235294117647, 3.3823529411764706`}, {
      3.5294117647058822`, 3.3823529411764706`, 3.088235294117647}, {
      4, 2.5, 3.5}, {4, 3.5, 2.5}, {4.375, 2.8125, 2.8125}, {3, 4, 3}, {
      3, 3.75, 3.25}, {3, 3.5, 3.5}, {3, 3, 4}, {3, 3.25, 3.75}, {
      3.3333333333333335`, 3.3333333333333335`, 3.3333333333333335`}, {
      3.3333333333333335`, 3.4782608695652173`, 3.1884057971014492`}, {
      3.3333333333333335`, 3.1884057971014492`, 3.4782608695652173`}, {
      3.723404255319149, 3.0851063829787235`, 3.1914893617021276`}, {
      3.723404255319149, 3.1914893617021276`, 3.0851063829787235`}, {
      4.666666666666667, 2.6666666666666665`, 2.6666666666666665`}, {
      3.7704918032786887`, 3.1147540983606556`, 3.1147540983606556`}, {
      3.669724770642202, 3.1192660550458715`, 3.2110091743119265`}, {
      3.669724770642202, 3.2110091743119265`, 3.1192660550458715`}, {
      3.5416666666666665`, 3.3333333333333335`, 3.125}, {3.5416666666666665`, 
      3.125, 3.3333333333333335`}, {2.8947368421052633`, 4.2105263157894735`, 
      2.8947368421052633`}, {2.8947368421052633`, 3.9473684210526314`, 
      3.1578947368421053`}, {3.8333333333333335`, 3.0833333333333335`, 
      3.0833333333333335`}, {2.857142857142857, 2.857142857142857, 
      4.285714285714286}, {2.857142857142857, 3.3333333333333335`, 
      3.8095238095238093`}, {2.857142857142857, 3.8095238095238093`, 
      3.3333333333333335`}, {2.857142857142857, 4.285714285714286, 
      2.857142857142857}, {4.333333333333333, 3, 2.6666666666666665`}, {
      4.333333333333333, 2.6666666666666665`, 3}, {2.8947368421052633`, 
      2.8947368421052633`, 4.2105263157894735`}, {2.8947368421052633`, 
      3.1578947368421053`, 3.9473684210526314`}, {2.8947368421052633`, 
      3.4210526315789473`, 3.6842105263157894`}, {2.8947368421052633`, 
      3.6842105263157894`, 3.4210526315789473`}, {4.634146341463414, 
      2.682926829268293, 2.682926829268293}, {4.871794871794871, 
      2.5641025641025643`, 2.5641025641025643`}, {2.7777777777777777`, 
      4.444444444444445, 2.7777777777777777`}, {2.7777777777777777`, 
      4.166666666666667, 3.0555555555555554`}, {2.7777777777777777`, 
      2.7777777777777777`, 4.444444444444445}, {2.7777777777777777`, 
      3.888888888888889, 3.3333333333333335`}, {2.7777777777777777`, 
      3.0555555555555554`, 4.166666666666667}, {2.7777777777777777`, 
      3.3333333333333335`, 3.888888888888889}, {2.7777777777777777`, 
      3.611111111111111, 3.611111111111111}, {4.615384615384615, 
      2.5641025641025643`, 2.8205128205128207`}, {4.615384615384615, 
      2.8205128205128207`, 2.5641025641025643`}, {4.8, 2.6, 2.6}, {
      3.658536585365854, 3.1097560975609757`, 3.231707317073171}, {
      3.658536585365854, 3.231707317073171, 3.1097560975609757`}, {
      3.225806451612903, 2.5806451612903225`, 4.193548387096774}, {
      3.225806451612903, 4.193548387096774, 2.5806451612903225`}, {
      5, 2.5, 2.5}, {2.6470588235294117`, 4.705882352941177, 
      2.6470588235294117`}, {2.6470588235294117`, 3.823529411764706, 
      3.5294117647058822`}, {2.6470588235294117`, 2.6470588235294117`, 
      4.705882352941177}, {2.6470588235294117`, 2.9411764705882355`, 
      4.411764705882353}, {2.6470588235294117`, 4.117647058823529, 
      3.235294117647059}, {2.6470588235294117`, 3.235294117647059, 
      4.117647058823529}, {2.6470588235294117`, 4.411764705882353, 
      2.9411764705882355`}, {2.6470588235294117`, 3.5294117647058822`, 
      3.823529411764706}, {3.736842105263158, 3.1052631578947367`, 
      3.1578947368421053`}, {3.736842105263158, 3.1578947368421053`, 
      3.1052631578947367`}, {2.5, 5, 2.5}, {2.5, 2.5, 5}, {2.5, 3.75, 3.75}, {
      2.5, 4.0625, 3.4375}, {2.5, 2.8125, 4.6875}, {2.5, 4.375, 3.125}, {2.5, 
      3.125, 4.375}, {2.5, 4.6875, 2.8125}, {2.5, 3.4375, 4.0625}, {
      3.7962962962962963`, 3.1018518518518516`, 3.1018518518518516`}, {
      3.7662337662337664`, 3.116883116883117, 3.116883116883117}, {
      3.7155963302752295`, 3.165137614678899, 3.1192660550458715`}, {
      3.7155963302752295`, 3.1192660550458715`, 3.165137614678899}, {
      3.7412587412587412`, 3.111888111888112, 3.1468531468531467`}, {
      3.7412587412587412`, 3.1468531468531467`, 3.111888111888112}, {
      3.782051282051282, 3.108974358974359, 3.108974358974359}, {
      3.764705882352941, 3.1176470588235294`, 3.1176470588235294`}, {
      3.7745098039215685`, 3.1127450980392157`, 3.1127450980392157`}}]]},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  BoxRatios->{1, 1, 0.4},
  FaceGridsStyle->Automatic,
  PlotRange->All,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.641104273277015*^9, 3.6411042825616393`*^9}, {
   3.641216918170356*^9, 3.641216922774623*^9}, 3.6412926840862427`*^9, 
   3.641357379699025*^9, 3.6413687131627073`*^9, 3.641383543650182*^9, 
   3.6416348597567873`*^9, 3.641636070066327*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msgGenV2", "=", 
  RowBox[{"msgCHSgr", "[", 
   RowBox[{"v2", ",", "genV2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6411043240842276`*^9, 3.6411043546970377`*^9}, {
  3.6413687155353985`*^9, 3.641368717853033*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "8", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "9", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "9", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "11", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "12", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "13", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "14", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "15", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "16", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "6", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "7", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "9", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "9", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "11", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "13", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "14", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "15", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "16", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "7", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "8", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "10", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "13", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "13", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "14", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "15", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "16", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "11", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "12", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "14", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "15", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "16", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "12", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "14", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "15", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "9", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "13", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "14", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "15", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "8", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "9", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "10", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "11", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "10", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "11", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "12", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "13", ",", "13"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.641104356924698*^9, 3.641216926708423*^9, 
  3.6412926869022408`*^9, 3.6413573832135267`*^9, 3.6413687215486536`*^9, 
  3.6413835488909035`*^9, 3.641634866790805*^9, 3.6416360761164474`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"msgGenV2Norm", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"gAux", "[", 
      RowBox[{"#", ",", "10"}], "]"}], "&"}], " ", "/@", " ", "msgGenV2"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.641104366204241*^9, 3.641104373790645*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPointPlot3D", "[", "msgGenV2Norm", "]"}], "//", 
  "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.6411043840499563`*^9, 3.641104413232745*^9}, {
  3.641216933121973*^9, 3.6412169332180433`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.3315753, 0.4561011, 0.6388182], 
   Point3DBox[
    NCache[{{Rational[30, 11], Rational[30, 11], Rational[50, 11]}, {
      Rational[30, 11], Rational[40, 11], Rational[40, 11]}, {
      Rational[30, 11], Rational[50, 11], Rational[30, 11]}, {4, 3, 3}, {
      Rational[40, 11], Rational[30, 11], Rational[40, 11]}, {
      Rational[40, 11], Rational[40, 11], Rational[30, 11]}, {
      Rational[10, 3], Rational[10, 3], Rational[10, 3]}, {
      Rational[40, 13], Rational[40, 13], Rational[50, 13]}, {
      Rational[40, 13], Rational[50, 13], Rational[40, 13]}, {
      Rational[50, 13], Rational[40, 13], Rational[40, 13]}, {
      Rational[20, 7], Rational[20, 7], Rational[30, 7]}, {
      Rational[20, 7], Rational[10, 3], Rational[80, 21]}, {
      Rational[20, 7], Rational[80, 21], Rational[10, 3]}, {
      Rational[20, 7], Rational[30, 7], Rational[20, 7]}, {
      4, Rational[5, 2], Rational[7, 2]}, {
      4, Rational[7, 2], Rational[5, 2]}, {
      Rational[5, 2], Rational[5, 2], 5}, {
      Rational[5, 2], Rational[45, 16], Rational[75, 16]}, {
      Rational[5, 2], Rational[25, 8], Rational[35, 8]}, {
      Rational[5, 2], Rational[55, 16], Rational[65, 16]}, {
      Rational[5, 2], Rational[15, 4], Rational[15, 4]}, {
      Rational[5, 2], Rational[65, 16], Rational[55, 16]}, {
      Rational[5, 2], Rational[35, 8], Rational[25, 8]}, {
      Rational[5, 2], Rational[75, 16], Rational[45, 16]}, {
      Rational[5, 2], 5, Rational[5, 2]}, {
      Rational[30, 7], Rational[20, 7], Rational[20, 7]}, {
      Rational[45, 11], Rational[30, 11], Rational[35, 11]}, {
      Rational[45, 11], Rational[35, 11], Rational[30, 11]}, {
      Rational[10, 3], Rational[10, 3], Rational[10, 3]}, {
      Rational[45, 17], Rational[45, 17], Rational[80, 17]}, {
      Rational[45, 17], Rational[50, 17], Rational[75, 17]}, {
      Rational[45, 17], Rational[55, 17], Rational[70, 17]}, {
      Rational[45, 17], Rational[60, 17], Rational[65, 17]}, {
      Rational[45, 17], Rational[65, 17], Rational[60, 17]}, {
      Rational[45, 17], Rational[70, 17], Rational[55, 17]}, {
      Rational[45, 17], Rational[75, 17], Rational[50, 17]}, {
      Rational[45, 17], Rational[80, 17], Rational[45, 17]}, {
      Rational[25, 6], Rational[35, 12], Rational[35, 12]}, {
      Rational[100, 31], Rational[80, 31], Rational[130, 31]}, {
      Rational[25, 9], Rational[25, 9], Rational[40, 9]}, {
      Rational[25, 9], Rational[55, 18], Rational[25, 6]}, {
      Rational[25, 9], Rational[10, 3], Rational[35, 9]}, {
      Rational[100, 31], Rational[130, 31], Rational[80, 31]}, {
      Rational[25, 9], Rational[65, 18], Rational[65, 18]}, {
      Rational[25, 9], Rational[35, 9], Rational[10, 3]}, {
      Rational[25, 9], Rational[25, 6], Rational[55, 18]}, {
      Rational[25, 9], Rational[40, 9], Rational[25, 9]}, {
      Rational[55, 19], Rational[55, 19], Rational[80, 19]}, {
      Rational[55, 19], Rational[60, 19], Rational[75, 19]}, {
      Rational[55, 19], Rational[65, 19], Rational[70, 19]}, {
      Rational[55, 19], Rational[70, 19], Rational[65, 19]}, {
      Rational[55, 19], Rational[75, 19], Rational[60, 19]}, {
      Rational[55, 19], Rational[80, 19], Rational[55, 19]}, {3, 3, 4}, {
      3, Rational[13, 4], Rational[15, 4]}, {
      3, Rational[7, 2], Rational[7, 2]}, {
      3, Rational[15, 4], Rational[13, 4]}, {3, 4, 3}, {
      Rational[13, 3], Rational[8, 3], 3}, {
      Rational[13, 3], 3, Rational[8, 3]}, {
      Rational[130, 41], Rational[130, 41], Rational[150, 41]}, {
      Rational[130, 41], Rational[140, 41], Rational[140, 41]}, {
      Rational[130, 41], Rational[150, 41], Rational[130, 41]}, {
      Rational[14, 3], Rational[8, 3], Rational[8, 3]}, {
      Rational[35, 8], Rational[45, 16], Rational[45, 16]}, {
      Rational[60, 13], Rational[100, 39], Rational[110, 39]}, {
      Rational[60, 13], Rational[110, 39], Rational[100, 39]}, {
      Rational[190, 39], Rational[100, 39], Rational[100, 39]}, {
      Rational[190, 41], Rational[110, 41], Rational[110, 41]}, {
      5, Rational[5, 2], Rational[5, 2]}, {
      Rational[24, 5], Rational[13, 5], Rational[13, 5]}}, {{
      2.727272727272727, 2.727272727272727, 4.545454545454546}, {
      2.727272727272727, 3.6363636363636362`, 3.6363636363636362`}, {
      2.727272727272727, 4.545454545454546, 2.727272727272727}, {4, 3, 3}, {
      3.6363636363636362`, 2.727272727272727, 3.6363636363636362`}, {
      3.6363636363636362`, 3.6363636363636362`, 2.727272727272727}, {
      3.3333333333333335`, 3.3333333333333335`, 3.3333333333333335`}, {
      3.076923076923077, 3.076923076923077, 3.8461538461538463`}, {
      3.076923076923077, 3.8461538461538463`, 3.076923076923077}, {
      3.8461538461538463`, 3.076923076923077, 3.076923076923077}, {
      2.857142857142857, 2.857142857142857, 4.285714285714286}, {
      2.857142857142857, 3.3333333333333335`, 3.8095238095238093`}, {
      2.857142857142857, 3.8095238095238093`, 3.3333333333333335`}, {
      2.857142857142857, 4.285714285714286, 2.857142857142857}, {
      4, 2.5, 3.5}, {4, 3.5, 2.5}, {2.5, 2.5, 5}, {2.5, 2.8125, 4.6875}, {2.5,
       3.125, 4.375}, {2.5, 3.4375, 4.0625}, {2.5, 3.75, 3.75}, {2.5, 4.0625, 
      3.4375}, {2.5, 4.375, 3.125}, {2.5, 4.6875, 2.8125}, {2.5, 5, 2.5}, {
      4.285714285714286, 2.857142857142857, 2.857142857142857}, {
      4.090909090909091, 2.727272727272727, 3.1818181818181817`}, {
      4.090909090909091, 3.1818181818181817`, 2.727272727272727}, {
      3.3333333333333335`, 3.3333333333333335`, 3.3333333333333335`}, {
      2.6470588235294117`, 2.6470588235294117`, 4.705882352941177}, {
      2.6470588235294117`, 2.9411764705882355`, 4.411764705882353}, {
      2.6470588235294117`, 3.235294117647059, 4.117647058823529}, {
      2.6470588235294117`, 3.5294117647058822`, 3.823529411764706}, {
      2.6470588235294117`, 3.823529411764706, 3.5294117647058822`}, {
      2.6470588235294117`, 4.117647058823529, 3.235294117647059}, {
      2.6470588235294117`, 4.411764705882353, 2.9411764705882355`}, {
      2.6470588235294117`, 4.705882352941177, 2.6470588235294117`}, {
      4.166666666666667, 2.9166666666666665`, 2.9166666666666665`}, {
      3.225806451612903, 2.5806451612903225`, 4.193548387096774}, {
      2.7777777777777777`, 2.7777777777777777`, 4.444444444444445}, {
      2.7777777777777777`, 3.0555555555555554`, 4.166666666666667}, {
      2.7777777777777777`, 3.3333333333333335`, 3.888888888888889}, {
      3.225806451612903, 4.193548387096774, 2.5806451612903225`}, {
      2.7777777777777777`, 3.611111111111111, 3.611111111111111}, {
      2.7777777777777777`, 3.888888888888889, 3.3333333333333335`}, {
      2.7777777777777777`, 4.166666666666667, 3.0555555555555554`}, {
      2.7777777777777777`, 4.444444444444445, 2.7777777777777777`}, {
      2.8947368421052633`, 2.8947368421052633`, 4.2105263157894735`}, {
      2.8947368421052633`, 3.1578947368421053`, 3.9473684210526314`}, {
      2.8947368421052633`, 3.4210526315789473`, 3.6842105263157894`}, {
      2.8947368421052633`, 3.6842105263157894`, 3.4210526315789473`}, {
      2.8947368421052633`, 3.9473684210526314`, 3.1578947368421053`}, {
      2.8947368421052633`, 4.2105263157894735`, 2.8947368421052633`}, {3, 3, 
      4}, {3, 3.25, 3.75}, {3, 3.5, 3.5}, {3, 3.75, 3.25}, {3, 4, 3}, {
      4.333333333333333, 2.6666666666666665`, 3}, {
      4.333333333333333, 3, 2.6666666666666665`}, {3.1707317073170733`, 
      3.1707317073170733`, 3.658536585365854}, {3.1707317073170733`, 
      3.4146341463414633`, 3.4146341463414633`}, {3.1707317073170733`, 
      3.658536585365854, 3.1707317073170733`}, {4.666666666666667, 
      2.6666666666666665`, 2.6666666666666665`}, {4.375, 2.8125, 2.8125}, {
      4.615384615384615, 2.5641025641025643`, 2.8205128205128207`}, {
      4.615384615384615, 2.8205128205128207`, 2.5641025641025643`}, {
      4.871794871794871, 2.5641025641025643`, 2.5641025641025643`}, {
      4.634146341463414, 2.682926829268293, 2.682926829268293}, {
      5, 2.5, 2.5}, {4.8, 2.6, 2.6}}]]},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  BoxRatios->{1, 1, 0.4},
  FaceGridsStyle->Automatic,
  PlotRange->All,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6411043989725847`*^9, 3.641104413733101*^9}, {
   3.641216929686531*^9, 3.6412169335422688`*^9}, 3.6412926897842884`*^9, 
   3.64135738626768*^9, 3.641368721653737*^9, 3.6413835521061893`*^9, 
   3.641634869167494*^9, 3.64163607628833*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ff", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Alpha]_", "\[Rule]", "a_"}], ",", 
       RowBox[{"\[Beta]_", "\[Rule]", "b_"}], ",", 
       RowBox[{"\[Chi]_", "\[Rule]", "c_"}]}], "}"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6411048668319335`*^9, 3.6411048747135625`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "msgGenV2", "]"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"msgGenV2", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"\[Alpha]", " ", 
           RowBox[{"vTrV2", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "+", 
          RowBox[{"\[Beta]", " ", 
           RowBox[{"vTrV2", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "+", 
          RowBox[{"\[Chi]", " ", 
           RowBox[{"vTrV2", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Chi]"}], "}"}]}], "]"}], 
      "//", "ff"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "sol", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"sol", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "0"}], "\[Or]", 
       RowBox[{
        RowBox[{"sol", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "<", "0"}], "\[Or]", 
       RowBox[{
        RowBox[{"sol", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "<", "0"}]}], ",", 
      RowBox[{"Print", "[", "\"\<Error\>\"", "]"}]}], "]"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.641104609923894*^9, 3.6411049353337545`*^9}, {
  3.641216966790882*^9, 3.641216974837597*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "4"], ",", 
   FractionBox["1", "4"], ",", 
   FractionBox["9", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783525467`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "4"], ",", 
   FractionBox["5", "4"], ",", 
   FractionBox["5", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783525467`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "4"], ",", 
   FractionBox["9", "4"], ",", 
   FractionBox["1", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783525467`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783525467`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "4"], ",", 
   FractionBox["1", "4"], ",", 
   FractionBox["5", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783525467`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "4"], ",", 
   FractionBox["5", "4"], ",", 
   FractionBox["1", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783681717`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783681717`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "4"], ",", 
   FractionBox["3", "4"], ",", 
   FractionBox["7", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783681717`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "4"], ",", 
   FractionBox["7", "4"], ",", 
   FractionBox["3", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783681717`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["7", "4"], ",", 
   FractionBox["3", "4"], ",", 
   FractionBox["3", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783681717`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "4"], ",", 
   FractionBox["3", "4"], ",", 
   FractionBox["15", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783837976`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "4"], ",", 
   FractionBox["7", "4"], ",", 
   FractionBox["11", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783837976`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "4"], ",", 
   FractionBox["11", "4"], ",", 
   FractionBox["7", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783837976`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "4"], ",", 
   FractionBox["15", "4"], ",", 
   FractionBox["3", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783837976`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "0", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783837976`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783994226`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "8"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783994226`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "7"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783994226`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "2", ",", "6"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783994226`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "3", ",", "5"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783994226`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "4", ",", "4"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360783994226`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "5", ",", "3"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784150486`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "6", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784150486`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "7", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784150486`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "8", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784150486`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["15", "4"], ",", 
   FractionBox["3", "4"], ",", 
   FractionBox["3", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784150486`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["7", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["3", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784150486`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["7", "2"], ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["1", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784306746`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["9", "4"], ",", 
   FractionBox["9", "4"], ",", 
   FractionBox["9", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784306746`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["15", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784306746`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["13", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784306746`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["5", "2"], ",", 
   FractionBox["11", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784306746`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["7", "2"], ",", 
   FractionBox["9", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784463*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["9", "2"], ",", 
   FractionBox["7", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784463*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["11", "2"], ",", 
   FractionBox["5", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784463*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["13", "2"], ",", 
   FractionBox["3", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784463*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["15", "2"], ",", 
   FractionBox["1", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784463*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784463*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["9", "4"], ",", 
   FractionBox["1", "4"], ",", 
   FractionBox["21", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784619255`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "7"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784619255`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "6"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784619255`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "5"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784619255`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["9", "4"], ",", 
   FractionBox["21", "4"], ",", 
   FractionBox["1", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784619255`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "4"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784775515`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "3"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784775515`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "6", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784775515`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "7", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784775515`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["13", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784775515`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["5", "2"], ",", 
   FractionBox["11", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784775515`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["7", "2"], ",", 
   FractionBox["9", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784931765`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["9", "2"], ",", 
   FractionBox["7", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784931765`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["11", "2"], ",", 
   FractionBox["5", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784931765`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["13", "2"], ",", 
   FractionBox["3", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784931765`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "6"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360784931765`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "5"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785088024`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "4"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785088024`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "5", ",", "3"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785088024`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "6", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785088024`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["3", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785088024`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11", "2"], ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["1", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785088024`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11", "4"], ",", 
   FractionBox["11", "4"], ",", 
   FractionBox["19", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785244284`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11", "4"], ",", 
   FractionBox["15", "4"], ",", 
   FractionBox["15", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785244284`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11", "4"], ",", 
   FractionBox["19", "4"], ",", 
   FractionBox["11", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785244284`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["13", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785244284`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785244284`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["33", "4"], ",", 
   FractionBox["1", "4"], ",", 
   FractionBox["5", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785400534`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["33", "4"], ",", 
   FractionBox["5", "4"], ",", 
   FractionBox["1", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785400534`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["37", "4"], ",", 
   FractionBox["1", "4"], ",", 
   FractionBox["1", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785400534`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["35", "4"], ",", 
   FractionBox["3", "4"], ",", 
   FractionBox["3", "4"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785400534`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12", ",", "0", ",", "0"}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785400534`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["23", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"]}], "}"}]], "Print",
 CellChangeTimes->{
  3.641104715789322*^9, {3.6411047468524556`*^9, 3.641104773640542*^9}, {
   3.641104843269144*^9, 3.6411048985465307`*^9}, 3.6411049357740655`*^9, {
   3.641216938024444*^9, 3.6412169439136343`*^9}, 3.641216976824997*^9, 
   3.6412926926162977`*^9, 3.641357389088692*^9, 3.641368725062148*^9, 
   3.6413835562861547`*^9, 3.64163487304359*^9, 3.6416360785400534`*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "Section"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6410491101147895`*^9, 3.641049111068471*^9}, {
  3.6416352978806953`*^9, 3.641635316737838*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", 
   RowBox[{"\"\<convexHullSemigroups3D`\>\"", ",", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
     "\"\<\\\\convexHullSemigroups3DLibraryV6.wl\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6413672154453716`*^9, 3.6413673099854956`*^9}, 
   3.6416212537002673`*^9}],

Cell[BoxData["\<\"J. I. Garc\[IAcute]a-Garc\[IAcute]a and A. \
Vigneron-Tenorio,\\nDpto. Matem\[AAcute]ticas, \\nUniversidad de \
C\[AAcute]diz\\nignacio.garcia@uca.es, alberto.vigneron@uca.es\\n\\nThis \
package contains the commands: \\n....\\nTry command::usage for more \
help\"\>"], "Print",
 CellChangeTimes->{3.6416355737271833`*^9, 3.641635691981591*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"configuration", "[", 
   RowBox[{
   "\"\<C:\\\\tmp\\\\lrs\\\\lrs.exe\>\"", ",", "\"\<C:\\\\tmp\\\\\>\"", ",", 
    "\"\<C:\\\\tmp\\\\Normaliz2.12\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"showConfiguration", "[", "]"}]}], "Input",
 CellChangeTimes->{{3.64104912673164*^9, 3.6410491300119753`*^9}, 
   3.641049284252866*^9, {3.6411073213478384`*^9, 3.641107352088739*^9}, {
   3.6411074438150835`*^9, 3.64110744640294*^9}, {3.641291681429268*^9, 
   3.6412916825410633`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C:\\\\tmp\\\\lrs\\\\lrs.exe\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\Normaliz2.12\"\>"}],
  SequenceForm[
  "C:\\tmp\\lrs\\lrs.exe", "\n", "C:\\tmp\\", "\n", "C:\\tmp\\Normaliz2.12"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6416353350258656`*^9, 3.6416354100954423`*^9, 
  3.6416355750441637`*^9, 3.6416356928218555`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{
    RowBox[{"8", "/", "3"}], "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"9", "/", "10"}], "*", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{
        RowBox[{"3", "/", "8"}], "*", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], ",", 
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{
        RowBox[{"3", "/", "8"}], "*", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}]}], ",", 
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "+", 
       RowBox[{
        RowBox[{"3", "/", "8"}], "*", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "/", "5"}], ",", 
          RowBox[{
           RowBox[{"-", "11"}], "/", "10"}], ",", 
          RowBox[{
           RowBox[{"-", "11"}], "/", "10"}]}], "}"}]}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"cota", "=", 
  RowBox[{"boundCohenMacaulay", "[", "v2", "]"}]}]}], "Input",
 CellChangeTimes->{{3.6412927288370266`*^9, 3.6412927301909885`*^9}, {
  3.6416354396004887`*^9, 3.641635441328724*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636086169344*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["77", "15"], ",", 
     FractionBox["127", "30"], ",", 
     FractionBox["127", "30"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[24, 5], 
    Rational[12, 5], 
    Rational[12, 5], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[77, 15], 
    Rational[127, 30], 
    Rational[127, 30]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.64163608618497*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"144", ",", "72", ",", "72"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "160", ",", "80"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "80", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "130", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "160", ",", "130"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"154", ",", "127", ",", "127"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{144, 72, 72}, {80, 160, 80}, {80, 80, 160}, {130, 130, 160}, {130, 
   160, 130}, {154, 127, 127}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.64163608618497*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.64163608618497*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636086231847*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"614.4`", ",", "1024.`", ",", "1024.`"}], "}"}]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.6416360863568544`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["24", "5"], ",", 
        FractionBox["12", "5"], ",", 
        FractionBox["12", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"], ",", 
        FractionBox["8", "3"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[24, 5], 
      Rational[12, 5], 
      Rational[12, 5]}}, {{
      Rational[8, 3], 
      Rational[16, 3], 
      Rational[8, 3]}}, {{
      Rational[8, 3], 
      Rational[8, 3], 
      Rational[16, 3]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.6416360863568544`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["24", "5"], ",", 
      FractionBox["12", "5"], ",", 
      FractionBox["12", "5"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 1, "]]=", {{
     Rational[24, 5], 
     Rational[12, 5], 
     Rational[12, 5]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636086372477*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["8", "3"], ",", 
      FractionBox["16", "3"], ",", 
      FractionBox["8", "3"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 2, "]]=", {{
     Rational[8, 3], 
     Rational[16, 3], 
     Rational[8, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.6416360864974823`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["8", "3"], ",", 
      FractionBox["8", "3"], ",", 
      FractionBox["16", "3"]}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 3, "]]=", {{
     Rational[8, 3], 
     Rational[8, 3], 
     Rational[16, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636086731866*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[1]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox["384", "25"], ",", 
        FractionBox["312", "25"], ",", 
        FractionBox["312", "25"]}], "}"}], ",", "3"}], "}"}], "}"}]}],
  SequenceForm["pYk[[1]]=", {{{
      Rational[384, 25], 
      Rational[312, 25], 
      Rational[312, 25]}, 3}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087073536*^9}],

Cell[BoxData[
 RowBox[{"{", 
  FractionBox["33792", "25"], "}"}]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087073536*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[2]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["64", "5"], ",", "16", ",", 
         FractionBox["64", "5"]}], "}"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["1888", "125"], ",", 
         FractionBox["1604", "125"], ",", 
         FractionBox["1564", "125"]}], "}"}], ",", "3"}], "}"}]}], "}"}]}],
  SequenceForm["pYk[[2]]=", {{{
      Rational[64, 5], 16, 
      Rational[64, 5]}, 3}, {{
      Rational[1888, 125], 
      Rational[1604, 125], 
      Rational[1564, 125]}, 3}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087089162*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["10752", "5"], ",", 
   FractionBox["26112", "25"]}], "}"}]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087089162*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[3]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["64", "5"], ",", 
         FractionBox["64", "5"], ",", "16"}], "}"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["1888", "125"], ",", 
         FractionBox["1564", "125"], ",", 
         FractionBox["1604", "125"]}], "}"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["64", "5"], ",", 
         FractionBox["392", "25"], ",", 
         FractionBox["328", "25"]}], "}"}], ",", "3"}], "}"}]}], "}"}]}],
  SequenceForm["pYk[[3]]=", {{{
      Rational[64, 5], 
      Rational[64, 5], 16}, 3}, {{
      Rational[1888, 125], 
      Rational[1564, 125], 
      Rational[1604, 125]}, 3}, {{
      Rational[64, 5], 
      Rational[392, 25], 
      Rational[328, 25]}, 3}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087089162*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["10752", "5"], ",", 
   FractionBox["26112", "25"], ",", 
   FractionBox["26112", "25"]}], "}"}]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087104787*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximo=\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["Maximo=", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087104787*^9}],

Cell[BoxData["\<\"--------------\"\>"], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087104787*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "1277.952`"}],
  SequenceForm["daux=", 1277.952],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087104787*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["384", "25"], ",", 
      FractionBox["312", "25"], ",", 
      FractionBox["312", "25"]}], "}"}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[384, 25], 
     Rational[312, 25], 
     Rational[312, 25]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087104787*^9}],

Cell[BoxData[
 RowBox[{"{", "1351.68`", "}"}]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087120413*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087120413*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "2027.52`"}],
  SequenceForm["daux=", 2027.52],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087120413*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["64", "5"], ",", "16", ",", 
       FractionBox["64", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1888", "125"], ",", 
       FractionBox["1604", "125"], ",", 
       FractionBox["1564", "125"]}], "}"}]}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[64, 5], 16, 
     Rational[64, 5]}, {
     Rational[1888, 125], 
     Rational[1604, 125], 
     Rational[1564, 125]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087120413*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2150.4`", ",", "1044.48`"}], "}"}]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087120413*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["15872", "5"], ",", 
     FractionBox["51712", "25"]}], "}"}], "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["51712", "25"], "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}],
  SequenceForm["vAux=", {
    Rational[15872, 5], 
    Rational[51712, 25]}, " ", 
   Rational[51712, 25], " ", {0, 1, 0}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087136038*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["lkaux[[i]]=", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087136038*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"daux=\"\>", "\[InvisibleSpace]", "921.6`"}],
  SequenceForm["daux=", 921.6],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087136038*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"listaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["64", "5"], ",", 
       FractionBox["64", "5"], ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1888", "125"], ",", 
       FractionBox["1564", "125"], ",", 
       FractionBox["1604", "125"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["64", "5"], ",", 
       FractionBox["392", "25"], ",", 
       FractionBox["328", "25"]}], "}"}]}], "}"}]}],
  SequenceForm["listaAux=", {{
     Rational[64, 5], 
     Rational[64, 5], 16}, {
     Rational[1888, 125], 
     Rational[1564, 125], 
     Rational[1604, 125]}, {
     Rational[64, 5], 
     Rational[392, 25], 
     Rational[328, 25]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087136038*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2150.4`", ",", "1044.48`", ",", "1044.48`"}], "}"}]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087136038*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lkaux[[i]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["lkaux[[i]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635447830574*^9, 3.6416355805356555`*^9, 
  3.6416357022981186`*^9, 3.641636087151664*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          FractionBox["384", "25"], ",", 
          FractionBox["312", "25"], ",", 
          FractionBox["312", "25"]}], "}"}], ",", "3"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["64", "5"], ",", "16", ",", 
           FractionBox["64", "5"]}], "}"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["1888", "125"], ",", 
           FractionBox["1604", "125"], ",", 
           FractionBox["1564", "125"]}], "}"}], ",", "3"}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["64", "5"], ",", 
           FractionBox["64", "5"], ",", "16"}], "}"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["1888", "125"], ",", 
           FractionBox["1564", "125"], ",", 
           FractionBox["1604", "125"]}], "}"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["64", "5"], ",", 
           FractionBox["392", "25"], ",", 
           FractionBox["328", "25"]}], "}"}], ",", "3"}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["24", "5"], ",", 
        FractionBox["12", "5"], ",", 
        FractionBox["12", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"], ",", 
        FractionBox["8", "3"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"]}], "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"24", ",", "12", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "16", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "8", ",", "16"}], "}"}]}], "}"}], ",", "4", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"16", "+", 
       RowBox[{"3", " ", "x1"}], "-", 
       RowBox[{"3", " ", "x2"}], "-", 
       RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"48", "-", 
       RowBox[{"11", " ", "x1"}], "+", 
       RowBox[{"11", " ", "x2"}], "-", 
       RowBox[{"9", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"97", "-", 
       RowBox[{"9", " ", "x1"}], "-", 
       RowBox[{"6", " ", "x2"}], "-", 
       RowBox[{"6", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"48", "-", 
       RowBox[{"11", " ", "x1"}], "-", 
       RowBox[{"9", " ", "x2"}], "+", 
       RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "24"}], "+", 
       RowBox[{"3", " ", "x1"}], "+", 
       RowBox[{"2", " ", "x2"}], "+", 
       RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6416357033026953`*^9, 3.641636087151664*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"raysOfConeOfCHSgr", "[", "v2", "]"}]], "Input",
 CellChangeTimes->{{3.6412748876227493`*^9, 3.641274890188572*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.641635723137365*^9, 3.641636093590581*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["77", "15"], ",", 
     FractionBox["127", "30"], ",", 
     FractionBox["127", "30"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[24, 5], 
    Rational[12, 5], 
    Rational[12, 5], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[77, 15], 
    Rational[127, 30], 
    Rational[127, 30]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635723137365*^9, 3.641636093590581*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"144", ",", "72", ",", "72"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "160", ",", "80"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "80", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "130", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "160", ",", "130"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"154", ",", "127", ",", "127"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{144, 72, 72}, {80, 160, 80}, {80, 80, 160}, {130, 130, 160}, {130, 
   160, 130}, {154, 127, 127}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635723137365*^9, 3.641636093590581*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635723137365*^9, 3.641636093590581*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.641635723137365*^9, 3.6416360936687098`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6412748909281073`*^9, 3.6412751104519978`*^9, 3.6412753688844943`*^9, 
   3.6412754792628765`*^9, 3.641275584517617*^9, 3.6412756623879232`*^9, 
   3.6412757304862785`*^9, {3.641275818042448*^9, 3.6412759117109685`*^9}, 
   3.641275942450797*^9, 3.6412760345151634`*^9, 3.641276188243393*^9, 
   3.6412762419575357`*^9, 3.641292711130446*^9, 3.6413573976017294`*^9, 
   3.6413687379443045`*^9, 3.6413835657108393`*^9, 3.6416348795243835`*^9, 
   3.6416352809409685`*^9, 3.641635723340498*^9, 3.6416360937780886`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"v2", ",", "3", ",", "False", ",", "True", ",", "True"}], "]"}], 
   "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.6412644031579285`*^9, 3.6412644233933*^9}, {
  3.641292720952427*^9, 3.641292723406165*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.641635724621799*^9, 3.641636094760647*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["77", "15"], ",", 
     FractionBox["127", "30"], ",", 
     FractionBox["127", "30"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[24, 5], 
    Rational[12, 5], 
    Rational[12, 5], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[77, 15], 
    Rational[127, 30], 
    Rational[127, 30]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635724621799*^9, 3.641636094760647*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"144", ",", "72", ",", "72"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "160", ",", "80"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "80", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "130", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "160", ",", "130"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"154", ",", "127", ",", "127"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{144, 72, 72}, {80, 160, 80}, {80, 80, 160}, {130, 130, 160}, {130, 
   160, 130}, {154, 127, 127}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635724621799*^9, 3.641636094776272*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635724621799*^9, 3.641636094776272*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.641635724621799*^9, 3.641636094833957*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["24", "5"], ",", 
        FractionBox["12", "5"], ",", 
        FractionBox["12", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"], ",", 
        FractionBox["8", "3"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[24, 5], 
      Rational[12, 5], 
      Rational[12, 5]}}, {{
      Rational[8, 3], 
      Rational[16, 3], 
      Rational[8, 3]}}, {{
      Rational[8, 3], 
      Rational[8, 3], 
      Rational[16, 3]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635724621799*^9, 3.6416360949433365`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["24", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["12", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["16", "3"], ",", 
       FractionBox["8", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["8", "3"], ",", 
       FractionBox["16", "3"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{
     Rational[24, 5], 
     Rational[12, 5], 
     Rational[12, 5]}, {
     Rational[8, 3], 
     Rational[16, 3], 
     Rational[8, 3]}, {
     Rational[8, 3], 
     Rational[8, 3], 
     Rational[16, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635724621799*^9, 3.6416360949745884`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"16", "+", 
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"48", "-", 
     RowBox[{"11", " ", "x1"}], "+", 
     RowBox[{"11", " ", "x2"}], "-", 
     RowBox[{"9", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"97", "-", 
     RowBox[{"9", " ", "x1"}], "-", 
     RowBox[{"6", " ", "x2"}], "-", 
     RowBox[{"6", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"48", "-", 
     RowBox[{"11", " ", "x1"}], "-", 
     RowBox[{"9", " ", "x2"}], "+", 
     RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "24"}], "+", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"2", " ", "x2"}], "+", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.641635724621799*^9, 3.641636095099593*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"72", "-", 
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"2", " ", "x2"}], "-", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.641635724621799*^9, 3.6416360953339777`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4624", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "371", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "82", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "289"}],
  SequenceForm[4624, " ", 371, " ", 82, " ", 289],
  Editable->False]], "Print",
 CellChangeTimes->{3.641635724621799*^9, 3.641636096146509*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{2.6666666666666665`, 2.6666666666666665`, 
    5.333333333333333}, {2.6666666666666665`, 5.333333333333333, 
    2.6666666666666665`}, {4.333333333333333, 4.333333333333333, 
    5.333333333333333}, {4.333333333333333, 5.333333333333333, 
    4.333333333333333}, {4.8, 2.4, 2.4}, {5.133333333333334, 
    4.233333333333333, 4.233333333333333}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.2211530044957437, 0.9892867311667555, 0.14577784414591033`], Opacity[
     0.5]}], Polygon3DBox[{{3, 1, 6}, {1, 5, 6}, {1, 2, 5}, {1, 3, 4}, {2, 1, 
      4}, {5, 2, 6}, {2, 4, 6}, {4, 3, 6}}]}], 
   GraphicsComplex3DBox[{{5.333333333333333, 5.333333333333333, 
    10.666666666666666`}, {5.333333333333333, 10.666666666666666`, 
    5.333333333333333}, {8.666666666666666, 8.666666666666666, 
    10.666666666666666`}, {8.666666666666666, 10.666666666666666`, 
    8.666666666666666}, {9.6, 4.8, 4.8}, {10.266666666666667`, 
    8.466666666666667, 8.466666666666667}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.9334201362304513, 0.6561696412048346, 0.11859858315292438`], Opacity[
     0.5]}], Polygon3DBox[{{3, 1, 6}, {1, 5, 6}, {1, 2, 5}, {1, 3, 4}, {2, 1, 
      4}, {5, 2, 6}, {2, 4, 6}, {4, 3, 6}}]}], 
   GraphicsComplex3DBox[{{8., 8., 16.}, {8., 16., 8.}, {13., 13., 16.}, {13., 
    16., 13.}, {14.4, 7.2, 7.2}, {15.4, 12.7, 12.7}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.23484226666587515`, 0.9131165849421257, 0.04930284151646336], Opacity[
     0.5]}], Polygon3DBox[{{1, 3, 2}, {3, 1, 6}, {1, 2, 5}, {2, 3, 4}, {1, 5, 
      6}, {5, 2, 6}, {2, 4, 6}, {4, 3, 6}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[
     NCache[{{Rational[24, 5], Rational[12, 5], Rational[12, 5]}, {
       Rational[8, 3], Rational[16, 3], Rational[8, 3]}, {
       Rational[8, 3], Rational[8, 3], Rational[16, 3]}}, {{4.8, 2.4, 2.4}, {
      2.6666666666666665`, 5.333333333333333, 2.6666666666666665`}, {
      2.6666666666666665`, 2.6666666666666665`, 5.333333333333333}}]]}, 
   {GrayLevel[0], PointSize[Medium], Point3DBox[CompressedData["
1:eJwtku2Z2zAMg3OxRIKknM5wK3WEW6D7/ytet8oTm+IHCIL+/vnz++f9er2+
v16vy+8vzvv5fb051/u9eFzX/7et539d67qCx9rXXphOtbVirVxLdq+91461
E1/sFUEk9xO8iFPgJMeSXE7sbVt7195NtR0RO3KHdpTBiGfszJ0iUbGVpFdQ
YVqQcGnQE0QbLnBexeMNTkYoYiIO2L5lRnbk0McRVajdMEpRFZ3RIn2SCoY0
EXhTDRtBClwDOXsgyMXGybwzP+ab6tSkTurOqqzOmqxD51Z2ZXf2mAV1o5zK
aQCO8hQwt0CyxMgUTA9FikWB825ppCPZ+Ei/GKVaNaqjulUfTwaRLnWrR33U
N7xcN6VpzWgONA1zSqd1xpSBvEt3A/wpsFlVFOK6DyMVY5j3QTl6GNG2yz71
P6OrpupU3QhganZ0V0/1QQ8zdXy6ZqwNrJ17Gu53Qd8fRwSaMUcwClJaO1P/
p4VRPZuvB1Hh4SbuMQhMzJe20kxPW7FbVGdzKMFimg2gZpFlURhMUDPXp9nD
UcefEWvWQzbRDMpIwMaQja18Mv8C77cblQ==
     "]]}, 
   {RGBColor[1, 0, 0], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[96, 5], Rational[48, 5], Rational[48, 5]}}, {{0, 0, 0}, {19.2,
        9.6, 9.6}}]], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[32, 3], Rational[64, 3], Rational[32, 3]}}, {{0, 0, 0}, {
       10.666666666666666`, 21.333333333333332`, 10.666666666666666`}}]], 
    Line3DBox[
     NCache[{{0, 0, 0}, {
       Rational[32, 3], Rational[32, 3], Rational[64, 3]}}, {{0, 0, 0}, {
       10.666666666666666`, 10.666666666666666`, 21.333333333333332`}}]]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All]], "Output",
 CellChangeTimes->{{3.6412644129929113`*^9, 3.641264424456052*^9}, 
   3.6412927246150208`*^9, 3.641357398831625*^9, 3.641368740710269*^9, 
   3.6413835681365786`*^9, 3.641634883590336*^9, 3.641635284056384*^9, 
   3.6416357262468634`*^9, 3.641636096271515*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isCohenMacaulay", "[", 
  RowBox[{"v2", ",", "cota"}], "]"}]], "Input",
 CellChangeTimes->{{3.6413574286748033`*^9, 3.6413574479655056`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generators of the rays we use to check the CM condition: \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"24", ",", "12", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "16", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "8", ",", "16"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Generators of the rays we use to check the CM condition: ", {{24, 12, 
   12}, {8, 16, 8}, {8, 8, 16}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.641636096740284*^9}],

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.641636096740284*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["77", "15"], ",", 
     FractionBox["127", "30"], ",", 
     FractionBox["127", "30"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[24, 5], 
    Rational[12, 5], 
    Rational[12, 5], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[77, 15], 
    Rational[127, 30], 
    Rational[127, 30]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.641636096740284*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"144", ",", "72", ",", "72"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "160", ",", "80"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "80", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "130", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "160", ",", "130"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"154", ",", "127", ",", "127"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{144, 72, 72}, {80, 160, 80}, {80, 80, 160}, {130, 130, 160}, {130, 
   160, 130}, {154, 127, 127}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.641636096740284*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.641636096740284*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.641636096802786*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["24", "5"], ",", 
        FractionBox["12", "5"], ",", 
        FractionBox["12", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"], ",", 
        FractionBox["8", "3"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[24, 5], 
      Rational[12, 5], 
      Rational[12, 5]}}, {{
      Rational[8, 3], 
      Rational[16, 3], 
      Rational[8, 3]}}, {{
      Rational[8, 3], 
      Rational[8, 3], 
      Rational[16, 3]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.6416360969121656`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["24", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["12", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["16", "3"], ",", 
       FractionBox["8", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["8", "3"], ",", 
       FractionBox["16", "3"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{
     Rational[24, 5], 
     Rational[12, 5], 
     Rational[12, 5]}, {
     Rational[8, 3], 
     Rational[16, 3], 
     Rational[8, 3]}, {
     Rational[8, 3], 
     Rational[8, 3], 
     Rational[16, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.6416360969277906`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"16", "+", 
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"48", "-", 
     RowBox[{"11", " ", "x1"}], "+", 
     RowBox[{"11", " ", "x2"}], "-", 
     RowBox[{"9", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"97", "-", 
     RowBox[{"9", " ", "x1"}], "-", 
     RowBox[{"6", " ", "x2"}], "-", 
     RowBox[{"6", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"48", "-", 
     RowBox[{"11", " ", "x1"}], "-", 
     RowBox[{"9", " ", "x2"}], "+", 
     RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "24"}], "+", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"2", " ", "x2"}], "+", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.641636097052796*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"96", "-", 
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"2", " ", "x2"}], "-", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.641636097177801*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10164", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "829", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "271", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "558"}],
  SequenceForm[10164, " ", 829, " ", 271, " ", 558],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.641636099271633*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The point \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "5"}], "}"}], 
   "\[InvisibleSpace]", "\<\" does not fulfill the condition\"\>"}],
  SequenceForm["The point ", {5, 5, 5}, " does not fulfill the condition"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413574487220387`*^9, 3.641368746057074*^9, 
  3.64138357736012*^9, 3.641635728560296*^9, 3.641636099627889*^9}]
}, Open  ]],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.641357434126674*^9, 3.641357449467559*^9}, 
   3.641368747305944*^9, 3.6413835786270146`*^9, 3.641635731372904*^9, 
   3.6416360996435165`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isBuchsbaum", "[", 
  RowBox[{"v2", ",", "cota"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636101956109*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["77", "15"], ",", 
     FractionBox["127", "30"], ",", 
     FractionBox["127", "30"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[24, 5], 
    Rational[12, 5], 
    Rational[12, 5], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[77, 15], 
    Rational[127, 30], 
    Rational[127, 30]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636101971734*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"144", ",", "72", ",", "72"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "160", ",", "80"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "80", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "130", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "160", ",", "130"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"154", ",", "127", ",", "127"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{144, 72, 72}, {80, 160, 80}, {80, 80, 160}, {130, 130, 160}, {130, 
   160, 130}, {154, 127, 127}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636101971734*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636101971734*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\tmp\\\
\\aux1\"\>"], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636101987359*^9}],

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.6416361085261235`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["24", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["12", "5"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["8", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["16", "3"], ",", 
     FractionBox["13", "3"], ",", 
     FractionBox["77", "15"], ",", 
     FractionBox["127", "30"], ",", 
     FractionBox["127", "30"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {
    Rational[24, 5], 
    Rational[12, 5], 
    Rational[12, 5], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[8, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[16, 3], 
    Rational[13, 3], 
    Rational[77, 15], 
    Rational[127, 30], 
    Rational[127, 30]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636108541751*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"144", ",", "72", ",", "72"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "160", ",", "80"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "80", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "130", ",", "160"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"130", ",", "160", ",", "130"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"154", ",", "127", ",", "127"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{144, 72, 72}, {80, 160, 80}, {80, 80, 160}, {130, 130, 160}, {130, 
   160, 130}, {154, 127, 127}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636108541751*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636108541751*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636108588629*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["24", "5"], ",", 
        FractionBox["12", "5"], ",", 
        FractionBox["12", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"], ",", 
        FractionBox["8", "3"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["8", "3"], ",", 
        FractionBox["8", "3"], ",", 
        FractionBox["16", "3"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{
      Rational[24, 5], 
      Rational[12, 5], 
      Rational[12, 5]}}, {{
      Rational[8, 3], 
      Rational[16, 3], 
      Rational[8, 3]}}, {{
      Rational[8, 3], 
      Rational[8, 3], 
      Rational[16, 3]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.6416361086980066`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["24", "5"], ",", 
       FractionBox["12", "5"], ",", 
       FractionBox["12", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["16", "3"], ",", 
       FractionBox["8", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["8", "3"], ",", 
       FractionBox["8", "3"], ",", 
       FractionBox["16", "3"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{
     Rational[24, 5], 
     Rational[12, 5], 
     Rational[12, 5]}, {
     Rational[8, 3], 
     Rational[16, 3], 
     Rational[8, 3]}, {
     Rational[8, 3], 
     Rational[8, 3], 
     Rational[16, 3]}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.6416361086980066`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"16", "+", 
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"3", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"48", "-", 
     RowBox[{"11", " ", "x1"}], "+", 
     RowBox[{"11", " ", "x2"}], "-", 
     RowBox[{"9", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"97", "-", 
     RowBox[{"9", " ", "x1"}], "-", 
     RowBox[{"6", " ", "x2"}], "-", 
     RowBox[{"6", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"48", "-", 
     RowBox[{"11", " ", "x1"}], "-", 
     RowBox[{"9", " ", "x2"}], "+", 
     RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "24"}], "+", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"2", " ", "x2"}], "+", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636108823012*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"72", "-", 
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"2", " ", "x2"}], "-", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636108948017*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4624", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "371", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "82", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "289"}],
  SequenceForm[4624, " ", 371, " ", 82, " ", 289],
  Editable->False]], "Print",
 CellChangeTimes->{3.641264325447921*^9, 3.6412644455920515`*^9, 
  3.6412927348612986`*^9, 3.6413574064920416`*^9, 3.641368754575117*^9, 
  3.6413835815931273`*^9, 3.6416357347145767`*^9, 3.641636109856249*^9}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.641264338705328*^9, 3.641264459115671*^9, 
  3.6412927483428698`*^9, 3.641357420912299*^9, 3.641368791381242*^9, 
  3.641383618277294*^9, 3.6416357914216995`*^9, 3.641636158298055*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "Section"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6410491101147895`*^9, 3.641049111068471*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", 
   RowBox[{"\"\<convexHullSemigroups3D`\>\"", ",", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
     "\"\<\\\\convexHullSemigroups3DLibraryV6.wl\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{3.6416212542353764`*^9}],

Cell[BoxData["\<\"J. I. Garc\[IAcute]a-Garc\[IAcute]a and A. \
Vigneron-Tenorio,\\nDpto. Matem\[AAcute]ticas, \\nUniversidad de \
C\[AAcute]diz\\nignacio.garcia@uca.es, alberto.vigneron@uca.es\\n\\nThis \
package contains the commands: \\n....\\nTry command::usage for more \
help\"\>"], "Print",
 CellChangeTimes->{3.6413821871199017`*^9, 3.6413822410592113`*^9, 
  3.6413823022066298`*^9, 3.64138235318583*^9, 3.64138244376814*^9, 
  3.6413824805432696`*^9, 3.641382880899563*^9, 3.6413830598906536`*^9, 
  3.641383189113429*^9, 3.6413832327964425`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"configuration", "[", 
   RowBox[{
   "\"\<C:\\\\tmp\\\\lrs\\\\lrs.exe\>\"", ",", "\"\<C:\\\\tmp\\\\\>\"", ",", 
    "\"\<C:\\\\tmp\\\\Normaliz2.12\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"showConfiguration", "[", "]"}]}], "Input",
 CellChangeTimes->{{3.6411073578608484`*^9, 3.641107359778218*^9}, {
  3.641211016111037*^9, 3.6412110169986625`*^9}, {3.641274477569577*^9, 
  3.641274478101952*^9}, {3.641381000885556*^9, 3.6413810018062067`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C:\\\\tmp\\\\lrs\\\\lrs.exe\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\Normaliz2.12\"\>"}],
  SequenceForm[
  "C:\\tmp\\lrs\\lrs.exe", "\n", "C:\\tmp\\", "\n", "C:\\tmp\\Normaliz2.12"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641382188273721*^9, 3.6413822418697805`*^9, 
  3.64138230264994*^9, 3.6413823535931215`*^9, 3.641382444496666*^9, 
  3.6413824813118095`*^9, 3.6413828813168616`*^9, 3.6413830603159714`*^9, 
  3.6413831895357227`*^9, 3.641383233222752*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"vvv1", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "3", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "0", ",", "1"}], "}"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vvv1", ",", "3", ",", "False", ",", "True", ",", "True"}], "]"}],
    "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]}], "Input",
 CellChangeTimes->{{3.641357493201624*^9, 3.64135750192482*^9}, {
  3.6413583777887764`*^9, 3.6413583782771235`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.641357502917514*^9, 3.641357871640348*^9, 3.64135837944394*^9, {
   3.641368803185635*^9, 3.6413688215346627`*^9}, 3.641380352323002*^9, 
   3.64138070492739*^9, 3.641380857124465*^9, 3.6413810033623095`*^9, 
   3.6413810365608835`*^9, 3.64138124115917*^9, 3.641381352907523*^9, 
   3.6413815113009996`*^9, 3.6413816074372673`*^9, 3.64138168078335*^9, 
   3.641381758351431*^9, 3.6413818564711065`*^9, 3.6413821188374157`*^9, {
   3.6413821607471747`*^9, 3.641382189529614*^9}, 3.6413822429995747`*^9, 
   3.6413823029171324`*^9, 3.6413823540474377`*^9, 3.641382445504383*^9, 
   3.641382482055338*^9, 3.6413828822375245`*^9, 3.641383060768276*^9, 
   3.6413831900150642`*^9, 3.641383233958268*^9, 3.6413836356949444`*^9, 
   3.6416358013051863`*^9, 3.6416361583918085`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.6413821895326157`*^9, 3.6413822430025897`*^9, 
  3.641382302923134*^9, 3.6413823540534368`*^9, 3.6413824455073843`*^9, 
  3.6413824820573387`*^9, 3.6413828822395105`*^9, 3.641383060773288*^9, 
  3.641383190020059*^9, 3.6413832339612694`*^9, 3.6413836356979456`*^9, 
  3.6416358013204045`*^9, 3.6416361583918085`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "0", ",", "0", ",", "7", ",", "3", ",", "0", ",", "10", ",", 
     "0", ",", "0", ",", "7", ",", "0", ",", "1"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {4, 0, 0, 7, 3, 0, 10, 0, 0, 7, 0, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413821895326157`*^9, 3.6413822430025897`*^9, 
  3.641382302923134*^9, 3.6413823540534368`*^9, 3.6413824455073843`*^9, 
  3.6413824820573387`*^9, 3.6413828822395105`*^9, 3.641383060773288*^9, 
  3.641383190020059*^9, 3.6413832339612694`*^9, 3.6413836356979456`*^9, 
  3.6416358013204045`*^9, 3.6416361583918085`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{4, 0, 0}, {7, 3, 0}, {10, 0, 0}, {7, 0, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413821895326157`*^9, 3.6413822430025897`*^9, 
  3.641382302923134*^9, 3.6413823540534368`*^9, 3.6413824455073843`*^9, 
  3.6413824820573387`*^9, 3.6413828822395105`*^9, 3.641383060773288*^9, 
  3.641383190020059*^9, 3.6413832339612694`*^9, 3.6413836356979456`*^9, 
  3.6416358013204045`*^9, 3.6416361583918085`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413821895326157`*^9, 3.6413822430025897`*^9, 
  3.641382302923134*^9, 3.6413823540534368`*^9, 3.6413824455073843`*^9, 
  3.6413824820573387`*^9, 3.6413828822395105`*^9, 3.641383060773288*^9, 
  3.641383190020059*^9, 3.6413832339612694`*^9, 3.6413836356979456`*^9, 
  3.6416358013204045`*^9, 3.6416361584074345`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.6413821895326157`*^9, 3.6413822430025897`*^9, 
  3.641382302923134*^9, 3.6413823540534368`*^9, 3.6413824455073843`*^9, 
  3.6413824820573387`*^9, 3.6413828822395105`*^9, 3.641383060773288*^9, 
  3.641383190020059*^9, 3.6413832339612694`*^9, 3.6413836356979456`*^9, 
  3.6416358013204045`*^9, 3.6416361584386854`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"7", ",", "3", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"7", ",", "0", ",", "1"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm[
  "vTriangulo=", {{{4, 0, 0}, {10, 0, 0}}, {{7, 3, 0}}, {{7, 0, 1}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413821895326157`*^9, 3.6413822430025897`*^9, 
  3.641382302923134*^9, 3.6413823540534368`*^9, 3.6413824455073843`*^9, 
  3.6413824820573387`*^9, 3.6413828822395105`*^9, 3.641383060773288*^9, 
  3.641383190020059*^9, 3.6413832339612694`*^9, 3.6413836356979456`*^9, 
  3.6416358013204045`*^9, 3.64163615856369*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{4, 0, 0}, {7, 3, 0}, {7, 0, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413821895326157`*^9, 3.6413822430025897`*^9, 
  3.641382302923134*^9, 3.6413823540534368`*^9, 3.6413824455073843`*^9, 
  3.6413824820573387`*^9, 3.6413828822395105`*^9, 3.641383060773288*^9, 
  3.641383190020059*^9, 3.6413832339612694`*^9, 3.6413836356979456`*^9, 
  3.6416358013204045`*^9, 3.64163615856369*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], "+", "x1", "-", "x2", "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"10", "-", "x1", "-", "x2", "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6413821895326157`*^9, 3.6413822430025897`*^9, 
  3.641382302923134*^9, 3.6413823540534368`*^9, 3.6413824455073843`*^9, 
  3.6413824820573387`*^9, 3.6413828822395105`*^9, 3.641383060773288*^9, 
  3.641383190020059*^9, 3.6413832339612694`*^9, 3.6413836356979456`*^9, 
  3.6416358013204045`*^9, 3.64163615867307*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"7", " ", "x2"}], "-", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"12", "-", "x1", "+", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.6413821895326157`*^9, 3.6413822430025897`*^9, 
  3.641382302923134*^9, 3.6413823540534368`*^9, 3.6413824455073843`*^9, 
  3.6413824820573387`*^9, 3.6413828822395105`*^9, 3.641383060773288*^9, 
  3.641383190020059*^9, 3.6413832339612694`*^9, 3.6413836356979456`*^9, 
  3.6416358013204045`*^9, 3.6416361588137007`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1240", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "112", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "73", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "39"}],
  SequenceForm[1240, " ", 112, " ", 73, " ", 39],
  Editable->False]], "Print",
 CellChangeTimes->{3.6413821895326157`*^9, 3.6413822430025897`*^9, 
  3.641382302923134*^9, 3.6413823540534368`*^9, 3.6413824455073843`*^9, 
  3.6413824820573387`*^9, 3.6413828822395105`*^9, 3.641383060773288*^9, 
  3.641383190020059*^9, 3.6413832339612694`*^9, 3.6413836356979456`*^9, 
  3.6416358013204045`*^9, 3.6416361590168333`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{4., 0., 0.}, {7., 0., 1.}, {7., 3., 0.}, {10., 0., 
    0.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.5717661836591386, 0.3974141776476994, 0.9419391124833061], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   GraphicsComplex3DBox[{{8., 0., 0.}, {14., 0., 2.}, {14., 6., 0.}, {20., 0.,
     0.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.5561086626807856, 0.38322637420081107`, 0.8415742339224155], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   GraphicsComplex3DBox[{{12., 0., 0.}, {21., 0., 3.}, {21., 9., 0.}, {30., 
    0., 0.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.20463099224208436`, 0.18181194300603143`, 0.5258648639765524], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[{{4, 0, 0}, {10, 0, 0}, {7, 3, 0}, {7, 0, 1}}]}, 
   {GrayLevel[0], PointSize[Medium], 
    Point3DBox[{{1, 0, 0}, {2, 0, 0}, {3, 0, 0}, {3, 1, 0}, {4, 1, 0}, {5, 2, 
     0}, {8, 0, 1}, {8, 3, 0}, {9, 0, 1}, {9, 2, 0}, {9, 3, 0}, {10, 0, 1}, {
     10, 1, 1}, {10, 3, 0}, {10, 4, 0}, {11, 1, 1}, {11, 4, 0}, {12, 2, 1}, {
     12, 5, 0}, {15, 0, 2}, {15, 3, 1}, {15, 6, 0}, {16, 0, 2}, {16, 2, 1}, {
     16, 3, 1}, {16, 5, 0}, {16, 6, 0}, {17, 0, 2}, {17, 1, 2}, {17, 3, 1}, {
     17, 4, 1}, {17, 6, 0}, {17, 7, 0}, {18, 1, 2}, {18, 4, 1}, {18, 7, 0}, {
     19, 2, 2}, {19, 5, 1}, {19, 8, 0}}]}, 
   {RGBColor[1, 0, 0], Line3DBox[{{0, 0, 0}, {16, 0, 0}}], 
    Line3DBox[{{0, 0, 0}, {28, 12, 0}}], Line3DBox[{{0, 0, 0}, {28, 0, 4}}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All]], "Output",
 CellChangeTimes->{
  3.641357502917514*^9, 3.641357871640348*^9, 3.64135837944394*^9, {
   3.641368803185635*^9, 3.6413688215346627`*^9}, 3.641380352323002*^9, 
   3.64138070492739*^9, 3.641380857124465*^9, 3.6413810033623095`*^9, 
   3.6413810365608835`*^9, 3.64138124115917*^9, 3.641381352907523*^9, 
   3.6413815113009996`*^9, 3.6413816074372673`*^9, 3.64138168078335*^9, 
   3.641381758351431*^9, 3.6413818564711065`*^9, 3.6413821188374157`*^9, {
   3.6413821607471747`*^9, 3.641382189529614*^9}, 3.6413822429995747`*^9, 
   3.6413823029171324`*^9, 3.6413823540474377`*^9, 3.641382445504383*^9, 
   3.641382482055338*^9, 3.6413828822375245`*^9, 3.641383060768276*^9, 
   3.6413831900150642`*^9, 3.641383233958268*^9, 3.6413836356949444`*^9, 
   3.6416358013051863`*^9, 3.641636159110588*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cota", "=", 
  RowBox[{"boundCohenMacaulay", "[", "vvv1", "]"}]}]], "Input",
 CellChangeTimes->{{3.641357551113739*^9, 3.641357552642836*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361593605976`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "0", ",", "0", ",", "7", ",", "3", ",", "0", ",", "10", ",", 
     "0", ",", "0", ",", "7", ",", "0", ",", "1"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {4, 0, 0, 7, 3, 0, 10, 0, 0, 7, 0, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.641636159368126*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{4, 0, 0}, {7, 3, 0}, {10, 0, 0}, {7, 0, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.641636159368126*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.641636159368126*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361594150047`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12.`", ",", "12.`", ",", "12.`"}], "}"}]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.64163615954001*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"7", ",", "3", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"7", ",", "0", ",", "1"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm[
  "vTriangulo=", {{{4, 0, 0}, {10, 0, 0}}, {{7, 3, 0}}, {{7, 0, 1}}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.64163615954001*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 1, "]]=", {{4, 0, 0}, {10, 0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361595556355`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"7", ",", "3", ",", "0"}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 2, "]]=", {{7, 3, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361595556355`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nvTriangulo[[\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"]]=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"7", ",", "0", ",", "1"}], "}"}], "}"}]}],
  SequenceForm["\nvTriangulo[[", 3, "]]=", {{7, 0, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361595556355`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[1]]=\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["pYk[[1]]=", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361595556355`*^9}],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361595712605`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[2]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["pYk[[2]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361595712605`*^9}],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361595868864`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pYk[[3]]=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["pYk[[3]]=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361595868864`*^9}],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361595868864`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximo=\"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Maximo=", 1],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.6416361595868864`*^9}],

Cell[BoxData["\<\"--------------\"\>"], "Print",
 CellChangeTimes->{{3.6413575399257946`*^9, 3.6413575531241655`*^9}, 
   3.6413581647575006`*^9, 3.641358287865919*^9, 3.64135833638136*^9, 
   3.6413584043756557`*^9, 3.6413587232901073`*^9, {3.6413688065280066`*^9, 
   3.6413688239173555`*^9}, 3.6413802555833073`*^9, 3.641380358227195*^9, 
   3.641380709600707*^9, 3.641380859463125*^9, {3.6413810112248926`*^9, 
   3.6413810380609407`*^9}, 3.6413812427452874`*^9, 3.641381354335537*^9, 
   3.64138151276704*^9, 3.641381608842265*^9, 3.6413816829578857`*^9, 
   3.641381760285805*^9, 3.6413818598775253`*^9, 3.641382121570348*^9, 
   3.6413821909956636`*^9, 3.641382245606434*^9, 3.641382304768436*^9, 
   3.6413823562149677`*^9, 3.6413824482263155`*^9, 3.64138248396069*^9, 
   3.6413828845211306`*^9, 3.64138306315598*^9, 3.641383192037492*^9, 
   3.641383236389985*^9, 3.641383639909937*^9, 3.6416358043308935`*^9, 
   3.641636159602512*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"7", ",", "3", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"7", ",", "0", ",", "1"}], "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], "+", "x1", "-", "x2", "-", 
       RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{"10", "-", "x1", "-", "x2", "-", 
       RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.64135754084146*^9, 3.6413575545892153`*^9}, 
   3.6413581652178297`*^9, 3.6413582883162394`*^9, 3.6413583368216825`*^9, 
   3.641358405251275*^9, 3.641358723742437*^9, {3.641368807414627*^9, 
   3.6413688248259993`*^9}, 3.641380256842191*^9, 3.641380359332974*^9, 
   3.641380710520363*^9, 3.641380860256689*^9, {3.6413810120124607`*^9, 
   3.6413810388304863`*^9}, 3.641381243267667*^9, 3.641381354866906*^9, 
   3.6413815134715314`*^9, 3.641381609598801*^9, 3.641381683712429*^9, 
   3.6413817610473514`*^9, 3.641381860662073*^9, 3.6413821222228184`*^9, 
   3.6413821917001452`*^9, 3.641382246186846*^9, 3.6413823053728743`*^9, 
   3.641382356829412*^9, 3.6413824487997217`*^9, 3.6413824845771275`*^9, 
   3.641382971418828*^9, 3.641383069193268*^9, 3.641383192274659*^9, 
   3.64138323663717*^9, 3.641383640105076*^9, 3.6416358045403585`*^9, 
   3.641636159602512*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["vvv1"], "Input",
 CellChangeTimes->{{3.6413832400716095`*^9, 3.641383241507635*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.641383241879897*^9, 3.6413836422215796`*^9, 
  3.6416358088331547`*^9, 3.64163615964939*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"isCohenMacaulay", "[", 
  RowBox[{"vvv1", ",", "cota"}], "]"}]], "Input",
 CellChangeTimes->{{3.6413575436044273`*^9, 3.6413575486009645`*^9}, {
  3.641383260523129*^9, 3.641383261196612*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Generators of the rays we use to check the CM condition: \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm[
  "Generators of the rays we use to check the CM condition: ", {{4, 0, 0}, {7,
    3, 0}, {7, 0, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641383261777022*^9, 3.6413836434994764`*^9, 
  3.64163581046272*^9, 3.641636162209942*^9}],

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.641383261777022*^9, 3.6413836434994764`*^9, 
  3.64163581046272*^9, 3.641636162209942*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "0", ",", "0", ",", "7", ",", "3", ",", "0", ",", "10", ",", 
     "0", ",", "0", ",", "7", ",", "0", ",", "1"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {4, 0, 0, 7, 3, 0, 10, 0, 0, 7, 0, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641383261777022*^9, 3.6413836434994764`*^9, 
  3.64163581046272*^9, 3.641636162225567*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{4, 0, 0}, {7, 3, 0}, {10, 0, 0}, {7, 0, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641383261777022*^9, 3.6413836434994764`*^9, 
  3.64163581046272*^9, 3.641636162225567*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641383261777022*^9, 3.6413836434994764`*^9, 
  3.64163581046272*^9, 3.641636162225567*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\JI\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.641383261777022*^9, 3.6413836434994764`*^9, 
  3.64163581046272*^9, 3.641636162256818*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"7", ",", "3", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"7", ",", "0", ",", "1"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm[
  "vTriangulo=", {{{4, 0, 0}, {10, 0, 0}}, {{7, 3, 0}}, {{7, 0, 1}}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641383261777022*^9, 3.6413836434994764`*^9, 
  3.64163581046272*^9, 3.641636162366197*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{4, 0, 0}, {7, 3, 0}, {7, 0, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641383261777022*^9, 3.6413836434994764`*^9, 
  3.64163581046272*^9, 3.6416361623818235`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], "+", "x1", "-", "x2", "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"10", "-", "x1", "-", "x2", "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.641383261777022*^9, 3.6413836434994764`*^9, 
  3.64163581046272*^9, 3.6416361624912024`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"7", " ", "x2"}], "-", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"4", "-", "x1", "+", "x2", "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{3.641383261777022*^9, 3.6413836434994764`*^9, 
  3.64163581046272*^9, 3.641636162616207*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "88", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm[88, " ", 12, " ", 6, " ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.641383261777022*^9, 3.6413836434994764`*^9, 
  3.64163581046272*^9, 3.641636162647459*^9}]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.6413832250439377`*^9, 3.6413832622783785`*^9}, 
   3.641383643904765*^9, 3.641635810931489*^9, 3.641636162694336*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Pruebas charla", "Section",
 CellChangeTimes->{{3.6412738541667767`*^9, 3.6412738583077087`*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6410491101147895`*^9, 3.641049111068471*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"configuration", "[", 
   RowBox[{
   "\"\<C:\\\\tmp\\\\lrs\\\\lrs.exe\>\"", ",", "\"\<C:\\\\tmp\\\\\>\"", ",", 
    "\"\<C:\\\\tmp\\\\Normaliz2.12\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"showConfiguration", "[", "]"}]}], "Input",
 CellChangeTimes->{{3.6411073578608484`*^9, 3.641107359778218*^9}, {
  3.641211016111037*^9, 3.6412110169986625`*^9}, {3.641274477569577*^9, 
  3.641274478101952*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"C:\\\\tmp\\\\lrs\\\\lrs.exe\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\\"\>", 
   "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\Normaliz2.12\"\>"}],
  SequenceForm[
  "C:\\tmp\\lrs\\lrs.exe", "\n", "C:\\tmp\\", "\n", "C:\\tmp\\Normaliz2.12"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412752606506386`*^9, {3.64127530908103*^9, 3.6412753534065137`*^9}, 
   3.6412755595919275`*^9, 3.641275640029038*^9, 3.6412759311177454`*^9, 
   3.6412766865532465`*^9, {3.641277044107049*^9, 3.6412770615264263`*^9}, 
   3.641278561269972*^9, 3.6412788768360567`*^9, 3.641278939694702*^9, 
   3.6412790079221573`*^9, 3.641279076900131*^9, 3.6412802449285545`*^9, 
   3.6412807406267686`*^9, 3.641281078781895*^9, 3.641281232217841*^9, 
   3.641291535232509*^9, 3.6412927484439573`*^9, 3.641295676713255*^9, 
   3.641296702243037*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vc1", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "4", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["42", "10"], ",", 
      FractionBox["11", "10"], ",", 
      FractionBox["51", "10"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["32", "10"], ",", 
      FractionBox["12", "10"], ",", 
      FractionBox["2", "10"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5", ",", "6"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "5"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.6412738661332645`*^9, 3.6412738862205296`*^9}, 
   3.6412739756700587`*^9, {3.6412740251632037`*^9, 3.641274044236738*^9}, {
   3.641276315850008*^9, 3.641276318936198*^9}, {3.6412763563187437`*^9, 
   3.641276359924306*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["21", "5"], ",", 
     FractionBox["11", "10"], ",", 
     FractionBox["51", "10"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["16", "5"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["1", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6412766875519547`*^9, {3.6412770452008247`*^9, 3.641277062378022*^9}, 
   3.6412785621135697`*^9, 3.6412788780999537`*^9, 3.6412789429670253`*^9, 
   3.641279011318553*^9, 3.641279077771741*^9, 3.6412802460613503`*^9, 
   3.6412810820582237`*^9, 3.6412915368076267`*^9, 3.6412927484809713`*^9, 
   3.64129567798815*^9, 3.6413804791230345`*^9, 3.641383649889024*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"boundCohenMacaulay", "[", "vc1", "]"}]], "Input",
 CellChangeTimes->{{3.6413804914217777`*^9, 3.641380496081088*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{3.641380497218884*^9, 3.6413836516782837`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "0", ",", "4", ",", "5", ",", "3", ",", "3",
      ",", "2", ",", "6", ",", "2", ",", "3", ",", "6", ",", "4", ",", "2", 
     ",", 
     FractionBox["21", "5"], ",", 
     FractionBox["11", "10"], ",", 
     FractionBox["51", "10"], ",", 
     FractionBox["16", "5"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["1", "5"], ",", "5", ",", "5", ",", "6", ",", "4", ",", "5", 
     ",", "5"}], "}"}]}],
  SequenceForm[
  "lptos de pintaAux=", {1, 2, 3, 0, 4, 5, 3, 3, 2, 6, 2, 3, 6, 4, 2, 
    Rational[21, 5], 
    Rational[11, 10], 
    Rational[51, 10], 
    Rational[16, 5], 
    Rational[6, 5], 
    Rational[1, 5], 5, 5, 6, 4, 5, 5}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641380497218884*^9, 3.6413836516812906`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "20", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "40", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "30", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"60", ",", "20", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"60", ",", "40", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"42", ",", "11", ",", "51"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"32", ",", "12", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "50", ",", "60"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "50", ",", "50"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{10, 20, 30}, {0, 40, 50}, {30, 30, 20}, {60, 20, 30}, {60, 40, 
   20}, {42, 11, 51}, {32, 12, 2}, {50, 50, 60}, {40, 50, 50}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.641380497218884*^9, 3.641383651684298*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{3.641380497218884*^9, 3.6413836516862907`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\usuario\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{3.641380497218884*^9, 3.641383651712309*^9}],

Cell[BoxData["\<\"The semigroup is not Cohen-Macaulay\"\>"], "Print",
 CellChangeTimes->{3.641380497218884*^9, 3.641383651865427*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.6413804974690714`*^9, 3.641383651870431*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"raysOfConeOfCHSgr", "[", "vc1", "]"}]], "Input",
 CellChangeTimes->{{3.6412741532792025`*^9, 3.641274187381384*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{
  3.6412753563325915`*^9, 3.641275419302307*^9, 3.641275563921003*^9, 
   3.641275642094503*^9, 3.6412759332852807`*^9, 3.641276080767017*^9, 
   3.641276249992242*^9, 3.641276320884592*^9, 3.6412763614764166`*^9, 
   3.641276462087863*^9, {3.641277047092168*^9, 3.6412770708960705`*^9}, 
   3.6412785630402374`*^9, 3.6412788791987424`*^9, 3.641278943880674*^9, 
   3.6412790125084057`*^9, 3.641279078686391*^9, 3.641280247648487*^9, 
   3.6412810835612783`*^9, 3.6412927502472267`*^9, 3.6412956790278907`*^9, 
   3.6413836555250273`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "0", ",", "4", ",", "5", ",", "3", ",", "3",
      ",", "2", ",", "6", ",", "2", ",", "3", ",", "6", ",", "4", ",", "2", 
     ",", 
     FractionBox["21", "5"], ",", 
     FractionBox["11", "10"], ",", 
     FractionBox["51", "10"], ",", 
     FractionBox["16", "5"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["1", "5"], ",", "5", ",", "5", ",", "6", ",", "4", ",", "5", 
     ",", "5"}], "}"}]}],
  SequenceForm[
  "lptos de pintaAux=", {1, 2, 3, 0, 4, 5, 3, 3, 2, 6, 2, 3, 6, 4, 2, 
    Rational[21, 5], 
    Rational[11, 10], 
    Rational[51, 10], 
    Rational[16, 5], 
    Rational[6, 5], 
    Rational[1, 5], 5, 5, 6, 4, 5, 5}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412753563325915`*^9, 3.641275419302307*^9, 3.641275563921003*^9, 
   3.641275642094503*^9, 3.6412759332852807`*^9, 3.641276080767017*^9, 
   3.641276249992242*^9, 3.641276320884592*^9, 3.6412763614764166`*^9, 
   3.641276462087863*^9, {3.641277047092168*^9, 3.6412770708960705`*^9}, 
   3.6412785630402374`*^9, 3.6412788791987424`*^9, 3.641278943880674*^9, 
   3.6412790125084057`*^9, 3.641279078686391*^9, 3.641280247648487*^9, 
   3.6412810835612783`*^9, 3.6412927502472267`*^9, 3.6412956790278907`*^9, 
   3.641383655527017*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "20", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "40", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "30", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"60", ",", "20", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"60", ",", "40", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"42", ",", "11", ",", "51"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"32", ",", "12", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "50", ",", "60"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "50", ",", "50"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{10, 20, 30}, {0, 40, 50}, {30, 30, 20}, {60, 20, 30}, {60, 40, 
   20}, {42, 11, 51}, {32, 12, 2}, {50, 50, 60}, {40, 50, 50}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412753563325915`*^9, 3.641275419302307*^9, 3.641275563921003*^9, 
   3.641275642094503*^9, 3.6412759332852807`*^9, 3.641276080767017*^9, 
   3.641276249992242*^9, 3.641276320884592*^9, 3.6412763614764166`*^9, 
   3.641276462087863*^9, {3.641277047092168*^9, 3.6412770708960705`*^9}, 
   3.6412785630402374`*^9, 3.6412788791987424`*^9, 3.641278943880674*^9, 
   3.6412790125084057`*^9, 3.641279078686391*^9, 3.641280247648487*^9, 
   3.6412810835612783`*^9, 3.6412927502472267`*^9, 3.6412956790278907`*^9, 
   3.6413836555300193`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412753563325915`*^9, 3.641275419302307*^9, 3.641275563921003*^9, 
   3.641275642094503*^9, 3.6412759332852807`*^9, 3.641276080767017*^9, 
   3.641276249992242*^9, 3.641276320884592*^9, 3.6412763614764166`*^9, 
   3.641276462087863*^9, {3.641277047092168*^9, 3.6412770708960705`*^9}, 
   3.6412785630402374`*^9, 3.6412788791987424`*^9, 3.641278943880674*^9, 
   3.6412790125084057`*^9, 3.641279078686391*^9, 3.641280247648487*^9, 
   3.6412810835612783`*^9, 3.6412927502472267`*^9, 3.6412956790278907`*^9, 
   3.6413836555320206`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\usuario\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{
  3.6412753563325915`*^9, 3.641275419302307*^9, 3.641275563921003*^9, 
   3.641275642094503*^9, 3.6412759332852807`*^9, 3.641276080767017*^9, 
   3.641276249992242*^9, 3.641276320884592*^9, 3.6412763614764166`*^9, 
   3.641276462087863*^9, {3.641277047092168*^9, 3.6412770708960705`*^9}, 
   3.6412785630402374`*^9, 3.6412788791987424`*^9, 3.641278943880674*^9, 
   3.6412790125084057`*^9, 3.641279078686391*^9, 3.641280247648487*^9, 
   3.6412810835612783`*^9, 3.6412927502472267`*^9, 3.6412956790278907`*^9, 
   3.6413836555560584`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "6", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "11", ",", "51"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.641274158383806*^9, 3.6412741890435643`*^9, 3.641274283257468*^9, 
   3.6412743221160693`*^9, 3.6412743579585223`*^9, 3.6412743913111954`*^9, 
   3.64127444970868*^9, 3.6412744934258366`*^9, 3.641274797684907*^9, 
   3.641275212541485*^9, 3.6412752435765142`*^9, 3.6412753564736824`*^9, 
   3.6412754194584074`*^9, 3.641275564784614*^9, 3.6412756428130136`*^9, 
   3.641275933991781*^9, 3.641276080924118*^9, 3.641276250174371*^9, 
   3.641276321075718*^9, 3.641276361657536*^9, 3.6412764622649775`*^9, {
   3.6412770472652903`*^9, 3.6412770717546806`*^9}, 3.64127856380377*^9, 
   3.641278879990296*^9, 3.64127894464921*^9, 3.6412790132769527`*^9, 
   3.641279079414909*^9, 3.6412802483770037`*^9, 3.6412810837163887`*^9, 
   3.6412927504533787`*^9, 3.6412956797814393`*^9, 3.641383655765196*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vc1", ",", "4", ",", "True", ",", "False", ",", "True"}], "]"}], 
   "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.6412738612347946`*^9, 3.641273862654804*^9}, {
  3.6412739791865444`*^9, 3.6412739912521214`*^9}, {3.6412762884355392`*^9, 
  3.641276288538624*^9}, {3.641276478952837*^9, 3.641276478994857*^9}, {
  3.641276546179581*^9, 3.6412765469180913`*^9}, {3.6412770759636755`*^9, 
  3.6412770772045517`*^9}, {3.6412771235934916`*^9, 3.6412771236375227`*^9}, {
  3.641278567700549*^9, 3.6412785686232023`*^9}, {3.641278888235154*^9, 
  3.64127888870049*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{
  3.6412785690595107`*^9, {3.6412788821958714`*^9, 3.641278889474039*^9}, 
   3.6412789456889577`*^9, 3.641279080636791*^9, 3.641279137601229*^9, 
   3.6412792398208137`*^9, 3.641279331204707*^9, 3.6412802497970123`*^9, {
   3.641280309096112*^9, 3.6412803173779936`*^9}, 3.641281085190443*^9, 
   3.641292753003189*^9, 3.641383660757742*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "0", ",", "4", ",", "5", ",", "3", ",", "3",
      ",", "2", ",", "6", ",", "2", ",", "3", ",", "6", ",", "4", ",", "2", 
     ",", 
     FractionBox["21", "5"], ",", 
     FractionBox["11", "10"], ",", 
     FractionBox["51", "10"], ",", 
     FractionBox["16", "5"], ",", 
     FractionBox["6", "5"], ",", 
     FractionBox["1", "5"], ",", "5", ",", "5", ",", "6", ",", "4", ",", "5", 
     ",", "5"}], "}"}]}],
  SequenceForm[
  "lptos de pintaAux=", {1, 2, 3, 0, 4, 5, 3, 3, 2, 6, 2, 3, 6, 4, 2, 
    Rational[21, 5], 
    Rational[11, 10], 
    Rational[51, 10], 
    Rational[16, 5], 
    Rational[6, 5], 
    Rational[1, 5], 5, 5, 6, 4, 5, 5}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412785690595107`*^9, {3.6412788821958714`*^9, 3.641278889474039*^9}, 
   3.6412789456889577`*^9, 3.641279080636791*^9, 3.641279137601229*^9, 
   3.6412792398208137`*^9, 3.641279331204707*^9, 3.6412802497970123`*^9, {
   3.641280309096112*^9, 3.6412803173779936`*^9}, 3.641281085190443*^9, 
   3.641292753003189*^9, 3.6413836607617455`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "20", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "40", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "30", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"60", ",", "20", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"60", ",", "40", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"42", ",", "11", ",", "51"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"32", ",", "12", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "50", ",", "60"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "50", ",", "50"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{10, 20, 30}, {0, 40, 50}, {30, 30, 20}, {60, 20, 30}, {60, 40, 
   20}, {42, 11, 51}, {32, 12, 2}, {50, 50, 60}, {40, 50, 50}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412785690595107`*^9, {3.6412788821958714`*^9, 3.641278889474039*^9}, 
   3.6412789456889577`*^9, 3.641279080636791*^9, 3.641279137601229*^9, 
   3.6412792398208137`*^9, 3.641279331204707*^9, 3.6412802497970123`*^9, {
   3.641280309096112*^9, 3.6412803173779936`*^9}, 3.641281085190443*^9, 
   3.641292753003189*^9, 3.6413836607637453`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412785690595107`*^9, {3.6412788821958714`*^9, 3.641278889474039*^9}, 
   3.6412789456889577`*^9, 3.641279080636791*^9, 3.641279137601229*^9, 
   3.6412792398208137`*^9, 3.641279331204707*^9, 3.6412802497970123`*^9, {
   3.641280309096112*^9, 3.6412803173779936`*^9}, 3.641281085190443*^9, 
   3.641292753003189*^9, 3.641383660765758*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\usuario\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{
  3.6412785690595107`*^9, {3.6412788821958714`*^9, 3.641278889474039*^9}, 
   3.6412789456889577`*^9, 3.641279080636791*^9, 3.641279137601229*^9, 
   3.6412792398208137`*^9, 3.641279331204707*^9, 3.6412802497970123`*^9, {
   3.641280309096112*^9, 3.6412803173779936`*^9}, 3.641281085190443*^9, 
   3.641292753003189*^9, 3.641383660832785*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"6", ",", "4", ",", "2"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3", ",", "2"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4", ",", "5"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["16", "5"], ",", 
        FractionBox["6", "5"], ",", 
        FractionBox["1", "5"]}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["21", "5"], ",", 
        FractionBox["11", "10"], ",", 
        FractionBox["51", "10"]}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{6, 4, 2}}, {{3, 3, 2}}, {{0, 4, 5}}, {{
      Rational[16, 5], 
      Rational[6, 5], 
      Rational[1, 5]}}, {{
      Rational[21, 5], 
      Rational[11, 10], 
      Rational[51, 10]}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412785690595107`*^9, {3.6412788821958714`*^9, 3.641278889474039*^9}, 
   3.6412789456889577`*^9, 3.641279080636791*^9, 3.641279137601229*^9, 
   3.6412792398208137`*^9, 3.641279331204707*^9, 3.6412802497970123`*^9, {
   3.641280309096112*^9, 3.6412803173779936`*^9}, 3.641281085190443*^9, 
   3.641292753003189*^9, 3.6413836610189185`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["16", "5"], ",", 
       FractionBox["6", "5"], ",", 
       FractionBox["1", "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["21", "5"], ",", 
       FractionBox["11", "10"], ",", 
       FractionBox["51", "10"]}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{6, 4, 2}, {3, 3, 2}, {0, 4, 5}, {
     Rational[16, 5], 
     Rational[6, 5], 
     Rational[1, 5]}, {
     Rational[21, 5], 
     Rational[11, 10], 
     Rational[51, 10]}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412785690595107`*^9, {3.6412788821958714`*^9, 3.641278889474039*^9}, 
   3.6412789456889577`*^9, 3.641279080636791*^9, 3.641279137601229*^9, 
   3.6412792398208137`*^9, 3.641279331204707*^9, 3.6412802497970123`*^9, {
   3.641280309096112*^9, 3.6412803173779936`*^9}, 3.641281085190443*^9, 
   3.641292753003189*^9, 3.6413836610229206`*^9}],

Cell[BoxData["\<\"Semigrupo no simplicial\"\>"], "Print",
 CellChangeTimes->{
  3.6412785690595107`*^9, {3.6412788821958714`*^9, 3.641278889474039*^9}, 
   3.6412789456889577`*^9, 3.641279080636791*^9, 3.641279137601229*^9, 
   3.6412792398208137`*^9, 3.641279331204707*^9, 3.6412802497970123`*^9, {
   3.641280309096112*^9, 3.6412803173779936`*^9}, 3.641281085190443*^9, 
   3.641292753003189*^9, 3.641383661026923*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"24", "-", "x1", "-", 
     RowBox[{"5", " ", "x2"}], "+", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"9", " ", "x1"}], "-", 
     RowBox[{"27", " ", "x2"}], "+", 
     RowBox[{"28", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"2", "+", "x1", "-", 
     RowBox[{"3", " ", "x2"}], "+", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"6", "+", "x1", "-", 
     RowBox[{"4", " ", "x2"}], "+", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"787", "+", 
     RowBox[{"30", " ", "x1"}], "+", 
     RowBox[{"37", " ", "x2"}], "-", 
     RowBox[{"187", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"21", "+", "x1", "-", 
     RowBox[{"4", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "17"}], "+", 
     RowBox[{"9", " ", "x1"}], "-", 
     RowBox[{"12", " ", "x2"}], "+", 
     RowBox[{"13", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1481"}], "+", 
     RowBox[{"210", " ", "x1"}], "+", 
     RowBox[{"679", " ", "x2"}], "-", 
     RowBox[{"29", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "13"}], "+", 
     RowBox[{"12", " ", "x1"}], "+", 
     RowBox[{"17", " ", "x2"}], "-", 
     RowBox[{"11", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "29"}], "+", 
     RowBox[{"10", " ", "x1"}], "-", 
     RowBox[{"4", " ", "x2"}], "+", 
     RowBox[{"9", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"221", "-", 
     RowBox[{"30", " ", "x1"}], "+", 
     RowBox[{"11", " ", "x2"}], "-", 
     RowBox[{"21", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"62", "-", 
     RowBox[{"9", " ", "x1"}], "-", "x2", "-", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"35", " ", "x1"}], "+", 
     RowBox[{"91", " ", "x2"}], "+", 
     RowBox[{"9", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"40", "-", 
     RowBox[{"16", " ", "x1"}], "+", 
     RowBox[{"7", " ", "x2"}], "+", 
     RowBox[{"14", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412785690595107`*^9, {3.6412788821958714`*^9, 3.641278889474039*^9}, 
   3.6412789456889577`*^9, 3.641279080636791*^9, 3.641279137601229*^9, 
   3.6412792398208137`*^9, 3.641279331204707*^9, 3.6412802497970123`*^9, {
   3.641280309096112*^9, 3.6412803173779936`*^9}, 3.641281085190443*^9, 
   3.641292753003189*^9, 3.641383661227064*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"149", " ", "x1"}], "+", 
     RowBox[{"210", " ", "x2"}], "-", 
     RowBox[{"168", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "295"}], " ", "x1"}], "+", 
     RowBox[{"774", " ", "x2"}], "+", 
     RowBox[{"76", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"5912", "-", 
     RowBox[{"695", " ", "x1"}], "+", 
     RowBox[{"596", " ", "x2"}], "+", 
     RowBox[{"154", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"x1", "-", 
     RowBox[{"3", " ", "x2"}], "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"4", " ", "x1"}], "-", 
     RowBox[{"13", " ", "x2"}], "+", 
     RowBox[{"14", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"8", "+", "x1", "-", 
     RowBox[{"3", " ", "x2"}], "+", 
     RowBox[{"2", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"1864", "-", 
     RowBox[{"29", " ", "x1"}], "-", 
     RowBox[{"44", " ", "x2"}], "-", 
     RowBox[{"58", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"7", " ", "x1"}], "-", 
     RowBox[{"15", " ", "x2"}], "+", 
     RowBox[{"12", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412785690595107`*^9, {3.6412788821958714`*^9, 3.641278889474039*^9}, 
   3.6412789456889577`*^9, 3.641279080636791*^9, 3.641279137601229*^9, 
   3.6412792398208137`*^9, 3.641279331204707*^9, 3.6412802497970123`*^9, {
   3.641280309096112*^9, 3.6412803173779936`*^9}, 3.641281085190443*^9, 
   3.641292753003189*^9, 3.6413836614282093`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "13125", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "1918", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "1799", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "119"}],
  SequenceForm[13125, " ", 1918, " ", 1799, " ", 119],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412785690595107`*^9, {3.6412788821958714`*^9, 3.641278889474039*^9}, 
   3.6412789456889577`*^9, 3.641279080636791*^9, 3.641279137601229*^9, 
   3.6412792398208137`*^9, 3.641279331204707*^9, 3.6412802497970123`*^9, {
   3.641280309096112*^9, 3.6412803173779936`*^9}, 3.641281085190443*^9, 
   3.641292753003189*^9, 3.6413836654020305`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{0., 4., 5.}, {1., 2., 3.}, {3., 3., 2.}, {3.2, 1.2, 
    0.2}, {4., 5., 5.}, {4.2, 1.1, 5.1}, {5., 5., 6.}, {6., 2., 3.}, {6., 4., 
    2.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.0033790637830990455`, 0.2014037868268741, 0.8830034927250909], Opacity[
     0.5]}], Polygon3DBox[{{7, 1, 6}, {5, 7, 9}, {9, 7, 8}, {1, 2, 6}, {7, 6, 
      8}, {7, 5, 1}, {5, 9, 1}, {6, 2, 4}, {6, 4, 8}, {1, 9, 3}, {2, 1, 4}, {
      1, 3, 4}, {3, 9, 4}, {4, 9, 8}}]}], 
   GraphicsComplex3DBox[{{0., 8., 10.}, {2., 4., 6.}, {6., 6., 4.}, {6.4, 2.4,
     0.4}, {8., 10., 10.}, {8.4, 2.2, 10.2}, {10., 10., 12.}, {12., 4., 6.}, {
    12., 8., 4.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.17008968161721594`, 0.8129303342007375, 0.5995535025514327], Opacity[
     0.5]}], Polygon3DBox[{{7, 1, 6}, {5, 7, 9}, {9, 7, 8}, {1, 2, 6}, {7, 6, 
      8}, {7, 5, 1}, {5, 9, 1}, {6, 2, 4}, {6, 4, 8}, {1, 9, 3}, {2, 1, 4}, {
      1, 3, 4}, {3, 9, 4}, {4, 9, 8}}]}], 
   GraphicsComplex3DBox[{{0., 12., 15.}, {3., 6., 9.}, {9., 9., 6.}, {9.6, 
    3.6, 0.6}, {12., 15., 15.}, {12.6, 3.3, 15.3}, {15., 15., 18.}, {18., 6., 
    9.}, {18., 12., 6.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.4678154075774563, 0.42575002061979594`, 0.47501332276681074`], Opacity[
     0.5]}], Polygon3DBox[{{7, 1, 6}, {5, 7, 9}, {9, 7, 8}, {1, 2, 6}, {7, 6, 
      8}, {7, 5, 1}, {5, 9, 1}, {6, 2, 4}, {6, 4, 8}, {1, 9, 3}, {2, 1, 4}, {
      1, 3, 4}, {3, 9, 4}, {4, 9, 8}}]}], 
   GraphicsComplex3DBox[{{0., 16., 20.}, {4., 8., 12.}, {12., 12., 8.}, {12.8,
     4.8, 0.8}, {16., 20., 20.}, {16.8, 4.4, 20.4}, {20., 20., 24.}, {24., 8.,
     12.}, {24., 16., 8.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.7243359199777741, 0.6781621667684323, 0.14418760045233592`], Opacity[
     0.5]}], Polygon3DBox[{{7, 1, 6}, {5, 7, 9}, {9, 7, 8}, {1, 2, 6}, {7, 6, 
      8}, {7, 5, 1}, {5, 9, 1}, {6, 2, 4}, {6, 4, 8}, {1, 9, 3}, {2, 1, 4}, {
      1, 3, 4}, {3, 9, 4}, {4, 9, 8}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[
     NCache[{{6, 4, 2}, {3, 3, 2}, {0, 4, 5}, {
       Rational[16, 5], Rational[6, 5], Rational[1, 5]}, {
       Rational[21, 5], Rational[11, 10], Rational[51, 10]}}, {{6, 4, 2}, {3, 
       3, 2}, {0, 4, 5}, {3.2, 1.2, 0.2}, {4.2, 1.1, 5.1}}]]}, 
   {RGBColor[0, 0, 1], PointSize[Medium], Point3DBox[CompressedData["
1:eJwll1uS67ANRO9YJN4ASclzk99sKUvIBrL/vzQUloslU/RDINB98K///Pff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     "]]}, 
   {RGBColor[1, 0, 0], Line3DBox[{{0, 0, 0}, {30, 20, 10}}], 
    Line3DBox[{{0, 0, 0}, {15, 15, 10}}], Line3DBox[{{0, 0, 0}, {0, 20, 25}}],
     Line3DBox[{{0, 0, 0}, {16, 6, 1}}], 
    Line3DBox[
     NCache[{{0, 0, 0}, {21, Rational[11, 2], Rational[51, 2]}}, {{0, 0, 0}, {
       21, 5.5, 25.5}}]]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{512.1525331174792, 579.},
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All,
  ViewPoint->{0.42672399082183293`, -3.349930773957031, 0.21417386710975603`},
  ViewVertical->{-0.006940005777473667, -0.8934416728120368, 
   0.9449771654873558}]], "Output",
 CellChangeTimes->{{3.6412739992407837`*^9, 3.6412740498427167`*^9}, {
   3.6412762623139906`*^9, 3.6412762897995086`*^9}, 3.6412763286360865`*^9, 
   3.6412763634748273`*^9, {3.6412764639121475`*^9, 3.6412764806220226`*^9}, 
   3.6412765489115067`*^9, {3.641277049497876*^9, 3.641277079020856*^9}, 
   3.6412771264705343`*^9, {3.641278564235077*^9, 3.641278571994596*^9}, {
   3.6412788846636143`*^9, 3.6412788920038357`*^9}, 3.641278948093665*^9, 
   3.6412790830484886`*^9, 3.6412791399489026`*^9, 3.6412792424426837`*^9, 
   3.641279333666463*^9, 3.6412802522017193`*^9, {3.6412803115338593`*^9, 
   3.6412803197837005`*^9}, 3.6412810879644156`*^9, 3.6412927553928795`*^9, 
   3.6413836655361347`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vc2", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "10", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Pi]", ",", 
      SqrtBox["2"], ",", 
      SqrtBox["3"]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.641280513243089*^9, 3.6412805450306573`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Pi]", ",", 
     SqrtBox["2"], ",", 
     SqrtBox["3"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.641280645323309*^9, 3.64129276267906*^9, 
  3.6413836681900196`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Pi]", ",", 
     SqrtBox["2"], ",", 
     SqrtBox["3"]}], "}"}], "//", "N"}]}]], "Input",
 CellChangeTimes->{{3.641280574787899*^9, 3.641280575206208*^9}, 
   3.6412806421884403`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.141592653589793`", ",", "1.4142135623730951`", ",", 
   "1.7320508075688772`"}], "}"}]], "Output",
 CellChangeTimes->{{3.6412805463806176`*^9, 3.6412805757355795`*^9}, 
   3.641292763646737*^9, 3.641383669147701*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vc2", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "10", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["314", "100"], ",", 
      FractionBox["141", "100"], ",", 
      FractionBox["173", "100"]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.641280586308084*^9, 3.641280690759234*^9}, 
   3.641281293446321*^9, {3.6412813644757714`*^9, 3.6412813745559297`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["157", "50"], ",", 
     FractionBox["141", "100"], ",", 
     FractionBox["173", "100"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6412806367325673`*^9, 3.641280691252589*^9}, 
   3.641280727580385*^9, 3.641281099345502*^9, 3.6412812419687753`*^9, 
   3.6412812940437546`*^9, 3.6412813752394114`*^9, 3.641292764982706*^9, 
   3.641383670185448*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"raysOfConeOfCHSgr", "[", "vc2", "]"}]], "Input",
 CellChangeTimes->{{3.6412811416135116`*^9, 3.641281174300723*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.6412811465970554`*^9, 3.6412811752613955`*^9}, 
   3.6412812451900616`*^9, 3.641281294960396*^9, 3.641281379247257*^9, 
   3.6412927664527316`*^9, 3.6413836712762012`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "0", ",", "0", ",", "0", ",", "10", ",", "0", ",", "0", ",", 
     "0", ",", "10", ",", 
     FractionBox["157", "50"], ",", 
     FractionBox["141", "100"], ",", 
     FractionBox["173", "100"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {10, 0, 0, 0, 10, 0, 0, 0, 10, 
    Rational[157, 50], 
    Rational[141, 100], 
    Rational[173, 100]}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412811465970554`*^9, 3.6412811752613955`*^9}, 
   3.6412812451900616`*^9, 3.641281294960396*^9, 3.641281379247257*^9, 
   3.6412927664527316`*^9, 3.6413836712782116`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1000", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1000", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1000"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"314", ",", "141", ",", "173"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{1000, 0, 0}, {0, 1000, 0}, {0, 0, 1000}, {314, 141, 173}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412811465970554`*^9, 3.6412811752613955`*^9}, 
   3.6412812451900616`*^9, 3.641281294960396*^9, 3.641281379247257*^9, 
   3.6412927664527316`*^9, 3.641383671280213*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412811465970554`*^9, 3.6412811752613955`*^9}, 
   3.6412812451900616`*^9, 3.641281294960396*^9, 3.641281379247257*^9, 
   3.6412927664527316`*^9, 3.6413836712822056`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\usuario\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.6412811465970554`*^9, 3.6412811752613955`*^9}, 
   3.6412812451900616`*^9, 3.641281294960396*^9, 3.641281379247257*^9, 
   3.6412927664527316`*^9, 3.6413836713012466`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6412811479580073`*^9, 3.6412811763291535`*^9}, 
   3.641281247748871*^9, 3.6412812951205225`*^9, 3.6412813794373884`*^9, 
   3.6412927666308575`*^9, 3.641383671482403*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vc2", ",", "3", ",", "True", ",", "False", ",", "True"}], "]"}], 
   "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.641280557268343*^9, 3.641280557321381*^9}, {
  3.641281409033403*^9, 3.6412814091264763`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{
  3.6412805590496063`*^9, {3.641280625573961*^9, 3.641280695178384*^9}, {
   3.641280729623843*^9, 3.641280744593577*^9}, 3.641281104102866*^9, {
   3.6412813854646716`*^9, 3.6412814096718616`*^9}, 3.641292769959221*^9, 
   3.6413836759675417`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "0", ",", "0", ",", "0", ",", "10", ",", "0", ",", "0", ",", 
     "0", ",", "10", ",", 
     FractionBox["157", "50"], ",", 
     FractionBox["141", "100"], ",", 
     FractionBox["173", "100"]}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {10, 0, 0, 0, 10, 0, 0, 0, 10, 
    Rational[157, 50], 
    Rational[141, 100], 
    Rational[173, 100]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412805590496063`*^9, {3.641280625573961*^9, 3.641280695178384*^9}, {
   3.641280729623843*^9, 3.641280744593577*^9}, 3.641281104102866*^9, {
   3.6412813854646716`*^9, 3.6412814096718616`*^9}, 3.641292769959221*^9, 
   3.6413836759745483`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1000", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1000", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1000"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"314", ",", "141", ",", "173"}], "}"}]}], "}"}]}],
  SequenceForm[
  "l=", {{1000, 0, 0}, {0, 1000, 0}, {0, 0, 1000}, {314, 141, 173}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412805590496063`*^9, {3.641280625573961*^9, 3.641280695178384*^9}, {
   3.641280729623843*^9, 3.641280744593577*^9}, 3.641281104102866*^9, {
   3.6412813854646716`*^9, 3.6412814096718616`*^9}, 3.641292769959221*^9, 
   3.641383675976548*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412805590496063`*^9, {3.641280625573961*^9, 3.641280695178384*^9}, {
   3.641280729623843*^9, 3.641280744593577*^9}, 3.641281104102866*^9, {
   3.6412813854646716`*^9, 3.6412814096718616`*^9}, 3.641292769959221*^9, 
   3.641383675978588*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\usuario\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{
  3.6412805590496063`*^9, {3.641280625573961*^9, 3.641280695178384*^9}, {
   3.641280729623843*^9, 3.641280744593577*^9}, 3.641281104102866*^9, {
   3.6412813854646716`*^9, 3.6412814096718616`*^9}, 3.641292769959221*^9, 
   3.641383675998554*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"10", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "10"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm["vTriangulo=", {{{10, 0, 0}}, {{0, 10, 0}}, {{0, 0, 10}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412805590496063`*^9, {3.641280625573961*^9, 3.641280695178384*^9}, {
   3.641280729623843*^9, 3.641280744593577*^9}, 3.641281104102866*^9, {
   3.6412813854646716`*^9, 3.6412814096718616`*^9}, 3.641292769959221*^9, 
   3.6413836761576767`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "10"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{10, 0, 0}, {0, 10, 0}, {0, 0, 10}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412805590496063`*^9, {3.641280625573961*^9, 3.641280695178384*^9}, {
   3.641280729623843*^9, 3.641280744593577*^9}, 3.641281104102866*^9, {
   3.6412813854646716`*^9, 3.6412814096718616`*^9}, 3.641292769959221*^9, 
   3.641383676160679*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"10", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", "0"}],
    ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1730"}], "+", 
     RowBox[{"173", " ", "x1"}], "+", 
     RowBox[{"173", " ", "x2"}], "+", 
     RowBox[{"545", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "470"}], "+", 
     RowBox[{"47", " ", "x1"}], "+", 
     RowBox[{"171", " ", "x2"}], "+", 
     RowBox[{"47", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1570"}], "+", 
     RowBox[{"343", " ", "x1"}], "+", 
     RowBox[{"157", " ", "x2"}], "+", 
     RowBox[{"157", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412805590496063`*^9, {3.641280625573961*^9, 3.641280695178384*^9}, {
   3.641280729623843*^9, 3.641280744593577*^9}, 3.641281104102866*^9, {
   3.6412813854646716`*^9, 3.6412814096718616`*^9}, 3.641292769959221*^9, 
   3.6413836762687464`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x3", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x1", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"x2", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"30", "-", "x1", "-", "x2", "-", "x3"}], "\[GreaterEqual]", 
    "0"}]}], "}"}]], "Print",
 CellChangeTimes->{
  3.6412805590496063`*^9, {3.641280625573961*^9, 3.641280695178384*^9}, {
   3.641280729623843*^9, 3.641280744593577*^9}, 3.641281104102866*^9, {
   3.6412813854646716`*^9, 3.6412814096718616`*^9}, 3.641292769959221*^9, 
   3.641383676410864*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "29791", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "5456", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "2718", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "2738"}],
  SequenceForm[29791, " ", 5456, " ", 2718, " ", 2738],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6412805590496063`*^9, {3.641280625573961*^9, 3.641280695178384*^9}, {
   3.641280729623843*^9, 3.641280744593577*^9}, 3.641281104102866*^9, {
   3.6412813854646716`*^9, 3.6412814096718616`*^9}, 3.641292769959221*^9, 
   3.641383682241989*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{0., 0., 10.}, {0., 10., 0.}, {3.14, 1.41, 1.73}, {
    10., 0., 0.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.19153922133928192`, 0.8794650669816659, 0.9722208669016066], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   GraphicsComplex3DBox[{{0., 0., 20.}, {0., 20., 0.}, {6.28, 2.82, 3.46}, {
    20., 0., 0.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.04503798634861789, 0.6629099820562614, 0.21123034581877342`], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   GraphicsComplex3DBox[{{0., 0., 30.}, {0., 30., 0.}, {9.42, 4.23, 5.19}, {
    30., 0., 0.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.19559697473024285`, 0.32057542336241385`, 0.3279434303188882], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[{{10, 0, 0}, {0, 10, 0}, {0, 0, 10}}]}, 
   {RGBColor[0, 0, 1], PointSize[Medium], Point3DBox[CompressedData["
1:eJwtWeeR5UhzRJdsCfnEzO59jKBLNIEO0CPaykyS8+si7i2A7qpKVf/+n//1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     "]]}, 
   {RGBColor[1, 0, 0], Line3DBox[{{0, 0, 0}, {40, 0, 0}}], 
    Line3DBox[{{0, 0, 0}, {0, 40, 0}}], Line3DBox[{{0, 0, 0}, {0, 0, 40}}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{576.5448945930588, 577.},
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All,
  ViewPoint->{-0.8395631171612427, -3.0767180320926606`, 1.1309022607185693`},
  ViewVertical->{-0.18436564379860515`, -0.25038724445718674`, 
   0.9504291331813557}]], "Output",
 CellChangeTimes->{
  3.641281137176352*^9, {3.6412813916070337`*^9, 3.641281412097574*^9}, 
   3.641292772357933*^9, 3.6413836824071565`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vc3", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "7", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "4", ",", "5"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.6412966422624345`*^9, 3.6412966810059466`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "7", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "4", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6412966814782925`*^9, 3.6413836841883807`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"chSemigroup", "[", 
    RowBox[{"vc3", ",", "2", ",", "False", ",", "False", ",", "True"}], "]"}],
    "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "showAxesAndPoints"}]], "Input",
 CellChangeTimes->{{3.6412966825490417`*^9, 3.641296714317611*^9}, {
  3.6412968877717724`*^9, 3.641296887834817*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"entrada en pintaAux\"\>"], "Print",
 CellChangeTimes->{{3.6412966947036734`*^9, 3.641296714600802*^9}, 
   3.6412968881980743`*^9, 3.641383685371219*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lptos de pintaAux=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "5", ",", "5", ",", "7", ",", "7", ",", "7", ",", "5", ",", "4",
      ",", "7", ",", "7", ",", "4", ",", "5"}], "}"}]}],
  SequenceForm["lptos de pintaAux=", {5, 5, 5, 7, 7, 7, 5, 4, 7, 7, 4, 5}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412966947036734`*^9, 3.641296714600802*^9}, 
   3.6412968881980743`*^9, 3.641383685375223*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"l=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "7", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "4", ",", "5"}], "}"}]}], "}"}]}],
  SequenceForm["l=", {{5, 5, 5}, {7, 7, 7}, {5, 4, 7}, {7, 4, 5}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412966947036734`*^9, 3.641296714600802*^9}, 
   3.6412968881980743`*^9, 3.6413836853772144`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Escribiendo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\tmp\\\\aux1.in\"\>"}],
  SequenceForm["Escribiendo: ", "C:\\tmp\\aux1.in"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412966947036734`*^9, 3.641296714600802*^9}, 
   3.6412968881980743`*^9, 3.6413836853792453`*^9}],

Cell[BoxData["\<\"C:\\\\tmp\\\\Normaliz2.12\\\\normaliz.exe -c -e C:\\\\Users\
\\\\usuario\\\\SkyDrive\\\\paquete-convex3d\\\\aux1\"\>"], "Print",
 CellChangeTimes->{{3.6412966947036734`*^9, 3.641296714600802*^9}, 
   3.6412968881980743`*^9, 3.641383685393236*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vTriangulo=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "7", ",", "7"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"5", ",", "4", ",", "7"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"7", ",", "4", ",", "5"}], "}"}], "}"}]}], "}"}]}],
  SequenceForm[
  "vTriangulo=", {{{5, 5, 5}, {7, 7, 7}}, {{5, 4, 7}}, {{7, 4, 5}}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412966947036734`*^9, 3.641296714600802*^9}, 
   3.6412968881980743`*^9, 3.641383685615393*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lvRayos=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "4", ",", "5"}], "}"}]}], "}"}]}],
  SequenceForm["lvRayos=", {{5, 5, 5}, {5, 4, 7}, {7, 4, 5}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412966947036734`*^9, 3.641296714600802*^9}, 
   3.6412968881980743`*^9, 3.641383685618396*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"2", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", 
     RowBox[{"2", " ", "x2"}], "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "20"}], "+", "x1", "+", 
     RowBox[{"2", " ", "x2"}], "+", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"28", "-", 
     RowBox[{"3", " ", "x1"}], "+", 
     RowBox[{"2", " ", "x2"}], "-", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}]}], "}"}]], "Print",
 CellChangeTimes->{{3.6412966947036734`*^9, 3.641296714600802*^9}, 
   3.6412968881980743`*^9, 3.6413836857405186`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x1"}], "-", 
     RowBox[{"2", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "-", 
     RowBox[{"2", " ", "x2"}], "+", 
     RowBox[{"3", " ", "x3"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x1"}], "+", 
     RowBox[{"3", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"40", "-", "x1", "-", 
     RowBox[{"2", " ", "x2"}], "-", "x3"}], "\[GreaterEqual]", "0"}]}], 
  "}"}]], "Print",
 CellChangeTimes->{{3.6412966947036734`*^9, 3.641296714600802*^9}, 
   3.6412968881980743`*^9, 3.6413836858525515`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3375", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "81", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "64"}],
  SequenceForm[3375, " ", 81, " ", 17, " ", 64],
  Editable->False]], "Print",
 CellChangeTimes->{{3.6412966947036734`*^9, 3.641296714600802*^9}, 
   3.6412968881980743`*^9, 3.6413836860036683`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[{{5., 4., 7.}, {5., 5., 5.}, {7., 4., 5.}, {7., 7., 
    7.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.2063851144392701, 0.9173932237742226, 0.5346438666590414], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   GraphicsComplex3DBox[{{10., 8., 14.}, {10., 10., 10.}, {14., 8., 10.}, {
    14., 14., 14.}}, 
    {Hue[0.6, 0.3, 0.85], EdgeForm[Hue[0.6, 0.3, 0.75]], FaceForm[{RGBColor[
     0.23426042470734365`, 0.5596125818237767, 0.38148923109185406`], Opacity[
     0.5]}], Polygon3DBox[{{1, 2, 3}, {2, 4, 3}, {3, 4, 1}, {1, 4, 2}}]}], 
   {RGBColor[1, 0, 0], PointSize[Medium], 
    Point3DBox[{{5, 5, 5}, {7, 7, 7}, {5, 4, 7}, {7, 4, 5}}]}, 
   {RGBColor[1, 0, 0], Line3DBox[{{0, 0, 0}, {15, 15, 15}}], 
    Line3DBox[{{0, 0, 0}, {15, 12, 21}}], 
    Line3DBox[{{0, 0, 0}, {21, 12, 15}}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  ImageSize->{500.47550164578394`, 544.},
  Lighting->{{"Ambient", 
     GrayLevel[0.45]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{2, 0, 2}]}, {"Directional", 
     GrayLevel[0.33], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     GrayLevel[0.3], 
     ImageScaled[{0, 2, 2}]}},
  Method->{"ShrinkWrap" -> True},
  PlotRange->All,
  ViewPoint->{2.512524528346007, 2.1702193533288847`, 0.6537342372068587},
  ViewVertical->{-0.1000874564686738, 1.3086130295618505`, 
   0.3409901854876988}]], "Output",
 CellChangeTimes->{3.6412968887534685`*^9, 3.6413836860667324`*^9}]
}, Open  ]]
}, Closed]]
},
WindowSize->{944, 981},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"10.0 for Microsoft Windows (64-bit) (July 1, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 110, 1, 70, "Section"],
Cell[693, 25, 169, 3, 31, "Input"],
Cell[CellGroupData[{
Cell[887, 32, 350, 9, 31, "Input"],
Cell[1240, 43, 535, 8, 157, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1812, 56, 528, 11, 52, "Input"],
Cell[2343, 69, 1010, 18, 62, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3402, 93, 19, 0, 70, "Section"],
Cell[CellGroupData[{
Cell[3446, 97, 641, 19, 31, "Input"],
Cell[4090, 118, 565, 18, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4692, 141, 129, 2, 31, "Input"],
Cell[4824, 145, 321, 5, 132, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5182, 155, 143, 2, 31, "Input"],
Cell[5328, 159, 303, 5, 152, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5668, 169, 173, 3, 31, "Input"],
Cell[CellGroupData[{
Cell[5866, 176, 97, 1, 23, "Print"],
Cell[5966, 179, 670, 19, 40, "Print"],
Cell[6639, 200, 669, 19, 23, "Print"],
Cell[7311, 221, 254, 6, 23, "Print"],
Cell[7568, 229, 145, 2, 23, "Print"]
}, Open  ]],
Cell[7728, 234, 1152, 33, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8917, 272, 159, 3, 31, "Input"],
Cell[9079, 277, 509, 15, 31, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9637, 298, 19, 0, 70, "Section"],
Cell[CellGroupData[{
Cell[9681, 302, 595, 17, 31, "Input"],
Cell[10279, 321, 1221, 34, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11537, 360, 221, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[11783, 368, 513, 7, 23, "Print"],
Cell[12299, 377, 1541, 43, 40, "Print"],
Cell[13843, 422, 1085, 25, 23, "Print"],
Cell[14931, 449, 670, 12, 23, "Print"],
Cell[15604, 463, 599, 8, 23, "Print"],
Cell[16206, 473, 597, 11, 23, "Print"],
Cell[16806, 486, 1445, 40, 40, "Print"],
Cell[18254, 528, 938, 21, 59, "Print"],
Cell[19195, 551, 940, 21, 59, "Print"],
Cell[20138, 574, 940, 21, 59, "Print"],
Cell[21081, 597, 1262, 33, 40, "Print"],
Cell[22346, 632, 588, 11, 40, "Print"],
Cell[22937, 645, 1256, 33, 40, "Print"],
Cell[24196, 680, 586, 11, 40, "Print"],
Cell[24785, 693, 1246, 33, 40, "Print"],
Cell[26034, 728, 586, 11, 40, "Print"],
Cell[26623, 741, 610, 11, 23, "Print"],
Cell[27236, 754, 508, 7, 23, "Print"],
Cell[27747, 763, 642, 11, 23, "Print"],
Cell[28392, 776, 1120, 29, 40, "Print"],
Cell[29515, 807, 567, 9, 23, "Print"],
Cell[30085, 818, 618, 11, 23, "Print"],
Cell[30706, 831, 642, 11, 23, "Print"],
Cell[31351, 844, 1114, 29, 40, "Print"],
Cell[32468, 875, 568, 9, 23, "Print"],
Cell[33039, 886, 618, 11, 23, "Print"],
Cell[33660, 899, 640, 11, 23, "Print"],
Cell[34303, 912, 1104, 29, 40, "Print"],
Cell[35410, 943, 566, 9, 23, "Print"],
Cell[35979, 954, 618, 11, 23, "Print"]
}, Open  ]],
Cell[36612, 968, 4279, 126, 167, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40928, 1099, 347, 8, 31, "Input"],
Cell[CellGroupData[{
Cell[41300, 1111, 269, 3, 23, "Print"],
Cell[41572, 1116, 1297, 39, 40, "Print"],
Cell[42872, 1157, 843, 21, 23, "Print"],
Cell[43718, 1180, 428, 8, 23, "Print"],
Cell[44149, 1190, 359, 4, 23, "Print"],
Cell[44511, 1196, 1205, 36, 40, "Print"],
Cell[45719, 1234, 1089, 33, 40, "Print"],
Cell[46811, 1269, 1417, 38, 43, "Print"],
Cell[48231, 1309, 963, 26, 23, "Print"],
Cell[49197, 1337, 532, 10, 23, "Print"]
}, Open  ]],
Cell[49744, 1350, 3354, 67, 399, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53135, 1422, 163, 3, 31, "Input"],
Cell[CellGroupData[{
Cell[53323, 1429, 649, 17, 23, "Print"],
Cell[53975, 1448, 143, 2, 23, "Print"],
Cell[54121, 1452, 1169, 38, 40, "Print"],
Cell[55293, 1492, 713, 20, 23, "Print"],
Cell[56009, 1514, 298, 7, 23, "Print"],
Cell[56310, 1523, 229, 3, 23, "Print"],
Cell[56542, 1528, 1077, 35, 40, "Print"],
Cell[57622, 1565, 963, 32, 40, "Print"],
Cell[58588, 1599, 1287, 37, 43, "Print"],
Cell[59878, 1638, 835, 25, 23, "Print"],
Cell[60716, 1665, 402, 9, 23, "Print"]
}, Open  ]],
Cell[61133, 1677, 147, 2, 31, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61329, 1685, 19, 0, 70, "Section"],
Cell[61351, 1687, 120, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[61496, 1693, 350, 9, 31, "Input"],
Cell[61849, 1704, 362, 5, 157, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62248, 1714, 528, 11, 52, "Input"],
Cell[62779, 1727, 466, 10, 62, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63282, 1742, 1502, 48, 52, "Input"],
Cell[64787, 1792, 1041, 34, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65865, 1831, 644, 16, 52, "Input"],
Cell[CellGroupData[{
Cell[66534, 1851, 170, 2, 23, "Print"],
Cell[66707, 1855, 1361, 44, 40, "Print"],
Cell[68071, 1901, 868, 22, 23, "Print"],
Cell[68942, 1925, 327, 7, 23, "Print"],
Cell[69272, 1934, 260, 3, 23, "Print"],
Cell[69535, 1939, 1078, 35, 40, "Print"],
Cell[70616, 1976, 964, 32, 40, "Print"],
Cell[71583, 2010, 1076, 30, 43, "Print"],
Cell[72662, 2042, 729, 21, 23, "Print"],
Cell[73394, 2065, 451, 9, 23, "Print"]
}, Open  ]],
Cell[73860, 2077, 5507, 101, 445, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[79416, 2184, 120, 1, 56, "Section"],
Cell[CellGroupData[{
Cell[79561, 2189, 116, 3, 31, "Input"],
Cell[79680, 2194, 331, 7, 52, "Output"]
}, Open  ]],
Cell[80026, 2204, 2174, 66, 118, "Input"],
Cell[82203, 2272, 116, 3, 31, "Input"],
Cell[CellGroupData[{
Cell[82344, 2279, 217, 4, 31, "Input"],
Cell[82564, 2285, 2254, 65, 72, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[84855, 2355, 272, 5, 25, "Input"],
Cell[CellGroupData[{
Cell[85152, 2364, 933, 28, 40, "Print"],
Cell[86088, 2394, 985, 26, 23, "Print"]
}, Open  ]],
Cell[87088, 2423, 618, 20, 46, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[87743, 2448, 318, 5, 25, "Input"],
Cell[88064, 2455, 1001, 33, 46, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[89102, 2493, 1031, 25, 46, "Input"],
Cell[90136, 2520, 612, 17, 52, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[90785, 2542, 662, 20, 46, "Input"],
Cell[91450, 2564, 609, 18, 52, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[92096, 2587, 730, 21, 46, "Input"],
Cell[92829, 2610, 590, 17, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93456, 2632, 517, 15, 31, "Input"],
Cell[93976, 2649, 1392, 47, 82, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[95405, 2701, 519, 15, 25, "Input"],
Cell[95927, 2718, 1412, 47, 82, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[97376, 2770, 517, 15, 25, "Input"],
Cell[97896, 2787, 1390, 47, 82, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[99323, 2839, 281, 8, 25, "Input"],
Cell[CellGroupData[{
Cell[99629, 2851, 888, 21, 23, "Print"],
Cell[100520, 2874, 734, 17, 23, "Print"],
Cell[101257, 2893, 896, 21, 23, "Print"],
Cell[102156, 2916, 890, 21, 23, "Print"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[103095, 2943, 277, 8, 25, "Input"],
Cell[CellGroupData[{
Cell[103397, 2955, 840, 20, 23, "Print"],
Cell[104240, 2977, 840, 20, 23, "Print"],
Cell[105083, 2999, 719, 19, 23, "Print"],
Cell[105805, 3020, 900, 21, 23, "Print"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[106754, 3047, 281, 8, 25, "Input"],
Cell[CellGroupData[{
Cell[107060, 3059, 899, 22, 23, "Print"],
Cell[107962, 3083, 837, 21, 23, "Print"],
Cell[108802, 3106, 905, 22, 23, "Print"],
Cell[109710, 3130, 891, 22, 23, "Print"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[110650, 3158, 969, 28, 66, "Input"],
Cell[CellGroupData[{
Cell[111644, 3190, 69, 1, 23, "Print"],
Cell[111716, 3193, 3189, 107, 112, "Print"],
Cell[114908, 3302, 829, 23, 43, "Print"],
Cell[115740, 3327, 551, 14, 23, "Print"],
Cell[116294, 3343, 172, 5, 23, "Print"],
Cell[116469, 3350, 71, 1, 23, "Print"],
Cell[116543, 3353, 3051, 107, 112, "Print"],
Cell[119597, 3462, 795, 22, 43, "Print"],
Cell[120395, 3486, 519, 13, 23, "Print"],
Cell[120917, 3501, 172, 5, 23, "Print"],
Cell[121092, 3508, 71, 1, 23, "Print"],
Cell[121166, 3511, 3615, 123, 112, "Print"],
Cell[124784, 3636, 973, 27, 43, "Print"],
Cell[125760, 3665, 590, 14, 23, "Print"],
Cell[126353, 3681, 170, 5, 23, "Print"],
Cell[126526, 3688, 71, 1, 23, "Print"],
Cell[126600, 3691, 3125, 107, 112, "Print"],
Cell[129728, 3800, 864, 24, 43, "Print"],
Cell[130595, 3826, 576, 14, 23, "Print"],
Cell[131174, 3842, 172, 5, 23, "Print"],
Cell[131349, 3849, 71, 1, 23, "Print"],
Cell[131423, 3852, 2651, 91, 112, "Print"],
Cell[134077, 3945, 695, 19, 43, "Print"],
Cell[134775, 3966, 489, 13, 23, "Print"],
Cell[135267, 3981, 172, 5, 23, "Print"],
Cell[135442, 3988, 71, 1, 23, "Print"],
Cell[135516, 3991, 3139, 107, 112, "Print"],
Cell[138658, 4100, 842, 23, 43, "Print"],
Cell[139503, 4125, 539, 14, 23, "Print"],
Cell[140045, 4141, 172, 5, 23, "Print"],
Cell[140220, 4148, 71, 1, 23, "Print"],
Cell[140294, 4151, 3107, 107, 112, "Print"],
Cell[143404, 4260, 805, 22, 43, "Print"],
Cell[144212, 4284, 535, 14, 23, "Print"],
Cell[144750, 4300, 170, 5, 23, "Print"],
Cell[144923, 4307, 69, 1, 23, "Print"],
Cell[144995, 4310, 3101, 107, 112, "Print"],
Cell[148099, 4419, 820, 22, 43, "Print"],
Cell[148922, 4443, 537, 14, 23, "Print"],
Cell[149462, 4459, 170, 5, 23, "Print"],
Cell[149635, 4466, 69, 1, 23, "Print"],
Cell[149707, 4469, 3147, 107, 112, "Print"],
Cell[152857, 4578, 801, 18, 43, "Print"],
Cell[153661, 4598, 537, 13, 23, "Print"],
Cell[154201, 4613, 170, 5, 23, "Print"],
Cell[154374, 4620, 69, 1, 23, "Print"],
Cell[154446, 4623, 3147, 107, 112, "Print"],
Cell[157596, 4732, 801, 18, 43, "Print"],
Cell[158400, 4752, 539, 13, 23, "Print"],
Cell[158942, 4767, 172, 5, 23, "Print"],
Cell[159117, 4774, 71, 1, 23, "Print"],
Cell[159191, 4777, 3577, 123, 112, "Print"],
Cell[162771, 4902, 939, 25, 43, "Print"],
Cell[163713, 4929, 568, 13, 23, "Print"],
Cell[164284, 4944, 172, 5, 23, "Print"],
Cell[164459, 4951, 68, 1, 23, "Print"],
Cell[164530, 4954, 3079, 107, 112, "Print"],
Cell[167612, 5063, 826, 20, 43, "Print"],
Cell[168441, 5085, 574, 14, 23, "Print"],
Cell[169018, 5101, 170, 5, 23, "Print"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[169237, 5112, 216, 5, 25, "Input"],
Cell[169456, 5119, 125, 3, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169618, 5127, 888, 28, 72, "Input"],
Cell[CellGroupData[{
Cell[170531, 5159, 781, 27, 40, "Print"],
Cell[171315, 5188, 270, 8, 40, "Print"],
Cell[171588, 5198, 201, 6, 40, "Print"],
Cell[171792, 5206, 75, 1, 23, "Print"],
Cell[171870, 5209, 710, 24, 40, "Print"],
Cell[172583, 5235, 270, 8, 40, "Print"],
Cell[172856, 5245, 202, 6, 40, "Print"],
Cell[173061, 5253, 74, 1, 23, "Print"],
Cell[173138, 5256, 772, 27, 40, "Print"],
Cell[173913, 5285, 264, 8, 40, "Print"],
Cell[174180, 5295, 196, 6, 40, "Print"],
Cell[174379, 5303, 75, 1, 23, "Print"],
Cell[174457, 5306, 698, 24, 40, "Print"],
Cell[175158, 5332, 264, 8, 40, "Print"],
Cell[175425, 5342, 197, 6, 40, "Print"],
Cell[175625, 5350, 72, 1, 23, "Print"],
Cell[175700, 5353, 776, 27, 40, "Print"],
Cell[176479, 5382, 266, 8, 40, "Print"],
Cell[176748, 5392, 195, 6, 40, "Print"],
Cell[176946, 5400, 75, 1, 23, "Print"],
Cell[177024, 5403, 647, 22, 40, "Print"],
Cell[177674, 5427, 265, 8, 40, "Print"],
Cell[177942, 5437, 197, 6, 40, "Print"],
Cell[178142, 5445, 72, 1, 23, "Print"],
Cell[178217, 5448, 863, 30, 40, "Print"],
Cell[179083, 5480, 266, 8, 40, "Print"],
Cell[179352, 5490, 197, 6, 40, "Print"],
Cell[179552, 5498, 75, 1, 23, "Print"],
Cell[179630, 5501, 791, 27, 40, "Print"],
Cell[180424, 5530, 265, 8, 40, "Print"],
Cell[180692, 5540, 195, 6, 40, "Print"],
Cell[180890, 5548, 75, 1, 23, "Print"],
Cell[180968, 5551, 792, 27, 40, "Print"],
Cell[181763, 5580, 266, 8, 40, "Print"],
Cell[182032, 5590, 198, 6, 40, "Print"],
Cell[182233, 5598, 74, 1, 23, "Print"],
Cell[182310, 5601, 867, 30, 40, "Print"],
Cell[183180, 5633, 264, 8, 40, "Print"],
Cell[183447, 5643, 204, 6, 40, "Print"],
Cell[183654, 5651, 75, 1, 23, "Print"],
Cell[183732, 5654, 871, 30, 40, "Print"],
Cell[184606, 5686, 265, 8, 40, "Print"],
Cell[184874, 5696, 203, 6, 40, "Print"],
Cell[185080, 5704, 74, 1, 23, "Print"],
Cell[185157, 5707, 875, 30, 40, "Print"],
Cell[186035, 5739, 273, 8, 40, "Print"],
Cell[186311, 5749, 212, 6, 40, "Print"],
Cell[186526, 5757, 73, 1, 23, "Print"],
Cell[186602, 5760, 877, 30, 40, "Print"],
Cell[187482, 5792, 268, 8, 40, "Print"],
Cell[187753, 5802, 211, 6, 40, "Print"],
Cell[187967, 5810, 75, 1, 23, "Print"],
Cell[188045, 5813, 848, 29, 40, "Print"],
Cell[188896, 5844, 272, 8, 40, "Print"],
Cell[189171, 5854, 213, 6, 40, "Print"],
Cell[189387, 5862, 74, 1, 23, "Print"],
Cell[189464, 5865, 870, 30, 40, "Print"],
Cell[190337, 5897, 266, 8, 40, "Print"],
Cell[190606, 5907, 204, 6, 40, "Print"],
Cell[190813, 5915, 73, 1, 23, "Print"],
Cell[190889, 5918, 866, 30, 40, "Print"],
Cell[191758, 5950, 266, 8, 40, "Print"],
Cell[192027, 5960, 204, 6, 40, "Print"],
Cell[192234, 5968, 72, 1, 23, "Print"],
Cell[192309, 5971, 861, 30, 40, "Print"],
Cell[193173, 6003, 268, 8, 40, "Print"],
Cell[193444, 6013, 205, 6, 40, "Print"],
Cell[193652, 6021, 73, 1, 23, "Print"],
Cell[193728, 6024, 812, 28, 40, "Print"],
Cell[194543, 6054, 266, 8, 40, "Print"],
Cell[194812, 6064, 203, 6, 40, "Print"],
Cell[195018, 6072, 72, 1, 23, "Print"],
Cell[195093, 6075, 870, 30, 40, "Print"],
Cell[195966, 6107, 270, 8, 40, "Print"],
Cell[196239, 6117, 209, 6, 40, "Print"],
Cell[196451, 6125, 75, 1, 23, "Print"],
Cell[196529, 6128, 796, 27, 40, "Print"],
Cell[197328, 6157, 273, 8, 40, "Print"],
Cell[197604, 6167, 213, 6, 40, "Print"],
Cell[197820, 6175, 75, 1, 23, "Print"],
Cell[197898, 6178, 799, 27, 40, "Print"],
Cell[198700, 6207, 272, 8, 40, "Print"],
Cell[198975, 6217, 205, 6, 40, "Print"],
Cell[199183, 6225, 72, 1, 23, "Print"],
Cell[199258, 6228, 870, 30, 40, "Print"],
Cell[200131, 6260, 270, 8, 40, "Print"],
Cell[200404, 6270, 211, 6, 40, "Print"],
Cell[200618, 6278, 72, 1, 23, "Print"],
Cell[200693, 6281, 795, 27, 40, "Print"],
Cell[201491, 6310, 273, 8, 40, "Print"],
Cell[201767, 6320, 211, 6, 40, "Print"],
Cell[201981, 6328, 73, 1, 23, "Print"],
Cell[202057, 6331, 797, 27, 40, "Print"],
Cell[202857, 6360, 270, 8, 40, "Print"],
Cell[203130, 6370, 205, 6, 40, "Print"],
Cell[203338, 6378, 72, 1, 23, "Print"],
Cell[203413, 6381, 862, 30, 40, "Print"],
Cell[204278, 6413, 271, 8, 40, "Print"],
Cell[204552, 6423, 210, 6, 40, "Print"],
Cell[204765, 6431, 75, 1, 23, "Print"],
Cell[204843, 6434, 762, 26, 40, "Print"],
Cell[205608, 6462, 270, 8, 40, "Print"],
Cell[205881, 6472, 207, 6, 40, "Print"],
Cell[206091, 6480, 74, 1, 23, "Print"],
Cell[206168, 6483, 859, 30, 40, "Print"],
Cell[207030, 6515, 266, 8, 40, "Print"],
Cell[207299, 6525, 197, 6, 40, "Print"],
Cell[207499, 6533, 73, 1, 23, "Print"],
Cell[207575, 6536, 785, 27, 40, "Print"],
Cell[208363, 6565, 263, 8, 40, "Print"],
Cell[208629, 6575, 193, 6, 40, "Print"],
Cell[208825, 6583, 73, 1, 23, "Print"],
Cell[208901, 6586, 762, 26, 40, "Print"],
Cell[209666, 6614, 266, 8, 40, "Print"],
Cell[209935, 6624, 196, 6, 40, "Print"],
Cell[210134, 6632, 74, 1, 23, "Print"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[210257, 6639, 159, 3, 25, "Input"],
Cell[210419, 6644, 2923, 94, 118, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[213391, 6744, 119, 1, 56, "Section"],
Cell[213513, 6747, 294, 6, 49, "Text"],
Cell[213810, 6755, 2002, 63, 118, "Input"],
Cell[CellGroupData[{
Cell[215837, 6822, 245, 4, 31, "Input"],
Cell[216085, 6828, 377, 10, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[216499, 6843, 136, 2, 31, "Input"],
Cell[216638, 6847, 342, 5, 132, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217017, 6857, 539, 15, 31, "Input"],
Cell[217559, 6874, 1844, 52, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[219440, 6931, 343, 9, 31, "Input"],
Cell[219786, 6942, 424, 10, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[220247, 6957, 462, 9, 31, "Input"],
Cell[CellGroupData[{
Cell[220734, 6970, 730, 15, 23, "Print"],
Cell[221467, 6987, 2577, 69, 62, "Print"],
Cell[224047, 7058, 1081, 26, 23, "Print"],
Cell[225131, 7086, 799, 14, 23, "Print"]
}, Open  ]],
Cell[225945, 7103, 5677, 95, 373, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[231659, 7203, 221, 5, 31, "Input"],
Cell[CellGroupData[{
Cell[231905, 7212, 351, 10, 23, "Print"],
Cell[232259, 7224, 2200, 64, 62, "Print"],
Cell[234462, 7290, 704, 21, 23, "Print"],
Cell[235169, 7313, 422, 9, 23, "Print"]
}, Open  ]],
Cell[235606, 7325, 4429, 128, 152, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[240084, 7459, 117, 1, 56, "Section"],
Cell[240204, 7462, 120, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[240349, 7468, 347, 9, 31, "Input"],
Cell[240699, 7479, 362, 5, 157, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[241098, 7489, 528, 11, 52, "Input"],
Cell[241629, 7502, 643, 13, 62, "Print"]
}, Open  ]],
Cell[242287, 7518, 2002, 63, 118, "Input"],
Cell[CellGroupData[{
Cell[244314, 7585, 440, 8, 31, "Input"],
Cell[CellGroupData[{
Cell[244779, 7597, 960, 13, 23, "Print"],
Cell[245742, 7612, 2473, 67, 40, "Print"],
Cell[248218, 7681, 1802, 37, 23, "Print"],
Cell[250023, 7720, 1120, 18, 23, "Print"],
Cell[251146, 7740, 1051, 14, 23, "Print"],
Cell[252200, 7756, 1004, 15, 23, "Print"],
Cell[253207, 7773, 1863, 46, 40, "Print"],
Cell[255073, 7821, 1378, 27, 59, "Print"],
Cell[256454, 7850, 1378, 27, 59, "Print"],
Cell[257835, 7879, 1378, 27, 59, "Print"],
Cell[259216, 7908, 2304, 59, 40, "Print"],
Cell[261523, 7969, 1058, 17, 40, "Print"],
Cell[262584, 7988, 2366, 59, 40, "Print"],
Cell[264953, 8049, 1114, 19, 40, "Print"],
Cell[266070, 8070, 2336, 59, 40, "Print"],
Cell[268409, 8131, 1088, 18, 40, "Print"],
Cell[269500, 8151, 1060, 17, 23, "Print"],
Cell[270563, 8170, 958, 13, 23, "Print"],
Cell[271524, 8185, 1063, 17, 23, "Print"],
Cell[272590, 8204, 2022, 51, 40, "Print"],
Cell[274615, 8257, 1036, 16, 23, "Print"],
Cell[275654, 8275, 1068, 17, 23, "Print"],
Cell[276725, 8294, 1092, 17, 23, "Print"],
Cell[277820, 8313, 2090, 51, 40, "Print"],
Cell[279913, 8366, 1076, 17, 23, "Print"],
Cell[280992, 8385, 1066, 17, 23, "Print"],
Cell[282061, 8404, 1061, 17, 23, "Print"],
Cell[283125, 8423, 2064, 51, 40, "Print"],
Cell[285192, 8476, 1062, 17, 23, "Print"],
Cell[286257, 8495, 1066, 17, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[287372, 8518, 102, 1, 31, "Input"],
Cell[287477, 8521, 6553, 192, 243, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[294067, 8718, 398, 9, 31, "Input"],
Cell[CellGroupData[{
Cell[294490, 8731, 399, 5, 23, "Print"],
Cell[294892, 8738, 1912, 59, 40, "Print"],
Cell[296807, 8799, 1241, 29, 23, "Print"],
Cell[298051, 8830, 556, 10, 23, "Print"],
Cell[298610, 8842, 487, 6, 23, "Print"],
Cell[299100, 8850, 1299, 38, 40, "Print"],
Cell[300402, 8890, 1185, 35, 40, "Print"],
Cell[301590, 8927, 2454, 67, 62, "Print"],
Cell[304047, 8996, 956, 24, 23, "Print"],
Cell[305006, 9022, 665, 12, 23, "Print"]
}, Open  ]],
Cell[305686, 9037, 3692, 70, 693, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[309415, 9112, 335, 8, 31, "Input"],
Cell[CellGroupData[{
Cell[309775, 9124, 417, 5, 23, "Print"],
Cell[310195, 9131, 1932, 59, 40, "Print"],
Cell[312130, 9192, 1261, 29, 23, "Print"],
Cell[313394, 9223, 576, 10, 23, "Print"],
Cell[313973, 9235, 505, 6, 23, "Print"],
Cell[314481, 9243, 1317, 38, 40, "Print"],
Cell[315801, 9283, 1203, 35, 40, "Print"],
Cell[317007, 9320, 2472, 67, 62, "Print"],
Cell[319482, 9389, 976, 24, 23, "Print"],
Cell[320461, 9415, 698, 12, 23, "Print"]
}, Open  ]],
Cell[321174, 9430, 388, 5, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[321599, 9440, 391, 6, 31, "Input"],
Cell[CellGroupData[{
Cell[322015, 9450, 1550, 30, 23, "Print"],
Cell[323568, 9482, 1060, 15, 23, "Print"],
Cell[324631, 9499, 2575, 69, 40, "Print"],
Cell[327209, 9570, 1904, 39, 23, "Print"],
Cell[329116, 9611, 1219, 20, 23, "Print"],
Cell[330338, 9633, 1150, 16, 23, "Print"],
Cell[331491, 9651, 1960, 48, 40, "Print"],
Cell[333454, 9701, 1846, 45, 40, "Print"],
Cell[335303, 9748, 3117, 77, 62, "Print"],
Cell[338423, 9827, 1617, 34, 23, "Print"],
Cell[340043, 9863, 1339, 22, 23, "Print"],
Cell[341385, 9887, 1332, 22, 23, "Print"]
}, Open  ]],
Cell[342732, 9912, 349, 5, 31, "Output"]
}, Open  ]],
Cell[343096, 9920, 137, 3, 31, "Input"],
Cell[CellGroupData[{
Cell[343258, 9927, 350, 9, 31, "Input"],
Cell[343611, 9938, 461, 7, 157, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[344109, 9950, 602, 12, 52, "Input"],
Cell[344714, 9964, 607, 12, 62, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[345358, 9981, 1338, 44, 82, "Input"],
Cell[346699, 10027, 1509, 47, 82, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[348245, 10079, 291, 6, 31, "Input"],
Cell[CellGroupData[{
Cell[348561, 10089, 238, 3, 23, "Print"],
Cell[348802, 10094, 1751, 57, 40, "Print"],
Cell[350556, 10153, 1080, 27, 23, "Print"],
Cell[351639, 10182, 397, 8, 23, "Print"],
Cell[352039, 10192, 288, 4, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[352376, 10202, 98, 1, 31, "Input"],
Cell[352477, 10205, 1405, 46, 82, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[353919, 10256, 188, 3, 31, "Input"],
Cell[CellGroupData[{
Cell[354132, 10263, 210, 3, 23, "Print"],
Cell[354345, 10268, 1723, 57, 40, "Print"],
Cell[356071, 10327, 1052, 27, 23, "Print"],
Cell[357126, 10356, 367, 8, 23, "Print"],
Cell[357496, 10366, 298, 4, 23, "Print"]
}, Open  ]],
Cell[357809, 10373, 674, 15, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[358520, 10393, 159, 3, 31, "Input"],
Cell[358682, 10398, 3466, 97, 112, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[362185, 10500, 99, 1, 31, "Input"],
Cell[362287, 10503, 23231, 648, 872, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[385555, 11156, 190, 3, 31, "Input"],
Cell[385748, 11161, 558, 7, 152, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[386343, 11173, 235, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[386603, 11181, 373, 9, 23, "Print"],
Cell[386979, 11192, 371, 9, 23, "Print"],
Cell[387353, 11203, 371, 9, 23, "Print"],
Cell[387727, 11214, 371, 9, 23, "Print"],
Cell[388101, 11225, 373, 9, 23, "Print"],
Cell[388477, 11236, 371, 9, 23, "Print"],
Cell[388851, 11247, 373, 9, 23, "Print"],
Cell[389227, 11258, 373, 9, 23, "Print"],
Cell[389603, 11269, 373, 9, 23, "Print"],
Cell[389979, 11280, 371, 9, 23, "Print"],
Cell[390353, 11291, 373, 9, 23, "Print"],
Cell[390729, 11302, 371, 9, 23, "Print"],
Cell[391103, 11313, 373, 9, 23, "Print"],
Cell[391479, 11324, 373, 9, 23, "Print"],
Cell[391855, 11335, 373, 9, 23, "Print"],
Cell[392231, 11346, 373, 9, 23, "Print"],
Cell[392607, 11357, 373, 9, 23, "Print"],
Cell[392983, 11368, 371, 9, 23, "Print"],
Cell[393357, 11379, 373, 9, 23, "Print"],
Cell[393733, 11390, 373, 9, 23, "Print"],
Cell[394109, 11401, 371, 9, 23, "Print"],
Cell[394483, 11412, 373, 9, 23, "Print"],
Cell[394859, 11423, 373, 9, 23, "Print"],
Cell[395235, 11434, 371, 9, 23, "Print"],
Cell[395609, 11445, 373, 9, 23, "Print"],
Cell[395985, 11456, 373, 9, 23, "Print"],
Cell[396361, 11467, 373, 9, 23, "Print"],
Cell[396737, 11478, 371, 9, 23, "Print"],
Cell[397111, 11489, 371, 9, 23, "Print"],
Cell[397485, 11500, 373, 9, 23, "Print"],
Cell[397861, 11511, 373, 9, 23, "Print"],
Cell[398237, 11522, 373, 9, 23, "Print"],
Cell[398613, 11533, 373, 9, 23, "Print"],
Cell[398989, 11544, 373, 9, 23, "Print"],
Cell[399365, 11555, 373, 9, 23, "Print"],
Cell[399741, 11566, 371, 9, 23, "Print"]
}, Open  ]],
Cell[400127, 11578, 203, 3, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[400367, 11586, 511, 14, 31, "Input"],
Cell[CellGroupData[{
Cell[400903, 11604, 446, 10, 23, "Print"],
Cell[401352, 11616, 446, 10, 23, "Print"]
}, Open  ]],
Cell[401813, 11629, 404, 9, 31, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[402266, 11644, 87, 1, 56, "Section"],
Cell[CellGroupData[{
Cell[402378, 11649, 537, 14, 31, "Input"],
Cell[402918, 11665, 716, 16, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[403671, 11686, 282, 6, 31, "Input"],
Cell[403956, 11694, 1241, 29, 392, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[405234, 11728, 493, 10, 31, "Input"],
Cell[CellGroupData[{
Cell[405752, 11742, 415, 5, 23, "Print"],
Cell[406170, 11749, 735, 13, 23, "Print"],
Cell[406908, 11764, 872, 19, 23, "Print"],
Cell[407783, 11785, 574, 10, 23, "Print"],
Cell[408360, 11797, 505, 6, 23, "Print"],
Cell[408868, 11805, 898, 20, 23, "Print"],
Cell[409769, 11827, 802, 17, 23, "Print"],
Cell[410574, 11846, 955, 23, 23, "Print"],
Cell[411532, 11871, 901, 22, 23, "Print"],
Cell[412436, 11895, 702, 12, 23, "Print"]
}, Open  ]],
Cell[413153, 11910, 2388, 49, 428, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[415578, 11964, 383, 9, 31, "Input"],
Cell[CellGroupData[{
Cell[415986, 11977, 321, 5, 23, "Print"],
Cell[416310, 11984, 641, 13, 23, "Print"],
Cell[416954, 11999, 778, 19, 23, "Print"],
Cell[417735, 12020, 478, 10, 23, "Print"],
Cell[418216, 12032, 409, 6, 23, "Print"],
Cell[418628, 12040, 800, 20, 23, "Print"],
Cell[419431, 12062, 704, 17, 23, "Print"],
Cell[420138, 12081, 857, 23, 23, "Print"],
Cell[420998, 12106, 805, 22, 23, "Print"],
Cell[421806, 12130, 606, 12, 23, "Print"]
}, Open  ]],
Cell[422427, 12145, 501, 7, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[422965, 12157, 292, 6, 31, "Input"],
Cell[CellGroupData[{
Cell[423282, 12167, 540, 7, 23, "Print"],
Cell[423825, 12176, 860, 15, 23, "Print"],
Cell[424688, 12193, 997, 21, 23, "Print"],
Cell[425688, 12216, 699, 12, 23, "Print"],
Cell[426390, 12230, 630, 8, 23, "Print"],
Cell[427023, 12240, 583, 9, 23, "Print"],
Cell[427609, 12251, 1023, 22, 23, "Print"],
Cell[428635, 12275, 827, 15, 43, "Print"],
Cell[429465, 12292, 827, 15, 43, "Print"],
Cell[430295, 12309, 827, 15, 43, "Print"],
Cell[431125, 12326, 945, 22, 40, "Print"],
Cell[432073, 12350, 540, 8, 23, "Print"],
Cell[432616, 12360, 945, 22, 40, "Print"],
Cell[433564, 12384, 540, 8, 23, "Print"],
Cell[434107, 12394, 945, 22, 40, "Print"],
Cell[435055, 12418, 540, 8, 23, "Print"],
Cell[435598, 12428, 639, 11, 23, "Print"],
Cell[436240, 12441, 537, 7, 23, "Print"],
Cell[436780, 12450, 642, 11, 23, "Print"],
Cell[437425, 12463, 876, 20, 40, "Print"],
Cell[438304, 12485, 542, 8, 23, "Print"],
Cell[438849, 12495, 647, 11, 23, "Print"],
Cell[439499, 12508, 642, 11, 23, "Print"],
Cell[440144, 12521, 876, 20, 40, "Print"],
Cell[441023, 12543, 542, 8, 23, "Print"],
Cell[441568, 12553, 647, 11, 23, "Print"],
Cell[442218, 12566, 640, 11, 23, "Print"],
Cell[442861, 12579, 874, 20, 40, "Print"],
Cell[443738, 12601, 540, 8, 23, "Print"],
Cell[444281, 12611, 645, 11, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[444975, 12628, 103, 1, 31, "Input"],
Cell[445081, 12631, 2464, 72, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[447582, 12708, 319, 5, 31, "Input"],
Cell[CellGroupData[{
Cell[447926, 12717, 1083, 23, 23, "Print"],
Cell[449012, 12742, 589, 8, 23, "Print"],
Cell[449604, 12752, 909, 16, 23, "Print"],
Cell[450516, 12770, 1046, 22, 23, "Print"],
Cell[451565, 12794, 746, 13, 23, "Print"],
Cell[452314, 12809, 674, 9, 23, "Print"],
Cell[452991, 12820, 1070, 23, 23, "Print"],
Cell[454064, 12845, 974, 20, 23, "Print"],
Cell[455041, 12867, 1124, 26, 23, "Print"],
Cell[456168, 12895, 1071, 25, 23, "Print"],
Cell[457242, 12922, 872, 15, 23, "Print"]
}, Open  ]],
Cell[458129, 12940, 339, 5, 31, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[458517, 12951, 117, 2, 56, "Section"],
Cell[CellGroupData[{
Cell[458659, 12957, 528, 14, 31, "Input"],
Cell[459190, 12973, 572, 14, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[459799, 12992, 348, 8, 31, "Input"],
Cell[CellGroupData[{
Cell[460172, 13004, 317, 4, 23, "Print"],
Cell[460492, 13010, 633, 12, 23, "Print"],
Cell[461128, 13024, 770, 18, 23, "Print"],
Cell[461901, 13044, 476, 9, 23, "Print"],
Cell[462380, 13055, 404, 5, 23, "Print"],
Cell[462787, 13062, 794, 19, 23, "Print"],
Cell[463584, 13083, 698, 16, 23, "Print"],
Cell[464285, 13101, 854, 22, 23, "Print"],
Cell[465142, 13125, 801, 21, 23, "Print"],
Cell[465946, 13148, 596, 11, 23, "Print"]
}, Open  ]],
Cell[466557, 13162, 2260, 47, 417, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[468854, 13214, 244, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[469123, 13222, 417, 5, 23, "Print"],
Cell[469543, 13229, 731, 13, 23, "Print"],
Cell[470277, 13244, 868, 19, 23, "Print"],
Cell[471148, 13265, 574, 10, 23, "Print"],
Cell[471725, 13277, 505, 6, 23, "Print"],
Cell[472233, 13285, 458, 7, 23, "Print"],
Cell[472694, 13294, 892, 20, 23, "Print"],
Cell[473589, 13316, 698, 13, 43, "Print"],
Cell[474290, 13331, 698, 13, 43, "Print"],
Cell[474991, 13346, 700, 13, 43, "Print"],
Cell[475694, 13361, 673, 14, 23, "Print"],
Cell[476370, 13377, 414, 6, 23, "Print"],
Cell[476787, 13385, 673, 14, 23, "Print"],
Cell[477463, 13401, 414, 6, 23, "Print"],
Cell[477880, 13409, 673, 14, 23, "Print"],
Cell[478556, 13425, 414, 6, 23, "Print"],
Cell[478973, 13433, 514, 9, 23, "Print"],
Cell[479490, 13444, 410, 5, 23, "Print"],
Cell[479903, 13451, 513, 9, 23, "Print"],
Cell[480419, 13462, 611, 12, 23, "Print"],
Cell[481033, 13476, 414, 6, 23, "Print"],
Cell[481450, 13484, 520, 9, 23, "Print"],
Cell[481973, 13495, 513, 9, 23, "Print"],
Cell[482489, 13506, 611, 12, 23, "Print"],
Cell[483103, 13520, 414, 6, 23, "Print"],
Cell[483520, 13528, 520, 9, 23, "Print"],
Cell[484043, 13539, 513, 9, 23, "Print"],
Cell[484559, 13550, 613, 12, 23, "Print"],
Cell[485175, 13564, 416, 6, 23, "Print"],
Cell[485594, 13572, 522, 9, 23, "Print"]
}, Open  ]],
Cell[486131, 13584, 1979, 62, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[488147, 13651, 313, 5, 31, "Input"],
Cell[CellGroupData[{
Cell[488485, 13660, 731, 18, 23, "Print"],
Cell[489219, 13680, 243, 3, 23, "Print"],
Cell[489465, 13685, 557, 11, 23, "Print"],
Cell[490025, 13698, 694, 17, 23, "Print"],
Cell[490722, 13717, 400, 8, 23, "Print"],
Cell[491125, 13727, 329, 4, 23, "Print"],
Cell[491457, 13733, 716, 18, 23, "Print"],
Cell[492176, 13753, 620, 15, 23, "Print"],
Cell[492799, 13770, 776, 21, 23, "Print"],
Cell[493578, 13793, 727, 20, 23, "Print"],
Cell[494308, 13815, 514, 10, 23, "Print"]
}, Open  ]],
Cell[494837, 13828, 371, 6, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[495245, 13839, 194, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[495464, 13847, 369, 5, 23, "Print"],
Cell[495836, 13854, 685, 13, 23, "Print"],
Cell[496524, 13869, 822, 19, 23, "Print"],
Cell[497349, 13890, 528, 10, 23, "Print"],
Cell[497880, 13902, 419, 6, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[498348, 13914, 132, 2, 31, "Input"],
Cell[498483, 13918, 306, 4, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[498826, 13927, 100, 1, 31, "Input"],
Cell[498929, 13930, 1787, 48, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[500753, 13983, 347, 6, 31, "Input"],
Cell[501103, 13991, 1765, 47, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[502905, 14043, 129, 2, 31, "Input"],
Cell[503037, 14047, 319, 4, 31, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[503405, 14057, 19, 0, 56, "Section"],
Cell[CellGroupData[{
Cell[503449, 14061, 609, 17, 46, "Input"],
Cell[504061, 14080, 1103, 31, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[505201, 14116, 399, 9, 31, "Input"],
Cell[CellGroupData[{
Cell[505625, 14129, 323, 4, 23, "Print"],
Cell[505951, 14135, 1281, 38, 40, "Print"],
Cell[507235, 14175, 895, 22, 23, "Print"],
Cell[508133, 14199, 478, 9, 23, "Print"],
Cell[508614, 14210, 411, 5, 23, "Print"],
Cell[509028, 14217, 1239, 37, 40, "Print"],
Cell[510270, 14256, 1125, 34, 40, "Print"],
Cell[511398, 14292, 1455, 39, 43, "Print"],
Cell[512856, 14333, 1013, 27, 23, "Print"],
Cell[513872, 14362, 598, 11, 23, "Print"]
}, Open  ]],
Cell[514485, 14376, 4292, 83, 389, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[518814, 14464, 324, 5, 31, "Input"],
Cell[CellGroupData[{
Cell[519163, 14473, 379, 5, 23, "Print"],
Cell[519545, 14480, 1337, 39, 40, "Print"],
Cell[520885, 14521, 951, 23, 23, "Print"],
Cell[521839, 14546, 536, 10, 23, "Print"],
Cell[522378, 14558, 469, 6, 23, "Print"],
Cell[522850, 14566, 468, 9, 23, "Print"],
Cell[523321, 14577, 1297, 38, 40, "Print"],
Cell[524621, 14617, 802, 19, 59, "Print"],
Cell[525426, 14638, 802, 19, 59, "Print"],
Cell[526231, 14659, 802, 19, 59, "Print"],
Cell[527036, 14680, 1124, 31, 40, "Print"],
Cell[528163, 14713, 454, 9, 40, "Print"],
Cell[528620, 14724, 1116, 31, 40, "Print"],
Cell[529739, 14757, 451, 9, 40, "Print"],
Cell[530193, 14768, 1112, 31, 40, "Print"],
Cell[531308, 14801, 450, 9, 40, "Print"],
Cell[531761, 14812, 476, 9, 23, "Print"],
Cell[532240, 14823, 374, 5, 23, "Print"],
Cell[532617, 14830, 505, 9, 23, "Print"],
Cell[533125, 14841, 982, 27, 40, "Print"],
Cell[534110, 14870, 434, 7, 23, "Print"],
Cell[534547, 14879, 486, 9, 23, "Print"],
Cell[535036, 14890, 510, 9, 23, "Print"],
Cell[535549, 14901, 976, 27, 40, "Print"],
Cell[536528, 14930, 434, 7, 23, "Print"],
Cell[536965, 14939, 484, 9, 23, "Print"],
Cell[537452, 14950, 505, 9, 23, "Print"],
Cell[537960, 14961, 970, 27, 40, "Print"],
Cell[538933, 14990, 434, 7, 23, "Print"],
Cell[539370, 14999, 486, 9, 23, "Print"]
}, Open  ]],
Cell[539871, 15011, 3954, 121, 167, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[543862, 15137, 368, 6, 31, "Input"],
Cell[CellGroupData[{
Cell[544255, 15147, 922, 21, 23, "Print"],
Cell[545180, 15170, 416, 6, 23, "Print"],
Cell[545599, 15178, 1374, 40, 40, "Print"],
Cell[546976, 15220, 988, 24, 23, "Print"],
Cell[547967, 15246, 575, 11, 23, "Print"],
Cell[548545, 15259, 506, 7, 23, "Print"],
Cell[549054, 15268, 1332, 39, 40, "Print"],
Cell[550389, 15309, 1218, 36, 40, "Print"],
Cell[551610, 15347, 1548, 41, 43, "Print"],
Cell[553161, 15390, 1107, 29, 23, "Print"],
Cell[554271, 15421, 683, 13, 23, "Print"]
}, Open  ]],
Cell[554969, 15437, 396, 6, 31, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[555414, 15449, 87, 1, 56, "Section"],
Cell[555504, 15452, 120, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[555649, 15458, 296, 8, 31, "Input"],
Cell[555948, 15468, 362, 5, 157, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[556347, 15478, 528, 11, 52, "Input"],
Cell[556878, 15491, 601, 13, 62, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[557516, 15509, 576, 16, 31, "Input"],
Cell[558095, 15527, 1357, 27, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[559489, 15559, 248, 6, 31, "Input"],
Cell[559740, 15567, 1187, 26, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[560964, 15598, 231, 5, 31, "Input"],
Cell[561198, 15605, 3907, 85, 233, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[565142, 15695, 166, 3, 31, "Input"],
Cell[565311, 15700, 1013, 23, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[566361, 15728, 97, 1, 31, "Input"],
Cell[566461, 15731, 659, 17, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[567157, 15753, 372, 10, 31, "Input"],
Cell[567532, 15765, 790, 18, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[568359, 15788, 370, 10, 31, "Input"],
Cell[568732, 15800, 589, 15, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[569358, 15820, 742, 13, 31, "Input"],
Cell[CellGroupData[{
Cell[570125, 15837, 170, 2, 23, "Print"],
Cell[570298, 15841, 579, 13, 23, "Print"],
Cell[570880, 15856, 796, 21, 23, "Print"],
Cell[571679, 15879, 325, 7, 23, "Print"],
Cell[572007, 15888, 258, 3, 23, "Print"],
Cell[572268, 15893, 975, 28, 23, "Print"],
Cell[573246, 15923, 547, 14, 23, "Print"],
Cell[573796, 15939, 692, 18, 23, "Print"],
Cell[574491, 15959, 494, 12, 23, "Print"],
Cell[574988, 15973, 453, 9, 23, "Print"]
}, Open  ]],
Cell[575456, 15985, 3738, 72, 433, "Output"]
}, Open  ]],
Cell[579209, 16060, 187, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[579421, 16068, 295, 4, 31, "Input"],
Cell[579719, 16074, 184, 2, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[579940, 16081, 307, 8, 31, "Input"],
Cell[CellGroupData[{
Cell[580272, 16093, 217, 3, 23, "Print"],
Cell[580492, 16098, 626, 14, 23, "Print"],
Cell[581121, 16114, 843, 22, 23, "Print"],
Cell[581967, 16138, 374, 8, 23, "Print"],
Cell[582344, 16148, 303, 4, 23, "Print"],
Cell[582650, 16154, 1022, 29, 23, "Print"],
Cell[583675, 16185, 594, 15, 23, "Print"],
Cell[584272, 16202, 737, 19, 23, "Print"],
Cell[585012, 16223, 542, 13, 23, "Print"],
Cell[585557, 16238, 496, 10, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[586102, 16254, 1083, 32, 72, "Input"],
Cell[587188, 16288, 213, 4, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[587438, 16297, 1584, 41, 72, "Input"],
Cell[589025, 16340, 73294, 1206, 378, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[662356, 17551, 299, 5, 31, "Input"],
Cell[CellGroupData[{
Cell[662680, 17560, 723, 10, 23, "Print"],
Cell[663406, 17572, 1132, 21, 23, "Print"],
Cell[664541, 17595, 1349, 29, 23, "Print"],
Cell[665893, 17626, 880, 15, 23, "Print"],
Cell[666776, 17643, 811, 11, 23, "Print"],
Cell[667590, 17656, 764, 12, 23, "Print"],
Cell[668357, 17670, 1530, 36, 23, "Print"],
Cell[669890, 17708, 1107, 21, 43, "Print"],
Cell[671000, 17731, 1107, 21, 43, "Print"],
Cell[672110, 17754, 1107, 21, 43, "Print"],
Cell[673220, 17777, 822, 14, 23, "Print"],
Cell[674045, 17793, 714, 11, 23, "Print"],
Cell[674762, 17806, 824, 14, 23, "Print"],
Cell[675589, 17822, 714, 11, 23, "Print"],
Cell[676306, 17835, 824, 14, 23, "Print"],
Cell[677133, 17851, 714, 11, 23, "Print"],
Cell[677850, 17864, 820, 14, 23, "Print"],
Cell[678673, 17880, 718, 10, 23, "Print"]
}, Open  ]],
Cell[679406, 17893, 1832, 52, 72, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[681275, 17950, 273, 5, 31, "Input"],
Cell[CellGroupData[{
Cell[681573, 17959, 976, 22, 23, "Print"],
Cell[682552, 17983, 488, 7, 23, "Print"],
Cell[683043, 17992, 897, 18, 23, "Print"],
Cell[683943, 18012, 1114, 26, 23, "Print"],
Cell[685060, 18040, 647, 12, 23, "Print"],
Cell[685710, 18054, 576, 8, 23, "Print"],
Cell[686289, 18064, 1295, 33, 23, "Print"],
Cell[687587, 18099, 867, 19, 23, "Print"],
Cell[688457, 18120, 1012, 23, 23, "Print"],
Cell[689472, 18145, 816, 17, 23, "Print"],
Cell[690291, 18164, 775, 14, 23, "Print"],
Cell[691069, 18180, 763, 14, 23, "Print"]
}, Open  ]],
Cell[691847, 18197, 468, 7, 31, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[692364, 18210, 19, 0, 56, "Section"],
Cell[CellGroupData[{
Cell[692408, 18214, 1496, 48, 52, "Input"],
Cell[693907, 18264, 1136, 35, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[695080, 18304, 270, 5, 31, "Input"],
Cell[CellGroupData[{
Cell[695375, 18313, 219, 3, 23, "Print"],
Cell[695597, 18318, 1392, 45, 40, "Print"],
Cell[696992, 18365, 903, 23, 23, "Print"],
Cell[697898, 18390, 374, 8, 23, "Print"],
Cell[698275, 18400, 305, 4, 23, "Print"]
}, Open  ]],
Cell[698595, 18407, 548, 13, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[699180, 18425, 192, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[699397, 18433, 348, 5, 23, "Print"],
Cell[699748, 18440, 1523, 47, 40, "Print"],
Cell[701274, 18489, 1032, 25, 23, "Print"],
Cell[702309, 18516, 503, 10, 23, "Print"],
Cell[702815, 18528, 394, 6, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[703236, 18538, 278, 8, 44, "Input"],
Cell[703517, 18548, 322, 9, 31, "Input"],
Cell[CellGroupData[{
Cell[703864, 18561, 184, 4, 31, "Input"],
Cell[704051, 18567, 1516, 23, 92, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[705604, 18595, 240, 5, 31, "Input"],
Cell[705847, 18602, 13360, 213, 298, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[719244, 18820, 241, 5, 31, "Input"],
Cell[719488, 18827, 5282, 147, 192, "Output"]
}, Open  ]],
Cell[724785, 18977, 271, 8, 31, "Input"],
Cell[CellGroupData[{
Cell[725081, 18989, 241, 5, 31, "Input"],
Cell[725325, 18996, 8782, 146, 298, "Output"]
}, Open  ]],
Cell[734122, 19145, 441, 12, 31, "Input"],
Cell[CellGroupData[{
Cell[734588, 19161, 1634, 44, 145, "Input"],
Cell[CellGroupData[{
Cell[736247, 19209, 536, 11, 40, "Print"],
Cell[736786, 19222, 536, 11, 40, "Print"],
Cell[737325, 19235, 536, 11, 40, "Print"],
Cell[737864, 19248, 536, 11, 40, "Print"],
Cell[738403, 19261, 536, 11, 40, "Print"],
Cell[738942, 19274, 536, 11, 40, "Print"],
Cell[739481, 19287, 470, 8, 23, "Print"],
Cell[739954, 19297, 536, 11, 40, "Print"],
Cell[740493, 19310, 536, 11, 40, "Print"],
Cell[741032, 19323, 536, 11, 40, "Print"],
Cell[741571, 19336, 537, 11, 40, "Print"],
Cell[742111, 19349, 537, 11, 40, "Print"],
Cell[742651, 19362, 537, 11, 40, "Print"],
Cell[743191, 19375, 537, 11, 40, "Print"],
Cell[743731, 19388, 470, 8, 23, "Print"],
Cell[744204, 19398, 470, 8, 23, "Print"],
Cell[744677, 19408, 470, 8, 23, "Print"],
Cell[745150, 19418, 470, 8, 23, "Print"],
Cell[745623, 19428, 470, 8, 23, "Print"],
Cell[746096, 19438, 470, 8, 23, "Print"],
Cell[746569, 19448, 470, 8, 23, "Print"],
Cell[747042, 19458, 470, 8, 23, "Print"],
Cell[747515, 19468, 470, 8, 23, "Print"],
Cell[747988, 19478, 470, 8, 23, "Print"],
Cell[748461, 19488, 470, 8, 23, "Print"],
Cell[748934, 19498, 537, 11, 40, "Print"],
Cell[749474, 19511, 536, 11, 40, "Print"],
Cell[750013, 19524, 536, 11, 40, "Print"],
Cell[750552, 19537, 536, 11, 40, "Print"],
Cell[751091, 19550, 537, 11, 40, "Print"],
Cell[751631, 19563, 537, 11, 40, "Print"],
Cell[752171, 19576, 537, 11, 40, "Print"],
Cell[752711, 19589, 532, 11, 40, "Print"],
Cell[753246, 19602, 532, 11, 40, "Print"],
Cell[753781, 19615, 533, 11, 40, "Print"],
Cell[754317, 19628, 533, 11, 40, "Print"],
Cell[754853, 19641, 533, 11, 40, "Print"],
Cell[755389, 19654, 466, 8, 23, "Print"],
Cell[755858, 19664, 537, 11, 40, "Print"],
Cell[756398, 19677, 470, 8, 23, "Print"],
Cell[756871, 19687, 470, 8, 23, "Print"],
Cell[757344, 19697, 470, 8, 23, "Print"],
Cell[757817, 19707, 537, 11, 40, "Print"],
Cell[758357, 19720, 470, 8, 23, "Print"],
Cell[758830, 19730, 470, 8, 23, "Print"],
Cell[759303, 19740, 470, 8, 23, "Print"],
Cell[759776, 19750, 470, 8, 23, "Print"],
Cell[760249, 19760, 537, 11, 40, "Print"],
Cell[760789, 19773, 537, 11, 40, "Print"],
Cell[761329, 19786, 536, 11, 40, "Print"],
Cell[761868, 19799, 536, 11, 40, "Print"],
Cell[762407, 19812, 537, 11, 40, "Print"],
Cell[762947, 19825, 537, 11, 40, "Print"],
Cell[763487, 19838, 470, 8, 23, "Print"],
Cell[763960, 19848, 470, 8, 23, "Print"],
Cell[764433, 19858, 470, 8, 23, "Print"],
Cell[764906, 19868, 470, 8, 23, "Print"],
Cell[765379, 19878, 470, 8, 23, "Print"],
Cell[765852, 19888, 537, 11, 40, "Print"],
Cell[766392, 19901, 537, 11, 40, "Print"],
Cell[766932, 19914, 539, 11, 40, "Print"],
Cell[767474, 19927, 539, 11, 40, "Print"],
Cell[768016, 19940, 539, 11, 40, "Print"],
Cell[768558, 19953, 537, 11, 40, "Print"],
Cell[769098, 19966, 470, 8, 23, "Print"],
Cell[769571, 19976, 537, 11, 40, "Print"],
Cell[770111, 19989, 537, 11, 40, "Print"],
Cell[770651, 20002, 537, 11, 40, "Print"],
Cell[771191, 20015, 537, 11, 40, "Print"],
Cell[771731, 20028, 471, 8, 23, "Print"],
Cell[772205, 20038, 537, 11, 40, "Print"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[772803, 20056, 19, 0, 56, "Section"],
Cell[772825, 20058, 171, 3, 31, "Input"],
Cell[CellGroupData[{
Cell[773021, 20065, 350, 9, 31, "Input"],
Cell[773374, 20076, 362, 5, 157, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[773773, 20086, 528, 11, 52, "Input"],
Cell[774304, 20099, 519, 11, 62, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[774860, 20115, 1718, 53, 72, "Input"],
Cell[CellGroupData[{
Cell[776603, 20172, 168, 2, 23, "Print"],
Cell[776774, 20176, 1342, 44, 40, "Print"],
Cell[778119, 20222, 853, 22, 23, "Print"],
Cell[778975, 20246, 324, 7, 23, "Print"],
Cell[779302, 20255, 256, 3, 23, "Print"],
Cell[779561, 20260, 214, 4, 23, "Print"],
Cell[779778, 20266, 1078, 35, 40, "Print"],
Cell[780859, 20303, 589, 16, 59, "Print"],
Cell[781451, 20321, 587, 16, 59, "Print"],
Cell[782041, 20339, 585, 16, 59, "Print"],
Cell[782629, 20357, 583, 17, 40, "Print"],
Cell[783215, 20376, 190, 4, 40, "Print"],
Cell[783408, 20382, 865, 26, 40, "Print"],
Cell[784276, 20410, 240, 6, 40, "Print"],
Cell[784519, 20418, 1169, 36, 40, "Print"],
Cell[785691, 20456, 277, 7, 40, "Print"],
Cell[785971, 20465, 265, 6, 23, "Print"],
Cell[786239, 20473, 163, 2, 23, "Print"],
Cell[786405, 20477, 276, 6, 23, "Print"],
Cell[786684, 20485, 514, 15, 40, "Print"],
Cell[787201, 20502, 171, 3, 23, "Print"],
Cell[787375, 20507, 273, 6, 23, "Print"],
Cell[787651, 20515, 274, 6, 23, "Print"],
Cell[787928, 20523, 726, 22, 40, "Print"],
Cell[788657, 20547, 200, 4, 23, "Print"],
Cell[788860, 20553, 677, 18, 40, "Print"],
Cell[789540, 20573, 273, 6, 23, "Print"],
Cell[789816, 20581, 270, 6, 23, "Print"],
Cell[790089, 20589, 959, 30, 40, "Print"],
Cell[791051, 20621, 217, 4, 23, "Print"],
Cell[791271, 20627, 273, 6, 23, "Print"]
}, Open  ]],
Cell[791559, 20636, 3501, 109, 167, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[795097, 20750, 139, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[795261, 20756, 117, 1, 23, "Print"],
Cell[795381, 20759, 1292, 43, 40, "Print"],
Cell[796676, 20804, 803, 21, 23, "Print"],
Cell[797482, 20827, 274, 6, 23, "Print"],
Cell[797759, 20835, 207, 2, 23, "Print"]
}, Open  ]],
Cell[797981, 20840, 801, 16, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[798819, 20861, 342, 8, 31, "Input"],
Cell[CellGroupData[{
Cell[799186, 20873, 117, 1, 23, "Print"],
Cell[799306, 20876, 1292, 43, 40, "Print"],
Cell[800601, 20921, 803, 21, 23, "Print"],
Cell[801407, 20944, 274, 6, 23, "Print"],
Cell[801684, 20952, 205, 2, 23, "Print"],
Cell[801892, 20956, 1027, 34, 40, "Print"],
Cell[802922, 20992, 913, 31, 40, "Print"],
Cell[803838, 21025, 1016, 29, 43, "Print"],
Cell[804857, 21056, 676, 20, 23, "Print"],
Cell[805536, 21078, 394, 8, 23, "Print"]
}, Open  ]],
Cell[805945, 21089, 4148, 80, 421, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[810130, 21174, 165, 3, 31, "Input"],
Cell[CellGroupData[{
Cell[810320, 21181, 685, 17, 23, "Print"],
Cell[811008, 21200, 187, 2, 23, "Print"],
Cell[811198, 21204, 1362, 44, 40, "Print"],
Cell[812563, 21250, 873, 22, 23, "Print"],
Cell[813439, 21274, 344, 7, 23, "Print"],
Cell[813786, 21283, 275, 3, 23, "Print"],
Cell[814064, 21288, 1097, 35, 40, "Print"],
Cell[815164, 21325, 983, 32, 40, "Print"],
Cell[816150, 21359, 1086, 30, 43, "Print"],
Cell[817239, 21391, 744, 21, 23, "Print"],
Cell[817986, 21414, 468, 9, 23, "Print"],
Cell[818457, 21425, 460, 9, 23, "Print"]
}, Open  ]],
Cell[818932, 21437, 198, 3, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[819167, 21445, 91, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[819283, 21451, 265, 3, 23, "Print"],
Cell[819551, 21456, 1440, 45, 40, "Print"],
Cell[820994, 21503, 951, 23, 23, "Print"],
Cell[821948, 21528, 422, 8, 23, "Print"],
Cell[822373, 21538, 313, 4, 23, "Print"],
Cell[822689, 21544, 267, 3, 23, "Print"],
Cell[822959, 21549, 1440, 45, 40, "Print"],
Cell[824402, 21596, 951, 23, 23, "Print"],
Cell[825356, 21621, 422, 8, 23, "Print"],
Cell[825781, 21631, 353, 4, 23, "Print"],
Cell[826137, 21637, 1175, 36, 40, "Print"],
Cell[827315, 21675, 1061, 33, 40, "Print"],
Cell[828379, 21710, 1164, 31, 43, "Print"],
Cell[829546, 21743, 822, 22, 23, "Print"],
Cell[830371, 21767, 542, 10, 23, "Print"]
}, Open  ]],
Cell[830928, 21780, 237, 3, 31, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[831214, 21789, 19, 0, 56, "Section"],
Cell[831236, 21791, 120, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[831381, 21797, 296, 8, 31, "Input"],
Cell[831680, 21807, 555, 8, 157, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[832272, 21820, 500, 10, 52, "Input"],
Cell[832775, 21832, 660, 13, 62, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[833472, 21850, 718, 20, 52, "Input"],
Cell[834193, 21872, 1129, 22, 31, "Output"],
Cell[CellGroupData[{
Cell[835347, 21898, 391, 5, 23, "Print"],
Cell[835741, 21905, 707, 13, 23, "Print"],
Cell[836451, 21920, 844, 19, 23, "Print"],
Cell[837298, 21941, 548, 10, 23, "Print"],
Cell[837849, 21953, 479, 6, 23, "Print"],
Cell[838331, 21961, 975, 24, 23, "Print"],
Cell[839309, 21987, 767, 17, 23, "Print"],
Cell[840079, 22006, 751, 16, 23, "Print"],
Cell[840833, 22024, 776, 17, 23, "Print"],
Cell[841612, 22043, 666, 12, 23, "Print"]
}, Open  ]],
Cell[842293, 22058, 3099, 57, 196, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[845429, 22120, 166, 3, 31, "Input"],
Cell[CellGroupData[{
Cell[845620, 22127, 953, 13, 23, "Print"],
Cell[846576, 22142, 1267, 21, 23, "Print"],
Cell[847846, 22165, 1404, 27, 23, "Print"],
Cell[849253, 22194, 1108, 18, 23, "Print"],
Cell[850364, 22214, 1041, 14, 23, "Print"],
Cell[851408, 22230, 988, 15, 23, "Print"],
Cell[852399, 22247, 1537, 32, 23, "Print"],
Cell[853939, 22281, 1339, 24, 43, "Print"],
Cell[855281, 22307, 1236, 21, 43, "Print"],
Cell[856520, 22330, 1236, 21, 43, "Print"],
Cell[857759, 22353, 1054, 17, 23, "Print"],
Cell[858816, 22372, 944, 14, 23, "Print"],
Cell[859763, 22388, 1054, 17, 23, "Print"],
Cell[860820, 22407, 944, 14, 23, "Print"],
Cell[861767, 22423, 1054, 17, 23, "Print"],
Cell[862824, 22442, 944, 14, 23, "Print"],
Cell[863771, 22458, 1050, 17, 23, "Print"],
Cell[864824, 22477, 946, 13, 23, "Print"]
}, Open  ]],
Cell[865785, 22493, 2157, 51, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[867979, 22549, 98, 1, 31, "Input"],
Cell[868080, 22552, 444, 12, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[868561, 22569, 216, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[868802, 22577, 653, 17, 23, "Print"],
Cell[869458, 22596, 165, 2, 23, "Print"],
Cell[869626, 22600, 481, 10, 23, "Print"],
Cell[870110, 22612, 618, 16, 23, "Print"],
Cell[870731, 22630, 322, 7, 23, "Print"],
Cell[871056, 22639, 253, 3, 23, "Print"],
Cell[871312, 22644, 752, 21, 23, "Print"],
Cell[872067, 22667, 546, 14, 23, "Print"],
Cell[872616, 22683, 530, 13, 23, "Print"],
Cell[873149, 22698, 549, 14, 23, "Print"],
Cell[873701, 22714, 430, 9, 23, "Print"]
}, Open  ]],
Cell[874146, 22726, 171, 2, 64, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[874366, 22734, 103, 1, 56, "Section"],
Cell[874472, 22737, 120, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[874617, 22743, 452, 10, 52, "Input"],
Cell[875072, 22755, 960, 18, 62, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[876069, 22778, 1149, 31, 75, "Input"],
Cell[877221, 22811, 1214, 32, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[878472, 22848, 141, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[878638, 22854, 119, 1, 23, "Print"],
Cell[878760, 22857, 907, 24, 40, "Print"],
Cell[879670, 22883, 1045, 27, 23, "Print"],
Cell[880718, 22912, 276, 6, 23, "Print"],
Cell[880997, 22920, 210, 2, 23, "Print"],
Cell[881210, 22924, 133, 1, 23, "Print"]
}, Open  ]],
Cell[881358, 22928, 111, 2, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[881506, 22935, 140, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[881671, 22941, 612, 9, 23, "Print"],
Cell[882286, 22952, 1398, 32, 40, "Print"],
Cell[883687, 22986, 1540, 35, 23, "Print"],
Cell[885230, 23023, 769, 14, 23, "Print"],
Cell[886002, 23039, 705, 10, 23, "Print"]
}, Open  ]],
Cell[886722, 23052, 1224, 24, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[887983, 23081, 699, 13, 31, "Input"],
Cell[CellGroupData[{
Cell[888707, 23098, 416, 6, 23, "Print"],
Cell[889126, 23106, 1206, 29, 40, "Print"],
Cell[890335, 23137, 1346, 32, 23, "Print"],
Cell[891684, 23171, 573, 11, 23, "Print"],
Cell[892260, 23184, 509, 7, 23, "Print"],
Cell[892772, 23193, 1415, 39, 40, "Print"],
Cell[894190, 23234, 1247, 34, 40, "Print"],
Cell[895440, 23270, 420, 6, 23, "Print"],
Cell[895863, 23278, 2812, 76, 81, "Print"],
Cell[898678, 23356, 1759, 47, 43, "Print"],
Cell[900440, 23405, 703, 13, 23, "Print"]
}, Open  ]],
Cell[901158, 23421, 8431, 146, 594, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[909626, 23572, 469, 14, 39, "Input"],
Cell[910098, 23588, 456, 14, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[910591, 23607, 273, 8, 59, "Input"],
Cell[910867, 23617, 261, 6, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[911165, 23628, 594, 16, 46, "Input"],
Cell[911762, 23646, 655, 17, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[912454, 23668, 140, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[912619, 23674, 247, 3, 23, "Print"],
Cell[912869, 23679, 715, 17, 40, "Print"],
Cell[913587, 23698, 729, 18, 23, "Print"],
Cell[914319, 23718, 404, 8, 23, "Print"],
Cell[914726, 23728, 340, 4, 23, "Print"]
}, Open  ]],
Cell[915081, 23735, 454, 11, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[915572, 23751, 345, 8, 31, "Input"],
Cell[CellGroupData[{
Cell[915942, 23763, 322, 5, 23, "Print"],
Cell[916267, 23770, 790, 19, 40, "Print"],
Cell[917060, 23791, 804, 20, 23, "Print"],
Cell[917867, 23813, 477, 10, 23, "Print"],
Cell[918347, 23825, 413, 6, 23, "Print"],
Cell[918763, 23833, 803, 20, 23, "Print"],
Cell[919569, 23855, 705, 17, 23, "Print"],
Cell[920277, 23874, 1031, 28, 23, "Print"],
Cell[921311, 23904, 568, 13, 23, "Print"],
Cell[921882, 23919, 607, 12, 23, "Print"]
}, Open  ]],
Cell[922504, 23934, 8578, 151, 592, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[931119, 24090, 432, 12, 31, "Input"],
Cell[931554, 24104, 397, 11, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[931988, 24120, 348, 8, 31, "Input"],
Cell[CellGroupData[{
Cell[932361, 24132, 171, 2, 23, "Print"],
Cell[932535, 24136, 485, 10, 23, "Print"],
Cell[933023, 24148, 624, 16, 23, "Print"],
Cell[933650, 24166, 330, 7, 23, "Print"],
Cell[933983, 24175, 264, 3, 23, "Print"],
Cell[934250, 24180, 756, 21, 23, "Print"],
Cell[935009, 24203, 550, 14, 23, "Print"],
Cell[935562, 24219, 788, 22, 23, "Print"],
Cell[936353, 24243, 728, 21, 23, "Print"],
Cell[937084, 24266, 446, 9, 23, "Print"]
}, Open  ]],
Cell[937545, 24278, 1713, 38, 559, "Output"]
}, Open  ]]
}, Closed]]
}
]
*)

(* End of internal cache information *)
