(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    105030,       2857]
NotebookOptionsPosition[    101716,       2743]
NotebookOutlinePosition[    102542,       2773]
CellTagsIndexPosition[    102369,       2766]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.5680678540835547`*^9, 3.5680678554810157`*^9}}],

Cell["Directory of HnfDecomposition.m", "Text",
 CellChangeTimes->{{3.5695630503279285`*^9, 3.5695630562412667`*^9}, 
   3.5695631702977905`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "pathHnfLibrary", "=", 
   "\"\<C:\\\\Users\\\\alb\\\\Desktop\\\\Dropbox\\\\Publicaciones\\\\\
semigrupos_descomponibles\\\\HnfDecomposition.m\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.5695631772871904`*^9, 3.569563218736561*^9}, 
   3.5695633416515913`*^9, {3.5695633743514614`*^9, 3.5695633781196775`*^9}, {
   3.569563819578927*^9, 3.5695638271163588`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", 
  RowBox[{"\"\<HnfDecomposition`\>\"", ",", "pathHnfLibrary"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.568101368545469*^9, 3.568101374186094*^9}, {
   3.568101509154844*^9, 3.5681015749302344`*^9}, {3.5681016102691016`*^9, 
   3.5681016222769136`*^9}, {3.5681016587495704`*^9, 3.568101678510312*^9}, {
   3.5681017494507422`*^9, 3.568101813667539*^9}, {3.5681018464292583`*^9, 
   3.568101861061094*^9}, 3.5681019049409766`*^9, {3.569190311201375*^9, 
   3.5691903163136797`*^9}, {3.569305939090047*^9, 3.5693059446066484`*^9}, 
   3.5693059811203203`*^9, {3.569563349584045*^9, 3.569563355599389*^9}}],

Cell[BoxData["\<\"\\nHnfDecomposition package by\\n\\nJ. I. \
Garc\[IAcute]a-Garc\[IAcute]a and A. Vigneron-Tenorio,\\nDpto. \
Matem\[AAcute]ticas, Universidad de C\[AAcute]diz\\n\\nignacio.garcia@uca.es, \
alberto.vigneron@uca.es\\n\\nThe package defines the following \
commands:\\n\\nhnfDecomposition, exec4ti2, exec4ti2Blocks\\nUse the \
Information command to know how to use them\\n\"\>"], "Print",
 CellChangeTimes->{3.5695638436613045`*^9, 3.5695639002855434`*^9, 
  3.569563987666541*^9, 3.569564043542737*^9, 3.569564117452965*^9, 
  3.569564247922427*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "hnfDecomposition"}]], "Input",
 CellChangeTimes->{{3.568127154979062*^9, 3.5681271611958594`*^9}, 
   3.568127691399961*^9, {3.569352437315633*^9, 3.5693524397384844`*^9}, {
   3.5693543269298906`*^9, 3.5693543490177813`*^9}, {3.5693545734259844`*^9, 
   3.5693545768097734`*^9}}],

Cell[BoxData[
 StyleBox["\<\"{permutations,blocks} = hnfDecomposition[M]\\n\\nComputes the \
HNF-decomposition of a matrix \\\"M\\\".\\n \\nThe returning values are the \
permutations of the columns of the matrix and the block matrices\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.5695642507615895`*^9},
 CellTags->"Info3569567850-6505568"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "exec4ti2"}]], "Input",
 CellChangeTimes->{{3.5691904698205156`*^9, 3.5691904924630938`*^9}, {
  3.5693544015392656`*^9, 3.569354406395711*^9}}],

Cell[BoxData[
 StyleBox["\<\"exec4ti2[comm,path,M]\\n\\nExecute the 4ti2 command \\\"comm\\\
\" which can be equal to \\\"4ti2int64 groebner\\\", \\\"4ti2int32 groebner\\\
\", \\\"4ti2gmp groebner\\\" or \\\"zsolve -G\\\". The entries are the \
command \\\"comm\\\", the path \\\"path\\\" where 4ti2 will store the output \
matrices and the matrix \\\"M\\\".\\n \\nThe returning value is the time of \
the execution and the returning code of the 4ti2 command.\\n\\nThe directory \
of the program 4ti2 must be in the PATH enviroment variable of your computer.\
\\n\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.5695642530327196`*^9},
 CellTags->"Info3569567852-6521915"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "exec4ti2Blocks"}]], "Input",
 CellChangeTimes->{{3.5691905007921953`*^9, 3.5691905013517656`*^9}, {
  3.569352476741414*^9, 3.5693524812365313`*^9}, {3.5693544094523516`*^9, 
  3.5693544138673906`*^9}, {3.5693545664972734`*^9, 3.5693545673693438`*^9}}],

Cell[BoxData[
 StyleBox["\<\"exec4ti2List[cmm,path,listOfMatrices]\\n\\nExecute the 4ti2 \
command \\\"comm\\\" which can be equal to \\n\\\"4ti2int64 groebner\\\", \
\\\"4ti2int32 groebner\\\", \\\"4ti2gmp groebner\\\" or \\\"zsolve -G\\\". \
The entries are the command \\\"comm\\\", the path \\\"path\\\" where 4ti2 \
will store the output matrices and the list of matrices listOfMatrices.\\n \
\\nThe returning value is the time of the execution and the returning code of \
the 4ti2 command.\\n\\nThe execution is done in parallel and the time of \
execution depends mainly on the number of processor of the computer.\\n\\nThe \
directory of the program 4ti2 must be in the PATH enviroment variable of your \
computer.\\n\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.569564256694929*^9},
 CellTags->"Info3569567856-9082545"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1, Graver basis computation", "Section",
 CellChangeTimes->{{3.569306536243367*^9, 3.569306539993367*^9}, {
  3.569312205527547*^9, 3.5693122106642656`*^9}, {3.5693123368517656`*^9, 
  3.5693123412521563`*^9}, {3.569564896532525*^9, 3.569564896660533*^9}}],

Cell["Example prueba_graver _ 0. mat", "Text",
 CellChangeTimes->{{3.5693122362580156`*^9, 3.5693122433449297`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"M1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "82"}], ",", 
       RowBox[{"-", "112"}], ",", "28", ",", "74", ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "34"}], ",", "93", ",", 
       RowBox[{"-", "24"}], ",", 
       RowBox[{"-", "2"}], ",", "43", ",", "71", ",", "2", ",", "51", ",", 
       "75", ",", "96", ",", 
       RowBox[{"-", "74"}], ",", "65", ",", 
       RowBox[{"-", "68"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", "66", ",", "52", ",", "88", ",", 
       RowBox[{"-", "2"}], ",", "23", ",", "9", ",", 
       RowBox[{"-", "88"}], ",", "0", ",", "10", ",", 
       RowBox[{"-", "29"}], ",", "108", ",", 
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "79"}], ",", "148", ",", 
       RowBox[{"-", "20"}], ",", "7", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", 
       RowBox[{"-", "65"}], ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "147"}], ",", "45", ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "43"}], ",", "113", ",", "54", ",", "9", ",", "25", ",", 
       "9", ",", "73", ",", "190", ",", 
       RowBox[{"-", "74"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "72"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "64"}], ",", "30", ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "45"}], ",", "41", ",", "115", ",", "24", ",", 
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "29"}], ",", "116", ",", 
       RowBox[{"-", "99"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"36", ",", "24", ",", 
       RowBox[{"-", "92"}], ",", "36", ",", "63", ",", "23", ",", 
       RowBox[{"-", "18"}], ",", "0", ",", "72", ",", 
       RowBox[{"-", "18"}], ",", "43", ",", 
       RowBox[{"-", "11"}], ",", "157", ",", "37", ",", "0", ",", 
       RowBox[{"-", "36"}], ",", "10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "91"}], ",", 
       RowBox[{"-", "121"}], ",", "59", ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "104"}], ",", "25", ",", "38", ",", 
       RowBox[{"-", "39"}], ",", "59", ",", "6", ",", "86", ",", "123", ",", 
       "67", ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "38"}], ",", "199", ",", 
       RowBox[{"-", "89"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "49"}], ",", "77", ",", 
       RowBox[{"-", "61"}], ",", "61", ",", 
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "15"}], ",", "47", ",", 
       RowBox[{"-", "60"}], ",", 
       RowBox[{"-", "33"}], ",", "108", ",", "19", ",", 
       RowBox[{"-", "32"}], ",", "7", ",", "32", ",", "120", ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "163"}], ",", "18"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", "24", ",", "0", ",", "40", ",", 
       RowBox[{"-", "8"}], ",", "114", ",", 
       RowBox[{"-", "110"}], ",", 
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "77"}], ",", 
       RowBox[{"-", "107"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "27"}], ",", "74", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "181"}], ",", 
       RowBox[{"-", "27"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "57"}], ",", "61", ",", "35", ",", 
       RowBox[{"-", "59"}], ",", 
       RowBox[{"-", "57"}], ",", "72", ",", 
       RowBox[{"-", "38"}], ",", "52", ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "80"}], ",", 
       RowBox[{"-", "122"}], ",", "26", ",", 
       RowBox[{"-", "69"}], ",", 
       RowBox[{"-", "64"}], ",", "11", ",", 
       RowBox[{"-", "107"}], ",", "34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"42", ",", "83", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "58"}], ",", "15", ",", 
       RowBox[{"-", "200"}], ",", "39", ",", "38", ",", "6", ",", 
       RowBox[{"-", "84"}], ",", "60", ",", "26", ",", "34", ",", 
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "89"}], ",", "37", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "9"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "12"}], ",", "10", ",", 
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "60"}], ",", 
       RowBox[{"-", "27"}], ",", "89", ",", 
       RowBox[{"-", "133"}], ",", "44", ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "121"}], ",", "15", ",", 
       RowBox[{"-", "74"}], ",", "26", ",", 
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "10"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"17", ",", "42", ",", "4", ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "72"}], ",", "16", ",", 
       RowBox[{"-", "23"}], ",", "5", ",", 
       RowBox[{"-", "78"}], ",", "13", ",", "125", ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "46"}], ",", "39", ",", 
       RowBox[{"-", "72"}], ",", "58"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"49", ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "45"}], ",", "67", ",", "37", ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "76"}], ",", "33", ",", 
       RowBox[{"-", "12"}], ",", "59", ",", "158", ",", "214", ",", "82", ",",
        "100", ",", "1", ",", "64", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "60"}], ",", "208", ",", "7", ",", "60", ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "221"}], ",", 
       RowBox[{"-", "94"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "20"}], ",", "10", ",", 
       RowBox[{"-", "147"}], ",", "134", ",", "68", ",", 
       RowBox[{"-", "136"}], ",", "100", ",", 
       RowBox[{"-", "40"}], ",", "113", ",", "111"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "101"}], ",", 
       RowBox[{"-", "38"}], ",", "66", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "106"}], ",", "88", ",", "78", ",", 
       RowBox[{"-", "75"}], ",", "9", ",", 
       RowBox[{"-", "6"}], ",", "94", ",", "40", ",", 
       RowBox[{"-", "136"}], ",", 
       RowBox[{"-", "34"}], ",", "19", ",", "27"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "3", ",", 
       RowBox[{"-", "12"}], ",", "42", ",", "59", ",", "27", ",", 
       RowBox[{"-", "74"}], ",", "34", ",", "82", ",", "17", ",", 
       RowBox[{"-", "85"}], ",", "3", ",", 
       RowBox[{"-", "97"}], ",", "27", ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "81"}], ",", 
       RowBox[{"-", "83"}], ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", 
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "115"}], ",", "61", ",", "75", ",", "51", ",", 
       RowBox[{"-", "146"}], ",", "8", ",", "95", ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "51"}], ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "240"}], ",", "68", ",", "10", ",", 
       RowBox[{"-", "75"}], ",", 
       RowBox[{"-", "149"}], ",", "71"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "68"}], ",", 
       RowBox[{"-", "77"}], ",", "16", ",", "36", ",", 
       RowBox[{"-", "38"}], ",", "12", ",", "54", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "67"}], ",", "95", ",", "83", ",", 
       RowBox[{"-", "22"}], ",", "7", ",", "64", ",", 
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "71"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5693101216886797`*^9, 3.5693101225265703`*^9}, {
  3.5693101991886797`*^9, 3.5693102013830156`*^9}, {3.5695649134354925`*^9, 
  3.569564913491495*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M1", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.56931020574825*^9, 3.5693102090011797`*^9}, {
  3.569564916652676*^9, 3.569564916764683*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "82"}], 
      RowBox[{"-", "112"}], "28", "74", 
      RowBox[{"-", "22"}], 
      RowBox[{"-", "34"}], "93", 
      RowBox[{"-", "24"}], 
      RowBox[{"-", "2"}], "43", "71", "2", "51", "75", "96", 
      RowBox[{"-", "74"}], "65", 
      RowBox[{"-", "68"}]},
     {
      RowBox[{"-", "8"}], "66", "52", "88", 
      RowBox[{"-", "2"}], "23", "9", 
      RowBox[{"-", "88"}], "0", "10", 
      RowBox[{"-", "29"}], "108", 
      RowBox[{"-", "67"}], 
      RowBox[{"-", "79"}], "148", 
      RowBox[{"-", "20"}], "7", 
      RowBox[{"-", "4"}]},
     {"28", 
      RowBox[{"-", "65"}], 
      RowBox[{"-", "18"}], 
      RowBox[{"-", "36"}], 
      RowBox[{"-", "35"}], 
      RowBox[{"-", "147"}], "45", 
      RowBox[{"-", "30"}], 
      RowBox[{"-", "56"}], 
      RowBox[{"-", "43"}], "113", "54", "9", "25", "9", "73", "190", 
      RowBox[{"-", "74"}]},
     {
      RowBox[{"-", "72"}], 
      RowBox[{"-", "6"}], 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "8"}], 
      RowBox[{"-", "42"}], 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "64"}], "30", 
      RowBox[{"-", "32"}], 
      RowBox[{"-", "45"}], "41", "115", "24", 
      RowBox[{"-", "36"}], 
      RowBox[{"-", "9"}], 
      RowBox[{"-", "29"}], "116", 
      RowBox[{"-", "99"}]},
     {"36", "24", 
      RowBox[{"-", "92"}], "36", "63", "23", 
      RowBox[{"-", "18"}], "0", "72", 
      RowBox[{"-", "18"}], "43", 
      RowBox[{"-", "11"}], "157", "37", "0", 
      RowBox[{"-", "36"}], "10", "1"},
     {
      RowBox[{"-", "91"}], 
      RowBox[{"-", "121"}], "59", 
      RowBox[{"-", "9"}], 
      RowBox[{"-", "52"}], 
      RowBox[{"-", "104"}], "25", "38", 
      RowBox[{"-", "39"}], "59", "6", "86", "123", "67", 
      RowBox[{"-", "11"}], 
      RowBox[{"-", "38"}], "199", 
      RowBox[{"-", "89"}]},
     {
      RowBox[{"-", "49"}], "77", 
      RowBox[{"-", "61"}], "61", 
      RowBox[{"-", "37"}], 
      RowBox[{"-", "15"}], "47", 
      RowBox[{"-", "60"}], 
      RowBox[{"-", "33"}], "108", "19", 
      RowBox[{"-", "32"}], "7", "32", "120", 
      RowBox[{"-", "21"}], 
      RowBox[{"-", "163"}], "18"},
     {
      RowBox[{"-", "8"}], "24", "0", "40", 
      RowBox[{"-", "8"}], "114", 
      RowBox[{"-", "110"}], 
      RowBox[{"-", "44"}], 
      RowBox[{"-", "8"}], 
      RowBox[{"-", "42"}], 
      RowBox[{"-", "77"}], 
      RowBox[{"-", "107"}], 
      RowBox[{"-", "50"}], 
      RowBox[{"-", "27"}], "74", 
      RowBox[{"-", "6"}], 
      RowBox[{"-", "181"}], 
      RowBox[{"-", "27"}]},
     {
      RowBox[{"-", "57"}], "61", "35", 
      RowBox[{"-", "59"}], 
      RowBox[{"-", "57"}], "72", 
      RowBox[{"-", "38"}], "52", 
      RowBox[{"-", "57"}], 
      RowBox[{"-", "42"}], 
      RowBox[{"-", "80"}], 
      RowBox[{"-", "122"}], "26", 
      RowBox[{"-", "69"}], 
      RowBox[{"-", "64"}], "11", 
      RowBox[{"-", "107"}], "34"},
     {"42", "83", 
      RowBox[{"-", "16"}], 
      RowBox[{"-", "58"}], "15", 
      RowBox[{"-", "200"}], "39", "38", "6", 
      RowBox[{"-", "84"}], "60", "26", "34", 
      RowBox[{"-", "84"}], 
      RowBox[{"-", "89"}], "37", 
      RowBox[{"-", "2"}], 
      RowBox[{"-", "9"}]},
     {
      RowBox[{"-", "12"}], "10", 
      RowBox[{"-", "48"}], 
      RowBox[{"-", "60"}], 
      RowBox[{"-", "27"}], "89", 
      RowBox[{"-", "133"}], "44", 
      RowBox[{"-", "32"}], 
      RowBox[{"-", "22"}], 
      RowBox[{"-", "57"}], 
      RowBox[{"-", "76"}], 
      RowBox[{"-", "121"}], "15", 
      RowBox[{"-", "74"}], "26", 
      RowBox[{"-", "93"}], 
      RowBox[{"-", "10"}]},
     {"17", "42", "4", 
      RowBox[{"-", "45"}], 
      RowBox[{"-", "13"}], 
      RowBox[{"-", "79"}], 
      RowBox[{"-", "72"}], "16", 
      RowBox[{"-", "23"}], "5", 
      RowBox[{"-", "78"}], "13", "125", 
      RowBox[{"-", "28"}], 
      RowBox[{"-", "46"}], "39", 
      RowBox[{"-", "72"}], "58"},
     {"49", 
      RowBox[{"-", "98"}], 
      RowBox[{"-", "45"}], "67", "37", 
      RowBox[{"-", "61"}], 
      RowBox[{"-", "11"}], 
      RowBox[{"-", "76"}], "33", 
      RowBox[{"-", "12"}], "59", "158", "214", "82", "100", "1", "64", "0"},
     {
      RowBox[{"-", "60"}], "208", "7", "60", 
      RowBox[{"-", "30"}], 
      RowBox[{"-", "221"}], 
      RowBox[{"-", "94"}], 
      RowBox[{"-", "40"}], 
      RowBox[{"-", "20"}], "10", 
      RowBox[{"-", "147"}], "134", "68", 
      RowBox[{"-", "136"}], "100", 
      RowBox[{"-", "40"}], "113", "111"},
     {"30", 
      RowBox[{"-", "10"}], 
      RowBox[{"-", "101"}], 
      RowBox[{"-", "38"}], "66", 
      RowBox[{"-", "10"}], 
      RowBox[{"-", "106"}], "88", "78", 
      RowBox[{"-", "75"}], "9", 
      RowBox[{"-", "6"}], "94", "40", 
      RowBox[{"-", "136"}], 
      RowBox[{"-", "34"}], "19", "27"},
     {
      RowBox[{"-", "10"}], "3", 
      RowBox[{"-", "12"}], "42", "59", "27", 
      RowBox[{"-", "74"}], "34", "82", "17", 
      RowBox[{"-", "85"}], "3", 
      RowBox[{"-", "97"}], "27", 
      RowBox[{"-", "19"}], 
      RowBox[{"-", "81"}], 
      RowBox[{"-", "83"}], "13"},
     {"15", 
      RowBox[{"-", "25"}], 
      RowBox[{"-", "115"}], "61", "75", "51", 
      RowBox[{"-", "146"}], "8", "95", 
      RowBox[{"-", "99"}], 
      RowBox[{"-", "51"}], 
      RowBox[{"-", "35"}], 
      RowBox[{"-", "240"}], "68", "10", 
      RowBox[{"-", "75"}], 
      RowBox[{"-", "149"}], "71"},
     {
      RowBox[{"-", "68"}], 
      RowBox[{"-", "77"}], "16", "36", 
      RowBox[{"-", "38"}], "12", "54", 
      RowBox[{"-", "16"}], 
      RowBox[{"-", "28"}], 
      RowBox[{"-", "67"}], "95", "83", 
      RowBox[{"-", "22"}], "7", "64", 
      RowBox[{"-", "36"}], 
      RowBox[{"-", "27"}], 
      RowBox[{"-", "71"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.569310210241414*^9, {3.5693105690041094`*^9, 3.569310575612508*^9}, 
   3.569311894665242*^9, 3.569311992609578*^9, 3.5693530095265703`*^9, 
   3.5693537126515703`*^9, 3.5695649879297533`*^9}]
}, Open  ]],

Cell["Define our working directory", "Text",
 CellChangeTimes->{{3.5693546442423906`*^9, 3.569354651522664*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"wd", "=", 
  "\"\<C:\\\\Users\\\\alb\\\\Desktop\\\\Dropbox\\\\Publicaciones\\\\\
semigrupos_descomponibles\>\""}]], "Input",
 CellChangeTimes->{{3.5686415297935467`*^9, 3.568641539565031*^9}, {
  3.5686423542515545`*^9, 3.568642355250578*^9}, {3.5695649694286947`*^9, 
  3.5695649783412046`*^9}}],

Cell[BoxData["\<\"C:\\\\Users\\\\alb\\\\Desktop\\\\Dropbox\\\\Publicaciones\\\
\\semigrupos_descomponibles\"\>"], "Output",
 CellChangeTimes->{{3.5693119854611406`*^9, 3.569311994319539*^9}, 
   3.5693530112130938`*^9, 3.569353714140828*^9, 3.5695649916509657`*^9}]
}, Open  ]],

Cell["\<\
If we try to compute the Graver basis without using decomposition, we get \
nothing during a long time\
\>", "Text",
 CellChangeTimes->{{3.5693118059787188`*^9, 3.569311864067586*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exec4ti2", "[", 
  RowBox[{"\"\<zsolve -G\>\"", ",", "wd", ",", "M1"}], "]"}]], "Input",
 CellChangeTimes->{{3.5693102497892656`*^9, 3.5693102525724688`*^9}, {
  3.569310502308797*^9, 3.569310502340047*^9}, {3.569311758366414*^9, 
  3.5693117623947344`*^9}, {3.5695649194378357`*^9, 3.56956491951684*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16.3149332`8.664130293444511", ",", 
   RowBox[{"-", "1073741510"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.569310493590047*^9, 3.5693105117384844`*^9}, 
   3.56931057874825*^9, 3.5693110983986406`*^9, 3.5693117942160234`*^9, {
   3.569312081317586*^9, 3.5693121077961016`*^9}, 3.5693530498966875`*^9, 
   3.5693537348117266`*^9, 3.5695650151253085`*^9}]
}, Open  ]],

Cell["We aborted obtaining a return error code ", "Text",
 CellChangeTimes->{{3.5693121449416094`*^9, 3.5693121631896563`*^9}, {
  3.569353042208211*^9, 3.5693530596798906`*^9}, {3.569353739241414*^9, 
  3.5693537434972734`*^9}, {3.5693537867628984`*^9, 3.5693537918429766`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"permutations1", ",", "blocks1"}], "}"}], "=", 
   RowBox[{"hnfDecomposition", "[", "M1", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.569310278484578*^9, 3.5693102828849688`*^9}, {
  3.5695649219019766`*^9, 3.569564936043785*^9}}],

Cell[CellGroupData[{

Cell[BoxData["permutations1"], "Input",
 CellChangeTimes->{{3.569310291524617*^9, 3.5693102944279375`*^9}, {
  3.5695649380929027`*^9, 3.569564938203909*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "4", ",", "5", ",", "8", ",", "9", ",", "15", ",", "16"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "3", ",", "7", ",", "10", ",", "11", ",", "14", ",", "18"}], 
    "}"}], ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", "12", "}"}], ",", 
   RowBox[{"{", "13", "}"}], ",", 
   RowBox[{"{", "17", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.569310295337117*^9, 3.569310595065633*^9, {3.569311869590047*^9, 
   3.569311899420125*^9}, 3.569311997712117*^9, 3.5693530650685625`*^9, 
   3.5693537466418047`*^9, 3.5695650260259323`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", " ", "/@", "blocks1"}]], "Input",
 CellChangeTimes->{{3.5693103069992266`*^9, 3.569310318109578*^9}, {
  3.5695649404360366`*^9, 3.5695649405010405`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "3", "7", "4", "9", 
        RowBox[{"-", "4"}], 
        RowBox[{"-", "7"}]},
       {"0", "8", "9", "2", "12", "1", 
        RowBox[{"-", "11"}]},
       {"0", "0", "12", "14", "16", 
        RowBox[{"-", "17"}], 
        RowBox[{"-", "13"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0", "0", "858", 
        RowBox[{"-", "8048"}]},
       {"0", "1", "0", "0", "0", "189", 
        RowBox[{"-", "1780"}]},
       {"0", "0", "1", "0", "0", "1028", 
        RowBox[{"-", "9631"}]},
       {"0", "0", "0", "1", "0", "1594", 
        RowBox[{"-", "14936"}]},
       {"0", "0", "0", "0", "1", "973", 
        RowBox[{"-", "9123"}]},
       {"0", "0", "0", "0", "0", "2190", 
        RowBox[{"-", "20524"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{3.569310318871297*^9, 3.5693105959015703`*^9, 
  3.569311870402547*^9, 3.569311900633992*^9, 3.569311998587117*^9, 
  3.5693530664259844`*^9, 3.5693537476740313`*^9, 3.569565032055277*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exec4ti2Blocks", "[", 
  RowBox[{"\"\<zsolve -G\>\"", ",", "wd", ",", "blocks1"}], "]"}]], "Input",
 CellChangeTimes->{{3.5693103464953203`*^9, 3.5693103516711016`*^9}, {
   3.5693106307228594`*^9, 3.5693106319611406`*^9}, 3.5693107641418047`*^9, {
   3.569310803031453*^9, 3.5693108285216875`*^9}, {3.5693109144455156`*^9, 
   3.5693109168918047`*^9}, {3.5693117069855547`*^9, 3.569311709359578*^9}, {
   3.569564943068187*^9, 3.5695649431891937`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.591091`7.653240012657111", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.56931044443575*^9, 3.5693106047365313`*^9, 3.569310664190633*^9, {
   3.569310797915242*^9, 3.5693108322209063`*^9}, 3.569311729949422*^9, {
   3.569311906687703*^9, 3.5693119401847734`*^9}, {3.569312012482625*^9, 
   3.5693120287365313`*^9}, 3.569353075402547*^9, 3.5693537544904375`*^9, {
   3.569565038774661*^9, 3.5695650543955545`*^9}}]
}, Open  ]],

Cell["\<\
In this case with the decomposition the result is obtained faster\
\>", "Text",
 CellChangeTimes->{{3.569353085625203*^9, 3.569353108081258*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Example 2, Gr\[ODoubleDot]ber basis computation\
\>", "Section",
 CellChangeTimes->{{3.569312262746297*^9, 3.5693122699953203`*^9}, {
  3.5693123451886797`*^9, 3.569312353965047*^9}, {3.569564901035783*^9, 
  3.5695649011317883`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"M2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "14"}], ",", "29", ",", "47", ",", "18", ",", 
       RowBox[{"-", "13"}], ",", "38", ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "143"}], ",", 
       RowBox[{"-", "83"}], ",", "35", ",", 
       RowBox[{"-", "113"}], ",", "34", ",", 
       RowBox[{"-", "122"}], ",", "104", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "130"}], ",", 
       RowBox[{"-", "42"}], ",", "24", ",", 
       RowBox[{"-", "96"}], ",", 
       RowBox[{"-", "54"}], ",", "68", ",", 
       RowBox[{"-", "103"}], ",", "98", ",", 
       RowBox[{"-", "77"}], ",", "79", ",", "1", ",", "10", ",", 
       RowBox[{"-", "20"}], ",", "52", ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "34"}], ",", 
       RowBox[{"-", "110"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "11"}], ",", "115", ",", "70", ",", "25", ",", 
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "38"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"139", ",", "97", ",", 
       RowBox[{"-", "130"}], ",", 
       RowBox[{"-", "41"}], ",", 
       RowBox[{"-", "23"}], ",", "46", ",", "145", ",", 
       RowBox[{"-", "147"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "29"}], ",", "129", ",", "2", ",", 
       RowBox[{"-", "96"}], ",", 
       RowBox[{"-", "126"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "92"}], ",", "100", ",", "54", ",", "99", ",", "32", ",", 
       "82", ",", "46", ",", 
       RowBox[{"-", "200"}], ",", "68", ",", 
       RowBox[{"-", "74"}], ",", "44", ",", "17", ",", "32", ",", 
       RowBox[{"-", "117"}], ",", "21", ",", "26", ",", 
       RowBox[{"-", "53"}], ",", 
       RowBox[{"-", "177"}], ",", "5", ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "127"}], ",", "49", ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "119"}], ",", "53", ",", "84", ",", "54", ",", "9", ",", 
       "33", ",", 
       RowBox[{"-", "113"}], ",", "121", ",", "47", ",", 
       RowBox[{"-", "39"}], ",", "185", ",", 
       RowBox[{"-", "51"}], ",", "100", ",", "48", ",", "106", ",", 
       RowBox[{"-", "43"}], ",", "56", ",", 
       RowBox[{"-", "89"}], ",", 
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "128"}], ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "59"}], ",", 
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "163"}], ",", 
       RowBox[{"-", "47"}], ",", 
       RowBox[{"-", "62"}], ",", "11", ",", 
       RowBox[{"-", "16"}], ",", "62", ",", 
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "26"}], ",", "12", ",", "21", ",", 
       RowBox[{"-", "24"}], ",", 
       RowBox[{"-", "216"}], ",", "152", ",", 
       RowBox[{"-", "96"}], ",", "20", ",", 
       RowBox[{"-", "60"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"156", ",", "37", ",", "87", ",", 
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "35"}], ",", "10", ",", "89", ",", 
       RowBox[{"-", "27"}], ",", "15", ",", "11", ",", 
       RowBox[{"-", "56"}], ",", "78", ",", "25", ",", "76", ",", 
       RowBox[{"-", "126"}], ",", 
       RowBox[{"-", "104"}], ",", 
       RowBox[{"-", "40"}], ",", "83", ",", "76", ",", "69", ",", 
       RowBox[{"-", "87"}], ",", 
       RowBox[{"-", "118"}], ",", "45", ",", "15", ",", "71", ",", "82", ",", 
       RowBox[{"-", "54"}], ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "98"}], ",", "56", ",", "60", ",", "69", ",", "2", ",", 
       "23", ",", 
       RowBox[{"-", "23"}], ",", "187", ",", "43", ",", "0", ",", 
       RowBox[{"-", "92"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "123"}], ",", "36", ",", "86", ",", "34", ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "74"}], ",", "188", ",", "60", ",", "19", ",", "228", ",", 
       RowBox[{"-", "131"}], ",", "126", ",", "112", ",", "110", ",", 
       RowBox[{"-", "59"}], ",", "80", ",", 
       RowBox[{"-", "99"}], ",", "42", ",", 
       RowBox[{"-", "40"}], ",", "1", ",", 
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "5"}], ",", "44", ",", "112", ",", 
       RowBox[{"-", "69"}], ",", "41", ",", 
       RowBox[{"-", "49"}], ",", "11", ",", "126", ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "26"}], ",", "40", ",", "61", ",", "53", ",", 
       RowBox[{"-", "13"}], ",", "189", ",", 
       RowBox[{"-", "114"}], ",", "103", ",", 
       RowBox[{"-", "26"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "97"}], ",", "73", ",", 
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "74"}], ",", "46", ",", "134", ",", "155", ",", 
       RowBox[{"-", "92"}], ",", "115", ",", 
       RowBox[{"-", "55"}], ",", 
       RowBox[{"-", "147"}], ",", 
       RowBox[{"-", "170"}], ",", "8", ",", "35", ",", 
       RowBox[{"-", "102"}], ",", "78", ",", 
       RowBox[{"-", "50"}], ",", "103", ",", "167", ",", "7", ",", 
       RowBox[{"-", "162"}], ",", "122", ",", 
       RowBox[{"-", "149"}], ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "65"}], ",", "73", ",", "61", ",", "43", ",", "80", ",", 
       "70", ",", 
       RowBox[{"-", "54"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "85"}], ",", 
       RowBox[{"-", "61"}], ",", "50", ",", "93", ",", 
       RowBox[{"-", "94"}], ",", "124", ",", "91"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "85"}], ",", 
       RowBox[{"-", "84"}], ",", "24", ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "80"}], ",", "27", ",", 
       RowBox[{"-", "24"}], ",", "71", ",", "32", ",", 
       RowBox[{"-", "80"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "67"}], ",", "196", ",", "47", ",", 
       RowBox[{"-", "17"}], ",", "62", ",", "82", ",", "42", ",", "98", ",", 
       RowBox[{"-", "95"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "19"}], ",", "116", ",", 
       RowBox[{"-", "21"}], ",", "154", ",", 
       RowBox[{"-", "46"}], ",", "39", ",", 
       RowBox[{"-", "117"}], ",", 
       RowBox[{"-", "22"}], ",", "53", ",", 
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "66"}], ",", "129", ",", "20", ",", 
       RowBox[{"-", "125"}], ",", "106", ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "18"}], ",", "48"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"152", ",", 
       RowBox[{"-", "128"}], ",", 
       RowBox[{"-", "1"}], ",", "21", ",", "20", ",", "80", ",", 
       RowBox[{"-", "79"}], ",", "68", ",", "74", ",", 
       RowBox[{"-", "117"}], ",", "115", ",", 
       RowBox[{"-", "27"}], ",", "102", ",", "40", ",", 
       RowBox[{"-", "117"}], ",", "36", ",", 
       RowBox[{"-", "114"}], ",", 
       RowBox[{"-", "153"}], ",", 
       RowBox[{"-", "149"}], ",", 
       RowBox[{"-", "21"}], ",", "55", ",", "44", ",", 
       RowBox[{"-", "64"}], ",", "124", ",", "90", ",", 
       RowBox[{"-", "77"}], ",", 
       RowBox[{"-", "67"}], ",", "15", ",", "47", ",", "28", ",", 
       RowBox[{"-", "32"}], ",", "70", ",", 
       RowBox[{"-", "1"}], ",", "101", ",", "19", ",", 
       RowBox[{"-", "105"}], ",", "31", ",", "7", ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "229"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "101"}], ",", "40", ",", "13", ",", 
       RowBox[{"-", "12"}], ",", "16", ",", "30", ",", "146", ",", "86", ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "165"}], ",", "75", ",", 
       RowBox[{"-", "18"}], ",", "88", ",", "27", ",", "51", ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "61"}], ",", "123", ",", "60", ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "65"}], ",", 
       RowBox[{"-", "12"}], ",", "40", ",", "41", ",", "31", ",", "52", ",", 
       "39", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "34"}], ",", 
       RowBox[{"-", "65"}], ",", "40", ",", "35", ",", "87", ",", "85", ",", 
       "125", ",", "102", ",", 
       RowBox[{"-", "114"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "71"}], ",", "0", ",", "16", ",", "28", ",", 
       RowBox[{"-", "17"}], ",", "51", ",", "141", ",", "83", ",", "15", ",", 
       "15", ",", 
       RowBox[{"-", "121"}], ",", "1", ",", 
       RowBox[{"-", "114"}], ",", 
       RowBox[{"-", "164"}], ",", "56", ",", 
       RowBox[{"-", "106"}], ",", "20", ",", 
       RowBox[{"-", "90"}], ",", 
       RowBox[{"-", "191"}], ",", "106", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "50"}], ",", "49", ",", "38", ",", "2", ",", 
       RowBox[{"-", "71"}], ",", 
       RowBox[{"-", "27"}], ",", "18", ",", "27", ",", "278", ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "34"}], ",", "82", ",", 
       RowBox[{"-", "36"}], ",", "27", ",", "110", ",", "27", ",", 
       RowBox[{"-", "48"}], ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"86", ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "68"}], ",", "14", ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "113"}], ",", 
       RowBox[{"-", "35"}], ",", "3", ",", 
       RowBox[{"-", "65"}], ",", 
       RowBox[{"-", "32"}], ",", "119", ",", "88", ",", "104", ",", 
       RowBox[{"-", "124"}], ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "92"}], ",", 
       RowBox[{"-", "54"}], ",", "60", ",", "55", ",", "45", ",", 
       RowBox[{"-", "16"}], ",", "2", ",", "95", ",", "34", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "44"}], ",", "67", ",", 
       RowBox[{"-", "29"}], ",", "46", ",", "86", ",", 
       RowBox[{"-", "18"}], ",", "50", ",", "30", ",", 
       RowBox[{"-", "25"}], ",", "17", ",", 
       RowBox[{"-", "262"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "53"}], ",", "32", ",", "157"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "111"}], ",", "64", ",", 
       RowBox[{"-", "81"}], ",", 
       RowBox[{"-", "23"}], ",", 
       RowBox[{"-", "125"}], ",", 
       RowBox[{"-", "183"}], ",", 
       RowBox[{"-", "69"}], ",", "20", ",", 
       RowBox[{"-", "126"}], ",", "269", ",", "71", ",", "160", ",", "33", 
       ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "2"}], ",", "117", ",", "48", ",", 
       RowBox[{"-", "136"}], ",", "45", ",", "5", ",", "115", ",", "151", ",", 
       RowBox[{"-", "2"}], ",", "49", ",", "61", ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "115"}], ",", 
       RowBox[{"-", "52"}], ",", "34", ",", "56", ",", "199", ",", "56", ",", 
       "1", ",", 
       RowBox[{"-", "125"}], ",", "120", ",", 
       RowBox[{"-", "49"}], ",", 
       RowBox[{"-", "126"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", 
       RowBox[{"-", "89"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "94"}], ",", "100", ",", 
       RowBox[{"-", "58"}], ",", 
       RowBox[{"-", "15"}], ",", "12", ",", "15", ",", "127", ",", 
       RowBox[{"-", "51"}], ",", "3", ",", "36", ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "14"}], ",", "37", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "37"}], ",", 
       RowBox[{"-", "69"}], ",", 
       RowBox[{"-", "84"}], ",", "97", ",", 
       RowBox[{"-", "31"}], ",", "61", ",", 
       RowBox[{"-", "63"}], ",", 
       RowBox[{"-", "54"}], ",", "46", ",", "56", ",", "8", ",", "28", ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "39"}], ",", "18", ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "48"}], ",", "105", ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "46"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", 
       RowBox[{"-", "6"}], ",", "6", ",", "106", ",", "55", ",", "61", ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "36"}], ",", "27", ",", "91", ",", 
       RowBox[{"-", "107"}], ",", "10", ",", 
       RowBox[{"-", "55"}], ",", "16", ",", "14", ",", "4", ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "18"}], ",", "43", ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "173"}], ",", "6", ",", 
       RowBox[{"-", "53"}], ",", 
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "3"}], ",", "59", ",", 
       RowBox[{"-", "17"}], ",", 
       RowBox[{"-", "91"}], ",", "74", ",", "84", ",", 
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "70"}], ",", "35", ",", "5", ",", "8", ",", 
       RowBox[{"-", "62"}], ",", "107"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"84", ",", 
       RowBox[{"-", "49"}], ",", "11", ",", 
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "21"}], ",", "29", ",", 
       RowBox[{"-", "90"}], ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "15"}], ",", "103", ",", 
       RowBox[{"-", "184"}], ",", 
       RowBox[{"-", "38"}], ",", 
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "89"}], ",", 
       RowBox[{"-", "186"}], ",", 
       RowBox[{"-", "70"}], ",", "112", ",", 
       RowBox[{"-", "63"}], ",", "76", ",", 
       RowBox[{"-", "114"}], ",", 
       RowBox[{"-", "91"}], ",", "113", ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "19"}], ",", "17", ",", 
       RowBox[{"-", "59"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "10"}], ",", "89", ",", "24", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "94"}], ",", "10", ",", "24", ",", "36", ",", "148", ",", 
       RowBox[{"-", "82"}], ",", 
       RowBox[{"-", "102"}], ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"122", ",", 
       RowBox[{"-", "55"}], ",", "43", ",", 
       RowBox[{"-", "53"}], ",", 
       RowBox[{"-", "55"}], ",", "51", ",", "41", ",", "100", ",", 
       RowBox[{"-", "67"}], ",", "12", ",", 
       RowBox[{"-", "32"}], ",", "30", ",", 
       RowBox[{"-", "65"}], ",", "44", ",", 
       RowBox[{"-", "103"}], ",", 
       RowBox[{"-", "199"}], ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "92"}], ",", 
       RowBox[{"-", "34"}], ",", "21", ",", 
       RowBox[{"-", "13"}], ",", 
       RowBox[{"-", "145"}], ",", "149", ",", 
       RowBox[{"-", "104"}], ",", "1", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "54"}], ",", "69", ",", 
       RowBox[{"-", "29"}], ",", "12", ",", "38", ",", "38", ",", "21", ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "57"}], ",", "117", ",", "145", ",", "8", ",", "18", ",", 
       "58"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "91"}], ",", "52", ",", "22", ",", 
       RowBox[{"-", "27"}], ",", 
       RowBox[{"-", "60"}], ",", 
       RowBox[{"-", "121"}], ",", "62", ",", 
       RowBox[{"-", "97"}], ",", 
       RowBox[{"-", "88"}], ",", 
       RowBox[{"-", "85"}], ",", 
       RowBox[{"-", "18"}], ",", "102", ",", "7", ",", 
       RowBox[{"-", "12"}], ",", "65", ",", "84", ",", "70", ",", "76", ",", 
       "142", ",", 
       RowBox[{"-", "8"}], ",", "82", ",", 
       RowBox[{"-", "60"}], ",", "36", ",", "81", ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "74"}], ",", "120", ",", 
       RowBox[{"-", "46"}], ",", "29", ",", 
       RowBox[{"-", "135"}], ",", "31", ",", 
       RowBox[{"-", "52"}], ",", 
       RowBox[{"-", "15"}], ",", "6", ",", "37", ",", 
       RowBox[{"-", "92"}], ",", 
       RowBox[{"-", "90"}], ",", "48", ",", "44", ",", "112"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"44", ",", "46", ",", 
       RowBox[{"-", "124"}], ",", 
       RowBox[{"-", "90"}], ",", 
       RowBox[{"-", "41"}], ",", "73", ",", "128", ",", 
       RowBox[{"-", "194"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "77"}], ",", 
       RowBox[{"-", "25"}], ",", "0", ",", 
       RowBox[{"-", "52"}], ",", "0", ",", "16", ",", "106", ",", 
       RowBox[{"-", "23"}], ",", "76", ",", "33", ",", "59", ",", "66", ",", 
       RowBox[{"-", "220"}], ",", "31", ",", "115", ",", "45", ",", "12", ",", 
       RowBox[{"-", "96"}], ",", 
       RowBox[{"-", "39"}], ",", "76", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "166"}], ",", 
       RowBox[{"-", "1"}], ",", "35", ",", 
       RowBox[{"-", "137"}], ",", "13", ",", 
       RowBox[{"-", "96"}], ",", 
       RowBox[{"-", "117"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"133", ",", 
       RowBox[{"-", "33"}], ",", "42", ",", 
       RowBox[{"-", "83"}], ",", 
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "42"}], ",", "123", ",", "95", ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "82"}], ",", "4", ",", "159", ",", "42", ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "119"}], ",", 
       RowBox[{"-", "143"}], ",", 
       RowBox[{"-", "42"}], ",", 
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "32"}], ",", "145", ",", "14", ",", 
       RowBox[{"-", "130"}], ",", "119", ",", 
       RowBox[{"-", "136"}], ",", "10", ",", "30", ",", "58", ",", 
       RowBox[{"-", "19"}], ",", 
       RowBox[{"-", "52"}], ",", "195", ",", "63", ",", "28", ",", "9", ",", 
       RowBox[{"-", "153"}], ",", "24", ",", 
       RowBox[{"-", "155"}], ",", "127", ",", "41", ",", "40", ",", "70"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "21"}], ",", "74", ",", 
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "123"}], ",", "107", ",", 
       RowBox[{"-", "182"}], ",", 
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "141"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "68", ",", "50", ",", "10", ",", 
       "12", ",", "153", ",", 
       RowBox[{"-", "66"}], ",", "108", ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "16"}], ",", "47", ",", "26", ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "37"}], ",", "17", ",", "41", ",", "28", ",", 
       RowBox[{"-", "58"}], ",", "40", ",", "82", ",", "43", ",", "30", ",", 
       "63", ",", 
       RowBox[{"-", "77"}], ",", "98", ",", 
       RowBox[{"-", "129"}], ",", "104"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", 
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "47"}], ",", "81", ",", 
       RowBox[{"-", "66"}], ",", "8", ",", 
       RowBox[{"-", "97"}], ",", "35", ",", "10", ",", "6", ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "66"}], ",", 
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "128"}], ",", "17", ",", "23", ",", 
       RowBox[{"-", "26"}], ",", "75", ",", "186", ",", 
       RowBox[{"-", "57"}], ",", 
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "2"}], ",", "35", ",", "89", ",", "48", ",", "101", ",", 
       "44", ",", "41", ",", 
       RowBox[{"-", "15"}], ",", 
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "69"}], ",", "52", ",", "61", ",", 
       RowBox[{"-", "47"}], ",", "19", ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "9"}], ",", "94", ",", 
       RowBox[{"-", "74"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "96"}], ",", 
       RowBox[{"-", "153"}], ",", 
       RowBox[{"-", "84"}], ",", "3", ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "7"}], ",", "13", ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "109"}], ",", 
       RowBox[{"-", "32"}], ",", 
       RowBox[{"-", "71"}], ",", 
       RowBox[{"-", "97"}], ",", 
       RowBox[{"-", "64"}], ",", "63", ",", "16", ",", "30", ",", "45", ",", 
       RowBox[{"-", "11"}], ",", "79", ",", 
       RowBox[{"-", "84"}], ",", "57", ",", "31", ",", "64", ",", "32", ",", 
       RowBox[{"-", "84"}], ",", 
       RowBox[{"-", "25"}], ",", "12", ",", "46", ",", "97", ",", "0", ",", 
       RowBox[{"-", "66"}], ",", 
       RowBox[{"-", "87"}], ",", "102", ",", "21", ",", "97", ",", 
       RowBox[{"-", "129"}], ",", "43", ",", 
       RowBox[{"-", "24"}], ",", 
       RowBox[{"-", "111"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "74"}], ",", "16", ",", "54", ",", "68", ",", 
       RowBox[{"-", "79"}], ",", 
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "119"}], ",", "6", ",", "10", ",", 
       RowBox[{"-", "136"}], ",", "202", ",", "32", ",", 
       RowBox[{"-", "8"}], ",", "10", ",", "69", ",", 
       RowBox[{"-", "28"}], ",", "7", ",", 
       RowBox[{"-", "35"}], ",", "49", ",", "112", ",", "57", ",", 
       RowBox[{"-", "80"}], ",", "159", ",", "118", ",", 
       RowBox[{"-", "23"}], ",", "82", ",", "4", ",", "75", ",", 
       RowBox[{"-", "24"}], ",", 
       RowBox[{"-", "48"}], ",", "20", ",", "2", ",", "106", ",", "28", ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "54"}], ",", "109", ",", 
       RowBox[{"-", "45"}], ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"19", ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "54"}], ",", "49", ",", "12", ",", 
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "130"}], ",", "44", ",", "134", ",", 
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "57"}], ",", "2", ",", "188", ",", "9", ",", "14", ",", 
       RowBox[{"-", "2"}], ",", "131", ",", 
       RowBox[{"-", "38"}], ",", 
       RowBox[{"-", "55"}], ",", 
       RowBox[{"-", "51"}], ",", "66", ",", 
       RowBox[{"-", "24"}], ",", "169", ",", 
       RowBox[{"-", "17"}], ",", "39", ",", "12", ",", "11", ",", 
       RowBox[{"-", "12"}], ",", "83", ",", 
       RowBox[{"-", "39"}], ",", "56", ",", "97", ",", "161", ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "53"}], ",", 
       RowBox[{"-", "82"}], ",", "135"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "21"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "34"}], ",", "68", ",", 
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "50"}], ",", "125", ",", 
       RowBox[{"-", "32"}], ",", "86", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "183"}], ",", 
       RowBox[{"-", "25"}], ",", "156", ",", "38", ",", "32", ",", "0", ",", 
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "60"}], ",", "0", ",", 
       RowBox[{"-", "81"}], ",", 
       RowBox[{"-", "19"}], ",", "47", ",", "28", ",", "3", ",", "40", ",", 
       RowBox[{"-", "102"}], ",", 
       RowBox[{"-", "35"}], ",", 
       RowBox[{"-", "57"}], ",", "70", ",", 
       RowBox[{"-", "55"}], ",", "34", ",", "58", ",", "147", ",", "23", ",", 
       "157", ",", 
       RowBox[{"-", "59"}], ",", 
       RowBox[{"-", "39"}], ",", "4", ",", 
       RowBox[{"-", "13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"184", ",", "27", ",", 
       RowBox[{"-", "15"}], ",", "13", ",", "40", ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "70"}], ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "26"}], ",", "16", ",", "20", ",", "128", ",", "16", ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "135"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "110"}], ",", 
       RowBox[{"-", "138"}], ",", 
       RowBox[{"-", "137"}], ",", 
       RowBox[{"-", "56"}], ",", "163", ",", "23", ",", "9", ",", "48", ",", 
       RowBox[{"-", "109"}], ",", "14", ",", "41", ",", "40", ",", 
       RowBox[{"-", "37"}], ",", "8", ",", 
       RowBox[{"-", "24"}], ",", "98", ",", "55", ",", 
       RowBox[{"-", "94"}], ",", "61", ",", 
       RowBox[{"-", "175"}], ",", 
       RowBox[{"-", "26"}], ",", 
       RowBox[{"-", "33"}], ",", 
       RowBox[{"-", "44"}], ",", 
       RowBox[{"-", "130"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "68"}], ",", 
       RowBox[{"-", "90"}], ",", 
       RowBox[{"-", "14"}], ",", 
       RowBox[{"-", "43"}], ",", 
       RowBox[{"-", "78"}], ",", 
       RowBox[{"-", "39"}], ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "59"}], ",", 
       RowBox[{"-", "54"}], ",", "61", ",", "16", ",", 
       RowBox[{"-", "74"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "32"}], ",", "36", ",", 
       RowBox[{"-", "98"}], ",", "44", ",", "4", ",", 
       RowBox[{"-", "157"}], ",", "62", ",", 
       RowBox[{"-", "25"}], ",", 
       RowBox[{"-", "86"}], ",", "122", ",", 
       RowBox[{"-", "29"}], ",", 
       RowBox[{"-", "47"}], ",", "131", ",", 
       RowBox[{"-", "64"}], ",", "66", ",", 
       RowBox[{"-", "98"}], ",", "97", ",", "40", ",", 
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "65"}], ",", "74", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "124"}], ",", "38", ",", 
       RowBox[{"-", "73"}], ",", 
       RowBox[{"-", "101"}], ",", "109"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "139"}], ",", 
       RowBox[{"-", "166"}], ",", 
       RowBox[{"-", "11"}], ",", "113", ",", "27", ",", 
       RowBox[{"-", "64"}], ",", "15", ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "61"}], ",", "101", ",", 
       RowBox[{"-", "191"}], ",", "98", ",", 
       RowBox[{"-", "59"}], ",", 
       RowBox[{"-", "40"}], ",", "120", ",", "177", ",", "8", ",", 
       RowBox[{"-", "27"}], ",", "27", ",", "136", ",", "90", ",", "61", ",", 
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "55"}], ",", 
       RowBox[{"-", "41"}], ",", "37", ",", "56", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "99"}], ",", 
       RowBox[{"-", "93"}], ",", 
       RowBox[{"-", "38"}], ",", 
       RowBox[{"-", "67"}], ",", 
       RowBox[{"-", "134"}], ",", "19", ",", "94", ",", 
       RowBox[{"-", "199"}], ",", "71", ",", 
       RowBox[{"-", "7"}], ",", "122"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"59", ",", "90", ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "37"}], ",", "20", ",", 
       RowBox[{"-", "18"}], ",", 
       RowBox[{"-", "2"}], ",", "52", ",", "38", ",", "38", ",", "51", ",", 
       RowBox[{"-", "166"}], ",", "10", ",", "68", ",", 
       RowBox[{"-", "70"}], ",", "164", ",", 
       RowBox[{"-", "60"}], ",", "9", ",", 
       RowBox[{"-", "139"}], ",", 
       RowBox[{"-", "50"}], ",", 
       RowBox[{"-", "86"}], ",", "73", ",", 
       RowBox[{"-", "105"}], ",", "13", ",", "29", ",", 
       RowBox[{"-", "45"}], ",", 
       RowBox[{"-", "46"}], ",", "58", ",", "30", ",", "267", ",", "21", ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "105"}], ",", "78", ",", 
       RowBox[{"-", "15"}], ",", "172", ",", 
       RowBox[{"-", "94"}], ",", 
       RowBox[{"-", "31"}], ",", 
       RowBox[{"-", "43"}], ",", "123"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"45", ",", 
       RowBox[{"-", "99"}], ",", "100", ",", 
       RowBox[{"-", "30"}], ",", "77", ",", 
       RowBox[{"-", "59"}], ",", "98", ",", 
       RowBox[{"-", "59"}], ",", "41", ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "98"}], ",", "38", ",", 
       RowBox[{"-", "16"}], ",", "244", ",", 
       RowBox[{"-", "60"}], ",", "8", ",", 
       RowBox[{"-", "60"}], ",", 
       RowBox[{"-", "18"}], ",", "71", ",", "137", ",", "87", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "91"}], ",", "76", ",", 
       RowBox[{"-", "10"}], ",", 
       RowBox[{"-", "85"}], ",", "27", ",", 
       RowBox[{"-", "29"}], ",", "39", ",", 
       RowBox[{"-", "212"}], ",", "15", ",", 
       RowBox[{"-", "30"}], ",", 
       RowBox[{"-", "120"}], ",", "57", ",", "59", ",", "160", ",", "100", 
       ",", "98", ",", "18", ",", 
       RowBox[{"-", "62"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"91", ",", "122", ",", "5", ",", "65", ",", "63", ",", 
       RowBox[{"-", "40"}], ",", "50", ",", "76", ",", "113", ",", "29", ",", 
       RowBox[{"-", "50"}], ",", "155", ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "40"}], ",", 
       RowBox[{"-", "44"}], ",", "148", ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "94"}], ",", 
       RowBox[{"-", "56"}], ",", 
       RowBox[{"-", "27"}], ",", "25", ",", "111", ",", 
       RowBox[{"-", "162"}], ",", "155", ",", "62", ",", "69", ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "18"}], ",", "11", ",", "38", ",", 
       RowBox[{"-", "59"}], ",", "94", ",", "105", ",", "78", ",", "70", ",", 
       "67", ",", 
       RowBox[{"-", "24"}], ",", "36", ",", "12", ",", 
       RowBox[{"-", "143"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"104", ",", "3", ",", 
       RowBox[{"-", "35"}], ",", "69", ",", "14", ",", 
       RowBox[{"-", "71"}], ",", 
       RowBox[{"-", "169"}], ",", "79", ",", "60", ",", "8", ",", "25", ",", 
       RowBox[{"-", "171"}], ",", 
       RowBox[{"-", "101"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "64"}], ",", "132", ",", 
       RowBox[{"-", "92"}], ",", "71", ",", "97", ",", 
       RowBox[{"-", "113"}], ",", 
       RowBox[{"-", "93"}], ",", "89", ",", 
       RowBox[{"-", "91"}], ",", "37", ",", "28", ",", "169", ",", "7", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "81"}], ",", "71", ",", 
       RowBox[{"-", "68"}], ",", "80", ",", "39", ",", "75", ",", "59", ",", 
       "52", ",", 
       RowBox[{"-", "80"}], ",", 
       RowBox[{"-", "66"}], ",", "78", ",", 
       RowBox[{"-", "37"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"54", ",", 
       RowBox[{"-", "68"}], ",", "34", ",", 
       RowBox[{"-", "6"}], ",", "116", ",", 
       RowBox[{"-", "53"}], ",", "7", ",", 
       RowBox[{"-", "165"}], ",", 
       RowBox[{"-", "16"}], ",", "121", ",", "47", ",", 
       RowBox[{"-", "15"}], ",", "15", ",", 
       RowBox[{"-", "188"}], ",", 
       RowBox[{"-", "31"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "2"}], ",", "188", ",", "115", ",", "79", ",", 
       RowBox[{"-", "7"}], ",", "47", ",", 
       RowBox[{"-", "61"}], ",", 
       RowBox[{"-", "94"}], ",", "45", ",", 
       RowBox[{"-", "71"}], ",", "105", ",", "12", ",", "88", ",", 
       RowBox[{"-", "30"}], ",", "6", ",", "46", ",", "82", ",", 
       RowBox[{"-", "12"}], ",", "44", ",", 
       RowBox[{"-", "91"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "98"}], ",", 
       RowBox[{"-", "16"}], ",", 
       RowBox[{"-", "31"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "95"}], ",", 
       RowBox[{"-", "7"}], ",", 
       RowBox[{"-", "68"}], ",", 
       RowBox[{"-", "48"}], ",", 
       RowBox[{"-", "3"}], ",", "28", ",", 
       RowBox[{"-", "202"}], ",", "190", ",", "21", ",", 
       RowBox[{"-", "97"}], ",", "145", ",", 
       RowBox[{"-", "17"}], ",", "140", ",", 
       RowBox[{"-", "52"}], ",", "57", ",", 
       RowBox[{"-", "38"}], ",", "66", ",", 
       RowBox[{"-", "152"}], ",", 
       RowBox[{"-", "170"}], ",", 
       RowBox[{"-", "150"}], ",", 
       RowBox[{"-", "75"}], ",", "46", ",", "23", ",", 
       RowBox[{"-", "111"}], ",", 
       RowBox[{"-", "88"}], ",", "76", ",", 
       RowBox[{"-", "132"}], ",", 
       RowBox[{"-", "11"}], ",", 
       RowBox[{"-", "44"}], ",", "192", ",", "47", ",", 
       RowBox[{"-", "76"}], ",", 
       RowBox[{"-", "62"}], ",", 
       RowBox[{"-", "207"}], ",", "38", ",", 
       RowBox[{"-", "122"}], ",", 
       RowBox[{"-", "22"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "184"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"63", ",", 
       RowBox[{"-", "120"}], ",", "19", ",", 
       RowBox[{"-", "55"}], ",", 
       RowBox[{"-", "20"}], ",", 
       RowBox[{"-", "55"}], ",", "15", ",", "177", ",", 
       RowBox[{"-", "36"}], ",", 
       RowBox[{"-", "46"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "64"}], ",", 
       RowBox[{"-", "45"}], ",", "64", ",", 
       RowBox[{"-", "66"}], ",", 
       RowBox[{"-", "31"}], ",", 
       RowBox[{"-", "28"}], ",", 
       RowBox[{"-", "142"}], ",", 
       RowBox[{"-", "24"}], ",", "62", ",", "37", ",", 
       RowBox[{"-", "47"}], ",", "40", ",", 
       RowBox[{"-", "32"}], ",", "109", ",", "39", ",", "25", ",", 
       RowBox[{"-", "25"}], ",", "0", ",", "126", ",", "41", ",", 
       RowBox[{"-", "6"}], ",", 
       RowBox[{"-", "39"}], ",", "51", ",", "52", ",", "28", ",", "17", ",", 
       "4", ",", "77", ",", 
       RowBox[{"-", "50"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.569312359272664*^9, 3.5693123606955156`*^9}, {
  3.569312676668172*^9, 3.5693126786818438`*^9}, {3.569565080036021*^9, 
  3.569565080158028*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M2", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.569312684018758*^9, 3.5693126900353594`*^9}, {
  3.5695650827171745`*^9, 3.569565082835181*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "14"}], "29", "47", "18", 
      RowBox[{"-", "13"}], "38", 
      RowBox[{"-", "50"}], 
      RowBox[{"-", "143"}], 
      RowBox[{"-", "83"}], "35", 
      RowBox[{"-", "113"}], "34", 
      RowBox[{"-", "122"}], "104", 
      RowBox[{"-", "3"}], 
      RowBox[{"-", "130"}], 
      RowBox[{"-", "42"}], "24", 
      RowBox[{"-", "96"}], 
      RowBox[{"-", "54"}], "68", 
      RowBox[{"-", "103"}], "98", 
      RowBox[{"-", "77"}], "79", "1", "10", 
      RowBox[{"-", "20"}], "52", 
      RowBox[{"-", "27"}], 
      RowBox[{"-", "22"}], 
      RowBox[{"-", "34"}], 
      RowBox[{"-", "110"}], 
      RowBox[{"-", "32"}], 
      RowBox[{"-", "11"}], "115", "70", "25", 
      RowBox[{"-", "88"}], 
      RowBox[{"-", "38"}]},
     {"139", "97", 
      RowBox[{"-", "130"}], 
      RowBox[{"-", "41"}], 
      RowBox[{"-", "23"}], "46", "145", 
      RowBox[{"-", "147"}], 
      RowBox[{"-", "9"}], 
      RowBox[{"-", "50"}], 
      RowBox[{"-", "29"}], "129", "2", 
      RowBox[{"-", "96"}], 
      RowBox[{"-", "126"}], 
      RowBox[{"-", "3"}], 
      RowBox[{"-", "92"}], "100", "54", "99", "32", "82", "46", 
      RowBox[{"-", "200"}], "68", 
      RowBox[{"-", "74"}], "44", "17", "32", 
      RowBox[{"-", "117"}], "21", "26", 
      RowBox[{"-", "53"}], 
      RowBox[{"-", "177"}], "5", 
      RowBox[{"-", "22"}], 
      RowBox[{"-", "127"}], "49", 
      RowBox[{"-", "32"}], 
      RowBox[{"-", "37"}]},
     {
      RowBox[{"-", "119"}], "53", "84", "54", "9", "33", 
      RowBox[{"-", "113"}], "121", "47", 
      RowBox[{"-", "39"}], "185", 
      RowBox[{"-", "51"}], "100", "48", "106", 
      RowBox[{"-", "43"}], "56", 
      RowBox[{"-", "89"}], 
      RowBox[{"-", "48"}], 
      RowBox[{"-", "128"}], 
      RowBox[{"-", "35"}], 
      RowBox[{"-", "59"}], 
      RowBox[{"-", "25"}], 
      RowBox[{"-", "48"}], 
      RowBox[{"-", "163"}], 
      RowBox[{"-", "47"}], 
      RowBox[{"-", "62"}], "11", 
      RowBox[{"-", "16"}], "62", 
      RowBox[{"-", "37"}], 
      RowBox[{"-", "26"}], "12", "21", 
      RowBox[{"-", "24"}], 
      RowBox[{"-", "216"}], "152", 
      RowBox[{"-", "96"}], "20", 
      RowBox[{"-", "60"}]},
     {"156", "37", "87", 
      RowBox[{"-", "73"}], 
      RowBox[{"-", "35"}], "10", "89", 
      RowBox[{"-", "27"}], "15", "11", 
      RowBox[{"-", "56"}], "78", "25", "76", 
      RowBox[{"-", "126"}], 
      RowBox[{"-", "104"}], 
      RowBox[{"-", "40"}], "83", "76", "69", 
      RowBox[{"-", "87"}], 
      RowBox[{"-", "118"}], "45", "15", "71", "82", 
      RowBox[{"-", "54"}], 
      RowBox[{"-", "46"}], 
      RowBox[{"-", "35"}], 
      RowBox[{"-", "98"}], "56", "60", "69", "2", "23", 
      RowBox[{"-", "23"}], "187", "43", "0", 
      RowBox[{"-", "92"}]},
     {
      RowBox[{"-", "123"}], "36", "86", "34", 
      RowBox[{"-", "22"}], 
      RowBox[{"-", "56"}], 
      RowBox[{"-", "74"}], "188", "60", "19", "228", 
      RowBox[{"-", "131"}], "126", "112", "110", 
      RowBox[{"-", "59"}], "80", 
      RowBox[{"-", "99"}], "42", 
      RowBox[{"-", "40"}], "1", 
      RowBox[{"-", "84"}], 
      RowBox[{"-", "5"}], "44", "112", 
      RowBox[{"-", "69"}], "41", 
      RowBox[{"-", "49"}], "11", "126", 
      RowBox[{"-", "17"}], 
      RowBox[{"-", "26"}], "40", "61", "53", 
      RowBox[{"-", "13"}], "189", 
      RowBox[{"-", "114"}], "103", 
      RowBox[{"-", "26"}]},
     {
      RowBox[{"-", "62"}], 
      RowBox[{"-", "97"}], "73", 
      RowBox[{"-", "73"}], 
      RowBox[{"-", "74"}], "46", "134", "155", 
      RowBox[{"-", "92"}], "115", 
      RowBox[{"-", "55"}], 
      RowBox[{"-", "147"}], 
      RowBox[{"-", "170"}], "8", "35", 
      RowBox[{"-", "102"}], "78", 
      RowBox[{"-", "50"}], "103", "167", "7", 
      RowBox[{"-", "162"}], "122", 
      RowBox[{"-", "149"}], 
      RowBox[{"-", "74"}], 
      RowBox[{"-", "65"}], "73", "61", "43", "80", "70", 
      RowBox[{"-", "54"}], 
      RowBox[{"-", "7"}], 
      RowBox[{"-", "85"}], 
      RowBox[{"-", "61"}], "50", "93", 
      RowBox[{"-", "94"}], "124", "91"},
     {
      RowBox[{"-", "85"}], 
      RowBox[{"-", "84"}], "24", 
      RowBox[{"-", "56"}], 
      RowBox[{"-", "19"}], 
      RowBox[{"-", "80"}], "27", 
      RowBox[{"-", "24"}], "71", "32", 
      RowBox[{"-", "80"}], 
      RowBox[{"-", "29"}], 
      RowBox[{"-", "67"}], "196", "47", 
      RowBox[{"-", "17"}], "62", "82", "42", "98", 
      RowBox[{"-", "95"}], 
      RowBox[{"-", "19"}], 
      RowBox[{"-", "19"}], "116", 
      RowBox[{"-", "21"}], "154", 
      RowBox[{"-", "46"}], "39", 
      RowBox[{"-", "117"}], 
      RowBox[{"-", "22"}], "53", 
      RowBox[{"-", "76"}], 
      RowBox[{"-", "66"}], "129", "20", 
      RowBox[{"-", "125"}], "106", 
      RowBox[{"-", "14"}], 
      RowBox[{"-", "18"}], "48"},
     {"152", 
      RowBox[{"-", "128"}], 
      RowBox[{"-", "1"}], "21", "20", "80", 
      RowBox[{"-", "79"}], "68", "74", 
      RowBox[{"-", "117"}], "115", 
      RowBox[{"-", "27"}], "102", "40", 
      RowBox[{"-", "117"}], "36", 
      RowBox[{"-", "114"}], 
      RowBox[{"-", "153"}], 
      RowBox[{"-", "149"}], 
      RowBox[{"-", "21"}], "55", "44", 
      RowBox[{"-", "64"}], "124", "90", 
      RowBox[{"-", "77"}], 
      RowBox[{"-", "67"}], "15", "47", "28", 
      RowBox[{"-", "32"}], "70", 
      RowBox[{"-", "1"}], "101", "19", 
      RowBox[{"-", "105"}], "31", "7", 
      RowBox[{"-", "28"}], 
      RowBox[{"-", "229"}]},
     {
      RowBox[{"-", "44"}], 
      RowBox[{"-", "101"}], "40", "13", 
      RowBox[{"-", "12"}], "16", "30", "146", "86", 
      RowBox[{"-", "15"}], 
      RowBox[{"-", "165"}], "75", 
      RowBox[{"-", "18"}], "88", "27", "51", 
      RowBox[{"-", "2"}], 
      RowBox[{"-", "61"}], "123", "60", 
      RowBox[{"-", "15"}], 
      RowBox[{"-", "4"}], 
      RowBox[{"-", "65"}], 
      RowBox[{"-", "12"}], "40", "41", "31", "52", "39", 
      RowBox[{"-", "12"}], 
      RowBox[{"-", "12"}], 
      RowBox[{"-", "34"}], 
      RowBox[{"-", "65"}], "40", "35", "87", "85", "125", "102", 
      RowBox[{"-", "114"}]},
     {
      RowBox[{"-", "71"}], "0", "16", "28", 
      RowBox[{"-", "17"}], "51", "141", "83", "15", "15", 
      RowBox[{"-", "121"}], "1", 
      RowBox[{"-", "114"}], 
      RowBox[{"-", "164"}], "56", 
      RowBox[{"-", "106"}], "20", 
      RowBox[{"-", "90"}], 
      RowBox[{"-", "191"}], "106", 
      RowBox[{"-", "12"}], 
      RowBox[{"-", "50"}], "49", "38", "2", 
      RowBox[{"-", "71"}], 
      RowBox[{"-", "27"}], "18", "27", "278", 
      RowBox[{"-", "21"}], 
      RowBox[{"-", "30"}], 
      RowBox[{"-", "34"}], "82", 
      RowBox[{"-", "36"}], "27", "110", "27", 
      RowBox[{"-", "48"}], "30"},
     {"86", 
      RowBox[{"-", "23"}], 
      RowBox[{"-", "68"}], "14", 
      RowBox[{"-", "13"}], 
      RowBox[{"-", "113"}], 
      RowBox[{"-", "35"}], "3", 
      RowBox[{"-", "65"}], 
      RowBox[{"-", "32"}], "119", "88", "104", 
      RowBox[{"-", "124"}], 
      RowBox[{"-", "61"}], 
      RowBox[{"-", "92"}], 
      RowBox[{"-", "54"}], "60", "55", "45", 
      RowBox[{"-", "16"}], "2", "95", "34", 
      RowBox[{"-", "6"}], 
      RowBox[{"-", "44"}], "67", 
      RowBox[{"-", "29"}], "46", "86", 
      RowBox[{"-", "18"}], "50", "30", 
      RowBox[{"-", "25"}], "17", 
      RowBox[{"-", "262"}], 
      RowBox[{"-", "56"}], 
      RowBox[{"-", "53"}], "32", "157"},
     {
      RowBox[{"-", "16"}], 
      RowBox[{"-", "19"}], 
      RowBox[{"-", "111"}], "64", 
      RowBox[{"-", "81"}], 
      RowBox[{"-", "23"}], 
      RowBox[{"-", "125"}], 
      RowBox[{"-", "183"}], 
      RowBox[{"-", "69"}], "20", 
      RowBox[{"-", "126"}], "269", "71", "160", "33", 
      RowBox[{"-", "21"}], 
      RowBox[{"-", "2"}], "117", "48", 
      RowBox[{"-", "136"}], "45", "5", "115", "151", 
      RowBox[{"-", "2"}], "49", "61", 
      RowBox[{"-", "27"}], 
      RowBox[{"-", "93"}], 
      RowBox[{"-", "115"}], 
      RowBox[{"-", "52"}], "34", "56", "199", "56", "1", 
      RowBox[{"-", "125"}], "120", 
      RowBox[{"-", "49"}], 
      RowBox[{"-", "126"}]},
     {"28", 
      RowBox[{"-", "89"}], 
      RowBox[{"-", "8"}], 
      RowBox[{"-", "37"}], 
      RowBox[{"-", "94"}], "100", 
      RowBox[{"-", "58"}], 
      RowBox[{"-", "15"}], "12", "15", "127", 
      RowBox[{"-", "51"}], "3", "36", 
      RowBox[{"-", "35"}], 
      RowBox[{"-", "93"}], 
      RowBox[{"-", "14"}], "37", 
      RowBox[{"-", "16"}], 
      RowBox[{"-", "37"}], 
      RowBox[{"-", "69"}], 
      RowBox[{"-", "84"}], "97", 
      RowBox[{"-", "31"}], "61", 
      RowBox[{"-", "63"}], 
      RowBox[{"-", "54"}], "46", "56", "8", "28", 
      RowBox[{"-", "14"}], 
      RowBox[{"-", "39"}], "18", 
      RowBox[{"-", "22"}], 
      RowBox[{"-", "48"}], "105", 
      RowBox[{"-", "99"}], 
      RowBox[{"-", "36"}], 
      RowBox[{"-", "46"}]},
     {"23", 
      RowBox[{"-", "6"}], "6", "106", "55", "61", 
      RowBox[{"-", "14"}], 
      RowBox[{"-", "36"}], "27", "91", 
      RowBox[{"-", "107"}], "10", 
      RowBox[{"-", "55"}], "16", "14", "4", 
      RowBox[{"-", "40"}], 
      RowBox[{"-", "9"}], 
      RowBox[{"-", "56"}], 
      RowBox[{"-", "50"}], 
      RowBox[{"-", "18"}], "43", 
      RowBox[{"-", "50"}], 
      RowBox[{"-", "173"}], "6", 
      RowBox[{"-", "53"}], 
      RowBox[{"-", "48"}], 
      RowBox[{"-", "3"}], "59", 
      RowBox[{"-", "17"}], 
      RowBox[{"-", "91"}], "74", "84", 
      RowBox[{"-", "109"}], 
      RowBox[{"-", "70"}], "35", "5", "8", 
      RowBox[{"-", "62"}], "107"},
     {"84", 
      RowBox[{"-", "49"}], "11", 
      RowBox[{"-", "42"}], 
      RowBox[{"-", "40"}], 
      RowBox[{"-", "21"}], "29", 
      RowBox[{"-", "90"}], 
      RowBox[{"-", "10"}], 
      RowBox[{"-", "15"}], "103", 
      RowBox[{"-", "184"}], 
      RowBox[{"-", "38"}], 
      RowBox[{"-", "88"}], 
      RowBox[{"-", "89"}], 
      RowBox[{"-", "186"}], 
      RowBox[{"-", "70"}], "112", 
      RowBox[{"-", "63"}], "76", 
      RowBox[{"-", "114"}], 
      RowBox[{"-", "91"}], "113", 
      RowBox[{"-", "33"}], 
      RowBox[{"-", "19"}], "17", 
      RowBox[{"-", "59"}], 
      RowBox[{"-", "16"}], 
      RowBox[{"-", "10"}], "89", "24", 
      RowBox[{"-", "10"}], 
      RowBox[{"-", "94"}], "10", "24", "36", "148", 
      RowBox[{"-", "82"}], 
      RowBox[{"-", "102"}], 
      RowBox[{"-", "31"}]},
     {"122", 
      RowBox[{"-", "55"}], "43", 
      RowBox[{"-", "53"}], 
      RowBox[{"-", "55"}], "51", "41", "100", 
      RowBox[{"-", "67"}], "12", 
      RowBox[{"-", "32"}], "30", 
      RowBox[{"-", "65"}], "44", 
      RowBox[{"-", "103"}], 
      RowBox[{"-", "199"}], 
      RowBox[{"-", "46"}], 
      RowBox[{"-", "92"}], 
      RowBox[{"-", "34"}], "21", 
      RowBox[{"-", "13"}], 
      RowBox[{"-", "145"}], "149", 
      RowBox[{"-", "104"}], "1", 
      RowBox[{"-", "8"}], 
      RowBox[{"-", "54"}], "69", 
      RowBox[{"-", "29"}], "12", "38", "38", "21", 
      RowBox[{"-", "79"}], 
      RowBox[{"-", "57"}], "117", "145", "8", "18", "58"},
     {
      RowBox[{"-", "91"}], "52", "22", 
      RowBox[{"-", "27"}], 
      RowBox[{"-", "60"}], 
      RowBox[{"-", "121"}], "62", 
      RowBox[{"-", "97"}], 
      RowBox[{"-", "88"}], 
      RowBox[{"-", "85"}], 
      RowBox[{"-", "18"}], "102", "7", 
      RowBox[{"-", "12"}], "65", "84", "70", "76", "142", 
      RowBox[{"-", "8"}], "82", 
      RowBox[{"-", "60"}], "36", "81", 
      RowBox[{"-", "57"}], 
      RowBox[{"-", "74"}], "120", 
      RowBox[{"-", "46"}], "29", 
      RowBox[{"-", "135"}], "31", 
      RowBox[{"-", "52"}], 
      RowBox[{"-", "15"}], "6", "37", 
      RowBox[{"-", "92"}], 
      RowBox[{"-", "90"}], "48", "44", "112"},
     {"44", "46", 
      RowBox[{"-", "124"}], 
      RowBox[{"-", "90"}], 
      RowBox[{"-", "41"}], "73", "128", 
      RowBox[{"-", "194"}], 
      RowBox[{"-", "33"}], 
      RowBox[{"-", "20"}], 
      RowBox[{"-", "21"}], 
      RowBox[{"-", "77"}], 
      RowBox[{"-", "25"}], "0", 
      RowBox[{"-", "52"}], "0", "16", "106", 
      RowBox[{"-", "23"}], "76", "33", "59", "66", 
      RowBox[{"-", "220"}], "31", "115", "45", "12", 
      RowBox[{"-", "96"}], 
      RowBox[{"-", "39"}], "76", 
      RowBox[{"-", "16"}], 
      RowBox[{"-", "6"}], 
      RowBox[{"-", "166"}], 
      RowBox[{"-", "1"}], "35", 
      RowBox[{"-", "137"}], "13", 
      RowBox[{"-", "96"}], 
      RowBox[{"-", "117"}]},
     {"133", 
      RowBox[{"-", "33"}], "42", 
      RowBox[{"-", "83"}], 
      RowBox[{"-", "64"}], 
      RowBox[{"-", "42"}], "123", "95", 
      RowBox[{"-", "46"}], 
      RowBox[{"-", "82"}], "4", "159", "42", 
      RowBox[{"-", "28"}], 
      RowBox[{"-", "119"}], 
      RowBox[{"-", "143"}], 
      RowBox[{"-", "42"}], 
      RowBox[{"-", "48"}], 
      RowBox[{"-", "32"}], "145", "14", 
      RowBox[{"-", "130"}], "119", 
      RowBox[{"-", "136"}], "10", "30", "58", 
      RowBox[{"-", "19"}], 
      RowBox[{"-", "52"}], "195", "63", "28", "9", 
      RowBox[{"-", "153"}], "24", 
      RowBox[{"-", "155"}], "127", "41", "40", "70"},
     {
      RowBox[{"-", "30"}], 
      RowBox[{"-", "61"}], 
      RowBox[{"-", "21"}], "74", 
      RowBox[{"-", "25"}], 
      RowBox[{"-", "123"}], "107", 
      RowBox[{"-", "182"}], 
      RowBox[{"-", "67"}], 
      RowBox[{"-", "141"}], 
      RowBox[{"-", "29"}], 
      RowBox[{"-", "3"}], "3", "68", "50", "10", "12", "153", 
      RowBox[{"-", "66"}], "108", 
      RowBox[{"-", "74"}], 
      RowBox[{"-", "16"}], "47", "26", 
      RowBox[{"-", "57"}], 
      RowBox[{"-", "48"}], 
      RowBox[{"-", "37"}], "17", "41", "28", 
      RowBox[{"-", "58"}], "40", "82", "43", "30", "63", 
      RowBox[{"-", "77"}], "98", 
      RowBox[{"-", "129"}], "104"},
     {"9", 
      RowBox[{"-", "36"}], 
      RowBox[{"-", "47"}], "81", 
      RowBox[{"-", "66"}], "8", 
      RowBox[{"-", "97"}], "35", "10", "6", 
      RowBox[{"-", "40"}], 
      RowBox[{"-", "66"}], 
      RowBox[{"-", "48"}], 
      RowBox[{"-", "128"}], "17", "23", 
      RowBox[{"-", "26"}], "75", "186", 
      RowBox[{"-", "57"}], 
      RowBox[{"-", "44"}], 
      RowBox[{"-", "2"}], "35", "89", "48", "101", "44", "41", 
      RowBox[{"-", "15"}], 
      RowBox[{"-", "84"}], 
      RowBox[{"-", "69"}], "52", "61", 
      RowBox[{"-", "47"}], "19", 
      RowBox[{"-", "45"}], 
      RowBox[{"-", "28"}], 
      RowBox[{"-", "9"}], "94", 
      RowBox[{"-", "74"}]},
     {
      RowBox[{"-", "96"}], 
      RowBox[{"-", "153"}], 
      RowBox[{"-", "84"}], "3", 
      RowBox[{"-", "4"}], 
      RowBox[{"-", "3"}], 
      RowBox[{"-", "7"}], "13", 
      RowBox[{"-", "40"}], 
      RowBox[{"-", "109"}], 
      RowBox[{"-", "32"}], 
      RowBox[{"-", "71"}], 
      RowBox[{"-", "97"}], 
      RowBox[{"-", "64"}], "63", "16", "30", "45", 
      RowBox[{"-", "11"}], "79", 
      RowBox[{"-", "84"}], "57", "31", "64", "32", 
      RowBox[{"-", "84"}], 
      RowBox[{"-", "25"}], "12", "46", "97", "0", 
      RowBox[{"-", "66"}], 
      RowBox[{"-", "87"}], "102", "21", "97", 
      RowBox[{"-", "129"}], "43", 
      RowBox[{"-", "24"}], 
      RowBox[{"-", "111"}]},
     {"0", 
      RowBox[{"-", "74"}], "16", "54", "68", 
      RowBox[{"-", "79"}], 
      RowBox[{"-", "36"}], 
      RowBox[{"-", "119"}], "6", "10", 
      RowBox[{"-", "136"}], "202", "32", 
      RowBox[{"-", "8"}], "10", "69", 
      RowBox[{"-", "28"}], "7", 
      RowBox[{"-", "35"}], "49", "112", "57", 
      RowBox[{"-", "80"}], "159", "118", 
      RowBox[{"-", "23"}], "82", "4", "75", 
      RowBox[{"-", "24"}], 
      RowBox[{"-", "48"}], "20", "2", "106", "28", 
      RowBox[{"-", "7"}], 
      RowBox[{"-", "54"}], "109", 
      RowBox[{"-", "45"}], "30"},
     {"19", 
      RowBox[{"-", "30"}], 
      RowBox[{"-", "54"}], "49", "12", 
      RowBox[{"-", "44"}], 
      RowBox[{"-", "93"}], 
      RowBox[{"-", "130"}], "44", "134", 
      RowBox[{"-", "25"}], 
      RowBox[{"-", "57"}], "2", "188", "9", "14", 
      RowBox[{"-", "2"}], "131", 
      RowBox[{"-", "38"}], 
      RowBox[{"-", "55"}], 
      RowBox[{"-", "51"}], "66", 
      RowBox[{"-", "24"}], "169", 
      RowBox[{"-", "17"}], "39", "12", "11", 
      RowBox[{"-", "12"}], "83", 
      RowBox[{"-", "39"}], "56", "97", "161", 
      RowBox[{"-", "16"}], 
      RowBox[{"-", "8"}], 
      RowBox[{"-", "30"}], 
      RowBox[{"-", "53"}], 
      RowBox[{"-", "82"}], "135"},
     {
      RowBox[{"-", "21"}], 
      RowBox[{"-", "3"}], 
      RowBox[{"-", "34"}], "68", 
      RowBox[{"-", "64"}], 
      RowBox[{"-", "56"}], 
      RowBox[{"-", "50"}], "125", 
      RowBox[{"-", "32"}], "86", 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "183"}], 
      RowBox[{"-", "25"}], "156", "38", "32", "0", 
      RowBox[{"-", "73"}], 
      RowBox[{"-", "60"}], "0", 
      RowBox[{"-", "81"}], 
      RowBox[{"-", "19"}], "47", "28", "3", "40", 
      RowBox[{"-", "102"}], 
      RowBox[{"-", "35"}], 
      RowBox[{"-", "57"}], "70", 
      RowBox[{"-", "55"}], "34", "58", "147", "23", "157", 
      RowBox[{"-", "59"}], 
      RowBox[{"-", "39"}], "4", 
      RowBox[{"-", "13"}]},
     {"184", "27", 
      RowBox[{"-", "15"}], "13", "40", 
      RowBox[{"-", "40"}], 
      RowBox[{"-", "70"}], 
      RowBox[{"-", "29"}], 
      RowBox[{"-", "26"}], "16", "20", "128", "16", 
      RowBox[{"-", "40"}], 
      RowBox[{"-", "135"}], 
      RowBox[{"-", "40"}], 
      RowBox[{"-", "110"}], 
      RowBox[{"-", "138"}], 
      RowBox[{"-", "137"}], 
      RowBox[{"-", "56"}], "163", "23", "9", "48", 
      RowBox[{"-", "109"}], "14", "41", "40", 
      RowBox[{"-", "37"}], "8", 
      RowBox[{"-", "24"}], "98", "55", 
      RowBox[{"-", "94"}], "61", 
      RowBox[{"-", "175"}], 
      RowBox[{"-", "26"}], 
      RowBox[{"-", "33"}], 
      RowBox[{"-", "44"}], 
      RowBox[{"-", "130"}]},
     {
      RowBox[{"-", "68"}], 
      RowBox[{"-", "90"}], 
      RowBox[{"-", "14"}], 
      RowBox[{"-", "43"}], 
      RowBox[{"-", "78"}], 
      RowBox[{"-", "39"}], 
      RowBox[{"-", "6"}], 
      RowBox[{"-", "59"}], 
      RowBox[{"-", "54"}], "61", "16", 
      RowBox[{"-", "74"}], 
      RowBox[{"-", "20"}], 
      RowBox[{"-", "32"}], "36", 
      RowBox[{"-", "98"}], "44", "4", 
      RowBox[{"-", "157"}], "62", 
      RowBox[{"-", "25"}], 
      RowBox[{"-", "86"}], "122", 
      RowBox[{"-", "29"}], 
      RowBox[{"-", "47"}], "131", 
      RowBox[{"-", "64"}], "66", 
      RowBox[{"-", "98"}], "97", "40", 
      RowBox[{"-", "64"}], 
      RowBox[{"-", "65"}], "74", 
      RowBox[{"-", "12"}], 
      RowBox[{"-", "124"}], "38", 
      RowBox[{"-", "73"}], 
      RowBox[{"-", "101"}], "109"},
     {
      RowBox[{"-", "139"}], 
      RowBox[{"-", "166"}], 
      RowBox[{"-", "11"}], "113", "27", 
      RowBox[{"-", "64"}], "15", 
      RowBox[{"-", "56"}], 
      RowBox[{"-", "61"}], "101", 
      RowBox[{"-", "191"}], "98", 
      RowBox[{"-", "59"}], 
      RowBox[{"-", "40"}], "120", "177", "8", 
      RowBox[{"-", "27"}], "27", "136", "90", "61", 
      RowBox[{"-", "67"}], 
      RowBox[{"-", "55"}], 
      RowBox[{"-", "41"}], "37", "56", 
      RowBox[{"-", "10"}], 
      RowBox[{"-", "30"}], 
      RowBox[{"-", "99"}], 
      RowBox[{"-", "93"}], 
      RowBox[{"-", "38"}], 
      RowBox[{"-", "67"}], 
      RowBox[{"-", "134"}], "19", "94", 
      RowBox[{"-", "199"}], "71", 
      RowBox[{"-", "7"}], "122"},
     {"59", "90", 
      RowBox[{"-", "5"}], 
      RowBox[{"-", "37"}], "20", 
      RowBox[{"-", "18"}], 
      RowBox[{"-", "2"}], "52", "38", "38", "51", 
      RowBox[{"-", "166"}], "10", "68", 
      RowBox[{"-", "70"}], "164", 
      RowBox[{"-", "60"}], "9", 
      RowBox[{"-", "139"}], 
      RowBox[{"-", "50"}], 
      RowBox[{"-", "86"}], "73", 
      RowBox[{"-", "105"}], "13", "29", 
      RowBox[{"-", "45"}], 
      RowBox[{"-", "46"}], "58", "30", "267", "21", 
      RowBox[{"-", "22"}], 
      RowBox[{"-", "105"}], "78", 
      RowBox[{"-", "15"}], "172", 
      RowBox[{"-", "94"}], 
      RowBox[{"-", "31"}], 
      RowBox[{"-", "43"}], "123"},
     {"45", 
      RowBox[{"-", "99"}], "100", 
      RowBox[{"-", "30"}], "77", 
      RowBox[{"-", "59"}], "98", 
      RowBox[{"-", "59"}], "41", 
      RowBox[{"-", "28"}], 
      RowBox[{"-", "98"}], "38", 
      RowBox[{"-", "16"}], "244", 
      RowBox[{"-", "60"}], "8", 
      RowBox[{"-", "60"}], 
      RowBox[{"-", "18"}], "71", "137", "87", 
      RowBox[{"-", "10"}], 
      RowBox[{"-", "91"}], "76", 
      RowBox[{"-", "10"}], 
      RowBox[{"-", "85"}], "27", 
      RowBox[{"-", "29"}], "39", 
      RowBox[{"-", "212"}], "15", 
      RowBox[{"-", "30"}], 
      RowBox[{"-", "120"}], "57", "59", "160", "100", "98", "18", 
      RowBox[{"-", "62"}]},
     {"91", "122", "5", "65", "63", 
      RowBox[{"-", "40"}], "50", "76", "113", "29", 
      RowBox[{"-", "50"}], "155", 
      RowBox[{"-", "8"}], 
      RowBox[{"-", "40"}], 
      RowBox[{"-", "44"}], "148", 
      RowBox[{"-", "56"}], 
      RowBox[{"-", "94"}], 
      RowBox[{"-", "56"}], 
      RowBox[{"-", "27"}], "25", "111", 
      RowBox[{"-", "162"}], "155", "62", "69", 
      RowBox[{"-", "22"}], 
      RowBox[{"-", "18"}], "11", "38", 
      RowBox[{"-", "59"}], "94", "105", "78", "70", "67", 
      RowBox[{"-", "24"}], "36", "12", 
      RowBox[{"-", "143"}]},
     {"104", "3", 
      RowBox[{"-", "35"}], "69", "14", 
      RowBox[{"-", "71"}], 
      RowBox[{"-", "169"}], "79", "60", "8", "25", 
      RowBox[{"-", "171"}], 
      RowBox[{"-", "101"}], 
      RowBox[{"-", "20"}], 
      RowBox[{"-", "64"}], "132", 
      RowBox[{"-", "92"}], "71", "97", 
      RowBox[{"-", "113"}], 
      RowBox[{"-", "93"}], "89", 
      RowBox[{"-", "91"}], "37", "28", "169", "7", 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "81"}], "71", 
      RowBox[{"-", "68"}], "80", "39", "75", "59", "52", 
      RowBox[{"-", "80"}], 
      RowBox[{"-", "66"}], "78", 
      RowBox[{"-", "37"}]},
     {"54", 
      RowBox[{"-", "68"}], "34", 
      RowBox[{"-", "6"}], "116", 
      RowBox[{"-", "53"}], "7", 
      RowBox[{"-", "165"}], 
      RowBox[{"-", "16"}], "121", "47", 
      RowBox[{"-", "15"}], "15", 
      RowBox[{"-", "188"}], 
      RowBox[{"-", "31"}], 
      RowBox[{"-", "22"}], 
      RowBox[{"-", "2"}], "188", "115", "79", 
      RowBox[{"-", "7"}], "47", 
      RowBox[{"-", "61"}], 
      RowBox[{"-", "94"}], "45", 
      RowBox[{"-", "71"}], "105", "12", "88", 
      RowBox[{"-", "30"}], "6", "46", "82", 
      RowBox[{"-", "12"}], "44", 
      RowBox[{"-", "91"}], 
      RowBox[{"-", "11"}], 
      RowBox[{"-", "98"}], 
      RowBox[{"-", "16"}], 
      RowBox[{"-", "31"}]},
     {
      RowBox[{"-", "95"}], 
      RowBox[{"-", "7"}], 
      RowBox[{"-", "68"}], 
      RowBox[{"-", "48"}], 
      RowBox[{"-", "3"}], "28", 
      RowBox[{"-", "202"}], "190", "21", 
      RowBox[{"-", "97"}], "145", 
      RowBox[{"-", "17"}], "140", 
      RowBox[{"-", "52"}], "57", 
      RowBox[{"-", "38"}], "66", 
      RowBox[{"-", "152"}], 
      RowBox[{"-", "170"}], 
      RowBox[{"-", "150"}], 
      RowBox[{"-", "75"}], "46", "23", 
      RowBox[{"-", "111"}], 
      RowBox[{"-", "88"}], "76", 
      RowBox[{"-", "132"}], 
      RowBox[{"-", "11"}], 
      RowBox[{"-", "44"}], "192", "47", 
      RowBox[{"-", "76"}], 
      RowBox[{"-", "62"}], 
      RowBox[{"-", "207"}], "38", 
      RowBox[{"-", "122"}], 
      RowBox[{"-", "22"}], 
      RowBox[{"-", "8"}], 
      RowBox[{"-", "12"}], 
      RowBox[{"-", "184"}]},
     {"63", 
      RowBox[{"-", "120"}], "19", 
      RowBox[{"-", "55"}], 
      RowBox[{"-", "20"}], 
      RowBox[{"-", "55"}], "15", "177", 
      RowBox[{"-", "36"}], 
      RowBox[{"-", "46"}], 
      RowBox[{"-", "1"}], 
      RowBox[{"-", "64"}], 
      RowBox[{"-", "45"}], "64", 
      RowBox[{"-", "66"}], 
      RowBox[{"-", "31"}], 
      RowBox[{"-", "28"}], 
      RowBox[{"-", "142"}], 
      RowBox[{"-", "24"}], "62", "37", 
      RowBox[{"-", "47"}], "40", 
      RowBox[{"-", "32"}], "109", "39", "25", 
      RowBox[{"-", "25"}], "0", "126", "41", 
      RowBox[{"-", "6"}], 
      RowBox[{"-", "39"}], "51", "52", "28", "17", "4", "77", 
      RowBox[{"-", "50"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.5693126907795*^9, 3.569353112765828*^9, 
  3.569353760217*^9, 3.5695651053024664`*^9}]
}, Open  ]],

Cell["Define our working directory", "Text",
 CellChangeTimes->{{3.569354660043172*^9, 3.5693546654035234`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"wd", "=", 
  "\"\<C:\\\\Users\\\\alb\\\\Desktop\\\\Dropbox\\\\Publicaciones\\\\\
semigrupos_descomponibles\>\""}]], "Input",
 CellChangeTimes->{3.569565076580824*^9}],

Cell[BoxData["\<\"C:\\\\Users\\\\usuario\\\\Google \
Drive\\\\Articulos\\\\descomponibles\\\\programa-hnf\"\>"], "Output",
 CellChangeTimes->{3.5693127259045*^9, 3.5693531142179766`*^9, 
  3.569353762107625*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"permutations2", ",", "blocks2"}], "}"}], "=", 
   RowBox[{"hnfDecomposition", "[", "M2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.5693127412795*^9, 3.569312747388875*^9}, {
  3.569565086187373*^9, 3.569565091115655*^9}}],

Cell[CellGroupData[{

Cell[BoxData["permutations2"], "Input",
 CellChangeTimes->{{3.569312751630086*^9, 3.569312756732625*^9}, {
  3.5695650930267644`*^9, 3.5695650931467714`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "4", ",", "15", ",", "17", ",", "31", ",", "32", ",", "33"}], 
    "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3", ",", "5", ",", "9", ",", "16", ",", "22", ",", "23", ",", "37"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "35"}], "}"}], ",", 
   RowBox[{"{", "7", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "8", ",", "18", ",", "19", ",", "21", ",", "27", ",", "30", ",", "39"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "11", ",", "12", ",", "13", ",", "36", ",", "38"}], 
    "}"}], ",", 
   RowBox[{"{", "14", "}"}], ",", 
   RowBox[{"{", "20", "}"}], ",", 
   RowBox[{"{", "24", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "26", ",", "29"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "34"}], "}"}], ",", 
   RowBox[{"{", "40", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.569312753886922*^9, 3.5693127571759844`*^9}, 
   3.569353116757039*^9, 3.5693537641896563`*^9, 3.569565112416873*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", " ", "/@", "blocks2"}]], "Input",
 CellChangeTimes->{{3.5693127604552813`*^9, 3.5693127685734453`*^9}, {
  3.5695650948188667`*^9, 3.5695650949468737`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "26", "64", "11", "54", "170"},
       {"0", "1", "12", "28", "4", "24", "75"},
       {"0", "0", "29", "70", "12", "58", "184"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "43", "11", 
        RowBox[{"-", "20"}], 
        RowBox[{"-", "29"}]},
       {"0", "1", "1", "230", "64", 
        RowBox[{"-", "107"}], 
        RowBox[{"-", "160"}]},
       {"0", "0", "2", "239", "66", 
        RowBox[{"-", "111"}], 
        RowBox[{"-", "165"}]},
       {"0", "0", "0", "354", "97", 
        RowBox[{"-", "163"}], 
        RowBox[{"-", "247"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "2"},
       {"0", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0", "552", "1007", 
        RowBox[{"-", "218"}]},
       {"0", "1", "0", "0", "781", "1424", 
        RowBox[{"-", "309"}]},
       {"0", "0", "1", "0", "240", "436", 
        RowBox[{"-", "95"}]},
       {"0", "0", "0", "1", "174", "316", 
        RowBox[{"-", "68"}]},
       {"0", "0", "0", "0", "965", "1759", 
        RowBox[{"-", "383"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0", "8546", "1357"},
       {"0", "1", "0", "0", "2730", "433"},
       {"0", "0", "1", "0", "6912", "1098"},
       {"0", "0", "0", "1", "54", "9"},
       {"0", "0", "0", "0", "8757", "1391"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "1"},
       {"0", "1", "1"},
       {"0", "0", "2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1"},
       {"0", "2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 CellChangeTimes->{3.5693127694103594`*^9, 3.5693531177941484`*^9, 
  3.56935376537325*^9, 3.5695651158610706`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exec4ti2Blocks", "[", 
  RowBox[{"\"\<4ti2gmp groebner\>\"", ",", "wd", ",", "blocks2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.569312790062703*^9, 3.5693127907423906`*^9}, 
   3.569312827425008*^9, {3.5695650972750072`*^9, 3.569565097395014*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5120292`7.160839722122716", ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.569312866493367*^9, 3.5693128962961016`*^9}, 
   3.5693531251447344`*^9, 3.5693537736378984`*^9, 3.5693538055753984`*^9, 
   3.569565127274723*^9, 3.569565235990941*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exec4ti2", "[", 
  RowBox[{"\"\<4ti2gmp groebner\>\"", ",", "wd", ",", "M2"}], "]"}]], "Input",
 CellChangeTimes->{{3.569312933413289*^9, 3.5693129334836016`*^9}, {
  3.569565099403129*^9, 3.569565099516135*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"54.1220956`9.184919597568939", ",", 
   RowBox[{"-", "1073741510"}]}], "}"}]], "Output",
 CellChangeTimes->{3.569313001672078*^9, 3.5693531490353594`*^9, 
  3.569353824473836*^9, 3.569565216431823*^9}]
}, Open  ]],

Cell["\<\
We aborted the execution of 4ti2. In this case using the decomposition it is \
obtained faster the Groebner basis\
\>", "Text",
 CellChangeTimes->{{3.569313010996297*^9, 3.5693130304045*^9}, {
   3.5693531523878984`*^9, 3.5693531856046953`*^9}, {3.5695645667186613`*^9, 
   3.56956456791873*^9}, 3.569564629301241*^9, {3.5695647577485876`*^9, 
   3.5695647590206604`*^9}}]
}, Open  ]]
},
WindowSize->{1904, 985},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3569567850-6505568"->{
  Cell[2806, 72, 357, 6, 109, "Print",
   CellTags->"Info3569567850-6505568"]},
 "Info3569567852-6521915"->{
  Cell[3375, 88, 682, 10, 160, "Print",
   CellTags->"Info3569567852-6521915"]},
 "Info3569567856-9082545"->{
  Cell[4378, 109, 842, 12, 211, "Print",
   CellTags->"Info3569567856-9082545"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3569567850-6505568", 102045, 2754},
 {"Info3569567852-6521915", 102154, 2757},
 {"Info3569567856-9082545", 102264, 2760}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 122, 2, 31, "Input"],
Cell[670, 24, 145, 2, 29, "Text"],
Cell[818, 28, 402, 8, 31, "Input"],
Cell[CellGroupData[{
Cell[1245, 40, 643, 10, 31, "Input"],
Cell[1891, 52, 566, 8, 252, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2494, 65, 309, 5, 31, "Input"],
Cell[2806, 72, 357, 6, 109, "Print",
 CellTags->"Info3569567850-6505568"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3200, 83, 172, 3, 31, "Input"],
Cell[3375, 88, 682, 10, 160, "Print",
 CellTags->"Info3569567852-6521915"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4094, 103, 281, 4, 31, "Input"],
Cell[4378, 109, 842, 12, 211, "Print",
 CellTags->"Info3569567856-9082545"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5257, 126, 270, 3, 71, "Section"],
Cell[5530, 131, 116, 1, 29, "Text"],
Cell[5649, 134, 8463, 213, 132, "Input"],
Cell[CellGroupData[{
Cell[14137, 351, 176, 3, 31, "Input"],
Cell[14316, 356, 6494, 203, 296, "Output"]
}, Open  ]],
Cell[20825, 562, 112, 1, 29, "Text"],
Cell[CellGroupData[{
Cell[20962, 567, 320, 6, 31, "Input"],
Cell[21285, 575, 265, 3, 30, "Output"]
}, Open  ]],
Cell[21565, 581, 194, 4, 29, "Text"],
Cell[CellGroupData[{
Cell[21784, 589, 329, 5, 31, "Input"],
Cell[22116, 596, 397, 7, 30, "Output"]
}, Open  ]],
Cell[22528, 606, 279, 3, 29, "Text"],
Cell[22810, 611, 298, 7, 31, "Input"],
Cell[CellGroupData[{
Cell[23133, 622, 158, 2, 31, "Input"],
Cell[23294, 626, 651, 18, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23982, 649, 191, 3, 31, "Input"],
Cell[24176, 654, 4397, 119, 102, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28610, 778, 477, 7, 31, "Input"],
Cell[29090, 787, 556, 11, 30, "Output"]
}, Open  ]],
Cell[29661, 801, 155, 3, 29, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29853, 809, 244, 5, 71, "Section"],
Cell[30100, 816, 33608, 797, 712, "Input"],
Cell[CellGroupData[{
Cell[63733, 1617, 179, 3, 31, "Input"],
Cell[63915, 1622, 24883, 752, 551, "Output"]
}, Open  ]],
Cell[88813, 2377, 112, 1, 29, "Text"],
Cell[CellGroupData[{
Cell[88950, 2382, 190, 4, 31, "Input"],
Cell[89143, 2388, 211, 3, 30, "Output"]
}, Open  ]],
Cell[89369, 2394, 292, 7, 31, "Input"],
Cell[CellGroupData[{
Cell[89686, 2405, 158, 2, 31, "Input"],
Cell[89847, 2409, 1076, 31, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90960, 2445, 193, 3, 31, "Input"],
Cell[91156, 2450, 8851, 242, 87, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100044, 2697, 275, 5, 31, "Input"],
Cell[100322, 2704, 464, 10, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100823, 2719, 236, 4, 31, "Input"],
Cell[101062, 2725, 241, 5, 30, "Output"]
}, Open  ]],
Cell[101318, 2733, 382, 7, 29, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
