(* ::Package:: *)

BeginPackage["ProporcionallyModularAffineSemigroupN2`"];


Authors="J. I. Garc\[IAcute]a-Garc\[IAcute]a and A. Vigneron-Tenorio,\nDpto. Matem\[AAcute]ticas, 
Universidad de C\[AAcute]diz
ignacio.garcia@uca.es, alberto.vigneron@uca.es\n";

Commands="This package defines the commands: 
ProporcionallyModularAffineSemigroupN2
Try command::usage for more help";

ProporcionallyModularAffineSemigroupN2:: usage="Returns the minimal generating set of a proportionally modular affine semigroup S of N^2.
If the inequality definig S is ax+by mob c <= dx + ey, the input is ProporcionallyModularAffineSemigroupN2[a,b,c,d,e]
.\n\[IndentingNewLine]Example: ProporcionallyModularAffineSemigroupN2[3,2,10,1,-1]\[IndentingNewLine]";



Begin["`Private`"];


ProporcionallyModularAffineSemigroupN2[f1_:Integer,f2_:Integer,b_:Integer,g1_:Integer,g2_:Integer]:=Module[{i,j,
tope,u,w,w1,w2,tildeu,tildeuX,tildeuY,x,y,t,S,f,g,G,PtosG,PtosGAux={},TopeG,MinPtosG,xx,msg={},seguir,l1,l2,l3},
If[g1<=0 && g2<=0,Print["Semigrupo= <{0,0}>"];Return[{{0,0}}]];
f[{x1_,x2_}]:=f1*x1+f2*x2;
g[{x1_,x2_}]:=g1*x1+g2*x2;
w=Sort[Solve[{g[{x,y}]==b,x*y==0,x>=0,y>=0},{x,y}]];
If[Length[w]==2,
tildeuX=Minimize[x,f[{x,0}]+t*b<=g[{x,0}]&&f[{x,0}]+t*b>=0&&x>0,{x,t},Integers];
tildeuX={x,0}/.tildeuX[[2]];
tildeuY=Minimize[y,f[{0,y}]+t*b<=g[{0,y}]&&f[{0,y}]+t*b>=0&&y>0,{y,t},Integers];
tildeuY={0,y}/.tildeuY[[2]];
w1={x,y}/.w[[2]];
w2={x,y}/.w[[1]];
G=ConvexHullMesh[{{0,0},w1+tildeuX,w2+tildeuY}];
TopeG=RegionBounds[G];
PtosG=Table[Table[j,{j,TopeG[[i,1]],TopeG[[i,2]]}],{i,1,2}];
PtosG=Flatten[Outer[List,PtosG[[1]],PtosG[[2]]],1];
For[i=1,i<=Length[PtosG],i++,
j=FindInstance[l1*(w1[[1]]+tildeuX[[1]])+l2*(w2[[1]]+tildeuY[[1]])==PtosG[[i]][[1]]&&l1*(w1[[2]]+tildeuX[[2]])+l2*(w2[[2]]+tildeuY[[2]])==PtosG[[i]][[2]]&&l1>=0&&l2>=0&&l1+l2<=1,{l1,l2},Reals];
If[Length[j]==1,PtosGAux=Join[PtosGAux,{PtosG[[i]]}]];
];
PtosG=PtosGAux;
PtosG=Delete[Select[PtosG,Mod[f[#],b]<=g[#]&],1]; (*PtosG, PUNTOS DE G en S*)
tope=Max[{(w1+tildeuX)[[1]],(w2+tildeuY)[[2]]}]+10;
,(* CASO g1g2\[LessEqual]0*)
u=Minimize[x+y,f[{x,y}]+t*b==0&&g[{x,y}]==0&&x>= 0&&y>=0&&x+y>0,{x,y,t},Integers];
u={x,y}/. u[[2]];
tildeu=Minimize[x+y,f[{x,y}]+t*b<=g[{x,y}]&&f[{x,y}]+t*b>=0&&x*y==0&&x+y>0&&y>=0&&x>= 0,{x,y,t},Integers];
tildeu={x,y}/.tildeu[[2]];
w={x,y}/.w[[1]];
G=ConvexHullMesh[{{0,0},u,w+tildeu,u+w+tildeu}];
TopeG=RegionBounds[G];
PtosG=Table[Table[j,{j,TopeG[[i,1]],TopeG[[i,2]]}],{i,1,2}];
PtosG=Flatten[Outer[List,PtosG[[1]],PtosG[[2]]],1];
For[i=1,i<=Length[PtosG],i++,
j=FindInstance[l1*u[[1]]+l2*(w[[1]]+tildeu[[1]])+l3*(u[[1]]+w[[1]]+tildeu[[1]])==PtosG[[i]][[1]]&&l1*u[[2]]+l2*(w[[2]]+tildeu[[2]])+l3*(u[[2]]+w[[2]]+tildeu[[2]])==PtosG[[i]][[2]]&&l1>=0&&l2>=0&&l3>=0&&l1+l2+l3<=1,{l1,l2,l3},Reals];
If[Length[j]==1,PtosGAux=Join[PtosGAux,{PtosG[[i]]}]];
];
PtosG=PtosGAux;
PtosG=Delete[Select[PtosG,Mod[f[#],b]<=g[#]&],1]; (*PtosG, PUNTOS DE G en S*)
tope=Max[{(u+w+tildeu)[[1]],(u+w+tildeu)[[2]]}]+Min[u[[1]],u[[2]]];
];
For[i=1,i<=Length[PtosG],i++,
seguir=True;
For[j=1,(j<=i-1) \[And] seguir,j++,
xx=PtosG[[i]]-PtosG[[j]];
If[Mod[f[xx],b]<=g[xx]\[And]xx[[1]]>=0 \[And]xx[[2]]>=0,seguir=False;];
];
If[(j==i)\[And]seguir,AppendTo[msg,PtosG[[i]]]];
];

S=Select[Flatten[Table[{i,j},{i,0,tope},{j,0,tope}],1],Mod[f[#],b]<=g[#]&];
Print[
Show[
{G,
ListPlot[S,PlotStyle->Directive[Red]],
ListPlot[PtosG,PlotStyle->Directive[Blue]],
ListPlot[msg,PlotStyle->Directive[Yellow]],
ContourPlot[g[{x1,x2}]==0,{x1,0,tope},{x2,0,tope}],
ContourPlot[g[{x1,x2}]==b,{x1,0,tope},{x2,0,tope}]
},AspectRatio->Automatic,Axes->True
]
];
Return[msg];
];


End[];
EndPackage[];
