#########################
# PyConvexHullSemigroup #
#########################

from PyNormaliz import *
import cdd as cdd
from cdd import *
from sympy import *
import numpy as numpy
from numpy import array
import itertools
import fractions
from fractions import Fraction

# INPUT:
#   lpoints: array with the points.
# OUTPUT:
#   array with 1 append to each element of lpoints.
def StepOne(lpoints):
    aux=list(lpoints)
    aux=[ x+[1] for x in aux ]
    return aux

# INPUT:
# - v: A list.
# OUTPUT:
# - The same list with all the elements as strings.
def ToString(v):
    return [ [str(x) for x in w] for w in v]

# INPUT:
# - v: A list with string.
# OUTPUT:
# - The same list with all the elements as fractions.
def String2Fraction(v):
    return [ [Fraction(x) for x in w] for w in v]

# INPUT:
# - v: A list with fraction.
# OUTPUT:
# - The same list with all the elements multiplied by the lcm.
def Fraction2Int(v):
    n = len(v)
    m = len(v[0])
    den = []
    for i in range(n):
        for j in range(m):
            den.append(v[i][j].denominator)
    lcmultiple = lcm(den)
    return [ [lcmultiple*x for x in w] for w in v]

# INPUT:
# - v: A list with rational vertices.
# OUTPUT:
# - The same list with integer vertices.
def Ver2Int(v):
    return Fraction2Int(String2Fraction(ToString(v)))

# INPUT:
#   lpoints: vertices of the polyhedron.
# OUTPUT:
# generators of the semigroups.
def StepTwo(lpoints):
    c = Cone(cone=lpoints)
    hb = c.HilbertBasis()
    n = len(hb)
    m = len(hb[0])
    return [[int(hb[i][j]) for j in range(m)] for i in range(n)]

# INPUT:
#   lpoints: array of points.
# OUTPUT:
#   lpoints without the last coordinate.
def StepThree(lpoints):
    aux = [[x for x in lpoints[i]] for i in range(len(lpoints))]
    n = len(aux)
    for i in range(n):
        aux[i].pop()
    return(aux)

#########################
# Equations to Vertices #
#########################

# INPUT:
#  - A matrix (b|-A) with the equations.
# OUTPUT:
#  - The set of extremal points.
def Eq2Ver(eq):
    mat = cdd.Matrix(eq, number_type='fraction')
    mat.rep_type = cdd.RepType.INEQUALITY
    poly = cdd.Polyhedron(mat)
    ext = poly.get_generators()
    aux = [list(ext[i]) for i in range(len(ext)) if ext[i][0]==1]
    for i in range(len(aux)):
        del aux[i][0]
    return(arrayF(aux))

#########################
# Vertices to Equations #
#########################

# INPUT:
#  - The set of extremal points.
# OUTPUT:
#  - A matrix (b|-A) with the equations.
def Ver2Eq(ver):
    #nver = [ [1]+ver[i] for i in range(len(ver))]
    nver = arrayF([ numpy.concatenate(([1],x)) for x in ver])
    mat = cdd.Matrix(nver, number_type='fraction')
    mat.rep_type = cdd.RepType.GENERATOR
    poly = cdd.Polyhedron(mat)
    hrep = poly.get_inequalities()
    return arrayF([list(x) for x in hrep])

###############################
# Cohen - Macaulay semigroups #
###############################

# INPUT:
# - a: List.
# - b: List.
# OUTPUT:
# True if b<a or false in other case.
def OrdenLexicografico(b,a):
    aux = [x-y for x,y in zip(a,b)]
    n = len(aux)
    for i in range(n):
        if(aux[i] != 0):
            if(aux[i] > 0):
                return(True)
            else:
                return(False)
    return(True)

# INPUT:
# - a: List.
# - b: List.
# OUTPUT:
# True if b<a or false in other case.
def OrdenLexicograficoGraduado(b,a):
    sumA = sum(a)
    sumB = sum(b)
    if(sumA == 0):
        return(False)
    if(sumB<sumA):
        return(True)
    if(sumA == sumB and OrdenLexicografico(b,a)):
        return(True)
    else:
        return(False)

# INPUT:
# - pts: vertices of the polyhedron.
# OUTPUT:
# - Rays of the cone that contains these vertices.
def Ver2Ray(pts,eq):
    pts1=Ver2Int(pts)
    c = Cone(cone = pts1)
    rayos=arrayF(c.ExtremeRays())
    newray = []
    for x in rayos:
        k=1
        y=x
        while not belongs2CSemigroup(y,pts,eq):
            k=k+1
            y=list(k*array(x))
        x=y
        newray.append(y)
    #print(newray)
    return arrayF(newray)

# Assume dim=3
# INPUT:
# - v: array of dimension 3.
# OUTPUT:
# - Norm two of the array.
def Norm(v):
    return sqrt(v[0]**2+v[1]**2+v[2]**2)

# INPUT:
# - pts: vertices of the polyhedron:
# OUTPUT:
# - Array with the least and greatest vertex such that are not in W
#    or if not points of W for complete it.
def LeastGreatest(pts,rays):
    n = len(pts)
    m = len(rays)
    # First we look for W vertices.
    w = []
    x = Symbol('x')
    for i in range(m):
        candidates = []
        for j in range(n):
            sol = solve(x*array(rays[i])-array(pts[j]), x)
            if sol != []:
                candidates.append(pts[j])
        if len(candidates) == 1:
            w.append(candidates[0])
    # This are the points which are not in W.
    w = list([list(x) for x in w])
    pt = list([list(x) for x in pts])
    v = [x for x in pt if x not in w]
    normW = [Norm(x) for x in w]
    maxW = max(normW)
    minW = min(normW)
    v1 = [x for x in v if Norm(x) < minW]
    normV1 = [Norm(x) for x in v1]
    v2 = [x for x in v if Norm(x) > maxW]
    normV2 = [Norm(x) for x in v2]
    if(v1 != []):
        l = [x for x in v1 if Norm(x) == max(normV1)][0]
    else:
        l = [x for x in w if Norm(x) == minW][0]
    if(v2 != []):
        g = [x for x in v2 if Norm(x) == min(normV2)][0]
    else:
        g = [x for x in w if Norm(x) == maxW][0]
    return([l,g])
        
    #if len(v) != 1:
    #    vnorm = [Norm(x) for x in v]
    #    return([min(vnorm),max(vnorm)])
    #else:
    #    vnorm = [Norm(x) for x in pts]
        #return([min(vnorm),max(vnorm)])

# INPUT:
# - v: array with two elements verifying v[0]<v[1]
# OUTPUT:
# - First k, such that (k+1)v[0]<kv[1]
def ComputeK0(v):
    l = Norm(v[0])
    g = Norm(v[1])
    k = 1
    while true:
        if (k+1)*l <= k*g:
            return k
        k = k+1
    return 0

# INPUT:
#   - values: List.
# OUTPUT:
#   - The list values without duplicate elements.
def RemoveDuplicates(values):
    output = []
    for value in values:
        if value not in output:
            output.append(value)
    return output

# Assume dim=3.
# Input:
#   - pt: A point we want to check if it is in the semigroup.
#   - eq: Equations of the semigroup.
# Output:
#   - True if the point is in the semigroup or False if it is not.
def Belongs(pt,eq):
    m =len(eq)
    for i in range(m):
        if (eq[i][0]+eq[i][1]*pt[0]+eq[i][2]*pt[1]+eq[i][3]*pt[2])<0:
            return(False)
    return(True)

# Assume dim=3 & len(rays)=3.
# Input:
#   - pts: List of points outside the semigroup and inside the cone.
#   - rays: Rays of the cone.
#   - eq: Equation of the polyhedron
# Output:
#   - True if the semigroup is Cohen-Macaulay or False if it is not.
def Caracterization(holes,rays,eq,vertices):
    n = len(holes)
    for i in range(n):
            isIn1 = belongs2CSemigroup(list(array(holes[i])+array(rays[0])),vertices,eq)# Belongs(list(array(pts[i])+array(rays[0])),eq)
            isIn2 = belongs2CSemigroup(list(array(holes[i])+array(rays[1])),vertices,eq)
            isIn3 = belongs2CSemigroup(list(array(holes[i])+array(rays[2])),vertices,eq)
            # As True is 1 and False is 0, for checking we have at least two zeros we realize the following sum.
            if (isIn1+isIn2+isIn3) > 1:
                #print(i,holes[i])
                return(False)
    return(True)

def expresableNp(v,lgen):
    # expresableNp([33, 54, 63], [[1, 2, 3], [2, 3, 1], [2, 3, 2], [2, 3, 3], [3, 3, 2], [4, 6, 7] ])
    z=[0 for i in lgen]
    if v==[0 for x in v]:
        return z
    elif any([x<0 for x in v]):
        return False
    else:
        for i,x in enumerate(lgen):
            w=[ v[i]-x[i] for i in range(len(v)) ]
            expresion=expresableNp(w,lgen)
            if expresion!=False:
                expresion[i]=expresion[i]+1
                return expresion
        return False
    

def belongs2CSemigroup(pt,ver,eq):
    # belongs2CSemigroup([4, 6, 7],pts,eq)
    if list(pt) == [0,0,0]:
        return True
    m=min( [ sum(x) for x in ver ] )
    k=1
    sumpt=sum(pt)
    while sumpt/k >= m:
        newpt = [Fraction(x.numerator, k*x.denominator) for x in pt]
        if Belongs(newpt,eq):
            return True
        k=k+1
    return False

def msgCHSgr(pts):
    pt =list([list(x) for x in pts])
    s1 = StepOne(pt)
    s = Ver2Int(s1)
    s2 = StepTwo(s)
    gen = StepThree(s2)
    eq = Ver2Eq(pts)
    n = len(gen)
    minimals = []
    for i in range(n):
        candidate = true
        for j in range(n):
            if i!= j:
                if belongs2CSemigroup(array(gen[i])-array(gen[j]),pt,eq):
                    candidate = False
        if candidate:
            minimals.append(gen[i])
    return arrayF(minimals)


###################
###################

def sortRowsLex(M):
    '''M=array([[0, 1, 1], [1, 2, 2], [1, 2, 3], [2, 2, 2], [2, 3, 4], [3, 2, 1], [3,3, 3], [4, 3, 2]])
    sortRowsLex(M)
    '''
    if len(M)==0:
        return M
    return M[np.lexsort((M.T)[-1::-1,:])]


def insertInLexMatrix(M,x):
    '''M=array([[3,4,5],[4,2,9],[0,1,2],[2,3,1]])
    M=sortRowsLex(M)
    print(M)
    insertInLexMatrix(M,array([3,4,6]))
    '''
    naux=len(x)
    if len(M)==0:
        return x.reshape(1,naux)
    
    nf,nc=M.shape
    if lLex(x,M[0]):
        return np.concatenate((x.reshape(1,nc),M),axis=0)
    elif lLex(M[-1],x):
        return np.concatenate((M,x.reshape(1,nc)),axis=0)

    pI,pF=0,len(M)-1
    pM=(pF+pI)//2
    fM=M[pM]
    #fM1=M[pM+1]
    while( pF-pI > 1):
        if np.all(fM==x):
            return M
        elif lLex(x,fM):
            pI,pF=pI,pM
            pM=(pF+pI)//2
            fM=M[pM]
        else:
            pI,pF=pM,pF
            pM=(pF+pI)//2
            fM=M[pM]
    if np.all(x==M[pI]):
        return M
    if np.all(x==M[pF]):
        return M
    
    return np.concatenate((M[:(pI+1),:],x.reshape(1,nc),M[(pI+1):,:]),axis=0)



################



def Ray2Eq(ray):
    nver = arrayF([ numpy.concatenate(([0],x)) for x in ray])
    mat = cdd.Matrix(nver, number_type='fraction')
    mat.rep_type = cdd.RepType.GENERATOR
    #print(mat)
    poly = cdd.Polyhedron(mat)
    hrep = poly.get_inequalities()
    return arrayF([list(x) for x in hrep])


def Holes(cote,ver,eqSg,ray):
    #cube = list( itertools.product( * [ range(ceiling(cote)) for i in range(3) ] ) )
    cube = itertools.product( * [ range(ceiling(cote)) for i in range(3) ] )
    #eqSg = Ver2Eq(ver)
    #ray = Ver2Ray(Ver2Int(ver))
    eqCn = Ray2Eq(ray)
    cube = String2Fraction(ToString(cube))
    h = []
    #return [ x for x in cube if Belongs(x,eqCn) and not belongs2CSemigroup(x,ver,eqSg)]
    for x in cube:
        if Belongs(x,eqCn) and not belongs2CSemigroup(x,ver,eqSg):
            h.append(x)
    return h


def isCohenMacaulay(pts):
    eq = Ver2Eq(pts)
    rays = Ver2Ray(pts,eq)
    merg = LeastGreatest(pts,rays)
    k0 = ComputeK0(merg)
    gen = msgCHSgr(pts)
    cote = k0*max([Norm(x) for x in gen])
    eqSg = Ver2Eq(pts)
    h = Holes(cote,pts,eqSg,rays)
    #eq = Ver2Eq(pts)
    #rays = Ver2Ray(Ver2Int(pts))
    return Caracterization(h,rays,eq,pts)

def arrayF(lista):
    return array( numpy.vectorize(lambda x:Fraction(x))(lista)  ,dtype=Fraction )

def belongsN(eqArray,n,punto):
    Maux=array(eqArray)
    #print(Maux)
    Maux[:,0]*=n
    paux= numpy.concatenate( (array([1]),punto) )
    #print(paux)
    return numpy.all( Maux.dot( paux ) >= 0  )

def PseudoFrobenius(h,gen,pts,eq):
    holes = []
    for x in h:
        if numpy.all(array([belongs2CSemigroup(x+g,pts,eq) for g in gen])):
            holes = holes + [list(x)]
    return(holes)

def isBauchBaum(pts):
    eq = Ver2Eq(pts)
    rays = Ver2Ray(pts,eq)
    [l,g]=LeastGreatest(pts,rays)
    k0=ComputeK0([l,g])
    gen = msgCHSgr(pts)
    maxgen = max([Norm(x) for x in gen])
    h = Holes(maxgen,pts,eq,rays)
    pf = PseudoFrobenius(h,gen,pts,eq)
    return(isCohenMacaulay(pts+pf))

